/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnImpl
implements TableColumnCore {
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    private String sName;
    private String sTitleLanguageKey = null;
    private int iAlignment;
    private int iType;
    private int iPosition;
    private int iWidth;
    private int iInterval;
    private long lLastSortValueChange;
    private String sTableID;
    private boolean bColumnAdded;
    private boolean bCoreDataSource;
    private ArrayList cellRefreshListeners;
    private ArrayList cellAddedListeners;
    private ArrayList cellDisposeListeners;
    private ArrayList cellToolTipListeners;
    private ArrayList cellMouseListeners;
    private ArrayList cellMouseMoveListeners;
    private ArrayList cellVisibilityListeners;
    private ArrayList<TableColumnExtraInfoListener> columnExtraInfoListeners;
    private Map mapOtherCellListeners;
    private int iConsecutiveErrCount;
    private ArrayList<TableContextMenuItem> menuItemsHeader;
    private ArrayList<TableContextMenuItem> menuItemsColumn;
    private boolean bObfusticateData;
    protected AEMonitor this_mon = new AEMonitor("TableColumn");
    private boolean bSortValueLive;
    private long lStatsRefreshTotalTime;
    private long lStatsRefreshCount = 0L;
    private long lStatsRefreshZeroCount = 0L;
    private boolean bSortAscending;
    private boolean editable;
    private int iMinWidth = -1;
    private int iMaxWidth = -1;
    private boolean bVisible;
    private boolean bMaxWidthAuto = false;
    private boolean bWidthAuto;
    private int iPreferredWidth;
    private boolean bPreferredWidthAuto = true;
    private int iPreferredWidthMax = -1;
    private boolean auto_tooltip = false;
    private Map userData;
    private boolean removed;
    private Class forPluginDataSourceType;

    public TableColumnImpl(String tableID, String columnID) {
        Class forPluginDataSourceType = null;
        if ("MyLibrary.big".equals(tableID) || "Unopened".equals(tableID) || "Unopened.big".equals(tableID)) {
            forPluginDataSourceType = Download.class;
        } else if ("MyTorrents.big".equals(tableID) || "MyTorrents".equals(tableID)) {
            forPluginDataSourceType = DownloadTypeIncomplete.class;
        } else if ("MySeeders".equals(tableID) || "MySeeders.big".equals(tableID)) {
            forPluginDataSourceType = DownloadTypeComplete.class;
        } else if ("Peers".equals(tableID)) {
            forPluginDataSourceType = Peer.class;
        } else if ("Files".equals(tableID)) {
            forPluginDataSourceType = DiskManagerFileInfo.class;
        } else if ("MyTracker".equals(tableID)) {
            forPluginDataSourceType = TrackerTorrent.class;
        } else if ("MyShares".equals(tableID)) {
            forPluginDataSourceType = ShareResource.class;
        }
        this.init(forPluginDataSourceType, tableID, columnID);
    }

    public TableColumnImpl(Class forDataSourceType, String tableID, String columnID) {
        this.init(forDataSourceType, tableID, columnID);
    }

    private void init(Class forDataSourceType, String tableID, String columnID) {
        this.forPluginDataSourceType = forDataSourceType;
        this.sTableID = tableID;
        this.sName = columnID;
        this.iType = 3;
        this.iWidth = 50;
        this.iAlignment = 1;
        this.bColumnAdded = false;
        this.bCoreDataSource = false;
        this.iInterval = -3;
        this.iConsecutiveErrCount = 0;
        this.lLastSortValueChange = 0L;
        this.bVisible = false;
        this.iMinWidth = 16;
        this.iPosition = -1;
        int iSortDirection = COConfigurationManager.getIntParameter(CFG_SORTDIRECTION);
        this.bSortAscending = iSortDirection != 1;
    }

    @Override
    public void initialize(int iAlignment, int iPosition, int iWidth, int iInterval) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.setPosition(iPosition);
        this.iWidth = iWidth;
        this.iMinWidth = 16;
        this.iInterval = iInterval;
    }

    @Override
    public void initialize(int iAlignment, int iPosition, int iWidth) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.setPosition(iPosition);
        this.iWidth = iWidth;
        this.iMinWidth = 16;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public String getTableID() {
        return this.sTableID;
    }

    @Override
    public void setType(int type) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iType = type;
    }

    @Override
    public int getType() {
        return this.iType;
    }

    @Override
    public void setWidth(int width) {
        if (width == this.iWidth || width < 0) {
            return;
        }
        if (this.iMinWidth > 0 && width < this.iMinWidth) {
            return;
        }
        if (this.iMaxWidth > 0 && width > this.iMaxWidth) {
            if (width == this.iMaxWidth) {
                return;
            }
            width = this.iMaxWidth;
        }
        if (this.iMinWidth < 0) {
            this.iMinWidth = width;
        }
        this.iWidth = width;
        if (this.bColumnAdded && this.bVisible) {
            this.triggerColumnSizeChange();
        }
    }

    @Override
    public void triggerColumnSizeChange() {
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.columnSizeChanged(this);
        if (this.iType == 2) {
            this.invalidateCells();
        }
    }

    @Override
    public int getWidth() {
        return this.iWidth;
    }

    @Override
    public void setPosition(int position) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        if (this.iPosition == -1 && position != -1) {
            this.setVisible(true);
        }
        this.iPosition = position;
        if (position == -1) {
            this.setVisible(false);
        }
    }

    @Override
    public int getPosition() {
        return this.iPosition;
    }

    @Override
    public void setAlignment(int alignment) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = alignment;
    }

    @Override
    public int getAlignment() {
        return this.iAlignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                this.cellRefreshListeners = new ArrayList(1);
            }
            this.cellRefreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCellRefreshListeners() {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                ArrayList arrayList = new ArrayList(0);
                return arrayList;
            }
            ArrayList arrayList = new ArrayList(this.cellRefreshListeners);
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                return;
            }
            this.cellRefreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean hasCellRefreshListener() {
        return this.cellRefreshListeners != null && this.cellRefreshListeners.size() > 0;
    }

    @Override
    public void setRefreshInterval(int interval) {
        this.iInterval = interval;
    }

    @Override
    public int getRefreshInterval() {
        return this.iInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                this.cellAddedListeners = new ArrayList(1);
            }
            this.cellAddedListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellOtherListener(String listenerID, Object listener) {
        try {
            ArrayList<Object> list;
            this.this_mon.enter();
            if (this.mapOtherCellListeners == null) {
                this.mapOtherCellListeners = new HashMap(1);
            }
            if ((list = (ArrayList<Object>)this.mapOtherCellListeners.get(listenerID)) == null) {
                list = new ArrayList<Object>(1);
                this.mapOtherCellListeners.put(listenerID, list);
            }
            list.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public Object[] getCellOtherListeners(String listenerID) {
        if (this.mapOtherCellListeners == null) {
            return null;
        }
        List list = (List)this.mapOtherCellListeners.get(listenerID);
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    @Override
    public boolean hasCellOtherListeners(String listenerID) {
        return this.mapOtherCellListeners != null && this.mapOtherCellListeners.get(listenerID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCellAddedListeners() {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                ArrayList arrayList = new ArrayList(0);
                return arrayList;
            }
            ArrayList arrayList = new ArrayList(this.cellAddedListeners);
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                return;
            }
            this.cellAddedListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                this.cellDisposeListeners = new ArrayList(1);
            }
            this.cellDisposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                return;
            }
            this.cellDisposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                this.cellToolTipListeners = new ArrayList(1);
            }
            this.cellToolTipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                return;
            }
            this.cellToolTipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCellMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean hasCellMouseMoveListener() {
        return this.cellMouseMoveListeners != null && this.cellMouseMoveListeners.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableColumnExtraInfoListener> getColumnExtraInfoListeners() {
        try {
            this.this_mon.enter();
            if (this.columnExtraInfoListeners == null) {
                ArrayList<TableColumnExtraInfoListener> arrayList = new ArrayList<TableColumnExtraInfoListener>(0);
                return arrayList;
            }
            ArrayList<TableColumnExtraInfoListener> arrayList = new ArrayList<TableColumnExtraInfoListener>(this.columnExtraInfoListeners);
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumnExtraInfoListener(TableColumnExtraInfoListener listener) {
        try {
            this.this_mon.enter();
            if (this.columnExtraInfoListeners == null) {
                this.columnExtraInfoListeners = new ArrayList(1);
            }
            this.columnExtraInfoListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeColumnExtraInfoListener(TableColumnExtraInfoListener listener) {
        try {
            this.this_mon.enter();
            if (this.columnExtraInfoListeners == null) {
                return;
            }
            this.columnExtraInfoListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void invalidateCells() {
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.columnInvalidate(this);
    }

    @Override
    public void invalidateCell(Object data_source) {
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.cellInvalidate((TableColumnCore)this, data_source);
    }

    @Override
    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addCellDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addCellRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addCellToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellAddedListener) {
            this.addCellAddedListener((TableCellAddedListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addCellMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addCellMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addCellVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableColumnExtraInfoListener) {
            this.addColumnExtraInfoListener((TableColumnExtraInfoListener)listenerObject);
        }
    }

    @Override
    public void setColumnAdded(boolean bAdded) {
        this.bColumnAdded = bAdded;
    }

    @Override
    public boolean getColumnAdded() {
        return this.bColumnAdded;
    }

    @Override
    public void setUseCoreDataSource(boolean bCoreDataSource) {
        this.bCoreDataSource = bCoreDataSource;
    }

    @Override
    public boolean getUseCoreDataSource() {
        return this.bCoreDataSource;
    }

    @Override
    public void invokeCellRefreshListeners(TableCell cell, boolean fastRefresh) throws Throwable {
        if (this.cellRefreshListeners == null) {
            return;
        }
        Throwable firstError = null;
        for (int i = 0; i < this.cellRefreshListeners.size(); ++i) {
            TableCellRefreshListener l = (TableCellRefreshListener)this.cellRefreshListeners.get(i);
            try {
                if (l instanceof TableCellLightRefreshListener) {
                    ((TableCellLightRefreshListener)l).refresh(cell, fastRefresh);
                    continue;
                }
                l.refresh(cell);
                continue;
            }
            catch (Throwable e) {
                if (firstError == null) {
                    firstError = e;
                }
                Debug.printStackTrace(e);
            }
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    @Override
    public void invokeCellAddedListeners(TableCell cell) {
        if (this.cellAddedListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellAddedListeners.size(); ++i) {
            try {
                ((TableCellAddedListener)this.cellAddedListeners.get(i)).cellAdded(cell);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeCellDisposeListeners(TableCell cell) {
        if (this.cellDisposeListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellDisposeListeners.size(); ++i) {
            try {
                ((TableCellDisposeListener)this.cellDisposeListeners.get(i)).dispose(cell);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeCellToolTipListeners(TableCellCore cell, int type) {
        if (this.cellToolTipListeners == null) {
            return;
        }
        if (type == 0) {
            for (int i = 0; i < this.cellToolTipListeners.size(); ++i) {
                try {
                    ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHover(cell);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            for (int i = 0; i < this.cellToolTipListeners.size(); ++i) {
                try {
                    ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHoverComplete(cell);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void invokeCellMouseListeners(TableCellMouseEvent event2) {
        ArrayList listeners;
        ArrayList arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)listeners.get(i);
                l.cellMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeCellVisibilityListeners(TableCellCore cell, int visibility) {
        if (this.cellVisibilityListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellVisibilityListeners.size(); ++i) {
            try {
                TableCellVisibilityListener l = (TableCellVisibilityListener)this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(cell, visibility);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void setPositionNoShift(int position) {
        this.iPosition = position;
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new LightHashMap(2);
        }
        this.userData.put(key, value);
    }

    @Override
    public void removeUserData(String key) {
        if (this.userData == null) {
            return;
        }
        this.userData.remove(key);
        if (this.userData.size() < 1) {
            this.userData = null;
        }
    }

    @Override
    public void remove() {
        this.removed = true;
        TableColumnManager.getInstance().removeColumns(new TableColumnCore[]{this});
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.tableStructureChanged(true, this.forPluginDataSourceType);
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public final void loadSettings(Map mapSettings) {
        int sortOrder;
        int position;
        int pos;
        String itemPrefix = "Column." + this.sName;
        String oldItemPrefix = "Table." + this.sTableID + "." + this.sName;
        Object object = mapSettings.get(itemPrefix);
        Object[] list = object instanceof List ? ((List)object).toArray() : new String[]{};
        if (list.length >= (pos = 0) + 1 && list[pos] instanceof Number) {
            boolean vis = ((Number)list[pos]).intValue() == 1;
            this.setVisible(vis);
        }
        if (list.length >= ++pos + 1 && list[pos] instanceof Number) {
            position = ((Number)list[pos]).intValue();
            this.setPositionNoShift(position);
        } else {
            position = COConfigurationManager.getIntParameter(oldItemPrefix + ".position", this.iPosition);
            if (this.iPosition == -1 && position != -1) {
                this.setVisible(true);
            }
            this.setPositionNoShift(position);
            if (position == -1) {
                this.setVisible(false);
            }
        }
        if (list.length >= ++pos + 1 && list[pos] instanceof Number) {
            int width = ((Number)list[pos]).intValue();
            this.setWidth(width);
        } else {
            this.setWidth(COConfigurationManager.getIntParameter(oldItemPrefix + ".width", this.iWidth));
        }
        if (list.length >= ++pos + 1 && list[pos] instanceof Number) {
            boolean autoTooltip = ((Number)list[pos]).intValue() == 1;
            this.setAutoTooltip(autoTooltip);
        } else {
            this.setAutoTooltip(COConfigurationManager.getBooleanParameter(oldItemPrefix + ".auto_tooltip", this.auto_tooltip));
        }
        if (list.length >= ++pos + 1 && list[pos] instanceof Number && (sortOrder = ((Number)list[pos]).intValue()) >= 0) {
            boolean bl = this.bSortAscending = sortOrder == 1;
        }
        if (list.length >= ++pos + 1 && list[pos] instanceof Map) {
            this.userData = (Map)list[pos];
            if (this.userData.size() < 1) {
                this.userData = null;
            }
        }
        this.postConfigLoad();
    }

    @Override
    public void postConfigLoad() {
    }

    @Override
    public void preConfigSave() {
    }

    @Override
    public final void saveSettings(Map mapSettings) {
        this.preConfigSave();
        if (mapSettings == null && (mapSettings = TableColumnManager.getInstance().getTableConfigMap(this.sTableID)) == null) {
            return;
        }
        String sItemPrefix = "Column." + this.sName;
        mapSettings.put(sItemPrefix, Arrays.asList(new Integer(this.bVisible ? 1 : 0), new Integer(this.iPosition), new Integer(this.iWidth), new Integer(this.auto_tooltip ? 1 : 0), new Integer(this.lLastSortValueChange == 0L ? -1 : (this.bSortAscending ? 1 : 0)), this.userData != null ? this.userData : Collections.EMPTY_MAP));
        sItemPrefix = "Table." + this.sTableID + "." + this.sName;
        if (COConfigurationManager.hasParameter(sItemPrefix + ".width", true)) {
            COConfigurationManager.removeParameter(sItemPrefix + ".position");
            COConfigurationManager.removeParameter(sItemPrefix + ".width");
            COConfigurationManager.removeParameter(sItemPrefix + ".auto_tooltip");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTitleLanguageKey() {
        try {
            this.this_mon.enter();
            if (this.sTitleLanguageKey == null) {
                this.sTitleLanguageKey = this.sTableID + ".column." + this.sName;
                if (MessageText.keyExists(this.sTitleLanguageKey)) {
                    String string = this.sTitleLanguageKey;
                    return string;
                }
                String sKeyPrefix = (this.sTableID.equals("MySeeders") ? "MyTorrents" : this.sTableID) + "View.";
                if (MessageText.keyExists(sKeyPrefix + this.sName)) {
                    String string = this.sTitleLanguageKey = sKeyPrefix + this.sName;
                    return string;
                }
                if (this.sTableID.equals("AllPeers")) {
                    sKeyPrefix = "Peers.column.";
                    if (MessageText.keyExists(sKeyPrefix + this.sName)) {
                        String string = this.sTitleLanguageKey = sKeyPrefix + this.sName;
                        return string;
                    }
                    sKeyPrefix = "PeersView.";
                    if (MessageText.keyExists(sKeyPrefix + this.sName)) {
                        String string = this.sTitleLanguageKey = sKeyPrefix + this.sName;
                        return string;
                    }
                }
                if (MessageText.keyExists((sKeyPrefix = "TableColumn.header.") + this.sName)) {
                    String string = this.sTitleLanguageKey = sKeyPrefix + this.sName;
                    return string;
                }
                sKeyPrefix = "MyTorrentsView." + this.sName;
                if (MessageText.keyExists(sKeyPrefix)) {
                    String string = this.sTitleLanguageKey = sKeyPrefix;
                    return string;
                }
            }
            String string = this.sTitleLanguageKey;
            return string;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getConsecutiveErrCount() {
        return this.iConsecutiveErrCount;
    }

    @Override
    public void setConsecutiveErrCount(int iCount) {
        this.iConsecutiveErrCount = iCount;
    }

    @Override
    public void removeContextMenuItem(TableContextMenuItem menuItem) {
        if (this.menuItemsColumn != null) {
            this.menuItemsColumn.remove(menuItem);
        }
        if (this.menuItemsHeader != null) {
            this.menuItemsColumn.remove(menuItem);
        }
    }

    @Override
    public TableContextMenuItem addContextMenuItem(String key) {
        return this.addContextMenuItem(key, 2);
    }

    @Override
    public TableContextMenuItem addContextMenuItem(String key, int menuStyle) {
        ArrayList<TableContextMenuItem> menuItems;
        if (menuStyle == 2) {
            if (this.menuItemsColumn == null) {
                this.menuItemsColumn = new ArrayList();
            }
            menuItems = this.menuItemsColumn;
        } else {
            if (this.menuItemsHeader == null) {
                this.menuItemsHeader = new ArrayList();
            }
            menuItems = this.menuItemsHeader;
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl(null, "", key);
        menuItems.add(item);
        return item;
    }

    @Override
    public TableContextMenuItem[] getContextMenuItems(int menuStyle) {
        ArrayList<TableContextMenuItem> menuItems = menuStyle == 2 ? this.menuItemsColumn : this.menuItemsHeader;
        if (menuItems == null) {
            return new TableContextMenuItem[0];
        }
        return menuItems.toArray(new TableContextMenuItem[0]);
    }

    @Override
    public boolean isObfusticated() {
        return this.bObfusticateData;
    }

    @Override
    public void setObfustication(boolean hideData) {
        this.bObfusticateData = hideData;
    }

    @Override
    public long getLastSortValueChange() {
        if (this.bSortValueLive) {
            return SystemTime.getCurrentTime();
        }
        return this.lLastSortValueChange;
    }

    @Override
    public void setLastSortValueChange(long lastSortValueChange) {
        this.lLastSortValueChange = lastSortValueChange;
    }

    @Override
    public boolean isSortValueLive() {
        return this.bSortValueLive;
    }

    @Override
    public void setSortValueLive(boolean live) {
        this.bSortValueLive = live;
    }

    @Override
    public void addRefreshTime(long ms) {
        if (ms == 0L) {
            ++this.lStatsRefreshZeroCount;
        } else {
            this.lStatsRefreshTotalTime += ms;
            ++this.lStatsRefreshCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateDiagnostics(IndentWriter writer) {
        writer.println("Column " + this.sTableID + ":" + this.sName + (this.bSortValueLive ? " (Live Sort)" : ""));
        try {
            writer.indent();
            if (this.lStatsRefreshCount > 0L) {
                writer.println("Avg refresh time (" + this.lStatsRefreshCount + " samples): " + this.lStatsRefreshTotalTime / this.lStatsRefreshCount + " (" + this.lStatsRefreshZeroCount + " zero ms refreshes not included)");
            }
            writer.println("Listeners: refresh=" + this.getListCountString(this.cellRefreshListeners) + "; dispose=" + this.getListCountString(this.cellDisposeListeners) + "; mouse=" + this.getListCountString(this.cellMouseListeners) + "; mm=" + this.getListCountString(this.cellMouseMoveListeners) + "; vis=" + this.getListCountString(this.cellVisibilityListeners) + "; added=" + this.getListCountString(this.cellAddedListeners) + "; tooltip=" + this.getListCountString(this.cellToolTipListeners));
            writer.println("lLastSortValueChange=" + this.lLastSortValueChange);
        }
        catch (Exception exception) {
        }
        finally {
            writer.exdent();
        }
    }

    private String getListCountString(List l) {
        if (l == null) {
            return "-0";
        }
        return "" + l.size();
    }

    @Override
    public void setTableID(String tableID) {
        this.sTableID = tableID;
    }

    public int compare(Object arg0, Object arg1) {
        boolean c1_is_null;
        TableCellCore cell0 = ((TableRowCore)arg0).getTableCellCore(this.sName);
        TableCellCore cell1 = ((TableRowCore)arg1).getTableCellCore(this.sName);
        Object c0 = cell0 == null ? "" : cell0.getSortValue();
        Object c1 = cell1 == null ? "" : cell1.getSortValue();
        boolean c0_is_null = c0 == null || c0.equals("");
        boolean bl = c1_is_null = c1 == null || c1.equals("");
        if (c1_is_null) {
            return c0_is_null ? 0 : -1;
        }
        if (c0_is_null) {
            return 1;
        }
        try {
            boolean c0isString = c0 instanceof String;
            boolean c1isString = c1 instanceof String;
            if (c0isString && c1isString) {
                if (this.bSortAscending) {
                    return ((String)c0).compareToIgnoreCase((String)c1);
                }
                return ((String)c1).compareToIgnoreCase((String)c0);
            }
            int val = c0isString && !c1isString ? -1 : (c1isString && !c0isString ? 1 : c1.compareTo(c0));
            return this.bSortAscending ? -val : val;
        }
        catch (ClassCastException e) {
            int c0_index = cell0 == null ? -999 : cell0.getTableRowCore().getIndex();
            int c1_index = cell1 == null ? -999 : cell1.getTableRowCore().getIndex();
            System.err.println("Can't compare " + c0.getClass().getName() + "(" + c0.toString() + ") from row #" + c0_index + " to " + c1.getClass().getName() + "(" + c1.toString() + ") from row #" + c1_index + " while sorting column " + this.sName);
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setSortAscending(boolean bAscending) {
        if (this.bSortAscending == bAscending) {
            return;
        }
        this.setLastSortValueChange(SystemTime.getCurrentTime());
        this.bSortAscending = bAscending;
    }

    @Override
    public boolean isSortAscending() {
        return this.bSortAscending;
    }

    @Override
    public int getMinWidth() {
        if (this.iMinWidth < 0) {
            return this.iWidth;
        }
        return this.iMinWidth;
    }

    @Override
    public void setMinWidth(int minwidth) {
        if (minwidth > this.iMaxWidth && this.iMaxWidth >= 0) {
            this.iMaxWidth = minwidth;
        }
        if (this.iPreferredWidth > 0 && this.iPreferredWidth < minwidth) {
            this.iPreferredWidth = minwidth;
        }
        this.iMinWidth = minwidth;
        if (this.iWidth < minwidth) {
            this.setWidth(minwidth);
        }
    }

    @Override
    public int getMaxWidth() {
        return this.iMaxWidth;
    }

    @Override
    public void setMaxWidth(int maxwidth) {
        if (maxwidth >= 0 && maxwidth < this.iMinWidth) {
            this.iMinWidth = maxwidth;
        }
        if (this.iPreferredWidth > maxwidth) {
            this.iPreferredWidth = maxwidth;
        }
        this.iMaxWidth = maxwidth;
        if (maxwidth >= 0 && this.iWidth > this.iMaxWidth) {
            this.setWidth(maxwidth);
        }
    }

    @Override
    public void setWidthLimits(int min, int max) {
        this.setMinWidth(min);
        this.setMaxWidth(max);
    }

    @Override
    public boolean isVisible() {
        return this.bVisible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.bVisible == visible) {
            return;
        }
        this.bVisible = visible;
        if (this.bVisible && this.iPosition == -1) {
            this.iPosition = -2;
        }
        this.invalidateCells();
    }

    @Override
    public boolean isMaxWidthAuto() {
        return this.bMaxWidthAuto;
    }

    @Override
    public void setMaxWidthAuto(boolean automaxwidth) {
        this.bMaxWidthAuto = automaxwidth;
    }

    @Override
    public boolean isMinWidthAuto() {
        return this.bWidthAuto;
    }

    @Override
    public void setMinWidthAuto(boolean autominwidth) {
        this.bWidthAuto = autominwidth;
    }

    @Override
    public int getPreferredWidth() {
        return this.iPreferredWidth;
    }

    @Override
    public void setPreferredWidthAuto(boolean auto) {
        this.bPreferredWidthAuto = auto;
    }

    @Override
    public boolean isPreferredWidthAuto() {
        return this.bPreferredWidthAuto;
    }

    public void setPreferredWidthMax(int maxprefwidth) {
        this.iPreferredWidthMax = maxprefwidth;
        if (this.iPreferredWidth > this.iPreferredWidthMax) {
            this.setPreferredWidth(maxprefwidth);
        }
    }

    public int getPreferredWidthMax() {
        return this.iPreferredWidthMax;
    }

    @Override
    public void setPreferredWidth(int width) {
        if (this.iPreferredWidthMax > 0 && width > this.iPreferredWidthMax) {
            width = this.iPreferredWidthMax;
        }
        this.iPreferredWidth = width < this.iMinWidth ? this.iMinWidth : (this.iMaxWidth > 0 && width > this.iMaxWidth ? this.iMaxWidth : width);
        if (this.bColumnAdded && this.bVisible) {
            this.triggerColumnSizeChange();
        }
    }

    @Override
    public void setAutoTooltip(boolean auto_tooltip) {
        this.auto_tooltip = auto_tooltip;
    }

    @Override
    public boolean doesAutoTooltip() {
        return this.auto_tooltip;
    }

    @Override
    public boolean isInplaceEdit() {
        return this.editable;
    }

    @Override
    public void setInplaceEdit(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean inplaceValueSet(TableCell cell, String value, boolean finalEdit) {
        return false;
    }

    @Override
    public Class getForDataSourceType() {
        return this.forPluginDataSourceType;
    }

    public void setForDataSourceType(Class forDataSourceType) {
        this.forPluginDataSourceType = forDataSourceType;
    }
}

