/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableView;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewImpl<DATASOURCETYPE>
implements TableView<DATASOURCETYPE> {
    private CopyOnWriteList<TableDataSourceChangedListener> listenersDataSourceChanged = new CopyOnWriteList();
    private CopyOnWriteList<TableSelectionListener> listenersSelection = new CopyOnWriteList();
    private CopyOnWriteList<TableLifeCycleListener> listenersLifeCycle = new CopyOnWriteList();
    private CopyOnWriteList<TableRefreshListener> listenersRefresh = new CopyOnWriteList();
    private CopyOnWriteList<TableCountChangeListener> listenersCountChange = new CopyOnWriteList(1);
    private Object parentDataSource;

    @Override
    public void addSelectionListener(TableSelectionListener listener, boolean bFireSelection) {
        this.listenersSelection.add(listener);
        if (bFireSelection) {
            TableRowCore[] rows = this.getSelectedRows();
            listener.selected(rows);
            listener.focusChanged(this.getFocusedRow());
        }
    }

    @Override
    public void addTableDataSourceChangedListener(TableDataSourceChangedListener l, boolean trigger) {
        this.listenersDataSourceChanged.add(l);
        if (trigger) {
            l.tableDataSourceChanged(this.parentDataSource);
        }
    }

    @Override
    public void removeTableDataSourceChangedListener(TableDataSourceChangedListener l) {
        this.listenersDataSourceChanged.remove(l);
    }

    @Override
    public void setParentDataSource(Object newDataSource) {
        this.parentDataSource = newDataSource;
        Object[] listeners = this.listenersDataSourceChanged.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableDataSourceChangedListener l = (TableDataSourceChangedListener)listeners[i];
            l.tableDataSourceChanged(newDataSource);
        }
    }

    protected void triggerDefaultSelectedListeners(TableRowCore[] selectedRows, int keyMask) {
        for (TableSelectionListener l : this.listenersSelection) {
            l.defaultSelected(selectedRows, keyMask);
        }
    }

    protected void triggerLifeCycleListener(int eventType) {
        Object[] listeners = this.listenersLifeCycle.toArray();
        if (eventType == 0) {
            for (int i = 0; i < listeners.length; ++i) {
                TableLifeCycleListener l = (TableLifeCycleListener)listeners[i];
                try {
                    l.tableViewInitialized();
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        } else {
            for (int i = 0; i < listeners.length; ++i) {
                TableLifeCycleListener l = (TableLifeCycleListener)listeners[i];
                try {
                    l.tableViewDestroyed();
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    protected void triggerSelectionListeners(TableRowCore[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            l.selected(rows);
        }
    }

    protected void triggerDeselectionListeners(TableRowCore[] rows) {
        if (rows == null) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            l.deselected(rows);
        }
    }

    protected void triggerMouseEnterExitRow(TableRowCore row, boolean enter) {
        if (row == null) {
            return;
        }
        Object[] listeners = this.listenersSelection.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            if (enter) {
                l.mouseEnter(row);
                continue;
            }
            l.mouseExit(row);
        }
    }

    protected void triggerFocusChangedListeners(TableRowCore row) {
        Object[] listeners = this.listenersSelection.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableSelectionListener l = (TableSelectionListener)listeners[i];
            l.focusChanged(row);
        }
    }

    protected void triggerTableRefreshListeners() {
        Object[] listeners = this.listenersRefresh.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableRefreshListener l = (TableRefreshListener)listeners[i];
            l.tableRefresh();
        }
    }

    @Override
    public void addLifeCycleListener(TableLifeCycleListener l) {
        this.listenersLifeCycle.add(l);
        if (!this.isDisposed()) {
            l.tableViewInitialized();
        }
    }

    @Override
    public void addRefreshListener(TableRefreshListener l, boolean trigger) {
        this.listenersRefresh.add(l);
        if (trigger) {
            l.tableRefresh();
        }
    }

    @Override
    public void addCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.add(listener);
    }

    public void removeCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.remove(listener);
    }

    protected void triggerListenerRowAdded(TableRowCore row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowAdded(row);
        }
    }

    protected void triggerListenerRowRemoved(TableRowCore row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowRemoved(row);
        }
    }

    @Override
    public void runForAllRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.getRows();
        if (runner.run(rows)) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }
}

