/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.File;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;

public class UIConfigDefaultsSWTv3 {
    public static void initialize(AzureusCore core) {
        ConfigurationManager config = ConfigurationManager.getInstance();
        if (System.getProperty("FORCE_PROGRESSIVE", "").length() > 0) {
            config.setParameter("Prioritize First Piece", true);
            config.save();
        }
        String sFirstVersion = config.getStringParameter("First Recorded Version");
        final ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
        defaults.addParameter("Wizard Completed", true);
        defaults.addParameter("ui", "az3");
        if (Constants.compareVersions(sFirstVersion, "2.5.0.0") == 0) {
            String sDefSavePath = config.getStringParameter("Default save path");
            System.out.println(sDefSavePath);
            String sDefPath = null;
            try {
                sDefPath = defaults.getStringParameter("Default save path");
            }
            catch (ConfigurationParameterNotFoundException e) {
                e.printStackTrace();
            }
            if (sDefPath != null) {
                File fNewPath = new File(sDefPath);
                if (sDefSavePath != null && fNewPath.equals(new File(sDefSavePath))) {
                    sFirstVersion = "3.0.0.5";
                    config.setParameter("First Recorded Version", sFirstVersion);
                    config.save();
                }
            }
        }
        boolean virginSwitch = config.getBooleanParameter("az3.virgin.switch", false);
        boolean immediateSwitch = config.getBooleanParameter("az3.switch.immediate", false);
        if (Constants.compareVersions(sFirstVersion, "3.0.0.0") >= 0 || immediateSwitch) {
            if (!config.isNewInstall() && Constants.compareVersions(sFirstVersion, "3.0.0.4") < 0) {
                String userPath = SystemProperties.getUserPath();
                File fOldPath = new File(userPath, "data");
                String sDefSavePath = config.getStringParameter("Default save path");
                String sDefPath = "";
                try {
                    sDefPath = defaults.getStringParameter("Default save path");
                }
                catch (ConfigurationParameterNotFoundException e) {
                    // empty catch block
                }
                File fNewPath = new File(sDefPath);
                if (sDefSavePath != null && fNewPath.equals(new File(sDefSavePath))) {
                    sFirstVersion = "3.0.0.5";
                    config.setParameter("First Recorded Version", sFirstVersion);
                    config.save();
                } else {
                    if (sDefSavePath == null || !fOldPath.equals(new File(sDefSavePath))) {
                        sFirstVersion = "2.5.0.0";
                        config.setParameter("First Recorded Version", sFirstVersion);
                        config.save();
                        return;
                    }
                    config.removeParameter("Default save path");
                }
            }
            defaults.addParameter("Auto Upload Speed Enabled", true);
            defaults.addParameter("Use default data dir", true);
            defaults.addParameter("Add URL Silently", true);
            defaults.addParameter("add_torrents_silently", true);
            defaults.addParameter("Popup Download Finished", false);
            defaults.addParameter("Popup Download Added", false);
            defaults.addParameter("Status Area Show SR", false);
            defaults.addParameter("Status Area Show NAT", false);
            defaults.addParameter("Status Area Show IPF", false);
            defaults.addParameter("Message Popup Autoclose in Seconds", 10);
            defaults.addParameter("window.maximized", true);
            defaults.addParameter("update.autodownload", true);
            defaults.addParameter("suppress_file_download_dialog", true);
            defaults.addParameter("auto_remove_inactive_items", false);
            defaults.addParameter("show_torrents_menu", false);
            config.save();
        }
        defaults.addParameter("v3.topbar.show.frog", false);
        defaults.addParameter("v3.topbar.show.plugin", false);
        defaults.addParameter("ui.toolbar.uiswitcher", false);
        defaults.addParameter("pluginbar.visible", false);
        config.removeParameter("v3.home-tab.starttab");
        defaults.addParameter("v3.topbar.height", 60);
        defaults.addParameter("v3.Start Advanced", false);
        defaults.addParameter("MyTorrentsView.table.style", 0);
        defaults.addParameter("v3.Show Welcome", true);
        boolean startAdvanced = config.getBooleanParameter("v3.Start Advanced");
        defaults.addParameter("Library.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryDL.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryUnopened.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryCD.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("list.dm.dblclick", "0");
        defaults.addParameter("vista.adminquit", false);
        defaults.addParameter("Password enabled", false);
        defaults.addParameter("Start Minimized", false);
        defaults.addParameter("Password enabled", false);
        defaults.addParameter("ToolBar.showText", true);
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void started(AzureusCore core) {
                defaults.addParameter("Plugin.DHT.dht.warn.user", false);
                defaults.addParameter("Plugin.UPnP.upnp.alertothermappings", false);
                defaults.addParameter("Plugin.UPnP.upnp.alertdeviceproblems", false);
            }
        });
    }
}

