/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser;

import com.aelitis.azureus.core.messenger.PlatformAuthorizedSender;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class PlatformAuthorizedSenderImpl
implements PlatformAuthorizedSender {
    String s = null;
    private Shell shell = null;

    public void startDownload(final URL url, final String data, final AESemaphore sem_waitDL, final boolean loginAndRetry) {
        Utils.execSWTThread(new AERunnable(){
            boolean[] isRetry = new boolean[]{false};

            public void runSupport() {
                try {
                    boolean ourShell = false;
                    Shell shell = PlatformAuthorizedSenderImpl.this.shell;
                    if (shell == null) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            shell = uiFunctions.getMainShell();
                        }
                        if (shell != null) {
                            PlatformAuthorizedSenderImpl.this.shell = shell;
                        } else {
                            shell = new Shell();
                            shell.setVisible(false);
                            ourShell = true;
                        }
                    }
                    final Browser browser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
                    browser.setVisible(false);
                    if (ourShell) {
                        final Shell shellFinal = shell;
                        browser.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                Utils.execSWTThreadLater(0, new AERunnable(){

                                    public void runSupport() {
                                        shellFinal.dispose();
                                    }
                                });
                            }
                        });
                    }
                    String responseType = Constants.isOSX ? "text/html" : "text/plain";
                    String fullUrl = url + "?" + data + "&responseType=" + responseType;
                    PlatformMessenger.debug("Open Auth URL: " + url + " in " + responseType + "\n" + fullUrl);
                    browser.addProgressListener(new ProgressListener(){

                        public void completed(ProgressEvent event2) {
                            PlatformAuthorizedSenderImpl.this.parseAuthorizedListenerResult(browser, sem_waitDL, isRetry, loginAndRetry);
                        }

                        public void changed(ProgressEvent event2) {
                        }
                    });
                    browser.setUrl(fullUrl);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    sem_waitDL.release();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAuthorizedListenerResult(final Browser browser, final AESemaphore sem_waitDL, boolean[] isRetry, boolean loginAndRetry) {
        if (browser.isDisposed()) {
            sem_waitDL.release();
            return;
        }
        boolean went_async = false;
        try {
            this.s = browser.getText();
            boolean authFail = this.s.indexOf(";exception;") > 0 && this.s.indexOf("authenticat") > 0 && this.s.indexOf("required") > 0;
            int i = this.s.indexOf("0;");
            if (i < 0) {
                String partial = this.s.length() == 0 ? "" : this.s.substring(0, Math.min(200, this.s.length()));
                PlatformMessenger.debug("Got BAD Auth Reply ( " + this.s.length() + "): " + partial);
            }
            if (authFail && loginAndRetry && !isRetry[0]) {
                this.s = null;
                isRetry[0] = true;
                went_async = true;
                SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

                    public void loginComplete() {
                        browser.refresh();
                    }

                    public void loginCanceled() {
                        browser.dispose();
                        sem_waitDL.release();
                    }
                });
            } else {
                if (i > 0) {
                    this.s = this.s.substring(i);
                }
                if (Constants.isOSX) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            browser.dispose();
                        }
                    });
                } else {
                    browser.dispose();
                }
            }
        }
        finally {
            if (!went_async) {
                sem_waitDL.release();
            }
        }
    }

    public String getResults() {
        return this.s;
    }

    public void clearResults() {
        this.s = null;
    }
}

