/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.util.MapUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;

public class BrowserRpcBuddyListener
extends AbstractBrowserMessageListener {
    private static final String DEFAULT_LISTENER_ID = "buddy";
    public static final String OP_ACCEPT = "accept";
    public static final String OP_INVITE = "invite";
    public static final String OP_SYNC = "sync";

    public BrowserRpcBuddyListener() {
        super(DEFAULT_LISTENER_ID);
    }

    public void handleMessage(BrowserMessage message) {
        try {
            String opid = message.getOperationId();
            Map decodedMap = message.getDecodedMap();
            if (OP_ACCEPT.equals(opid)) {
                Map mapBuddy = MapUtils.getMapMap(decodedMap, DEFAULT_LISTENER_ID, Collections.EMPTY_MAP);
                String code = MapUtils.getMapString(decodedMap, "code", null);
                VuzeBuddyManager.log("buddy accept " + mapBuddy.get("login-id") + "/" + code);
                if (mapBuddy.size() > 0) {
                    List pkList = MapUtils.getMapList(mapBuddy, "pks", Collections.EMPTY_LIST);
                    String[] pks = pkList.toArray(new String[0]);
                    VuzeBuddyManager.acceptInvite(code, pks);
                }
            } else if (OP_INVITE.equals(opid)) {
                VuzeBuddyManager.inviteWithShare(decodedMap, null, null, null);
            } else if (OP_SYNC.equals(opid)) {
                long last = MapUtils.getMapLong(decodedMap, "min-time-secs", 0L);
                if (SystemTime.getCurrentTime() - PlatformBuddyMessenger.getLastSyncCheck() > last * 1000L) {
                    PlatformBuddyMessenger.sync(null);
                }
            }
        }
        catch (Throwable t) {
            message.debug("handle Config message", t);
        }
    }
}

