/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.AbstractBrowserRequestListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.StatusListener;
import com.aelitis.azureus.ui.swt.shells.LightBoxBrowserWindow;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import org.gudy.azureus2.core3.util.Debug;

public class LightBoxBrowserListener
extends AbstractBrowserRequestListener {
    private LightBoxBrowserWindow browserWindow;

    public LightBoxBrowserListener(LightBoxBrowserWindow browserWindow) {
        this.browserWindow = browserWindow;
    }

    public void handleResize() {
        if (null != this.browserWindow) {
            this.browserWindow.setSize(this.getWidth(), this.getHeight());
        }
    }

    public void handleClose() {
        if (null != this.browserWindow) {
            this.browserWindow.close();
        }
        if (null != this.getStatusMessage()) {
            try {
                BrowserMessage statusMessage = new BrowserMessage(this.getStatusMessage());
                new StatusListener().handleMessage(statusMessage);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.isRedirect() && null != this.browserWindow.getRedirectURL()) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (null == uiFunctions) {
                throw new IllegalStateException("No instance of UIFunctionsSWT found; the UIFunctionsManager might not have been initialized properly");
            }
            if (uiFunctions instanceof UIFunctionsImpl) {
                SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            }
        }
        if (null != this.getDisplayMessage()) {
            try {
                BrowserMessage displayMessage = new BrowserMessage(this.getDisplayMessage());
                if ("open-url".equals(displayMessage.getOperationId())) {
                    new DisplayListener(null).handleMessage(displayMessage);
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void handleRefresh() {
        if (null != this.browserWindow) {
            this.browserWindow.refresh();
        }
    }
}

