/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;

public class VuzeListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "vuze";
    public static final String OP_LOAD_VUZE_FILE = "load-vuze-file";

    public VuzeListener() {
        super(DEFAULT_LISTENER_ID);
    }

    public void handleMessage(BrowserMessage message) {
        VuzeFile vf;
        VuzeFileHandler vfh;
        String opid = message.getOperationId();
        if (OP_LOAD_VUZE_FILE.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String content = MapUtils.getMapString(decodedMap, "content", null);
            if (content == null) {
                throw new IllegalArgumentException("content missing");
            }
            byte[] bytes = Base32.decode(content);
            vfh = VuzeFileHandler.getSingleton();
            vf = vfh.loadVuzeFile(bytes);
            if (vf == null) {
                throw new IllegalArgumentException("content invalid");
            }
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
        vfh.handleFiles(new VuzeFile[]{vf}, 0);
    }
}

