/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserTransaction;
import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.utils.ImageResizeException;
import com.aelitis.azureus.ui.swt.utils.ImageResizer;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.PublishUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentCreator;
import org.gudy.azureus2.plugins.torrent.TorrentCreatorListener;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class PublishTransaction
extends BrowserTransaction {
    private static final String ELEMENTS = "elements";
    private static final int DEFAULT_IMAGE_BOX_SIZE = 320;
    private static final float DEFAULT_JPEG_QUALITY = 0.85f;
    private Shell shell;
    private LocalHoster hoster;
    private TorrentCreator creator;
    private TorrentCreatorListener creatorListener;
    private File dataFile;

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setLocalHoster(LocalHoster hoster) {
        this.hoster = hoster;
    }

    public PublishTransaction(int id, String type, ClientMessageContext context2) {
        super(id, type, context2);
    }

    public void chooseFile(BrowserMessage message) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDialog dialog = new FileDialog(PublishTransaction.this.shell);
                String file = dialog.open();
                PublishTransaction.this.createTorrentFile(file);
            }
        });
    }

    public void chooseFolder(BrowserMessage message) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DirectoryDialog dialog = new DirectoryDialog(PublishTransaction.this.shell);
                String file = dialog.open();
                PublishTransaction.this.createTorrentFile(file);
            }
        });
    }

    protected boolean canceling() {
        if (this.creator != null) {
            this.creator.cancel();
            this.creator.removeListener(this.creatorListener);
            this.creator = null;
        }
        return true;
    }

    public void chooseThumbnail(final BrowserMessage message) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.SWT_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PublishTransaction.this._chooseThumbnail(message);
            }
        });
    }

    private void _chooseThumbnail(BrowserMessage message) {
        int[] resize_size = new int[]{320, 320};
        float[] image_quality = new float[]{0.85f};
        Map elements = null;
        if (message.isParamObject()) {
            Map parameters = message.getDecodedMap();
            try {
                resize_size[0] = MapUtils.getMapInt(parameters, "width", 320);
                resize_size[1] = MapUtils.getMapInt(parameters, "height", 320);
                image_quality[0] = ((Number)MapUtils.getMapObject(parameters, "quality", new Double(0.85f), Number.class)).floatValue();
                if (parameters.containsKey(ELEMENTS)) {
                    elements = (Map)parameters.get(ELEMENTS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"Image Files"});
        dialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.bmp;*.gif;*.png;*.tiff,*.tif"});
        String fileName = dialog.open();
        if (fileName != null) {
            try {
                this.sendBrowserMessage("thumb", "start", elements);
                File file = new File(fileName);
                ResizedImageInfo info = this.loadAndResizeImage(file, resize_size[0], resize_size[1], 1.0f);
                if (info == null) {
                    this.debug("User canceled image resizing");
                    this.sendBrowserMessage("thumb", "clear", elements);
                } else {
                    String thumbURL = info.url.toString();
                    this.debug("Size : " + info.data.length);
                    String encoded = new String(Base64.encode(info.data));
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", thumbURL);
                    params.put("width", new Long(info.width));
                    params.put("height", new Long(info.height));
                    params.put("data", encoded);
                    if (elements != null) {
                        params.put(ELEMENTS, elements);
                    }
                    this.sendBrowserMessage("thumb", "done", params);
                }
            }
            catch (ImageResizeException e) {
                this.debug("Error resizing image", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("message", e.getMessage());
                this.sendBrowserMessage("page", "error", params);
            }
            catch (Exception e) {
                this.debug("Error reading file", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                HashMap<String, String> params = new HashMap<String, String>();
                String errmsg = e.getMessage();
                params.put("message", "Vuze cannot process this image. Please select another one.\n\nDetailed Error: " + errmsg);
                this.sendBrowserMessage("page", "error", params);
            }
            catch (OutOfMemoryError e) {
                this.debug("Error processing the image", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("message", "Vuze cannot process this image (likely reason is that it is too big). Please select another one.");
                this.sendBrowserMessage("page", "error", params);
            }
        }
    }

    public void torrentIsReady(BrowserMessage message) {
        String torrent = MapUtils.getMapString(message.getDecodedMap(), "torrent", null);
        if (torrent != null) {
            this.torrentIsReady(torrent);
        }
    }

    protected void torrentIsReady(String strTorrent) {
        try {
            strTorrent = strTorrent.replaceAll("\\n", "");
            this.debug("data file path = [" + this.dataFile.getPath() + "]");
            this.debug("Torrent is ready, size = " + strTorrent.length() + ", content (base64) : " + strTorrent);
            byte[] torrent_data = Base64.decode(strTorrent);
            this.debug("Torrent Byte Length: " + torrent_data.length);
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            Torrent torrent = pi.getTorrentManager().createFromBEncodedData(torrent_data);
            torrent.setDefaultEncoding();
            torrent.setComplete(this.dataFile);
            Download download = pi.getDownloadManager().addDownload(torrent, null, this.dataFile);
            PublishUtils.setPublished(download);
            download.setForceStart(true);
            this.stop();
        }
        catch (Throwable t) {
            Debug.out("torrentIsReady", t);
        }
    }

    private void torrentCreationFailed(Exception cause) {
        this.debug("Torrent Creation Failed", cause);
        this.sendBrowserMessage("torrent", "failed");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", "Vuze cannot process this file. Please select another file.");
        this.sendBrowserMessage("page", "error", params);
    }

    private void createTorrentFile(String file) {
        if (file != null) {
            this.dataFile = new File(file);
            try {
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                this.creator = pi.getTorrentManager().createFromDataFileEx(this.dataFile, new URL("http://xxxxxxxxxxxxxxxxx:6969/announce"), false);
                this.creatorListener = new TorrentCreatorListener(){

                    public void complete(Torrent torrent) {
                        try {
                            torrent.setDefaultEncoding();
                            PublishTransaction.this.debug("local torrent creation complete: " + torrent.getName() + " : " + torrent.getMagnetURI());
                            String tData = new String(Base64.encode(torrent.writeToBEncodedData()));
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("data", tData);
                            PublishTransaction.this.sendBrowserMessage("torrent", "done", params);
                        }
                        catch (Throwable t) {
                            PublishTransaction.this.debug("error encoding torrent", t);
                        }
                    }

                    public void failed(TorrentException cause) {
                        PublishTransaction.this.torrentCreationFailed(cause);
                    }

                    public void reportActivity(String activity) {
                    }

                    public void reportPercentageDone(int percent) {
                        HashMap<String, Long> params = new HashMap<String, Long>();
                        params.put("percent", new Long(percent));
                        PublishTransaction.this.sendBrowserMessage("torrent", "progress", params);
                    }
                };
                this.creator.addListener(this.creatorListener);
                this.creator.start();
            }
            catch (MalformedURLException e) {
                this.torrentCreationFailed(e);
            }
            catch (TorrentException e) {
                this.torrentCreationFailed(e);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("folder", new Boolean(this.dataFile.isDirectory()));
            params.put("name", this.dataFile.getName());
            Long[] info = this.getSizeAndCount(this.dataFile);
            params.put("size", info[0]);
            params.put("num-files", info[1]);
            params.put("size-text", DisplayFormatters.formatByteCountToKiBEtc(info[0]));
            this.sendBrowserMessage("torrent", "chosen", params);
        } else {
            this.cancel();
            this.stop();
        }
    }

    private Long[] getSizeAndCount(File folderFile) {
        if (folderFile.isFile()) {
            return new Long[]{new Long(folderFile.length()), new Long(1L)};
        }
        if (folderFile.isDirectory()) {
            long size = 0L;
            long numFiles = 0L;
            File[] files = folderFile.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    Long[] sizeAndCount = this.getSizeAndCount(file);
                    size += sizeAndCount[0].longValue();
                    numFiles += sizeAndCount[1].longValue();
                }
            }
            return new Long[]{new Long(size), new Long(numFiles)};
        }
        return new Long[]{new Long(0L), new Long(0L)};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResizedImageInfo loadAndResizeImage(File f, int width, int height, float quality) throws Exception {
        String ext;
        ImageLoader loader = new ImageLoader();
        Display display = this.shell.getDisplay();
        Image source = null;
        try {
            source = new Image((Device)this.shell.getDisplay(), f.getAbsolutePath());
        }
        catch (Error e) {
            // empty catch block
        }
        if (source == null) {
            throw new ImageResizeException("Unable to read image.  Please choose another.");
        }
        Rectangle bounds = source.getBounds();
        try {
            if (bounds.width == width && bounds.height == height && f.length() >= 60000L) {
                // empty if block
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        ImageResizer resizer = new ImageResizer(display, width, height, this.shell);
        Image output = resizer.resize(source);
        if (output == null) {
            return null;
        }
        ImageData data = output.getImageData();
        if (output != null && !output.isDisposed()) {
            output.dispose();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        loader.data = new ImageData[]{data};
        if (SWT.getVersion() >= 3500) {
            loader.save((OutputStream)baos, 5);
            ext = ".png";
        } else {
            try {
                Class<?> cJPGFF = Class.forName("org.eclipse.swt.internal.image.JPEGFileFormat");
                Constructor<?> jpgConst = cJPGFF.getDeclaredConstructor(new Class[0]);
                jpgConst.setAccessible(true);
                FileFormat format = (FileFormat)jpgConst.newInstance(new Object[0]);
                Field field = cJPGFF.getDeclaredField("encoderQFactor");
                field.setAccessible(true);
                field.setInt(format, (int)(quality * 100.0f));
                Class<?> claLEDataOS = Class.forName("org.eclipse.swt.internal.image.LEDataOutputStream");
                Constructor<?> le_constructor = claLEDataOS.getDeclaredConstructor(OutputStream.class);
                le_constructor.setAccessible(true);
                Object le_stream = le_constructor.newInstance(baos);
                Method unloadIntoStream = cJPGFF.getMethod("unloadIntoStream", ImageLoader.class, claLEDataOS);
                try {
                    unloadIntoStream.invoke((Object)format, loader, le_stream);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                loader.save((OutputStream)baos, 4);
            }
            ext = ".jpg";
        }
        byte[] bs = baos.toByteArray();
        File fDest = File.createTempFile("thumbnail", ext);
        FileOutputStream fos = new FileOutputStream(fDest);
        fos.write(bs);
        fos.close();
        URL url = this.hoster.hostFile(fDest);
        return new ResizedImageInfo(url, width, height, bs);
    }

    private class ResizedImageInfo {
        public URL url;
        public int width;
        public int height;
        public byte[] data;

        public ResizedImageInfo(URL url, int width, int height, byte[] data) {
            this.url = url;
            this.width = width;
            this.height = height;
            this.data = data;
        }
    }
}

