/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.msg;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.ui.swt.browser.msg.MessageListener;
import com.aelitis.azureus.util.UrlFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class MessageDispatcherSWT
implements StatusTextListener,
TitleListener,
BrowserMessageDispatcher {
    public static final String LISTENER_ID = "dispatcher";
    public static final String OP_RESET_SEQUENCE = "reset-sequence";
    public static final String CONTEXT_LISTENER_ID = "context";
    private static final int INITIAL_LAST_SEQUENCE = -1;
    private ClientMessageContext context;
    private Map listeners = new HashMap();
    private int lastSequence = -1;
    private String sLastEventText;
    private AEMonitor class_mon = new AEMonitor("MessageDispatcher");
    private Browser browser;

    public MessageDispatcherSWT(ClientMessageContext context2) {
        this.context = context2;
    }

    public void registerBrowser(Browser browser) {
        this.browser = browser;
        browser.addStatusTextListener((StatusTextListener)this);
        browser.addTitleListener((TitleListener)this);
    }

    public void deregisterBrowser(Browser browser) {
        browser.removeStatusTextListener((StatusTextListener)this);
        browser.removeTitleListener((TitleListener)this);
    }

    public synchronized void addListener(BrowserMessageListener listener) {
        String id = listener.getId();
        BrowserMessageListener registered = (BrowserMessageListener)this.listeners.get(id);
        if (registered != null) {
            if (registered != listener) {
                throw new IllegalStateException("Listener " + registered.getClass().getName() + " already registered for ID " + id);
            }
        } else {
            listener.setContext(this.context);
            this.listeners.put(id, listener);
        }
    }

    public void addListener(MessageListener listener) {
        if (listener instanceof BrowserMessageListener) {
            this.addListener((BrowserMessageListener)listener);
        }
    }

    public synchronized void removeListener(BrowserMessageListener listener) {
        this.removeListener(listener.getId());
    }

    public synchronized void removeListener(String id) {
        BrowserMessageListener removed = (BrowserMessageListener)this.listeners.remove(id);
        if (removed != null) {
            removed.setContext(null);
        }
    }

    public BrowserMessageListener getListener(String id) {
        return (BrowserMessageListener)this.listeners.get(id);
    }

    public void changed(StatusTextEvent event2) {
        this.processIncomingMessage(event2.text, ((Browser)event2.widget).getUrl());
    }

    public void changed(TitleEvent event2) {
        this.processIncomingMessage(event2.title, ((Browser)event2.widget).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingMessage(String msg, String referer) {
        if (msg == null) {
            return;
        }
        try {
            this.class_mon.enter();
            if (this.sLastEventText != null && msg.equals(this.sLastEventText)) {
                return;
            }
            this.sLastEventText = msg;
        }
        finally {
            this.class_mon.exit();
        }
        if (msg.startsWith("AZMSG")) {
            try {
                BrowserMessage browserMessage = new BrowserMessage(msg);
                browserMessage.setReferer(referer);
                this.dispatch(browserMessage);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void dispatch(final BrowserMessage message) {
        String listenerId;
        if (message == null) {
            return;
        }
        String referer = message.getReferer();
        if (referer != null && !UrlFilter.getInstance().urlCanRPC(referer)) {
            this.context.debug("blocked " + message + "\n  " + referer);
            return;
        }
        this.context.debug("Received " + message);
        if (this.browser != null && !this.browser.isDisposed() && Utils.isThisThreadSWT()) {
            this.context.debug("   browser url: " + this.browser.getUrl());
        }
        if (LISTENER_ID.equals(listenerId = message.getListenerId())) {
            this.handleMessage(message);
        } else if (!this.isValidSequence(message)) {
            this.context.debug("Ignoring duplicate: " + message);
        } else {
            final BrowserMessageListener listener = this.getListener(listenerId);
            if (listener == null) {
                this.context.debug("No listener registered with ID " + listenerId);
            } else {
                new AEThread2("dispatch for " + listenerId, true){

                    public void run() {
                        listener.handleMessage(message);
                        message.complete(true, true, null);
                    }
                }.start();
            }
        }
    }

    public void handleMessage(BrowserMessage message) {
        String operationId = message.getOperationId();
        if (!OP_RESET_SEQUENCE.equals(operationId)) {
            throw new IllegalArgumentException("Unknown operation: " + operationId);
        }
        this.resetSequence();
    }

    public boolean isValidSequence(BrowserMessage message) {
        int sequence = message.getSequence();
        if (sequence < 0) {
            Debug.outNoStack("Invalid sequence number: " + sequence);
            return false;
        }
        if (sequence <= this.lastSequence) {
            this.context.debug("Duplicate sequence number: " + sequence + ", last: " + this.lastSequence);
            return false;
        }
        this.lastSequence = sequence;
        return true;
    }

    public void resetSequence() {
        this.context.debug("Reseting sequence number");
        this.lastSequence = -1;
    }
}

