/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.buddy.chat.impl;

import com.aelitis.azureus.buddy.chat.Chat;
import com.aelitis.azureus.buddy.chat.ChatDiscussion;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.chat.DiscussionListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.AvatarWidget;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;

public class ChatWindow
implements DiscussionListener {
    private static List chatWindows = new ArrayList();
    AvatarWidget avatar;
    Chat chat;
    ChatDiscussion discussion;
    Display display;
    Shell shell;
    Color white;
    ScrolledComposite messagesHolder;
    Composite messages;
    Text input;
    Listener moveListener;
    Font textFont;
    Font nameFont;
    Font timeFont;
    PaintListener myNameHighligther;
    PaintListener friendNameHighlighter;
    static DateFormat dateFormater = new SimpleDateFormat("hh:mm a");
    static final int border = 5;
    static final int spacing = 5;
    Listener linkListener;
    String lastSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatWindow(AvatarWidget _avatar, Chat _chat, ChatDiscussion _discussion) {
        int i;
        this.avatar = _avatar;
        this.chat = _chat;
        this.discussion = _discussion;
        List list = chatWindows;
        synchronized (list) {
            chatWindows.add(this);
        }
        this.linkListener = new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                Program.launch((String)text);
            }
        };
        Control avatarControl = this.avatar.getControl();
        this.display = avatarControl.getDisplay();
        this.shell = new Shell(this.avatar.getControl().getShell(), 68);
        this.shell.setText(MessageText.getString("v3.buddy.menu.chat"));
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event e) {
                ChatWindow.this.close();
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                    ChatWindow.this.hide();
                }
            }
        });
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 3;
        fillLayout.marginWidth = 3;
        this.shell.setLayout((Layout)fillLayout);
        final Composite mainPanel = new Composite((Composite)this.shell, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        mainPanel.setLayout((Layout)formLayout);
        mainPanel.setBackgroundMode(1);
        this.myNameHighligther = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Label label = (Label)e.widget;
                String text = (String)label.getData("text");
                if (text != null) {
                    Point p = label.getSize();
                    try {
                        e.gc.setTextAntialias(1);
                        e.gc.setAntialias(1);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    e.gc.setForeground(ColorCache.getColor((Device)ChatWindow.this.display, 93, 93, 93));
                    e.gc.setBackground(ColorCache.getColor((Device)ChatWindow.this.display, 208, 208, 208));
                    e.gc.fillRoundRectangle(0, 0, p.x, p.y, 12, 12);
                    e.gc.drawText(text, 4, 0);
                }
            }
        };
        this.friendNameHighlighter = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Label label = (Label)e.widget;
                String text = (String)label.getData("text");
                if (text != null) {
                    Point p = label.getSize();
                    try {
                        e.gc.setTextAntialias(1);
                        e.gc.setAntialias(1);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    e.gc.setForeground(ColorCache.getColor((Device)ChatWindow.this.display, 93, 93, 93));
                    e.gc.setBackground(ColorCache.getColor((Device)ChatWindow.this.display, 192, 204, 220));
                    e.gc.fillRoundRectangle(0, 0, p.x, p.y, 12, 12);
                    e.gc.drawText(text, 4, 0);
                }
            }
        };
        FontData[] fDatas = this.shell.getFont().getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
                continue;
            }
            fDatas[i].setHeight(10);
        }
        this.textFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(9);
                continue;
            }
            fDatas[i].setHeight(7);
        }
        this.timeFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(14);
            } else {
                fDatas[i].setHeight(12);
            }
            fDatas[i].setStyle(1);
        }
        this.nameFont = new Font((Device)this.display, fDatas);
        Canvas avatarPicture = new Canvas(mainPanel, 0);
        avatarPicture.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image avatarImage = ChatWindow.this.avatar.getVuzeBuddy().getAvatarImage();
                if (avatarImage != null) {
                    Rectangle size = avatarImage.getBounds();
                    e.gc.drawImage(avatarImage, 0, 0, size.width, size.height, 0, 0, 30, 30);
                }
                ChatWindow.this.avatar.getVuzeBuddy().releaseAvatarImage(avatarImage);
            }
        });
        FormData data = new FormData();
        data.width = 30;
        data.height = 30;
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        avatarPicture.setLayoutData((Object)data);
        Label avatarName = new Label(mainPanel, 0);
        avatarName.setFont(this.nameFont);
        avatarName.setText(this.avatar.getVuzeBuddy().getDisplayName());
        data = new FormData();
        data.left = new FormAttachment((Control)avatarPicture, 5);
        data.top = new FormAttachment((Control)avatarPicture, -6, 0x1000000);
        data.right = new FormAttachment(100, -5);
        avatarName.setLayoutData((Object)data);
        this.messagesHolder = new ScrolledComposite(mainPanel, 2560);
        this.messagesHolder.setBackground(mainPanel.getDisplay().getSystemColor(25));
        this.messagesHolder.setAlwaysShowScrollBars(true);
        this.messagesHolder.setExpandHorizontal(true);
        this.messagesHolder.setExpandVertical(true);
        this.messages = new Composite((Composite)this.messagesHolder, 0);
        this.messages.setBackground(this.messagesHolder.getBackground());
        GridLayout messagesLayout = new GridLayout();
        messagesLayout.verticalSpacing = 5;
        this.messages.setLayout((Layout)messagesLayout);
        this.messagesHolder.setContent((Control)this.messages);
        List chatMessages = this.discussion.getAllMessages();
        for (int i2 = 0; i2 < chatMessages.size(); ++i2) {
            ChatMessage cm = (ChatMessage)chatMessages.get(i2);
            cm.setRendered();
            this.renderMessage(cm);
        }
        this.discussion.setListener(new DiscussionListener(){

            public void newMessage(final ChatMessage message) {
                message.setRendered();
                if (!ChatWindow.this.display.isDisposed()) {
                    ChatWindow.this.display.asyncExec(new Runnable(){

                        public void run() {
                            if (!ChatWindow.this.messages.isDisposed()) {
                                ChatWindow.this.renderMessage(message);
                            }
                        }
                    });
                }
            }
        });
        this.input = new Text(mainPanel, 64);
        this.input.setBackground(this.messagesHolder.getBackground());
        this.input.setTextLimit(256);
        this.input.setFont(this.textFont);
        this.input.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 13) {
                    String text = ChatWindow.this.input.getText().trim();
                    if (text.length() > 0) {
                        ChatWindow.this.chat.sendMessage(ChatWindow.this.avatar.getVuzeBuddy(), text);
                    }
                    ChatWindow.this.input.setText("");
                }
            }
        });
        this.input.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                mainPanel.layout();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.input.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)avatarPicture, 5);
        data.bottom = new FormAttachment((Control)this.input, -5);
        this.messagesHolder.setLayoutData((Object)data);
        this.shell.setSize(250, 300);
        this.setPosition();
        this.input.setFocus();
        if (this.avatar.getVuzeBuddy().getVersion() < 2) {
            this.renderSystemMessage(MessageText.getString("v3.chat.wrongversion", new String[]{this.avatar.getVuzeBuddy().getDisplayName()}));
            this.input.setEnabled(false);
        } else if (!this.avatar.getVuzeBuddy().isOnline(true)) {
            this.renderSystemMessage(MessageText.getString("v3.chat.offline", new String[]{this.avatar.getVuzeBuddy().getDisplayName()}));
        }
        this.shell.open();
        this.display.asyncExec(new Runnable(){

            public void run() {
                ChatWindow.this.avatar.getControl().redraw();
            }
        });
    }

    private void renderSystemMessage(String message) {
        Composite messageHolder = new Composite(this.messages, 0);
        messageHolder.setBackground(ColorCache.getColor((Device)this.display, 244, 238, 188));
        FillLayout layout = new FillLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 5;
        messageHolder.setLayout((Layout)layout);
        Label text = new Label(messageHolder, 64);
        text.setBackground(ColorCache.getColor((Device)this.display, 244, 238, 188));
        text.setText(message);
        messageHolder.setLayoutData((Object)new GridData(768));
        this.messages.layout();
    }

    private void renderMessage(ChatMessage message) {
        long time;
        FormData data;
        Composite messageHolder = new Composite(this.messages, 0);
        messageHolder.setBackgroundMode(2);
        messageHolder.setBackground(this.messagesHolder.getBackground());
        messageHolder.setLayout((Layout)new FormLayout());
        Label name = null;
        Label time_lab = new Label(messageHolder, 0);
        String sender = message.getSender();
        if (sender != null) {
            if (!sender.equals(this.lastSender)) {
                name = new Label(messageHolder, 0);
                name.setData("text", (Object)message.getSender());
                data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                name.setLayoutData((Object)data);
                if (message.isMe()) {
                    name.addPaintListener(this.myNameHighligther);
                } else {
                    name.addPaintListener(this.friendNameHighlighter);
                }
            }
            this.lastSender = sender;
        }
        if ((time = message.getOriginatorTimestamp()) > SystemTime.getCurrentTime()) {
            time = SystemTime.getCurrentTime();
        }
        time_lab.setText(dateFormater.format(new Date(time)));
        data = new FormData();
        if (name != null) {
            data.top = new FormAttachment((Control)name, 1);
        }
        data.right = new FormAttachment(100, 0);
        time_lab.setLayoutData((Object)data);
        time_lab.setFont(this.timeFont);
        Link text = new Link(messageHolder, 64);
        text.setBackground(messageHolder.getBackground());
        text.setForeground(ColorCache.getColor((Device)this.display, 27, 27, 27));
        text.setFont(this.textFont);
        String msg = message.getMessage();
        msg = msg.replaceAll("(?i)((?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\]))", "<a href=\"mailto:$1\">$0</a>");
        msg = msg.replaceAll("(?i)\\b(https?://[^\\s]*?)(\\s|\\]|>|\\z)", "<a href=\"$1\">$0</a>");
        text.setText(msg);
        data = new FormData();
        data.left = new FormAttachment(0, 3);
        data.right = new FormAttachment((Control)time_lab, -3);
        if (name != null) {
            data.top = new FormAttachment((Control)name, 0);
        }
        text.setLayoutData((Object)data);
        text.addListener(13, this.linkListener);
        messageHolder.setLayoutData((Object)new GridData(768));
        this.messages.layout();
        Rectangle r = this.messagesHolder.getClientArea();
        this.messagesHolder.setMinSize(this.messages.computeSize(r.width, -1));
        this.messagesHolder.getVerticalBar().setSelection(this.messagesHolder.getVerticalBar().getMaximum());
        this.messagesHolder.layout();
        if (this.shell.isVisible()) {
            this.discussion.clearNewMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.discussion.clearAllMessages();
        this.discussion.setListener(null);
        this.shell.dispose();
        if (this.textFont != null && !this.textFont.isDisposed()) {
            this.textFont.dispose();
        }
        if (this.nameFont != null && !this.nameFont.isDisposed()) {
            this.nameFont.dispose();
        }
        if (this.timeFont != null && !this.timeFont.isDisposed()) {
            this.timeFont.dispose();
        }
        List list = chatWindows;
        synchronized (list) {
            chatWindows.remove(this);
        }
        this.avatar.getControl().redraw();
    }

    public void setPosition() {
        Control avatarControl = this.avatar.getControl();
        if (this.avatar.isFullyVisible() && !this.shell.isDisposed()) {
            Point shellPosition = avatarControl.toDisplay(0, 0);
            shellPosition.y -= 300;
            int displayWidth = this.display.getBounds().width;
            if (shellPosition.x + 250 > displayWidth) {
                shellPosition.x = displayWidth - 250;
            }
            this.shell.setLocation(shellPosition);
        } else {
            this.hide();
        }
    }

    public void newMessage(final ChatMessage message) {
        if (!this.display.isDisposed()) {
            message.setRendered();
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ChatWindow.this.renderMessage(message);
                    ChatWindow.this.avatar.getControl().redraw();
                }
            });
        }
    }

    public boolean isDisposed() {
        if (this.shell != null) {
            return this.shell.isDisposed();
        }
        return true;
    }

    public boolean isVisible() {
        if (!this.shell.isDisposed()) {
            return this.shell.isVisible();
        }
        return false;
    }

    public void show() {
        if (!this.shell.isDisposed()) {
            this.setPosition();
            this.shell.setVisible(true);
            this.input.setFocus();
            this.discussion.clearNewMessages();
            this.avatar.getControl().redraw();
        }
    }

    public void hide() {
        if (this.discussion.getNbMessages() == 0) {
            this.close();
        }
        if (!this.shell.isDisposed()) {
            this.shell.setVisible(false);
            Color gray = this.display.getSystemColor(16);
            Control[] controls = this.messages.getChildren();
            for (int i = 0; i < controls.length; ++i) {
                Control[] children = ((Composite)controls[i]).getChildren();
                for (int j = 0; j < children.length; ++j) {
                    children[j].setForeground(gray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAllOthers() {
        List list = chatWindows;
        synchronized (list) {
            for (int i = 0; i < chatWindows.size(); ++i) {
                ChatWindow chatWindow = (ChatWindow)chatWindows.get(i);
                if (chatWindow == this || chatWindow.isDisposed()) continue;
                chatWindow.hide();
            }
        }
    }
}

