/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.buddy.chat.impl;

import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.views.skin.AvatarWidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;

public class MessageNotificationWindow {
    private static final int initialAlpha = 230;
    public static int nbOpen = 0;
    public static int currentOffset = 0;

    public MessageNotificationWindow(final AvatarWidget avatar, ChatMessage message) {
        final Display display = avatar.getControl().getDisplay();
        final Shell shell = new Shell(display, 16392);
        Image background = ImageLoader.getInstance().getImage("chatNotification");
        final Region region2 = new Region();
        ImageData imageData = background.getImageData();
        if (imageData.alphaData != null) {
            Rectangle pixel = new Rectangle(0, 0, 1, 1);
            for (int y = 0; y < imageData.height; ++y) {
                for (int x = 0; x < imageData.width; ++x) {
                    if (imageData.getAlpha(x, y) != 255) continue;
                    pixel.x = imageData.x + x;
                    pixel.y = imageData.y + y;
                    region2.add(pixel);
                }
            }
        } else {
            ImageData mask = imageData.getTransparencyMask();
            Rectangle pixel = new Rectangle(0, 0, 1, 1);
            for (int y = 0; y < mask.height; ++y) {
                for (int x = 0; x < mask.width; ++x) {
                    if (mask.getPixel(x, y) == 0) continue;
                    pixel.x = imageData.x + x;
                    pixel.y = imageData.y + y;
                    region2.add(pixel);
                }
            }
        }
        shell.setRegion(region2);
        shell.setBackgroundImage(background);
        shell.setBackgroundMode(2);
        shell.setLayout((Layout)new FormLayout());
        Canvas image = new Canvas((Composite)shell, 0);
        image.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image avatarImage = avatar.getVuzeBuddy().getAvatarImage();
                if (avatarImage != null) {
                    e.gc.drawImage(avatarImage, 0, 0, 40, 40, 0, 0, 30, 30);
                }
                avatar.getVuzeBuddy().releaseAvatarImage(avatarImage);
            }
        });
        Label name = new Label((Composite)shell, 0);
        name.setForeground(display.getSystemColor(1));
        name.setText(message.getSender());
        FontData[] fDatas = name.getFont().getFontData();
        for (int i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
            } else {
                fDatas[i].setHeight(10);
            }
            fDatas[i].setStyle(1);
        }
        final Font nameFont = new Font((Device)display, fDatas);
        name.setFont(nameFont);
        Label text = new Label((Composite)shell, 0);
        text.setForeground(display.getSystemColor(1));
        text.setText(message.getMessage());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 12);
        data.top = new FormAttachment(0, 10);
        data.width = 30;
        data.height = 30;
        image.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)image, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 10);
        name.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)image, 5);
        data.top = new FormAttachment((Control)name, 1);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment((Control)image, 0, 1024);
        text.setLayoutData((Object)data);
        Listener mouseUpListener = new Listener(){

            public void handleEvent(Event arg0) {
                avatar.doChatClicked(true);
                avatar.getControl().getShell().setVisible(true);
                avatar.getControl().getShell().setActive();
                shell.dispose();
                region2.dispose();
                nameFont.dispose();
                if (--nbOpen == 0) {
                    currentOffset = 0;
                }
            }
        };
        shell.addListener(4, mouseUpListener);
        name.addListener(4, mouseUpListener);
        image.addListener(4, mouseUpListener);
        text.addListener(4, mouseUpListener);
        AEThread2 closer = new AEThread2("notification closer", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                try {
                    Thread.sleep(5000L);
                    for (int alpha = 230; alpha > 0; alpha -= 10) {
                        final int _alpha = alpha;
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    if (!shell.isDisposed()) {
                                        try {
                                            shell.setAlpha(_alpha);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (Throwable throwable) {
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (!shell.isDisposed()) {
                                    shell.dispose();
                                    region2.dispose();
                                    nameFont.dispose();
                                    if (--nbOpen == 0) {
                                        currentOffset = 0;
                                    }
                                }
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (!display.isDisposed()) {
                            display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw throwable2;
                    }
                }
                if (!display.isDisposed()) {
                    display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        closer.start();
        Rectangle displayArea = display.getBounds();
        shell.setLocation(displayArea.width - imageData.width - 50, 100 + (imageData.height + 20) * currentOffset);
        shell.setSize(imageData.x + imageData.width, imageData.y + imageData.height);
        try {
            shell.setAlpha(230);
        }
        catch (Throwable t) {
            // empty catch block
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.getInstance().releaseImage("chatNotification");
            }
        });
        shell.open();
        shell.setActive();
        ++nbOpen;
        ++currentOffset;
    }
}

