/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ContentNetworkUI;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnAzProduct
extends CoreTableColumn
implements TableCellAddedListener,
TableCellToolTipListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    private static final String NAME_NOCN = "";
    public static String COLUMN_ID = "AzProduct";
    private static Image imgProductGlobe = ImageLoader.getInstance().getImage("column.azproduct.globe");

    public ColumnAzProduct(String sTableID) {
        super(COLUMN_ID, 3, -2, 40, sTableID);
        this.initializeAsGraphic(40);
    }

    public ColumnAzProduct(TableColumn column) {
        super(null, null);
        column.initialize(3, -2, 40, -1);
        column.setType(2);
        column.addListeners(this);
        ((TableColumnImpl)column).addCellOtherListener("SWTPaint", this);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void cellPaint(GC gc, final TableCellSWT cell) {
        Rectangle dstBounds;
        Object ds = cell.getDataSource();
        Image img = imgProductGlobe;
        ContentNetwork cn = null;
        if (ds != null) {
            long cnID;
            cn = DataSourceUtils.getContentNetwork(ds);
            long l = cnID = cn == null ? -1L : cn.getID();
            if (cnID > 0L) {
                img = ContentNetworkUI.loadImage(cnID, new ContentNetworkUI.ContentNetworkImageLoadedListener(){

                    public void contentNetworkImageLoaded(Long contentNetworkID, Image image, boolean wasReturned) {
                        if (!wasReturned) {
                            cell.invalidate();
                        }
                    }
                });
            }
        }
        if (img == null) {
            return;
        }
        Rectangle imgBounds = img.getBounds();
        Rectangle cellBounds = cell.getBounds();
        if (imgBounds.height > cellBounds.height) {
            int w = cellBounds.height * imgBounds.width / imgBounds.height;
            dstBounds = new Rectangle(imgBounds.x, imgBounds.y, w, cellBounds.height);
            gc.setAdvanced(true);
        } else {
            dstBounds = new Rectangle(imgBounds.x, imgBounds.y, imgBounds.width, imgBounds.height);
        }
        if (cellBounds.width < 60) {
            gc.drawImage(img, imgBounds.x, imgBounds.y, imgBounds.width, imgBounds.height, cellBounds.x + (cellBounds.width - dstBounds.width) / 2, cellBounds.y + (cellBounds.height - dstBounds.height) / 2, dstBounds.width, dstBounds.height);
        } else {
            gc.drawImage(img, imgBounds.x, imgBounds.y, imgBounds.width, imgBounds.height, cellBounds.x + 1, cellBounds.y + (cellBounds.height - dstBounds.height) / 2, dstBounds.width, dstBounds.height);
            cellBounds.x += imgBounds.width + 4;
            cellBounds.width -= imgBounds.width + 4;
            GCStringPrinter.printString(gc, cn == null ? NAME_NOCN : cn.getName(), cellBounds, true, false, 16384);
        }
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds != null) {
            long cnID;
            ContentNetwork cn = DataSourceUtils.getContentNetwork(ds);
            long sortVal = cnID = cn == null ? -1L : cn.getID();
            cell.setSortValue(sortVal);
        }
    }

    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds != null) {
            ContentNetwork cn = DataSourceUtils.getContentNetwork(ds);
            cell.setToolTip(cn == null ? null : cn.getName());
        }
    }

    public void cellHoverComplete(TableCell cell) {
    }
}

