/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.swt.columns.utils.ColumnImageClickArea;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnControls
extends CoreTableColumn
implements TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static String COLUMN_ID = "Controls";
    private static final int COLUMN_WIDTH = 32;
    private static final boolean DEBUG = false;
    private Display display;
    public static Font fontText;
    List listClickAreas = new ArrayList();

    public ColumnControls(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 32, sTableID);
        this.initializeAsGraphic(32);
        this.setMinWidth(32);
        this.setMaxWidth(32);
        this.display = SWTThread.getInstance().getDisplay();
        ColumnImageClickArea clickArea = new ColumnImageClickArea(COLUMN_ID, "up", "image.torrent.up");
        clickArea.setPosition(0, 0);
        this.listClickAreas.add(clickArea);
        clickArea = new ColumnImageClickArea(COLUMN_ID, "down", "image.torrent.down");
        clickArea.setPosition(16, 0);
        this.listClickAreas.add(clickArea);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener,
    TableCellMouseListener,
    TableCellVisibilityListener {
        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginHeight(1);
            cell.setMarginWidth(0);
            cell.setFillCell(true);
            for (ColumnImageClickArea clickArea : ColumnControls.this.listClickAreas) {
                clickArea.addCell(cell);
            }
        }

        public void dispose(TableCell cell) {
            this.disposeExisting(cell);
        }

        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refresh(TableCell cell, boolean bForce) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                this.disposeExisting(cell);
                return;
            }
            int position = dm.getPosition();
            int cellWidth = cell.getWidth();
            int cellHeight = cell.getHeight();
            Image image = null;
            Graphic graphic = cell.getGraphic();
            if (graphic instanceof UISWTGraphic) {
                image = ((UISWTGraphic)graphic).getImage();
            }
            if (image != null) {
                Rectangle bounds = image.getBounds();
                if (!cell.setSortValue(position) && cell.isValid() && bounds.width == cellWidth && bounds.height == cellHeight) {
                    return;
                }
            } else {
                cell.setSortValue(position);
            }
            this.disposeExisting(cell);
            image = new Image((Device)ColumnControls.this.display, cellWidth, cellHeight);
            GC gcImage = new GC((Drawable)image);
            try {
                Color background = ColorCache.getColor((Device)ColumnControls.this.display, cell.getBackground());
                if (background != null) {
                    gcImage.setBackground(background);
                    gcImage.fillRectangle(0, 0, cellWidth, cellHeight);
                }
                int[] fg = cell.getForeground();
                gcImage.setForeground(ColorCache.getColor((Device)ColumnControls.this.display, fg[0], fg[1], fg[2]));
                Rectangle bounds = image.getBounds();
                GCStringPrinter.printString(gcImage, "" + position + (dm.getAssumedComplete() ? "^" : "v"), bounds, true, false, 0x1000400);
                gcImage.setFont(null);
                for (ColumnImageClickArea clickArea : ColumnControls.this.listClickAreas) {
                    clickArea.drawImage(cell, gcImage);
                }
            }
            finally {
                gcImage.dispose();
            }
            this.disposeExisting(cell);
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(image);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(image));
            }
        }

        public void cellMouseTrigger(TableCellMouseEvent event2) {
            if (event2.data instanceof ColumnImageClickArea) {
                DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
                if (dm == null) {
                    return;
                }
                ColumnImageClickArea clickArea = (ColumnImageClickArea)event2.data;
                this.log(event2.cell, "CLICK ON " + clickArea.getId());
                if (clickArea.getId().equals("up")) {
                    dm.getGlobalManager().moveUp(dm);
                } else if (clickArea.getId().equals("down")) {
                    dm.getGlobalManager().moveDown(dm);
                }
                event2.cell.getTableColumn().invalidateCells();
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 1) {
                this.disposeExisting(cell);
            } else if (visibility == 0) {
                this.refresh(cell, true);
            }
        }

        private void disposeExisting(TableCell cell) {
            Image oldImage;
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof UISWTGraphic && (oldImage = ((UISWTGraphic)oldGraphic).getImage()) != null && !oldImage.isDisposed()) {
                cell.setGraphic(null);
                oldImage.dispose();
            }
        }

        private void log(TableCell cell, String s) {
        }
    }
}

