/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnProgressETA
extends CoreTableColumn
implements TableCellAddedListener,
TableCellMouseListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "ProgressETA";
    private static final int borderWidth = 1;
    private static final int COLUMN_WIDTH = 150;
    public static final long SHOW_ETA_AFTER_MS = 30000L;
    private static final Object CLICK_KEY = new Object();
    private static Font fontText = null;
    Display display;
    private Color cBG;
    private Color cFG;
    private Color cBorder;
    private Color cText;
    Color textColor;

    public ColumnProgressETA(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 150, sTableID);
        this.initializeAsGraphic(150);
        this.setAlignment(1);
        this.setMinWidth(150);
        this.display = SWTThread.getInstance().getDisplay();
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.cBG = skinProperties.getColor("color.progress.bg");
        if (this.cBG == null) {
            this.cBG = Colors.blues[9];
        }
        this.cFG = skinProperties.getColor("color.progress.fg");
        if (this.cFG == null) {
            this.cFG = Colors.blues[0];
        }
        this.cBorder = skinProperties.getColor("color.progress.border");
        if (this.cBorder == null) {
            this.cBorder = Colors.grey;
        }
        this.cText = skinProperties.getColor("color.progress.text");
        if (this.cText == null) {
            this.cText = Colors.black;
        }
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential", "time"});
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellSWTPaintListener {
        int lastPercentDone = 0;
        long lastETA;

        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginHeight(3);
        }

        public void refresh(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            int percentDone = this.getPercentDone(cell);
            long sortValue = 0L;
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            if (completedTime <= 0L) {
                sortValue = dm.getDownloadState().getLongParameter("stats.download.added.time") * 10000L;
                sortValue += (long)(1000 - percentDone);
            } else {
                sortValue = completedTime;
            }
            long eta = this.getETA(cell);
            if (!cell.setSortValue(sortValue) && cell.isValid() && this.lastPercentDone == percentDone && this.lastETA == eta) {
                return;
            }
            this.lastPercentDone = percentDone;
            this.lastETA = eta;
            cell.setSortValue(sortValue);
            cell.invalidate();
        }

        public void cellPaint(GC gcImage, TableCellSWT cell) {
            String sSpeed;
            boolean showSecondLine;
            int x2;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            int percentDone = this.getPercentDone(cell);
            long eta = this.getETA(cell);
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            Color fgFirst = gcImage.getForeground();
            Rectangle cellBounds = cell.getBounds();
            int x0 = cellBounds.x + cell.getMarginWidth();
            int y0 = cellBounds.y + cell.getMarginHeight();
            int x1 = 1;
            int y1 = 1;
            int progressX2 = x2 = newWidth - x1 - 1;
            int progressY2 = newHeight - y1 - 1 - 13;
            if (progressY2 > 18) {
                progressY2 = 18;
            }
            boolean bl = showSecondLine = progressY2 > 0;
            if (!showSecondLine) {
                progressY2 = newHeight;
            }
            if (x2 < 10 || progressX2 < 10) {
                return;
            }
            boolean bDrawProgressBar = true;
            String sETALine = null;
            long lSpeed = this.getSpeed(dm);
            String string = sSpeed = lSpeed <= 0L ? "" : "(" + DisplayFormatters.formatByteCountToKiBEtcPerSec(lSpeed, true) + ")";
            if (bDrawProgressBar && percentDone < 1000) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                Image imgEnd = imageLoader.getImage("dl_bar_end");
                Image img0 = imageLoader.getImage("dl_bar_0");
                Image img1 = imageLoader.getImage("dl_bar_1");
                gcImage.drawImage(imgEnd, x0, y0 + y1);
                gcImage.drawImage(imgEnd, x0 + progressX2 - x1 + 1, y0 + y1);
                int limit = (progressX2 - x1) * percentDone / 1000;
                gcImage.drawImage(img1, 0, 0, 1, 13, x0 + x1, y0 + y1, limit, 13);
                if (limit < progressX2) {
                    gcImage.drawImage(img0, 0, 0, 1, 13, x0 + limit + 1, y0 + y1, progressX2 - limit - 1, 13);
                }
                imageLoader.releaseImage("dl_bar_end");
                imageLoader.releaseImage("dl_bar_0");
                imageLoader.releaseImage("dl_bar_1");
            }
            if (sETALine == null) {
                int cursor_id;
                if (dm.isUnauthorisedOnTracker()) {
                    sETALine = dm.getTrackerStatus();
                } else if (dm.isDownloadComplete(true)) {
                    sETALine = DisplayFormatters.formatByteCountToKiBEtc(dm.getSize());
                } else if (eta > 0L) {
                    String sETA = TimeFormatter.format(eta);
                    sETALine = MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA});
                } else {
                    sETALine = DisplayFormatters.formatDownloadStatus(dm);
                }
                if (sETALine.indexOf("http://") == -1) {
                    dm.setUserData(CLICK_KEY, null);
                    cursor_id = 0;
                } else {
                    dm.setUserData(CLICK_KEY, sETALine);
                    cursor_id = 21;
                    if (!cell.getTableRow().isSelected()) {
                        fgFirst = Colors.blue;
                    }
                }
                cell.setCursorID(cursor_id);
            }
            if (fontText == null) {
                fontText = Utils.getFontWithHeight(gcImage.getFont(), gcImage, 11);
            }
            gcImage.setTextAntialias(1);
            if (showSecondLine) {
                gcImage.setFont(fontText);
                gcImage.setForeground(fgFirst);
                gcImage.drawText(sETALine, x0 + 2, y0 + progressY2, true);
                Point textExtent = gcImage.textExtent(sETALine);
                cell.setToolTip(textExtent.x > newWidth ? sETALine : null);
            }
            int middleY = (progressY2 - 12) / 2;
            if (percentDone == 1000) {
                gcImage.setForeground(ColumnProgressETA.this.cText);
                gcImage.drawText("Complete", x0 + 2, y0 + middleY, true);
            } else if (bDrawProgressBar) {
                gcImage.setForeground(ColumnProgressETA.this.cText);
                String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
                gcImage.drawText(sSpeed, x0 + 50, y0 + y1 + 1, true);
                gcImage.drawText(sPercent, x0 + 2, y0 + y1 + 1, true);
            }
            gcImage.setFont(null);
        }

        private int getPercentDone(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 0;
            }
            return dm.getStats().getDownloadCompleted(true);
        }

        private long getETA(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 0L;
            }
            long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
            if (diff > 30000L) {
                return dm.getStats().getETA();
            }
            return 0L;
        }

        private int getState(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 100;
            }
            return dm.getState();
        }

        private boolean isStopped(TableCell cell) {
            int state = this.getState(cell);
            return state == 75 || state == 70 || state == 65 || state == 100;
        }

        private long getSpeed(DownloadManager dm) {
            if (dm == null) {
                return 0L;
            }
            return dm.getStats().getDataReceiveRate();
        }

        public EnhancedDownloadManager getEDM(DownloadManager dm) {
            DownloadManagerEnhancer dmEnhancer = DownloadManagerEnhancer.getSingleton();
            if (dmEnhancer == null) {
                return null;
            }
            return dmEnhancer.getEnhancedDownload(dm);
        }

        private void log(TableCell cell, String s) {
            System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
        }
    }
}

