/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnQuality
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "Quality";
    public Font font;
    private static final int COLUMN_WIDTH = 50;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public ColumnQuality(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 50, sTableID);
        this.initializeAsGraphic(50);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle cellBounds = cell.getBounds();
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        String quality = PlatformTorrentUtils.getContentQuality(torrent);
        String imageID = "icon.quality." + quality;
        Image img = ImageLoader.getInstance().getImage(imageID);
        try {
            if (ImageLoader.isRealImage(img)) {
                Rectangle imgBounds = img.getBounds();
                if (imgBounds.height <= cellBounds.height) {
                    gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
                    return;
                }
            }
            GCStringPrinter.printString(gc, quality, cellBounds, true, false, 0x1000000);
        }
        finally {
            ImageLoader.getInstance().releaseImage(imageID);
        }
    }

    public void refresh(TableCell cell) {
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        String quality = PlatformTorrentUtils.getContentQuality(torrent);
        cell.setSortValue((Comparable)((Object)quality));
    }
}

