/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.messenger.config.RatingUpdateListener2;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.torrent.RatingInfoList;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRate
extends CoreTableColumn
implements TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "Rating";
    public static final int COLUMN_WIDTH = 58;
    public static final boolean ROW_HOVER = System.getProperty("rowhover", "0").equals("1");
    private static Font font = null;
    private static Font smallFont = null;
    private static Image imgRateMe = ImageLoader.getInstance().getImage("icon.rateme");
    private static Image imgRateMeUp;
    private static Image imgRateMeDown;
    private static Image imgUpSmall;
    private static Image imgDownSmall;
    private static Image imgUp;
    private static Image imgDown;
    private static Image imgWait;
    private static Image imgRateMeButton;
    private static Image imgRateMeButtonEnabled;
    private static Image imgRateMeButtonDisabled;
    private static Rectangle boundsRateMe;
    private static int width;
    private boolean useButton;
    private boolean disabled;
    private boolean allowRate = true;

    public ColumnRate(String sTableID) {
        this(sTableID, false);
    }

    public ColumnRate(String sTableID, boolean allowRate) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 58, sTableID);
        this.allowRate = allowRate;
        this.initializeAsGraphic(58);
        this.setAlignment(2);
        this.setWidthLimits(58, 58);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public void cellAdded(TableCell cell) {
        PlatformRatingMessenger.setGlobalRatingUpdateDelayed(false);
        new Cell(cell);
    }

    public boolean useButton() {
        return this.useButton;
    }

    public void setUseButton(boolean useButton) {
        this.useButton = useButton;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        imgRateMeButton = disabled ? imgRateMeButtonDisabled : imgRateMeButtonEnabled;
        this.invalidateCells();
    }

    private DownloadManager getDM(Object ds) {
        DownloadManager dm = null;
        if (ds instanceof DownloadManager) {
            dm = (DownloadManager)ds;
        } else if (ds instanceof VuzeActivitiesEntry) {
            dm = ((VuzeActivitiesEntry)ds).getDownloadManger();
        }
        return dm;
    }

    private Point getRateIconPos(Rectangle imgBounds, int cellWidth, int cellHeight) {
        int y;
        int n = y = imgBounds.height == cellHeight ? 0 : (cellHeight - imgBounds.height) / 2;
        int x = this.useButton ? (imgBounds.width == cellWidth ? 0 : (cellWidth - imgBounds.width) / 2) : cellWidth - imgBounds.width;
        return new Point(x, y);
    }

    static {
        boundsRateMe = imgRateMe.getBounds();
        width = ColumnRate.boundsRateMe.width;
        imgRateMeButton = imgRateMeButtonEnabled = ImageLoader.getInstance().getImage("icon.rateme-button");
        width = Math.max(width, ColumnRate.imgRateMeButton.getBounds().width);
        imgRateMeButtonDisabled = ImageLoader.getInstance().getImage("icon.rateme-button-disabled");
        width = Math.max(width, ColumnRate.imgRateMeButtonDisabled.getBounds().width);
        imgRateMeUp = ImageLoader.getInstance().getImage("icon.rateme.up");
        imgRateMeDown = ImageLoader.getInstance().getImage("icon.rateme.down");
        imgWait = ImageLoader.getInstance().getImage("icon.rate.wait");
        width = Math.max(width, ColumnRate.imgWait.getBounds().width);
        imgDown = ImageLoader.getInstance().getImage("icon.rate.down");
        imgUp = ImageLoader.getInstance().getImage("icon.rate.up");
        imgDownSmall = ImageLoader.getInstance().getImage("icon.rate.small.down");
        imgUpSmall = ImageLoader.getInstance().getImage("icon.rate.small.up");
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener,
    TableCellMouseMoveListener,
    TableCellToolTipListener,
    TableRowMouseListener,
    RatingUpdateListener2,
    TableCellVisibilityListener {
        String rating = "--";
        private boolean bMouseDowned;
        private int hoveringOn = -1;
        private DownloadManager dm;
        private TableCell cell;
        private Rectangle areaUserRating = null;

        public Cell(TableCell cell) {
            boolean isContent;
            this.cell = cell;
            PlatformRatingMessenger.addListener(this);
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
            this.dm = ColumnRate.this.getDM(cell.getDataSource());
            if (this.dm != null && !(isContent = PlatformTorrentUtils.isContent(this.dm.getTorrent(), true))) {
                this.rating = "";
                return;
            }
            TableRow tableRow = cell.getTableRow();
            if (tableRow != null) {
                tableRow.addMouseListener(this);
            }
        }

        public void dispose(TableCell cell) {
            PlatformRatingMessenger.removeListener(this);
            this.disposeOldImage(cell);
        }

        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        public void refresh(final TableCell cell, final boolean force) {
            int[] bg;
            boolean b;
            if (cell.isDisposed()) {
                return;
            }
            DownloadManager newDM = ColumnRate.this.getDM(cell.getDataSource());
            if (this.dm == null || newDM != this.dm) {
                if (newDM == null) {
                    return;
                }
                this.dm = newDM;
            }
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        Cell.this.refresh(cell, force);
                    }
                });
                return;
            }
            DownloadManager dm = ColumnRate.this.getDM(cell.getDataSource());
            if (dm == null) {
                return;
            }
            TOTorrent torrent = dm.getTorrent();
            String rating = GlobalRatingUtils.getRatingString(torrent);
            long count = GlobalRatingUtils.getCount(torrent);
            int userRating = -3;
            if (PlatformTorrentUtils.isContent(dm.getTorrent(), true)) {
                userRating = PlatformTorrentUtils.getUserRating(dm.getTorrent());
            }
            try {
                float val = Float.parseFloat(rating) * 1000000.0f + (float)count;
                b = !cell.setSortValue(val += (float)((userRating + 3) * 10000000));
            }
            catch (Exception e) {
                boolean bl = b = !cell.setSortValue(count > 0L ? new Float(count) : null);
            }
            if (!force) {
                if (b && cell.isValid()) {
                    return;
                }
                if (!cell.isShown()) {
                    return;
                }
            }
            int width = cell.getWidth();
            int height = cell.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            boolean needsFill = false;
            Image img = ((UISWTGraphic)cell.getBackgroundGraphic()).getImage();
            if (img == null) {
                img = new Image((Device)Display.getDefault(), width, height);
                needsFill = true;
            }
            GC gcImage = new GC((Drawable)img);
            if (needsFill && (bg = cell.getBackground()) != null) {
                gcImage.setBackground(ColorCache.getColor(gcImage.getDevice(), bg[0], bg[1], bg[2]));
                gcImage.fillRectangle(0, 0, width, height);
            }
            boolean showAverage = !ColumnRate.this.useButton;
            boolean showRateActionIcon = ColumnRate.this.useButton;
            Image imgRate = null;
            if (ColumnRate.this.allowRate) {
                if (ROW_HOVER) {
                    boolean rowHasMouse;
                    TableRow row = cell.getTableRow();
                    boolean bl = rowHasMouse = row instanceof TableRowCore ? ((TableRowCore)row).isMouseOver() : false;
                    if (rowHasMouse && userRating == -1) {
                        showAverage = false;
                        showRateActionIcon = true;
                    }
                }
                boolean cellHasMouse = cell instanceof TableCellCore ? ((TableCellCore)cell).isMouseOver() : false;
                block5 : switch (userRating) {
                    case -2: {
                        imgRate = imgWait;
                        break;
                    }
                    case -3: {
                        if (!ColumnRate.this.disabled) break;
                        imgRate = imgRateMeButtonDisabled;
                        break;
                    }
                    case -1: {
                        boolean mouseIn;
                        boolean bl = mouseIn = ColumnRate.this.useButton && cellHasMouse;
                        if (ColumnRate.this.useButton && !mouseIn || ColumnRate.this.disabled) {
                            imgRate = imgRateMeButton;
                            break;
                        }
                        if (cellHasMouse) {
                            showAverage = false;
                            showRateActionIcon = true;
                        }
                        switch (this.hoveringOn) {
                            case 0: {
                                imgRate = imgRateMeDown;
                                break block5;
                            }
                            case 1: {
                                imgRate = imgRateMeUp;
                                break block5;
                            }
                        }
                        imgRate = imgRateMe;
                        break;
                    }
                    case 0: {
                        imgRate = ColumnRate.this.useButton ? imgDown : imgDownSmall;
                        break;
                    }
                    case 1: {
                        imgRate = ColumnRate.this.useButton ? imgUp : imgUpSmall;
                    }
                }
            }
            this.areaUserRating = null;
            if (showAverage) {
                if (showRateActionIcon) {
                    try {
                        gcImage.setAlpha(40);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Rectangle r = img.getBounds();
                int bigTextStyle = 131200;
                int smallTextStyle = 131072;
                if (imgRate != null && (userRating >= 0 || userRating == -2)) {
                    Rectangle imgRateDrawArea = imgRate.getBounds();
                    imgRateDrawArea.x = r.width - 53;
                    imgRateDrawArea.y = (height - 14) / 2 - imgRate.getBounds().height / 2;
                    gcImage.drawImage(imgRate, imgRateDrawArea.x, imgRateDrawArea.y);
                    if (userRating >= 0) {
                        this.areaUserRating = imgRateDrawArea;
                    }
                }
                r.y += 2;
                r.height -= 14;
                if (font == null) {
                    FontData[] fontData = gcImage.getFont().getFontData();
                    fontData[0].setStyle(1);
                    Utils.getFontHeightFromPX(gcImage.getDevice(), fontData, gcImage, 22);
                    font = new Font((Device)Display.getDefault(), fontData);
                }
                gcImage.setFont(font);
                try {
                    gcImage.setTextAntialias(1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
                int[] cbg = cell.getBackground();
                HSLColor hsl = new HSLColor();
                hsl.initHSLbyRGB(cbg[0], cbg[1], cbg[2]);
                hsl.setLuminence(hsl.getLuminence() - 10);
                Color color2 = ColorCache.getColor((Device)Display.getDefault(), hsl.getRed(), hsl.getGreen(), hsl.getBlue());
                if (color2 != null) {
                    gcImage.setForeground(color2);
                }
                GCStringPrinter.printString(gcImage, rating, r, true, false, bigTextStyle);
                Color color1 = ColorCache.getColor((Device)Display.getDefault(), GlobalRatingUtils.getColor(torrent));
                if (color1 == null && (color1 = skinProperties.getColor("color.row.fg")) == null) {
                    color1 = ColorCache.getColor(gcImage.getDevice(), cell.getForeground());
                }
                r = img.getBounds();
                r.width -= 2;
                r.height -= 14;
                if (color1 != null) {
                    gcImage.setForeground(color1);
                }
                GCStringPrinter.printString(gcImage, rating, r, true, false, bigTextStyle);
                if (count > 0L) {
                    if (smallFont == null) {
                        gcImage.setFont(null);
                        FontData[] fontData = gcImage.getFont().getFontData();
                        fontData[0].setHeight(Utils.pixelsToPoint(9, Display.getDefault().getDPI().y));
                        smallFont = new Font((Device)Display.getDefault(), fontData);
                    }
                    gcImage.setFont(smallFont);
                    try {
                        gcImage.setTextAntialias(-1);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Rectangle rectDrawRatings = img.getBounds();
                    rectDrawRatings.width -= 3;
                    rectDrawRatings.y = r.y + 20;
                    String sRatingInfo = count + " ratings";
                    Point ratingInfoExtent = gcImage.textExtent(sRatingInfo);
                    if (ratingInfoExtent.x > rectDrawRatings.width) {
                        sRatingInfo = DisplayFormatters.formatDecimal((double)count / 1000.0, 1) + "k ratings";
                        ratingInfoExtent = gcImage.textExtent(sRatingInfo);
                        if (ratingInfoExtent.x > rectDrawRatings.width) {
                            sRatingInfo = count / 1000L + "k ratings";
                        }
                    }
                    GCStringPrinter.printString(gcImage, sRatingInfo, rectDrawRatings, true, false, 0x80 | smallTextStyle);
                }
                if (showRateActionIcon) {
                    try {
                        gcImage.setAlpha(255);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (showRateActionIcon && imgRate != null) {
                Point drawPos = ColumnRate.this.getRateIconPos(imgRate.getBounds(), width, height);
                gcImage.drawImage(imgRate, drawPos.x, drawPos.y);
                this.areaUserRating = imgRate.getBounds();
                this.areaUserRating.x = drawPos.x;
                this.areaUserRating.y = drawPos.y;
            }
            gcImage.dispose();
            UISWTGraphicImpl graphic = new UISWTGraphicImpl(img);
            this.disposeOldImage(cell);
            cell.setGraphic(graphic);
        }

        private void disposeOldImage(TableCell cell) {
            Image image;
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof UISWTGraphic && (image = ((UISWTGraphic)oldGraphic).getImage()) != null && !image.isDisposed()) {
                image.dispose();
            }
        }

        public void cellMouseTrigger(final TableCellMouseEvent event2) {
            DownloadManager dm;
            if (this.dm == null) {
                return;
            }
            TableRow tableRow = event2.cell.getTableRow();
            if (tableRow == null) {
                this.rowMouseTrigger(event2, event2.cell);
            }
            if (ColumnRate.this.disabled) {
                return;
            }
            if (event2.eventType == 1 && event2.button == 2) {
                dm = ColumnRate.this.getDM(event2.cell.getDataSource());
                if (dm == null) {
                    return;
                }
                TOTorrent torrent = dm.getTorrent();
                PlatformRatingMessenger.updateGlobalRating(torrent, 0L);
                Utils.beep();
            }
            if (!ColumnRate.this.allowRate) {
                return;
            }
            if (event2.eventType == 5) {
                this.hoveringOn = -1;
            } else if (event2.eventType == 3) {
                int userRating = PlatformTorrentUtils.getUserRating(this.dm.getTorrent());
                if (userRating == -1) {
                    int cellWidth = event2.cell.getWidth();
                    int cellHeight = event2.cell.getHeight();
                    Point drawPos = ColumnRate.this.getRateIconPos(boundsRateMe, cellWidth, cellHeight);
                    drawPos.x = event2.x - drawPos.x;
                    drawPos.y = event2.y - drawPos.y;
                    if (drawPos.x >= 0 && drawPos.y >= 0 && drawPos.x < boundsRateMe.width && drawPos.y < boundsRateMe.height) {
                        int value;
                        int n = value = drawPos.x < boundsRateMe.height - drawPos.y + 1 ? 1 : 0;
                        if (this.hoveringOn != value) {
                            this.hoveringOn = value;
                            if (this.cell instanceof TableCellCore) {
                                ((TableCellCore)event2.cell).setCursorID(21);
                            }
                            this.refresh(event2.cell, true);
                        }
                    } else if (this.hoveringOn != -1) {
                        this.hoveringOn = -1;
                        if (this.cell instanceof TableCellCore) {
                            ((TableCellCore)event2.cell).setCursorID(0);
                        }
                        this.refresh(event2.cell, true);
                    }
                } else if (this.cell instanceof TableCellCore) {
                    if (this.areaUserRating != null && this.areaUserRating.contains(event2.x, event2.y)) {
                        ((TableCellCore)event2.cell).setCursorID(21);
                        event2.cell.setToolTip("Click to remove your rating");
                    } else {
                        ((TableCellCore)event2.cell).setCursorID(0);
                        event2.cell.setToolTip(null);
                    }
                }
            }
            if (event2.eventType == 4 || event2.eventType == 5) {
                this.refresh(event2.cell, true);
                return;
            }
            if (event2.eventType != 0 && event2.eventType != 1) {
                return;
            }
            if (event2.button != 1) {
                return;
            }
            dm = ColumnRate.this.getDM(event2.cell.getDataSource());
            if (dm == null) {
                return;
            }
            if (!PlatformTorrentUtils.isContent(dm.getTorrent(), true)) {
                return;
            }
            int userRating = PlatformTorrentUtils.getUserRating(dm.getTorrent());
            if (event2.eventType == 0) {
                this.bMouseDowned = true;
                return;
            }
            if (event2.eventType == 1 && this.bMouseDowned) {
                if (userRating == -1) {
                    int cellWidth = event2.cell.getWidth();
                    int cellHeight = event2.cell.getHeight();
                    Point drawPos = ColumnRate.this.getRateIconPos(boundsRateMe, cellWidth, cellHeight);
                    drawPos.x = event2.x - drawPos.x;
                    drawPos.y = event2.y - drawPos.y;
                    if (drawPos.x >= 0 && drawPos.y >= 0 && drawPos.x < boundsRateMe.width && drawPos.y < boundsRateMe.height) {
                        try {
                            TOTorrent torrent = dm.getTorrent();
                            int value = drawPos.x < boundsRateMe.height - drawPos.y + 1 ? 1 : 0;
                            PlatformRatingMessenger.setUserRating(torrent, value, true, 0L, new PlatformMessengerListener(){

                                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                                    Cell.this.refresh(event2.cell, true);
                                }

                                public void messageSent(PlatformMessage message) {
                                }
                            });
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                } else if (this.areaUserRating != null && this.areaUserRating.contains(event2.x, event2.y)) {
                    try {
                        TOTorrent torrent = dm.getTorrent();
                        if (userRating >= 0) {
                            this.refresh(event2.cell, true);
                            PlatformRatingMessenger.setUserRating(torrent, -1, true, 0L, new PlatformMessengerListener(){

                                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                                    Cell.this.refresh(event2.cell, true);
                                }

                                public void messageSent(PlatformMessage message) {
                                }
                            });
                            event2.skipCoreFunctionality = true;
                        }
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
            this.bMouseDowned = false;
        }

        public void cellHover(TableCell cell) {
            if (Constants.isCVSVersion()) {
                DownloadManager dm = ColumnRate.this.getDM(cell.getDataSource());
                if (dm == null) {
                    return;
                }
                TOTorrent torrent = dm.getTorrent();
                long refreshOn = GlobalRatingUtils.getRefreshOn(torrent);
                long diff = (refreshOn - SystemTime.getCurrentTime()) / 1000L;
                Object toolTip = cell.getToolTip();
                if (!(toolTip instanceof String) || ((String)toolTip).startsWith("G.")) {
                    cell.setToolTip("G.Rating Auto Refreshes in " + TimeFormatter.format(diff));
                }
            }
        }

        public void cellHoverComplete(TableCell cell) {
        }

        public void rowMouseTrigger(TableRowMouseEvent event2) {
            TableCell cell = event2.row.getTableCell(ColumnRate.COLUMN_ID);
            this.rowMouseTrigger(event2, cell);
        }

        public void rowMouseTrigger(TableRowMouseEvent event2, TableCell cell) {
            boolean changed = false;
            if (event2.eventType == 4) {
                changed = true;
            } else if (event2.eventType == 5) {
                changed = true;
            }
            if (changed) {
                if (cell != null) {
                    this.refresh(cell, true);
                } else if (event2.row != null) {
                    ((TableRowCore)event2.row).invalidate();
                    ((TableRowCore)event2.row).redraw();
                }
            }
        }

        public void ratingUpdated(RatingInfoList rating) {
            if (this.dm == null) {
                return;
            }
            try {
                String hash = this.dm.getTorrent().getHashWrapper().toBase32String();
                if (rating.hasHash(hash)) {
                    this.refresh(this.cell, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 0) {
                PlatformRatingMessenger.addListener(this);
            } else if (visibility == 1) {
                PlatformRatingMessenger.removeListener(this);
            }
        }
    }
}

