/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefresher;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRateUpDown
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "RateIt";
    private static final String ID_ICON_RATE = "icon.rate.library";
    private static final String ID_ICON_RATE_UP = "icon.rate.library.up";
    private static final String ID_ICON_RATE_DOWN = "icon.rate.library.down";
    private UISWTGraphicImpl graphicRate;
    private UISWTGraphicImpl graphicRateDown;
    private UISWTGraphicImpl graphicRateUp;
    private UISWTGraphicImpl[] graphicsWait;
    private Rectangle boundsRate;
    private static int width = 50;
    private boolean useButton = false;
    private boolean disabled = false;
    TableRow previousSelection = null;

    public ColumnRateUpDown(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, width, sTableID);
        this.initializeAsGraphic(width);
        this.setWidthLimits(width, width);
        Image img = ImageLoader.getInstance().getImage(ID_ICON_RATE);
        this.graphicRate = new UISWTGraphicImpl(img);
        img = ImageLoader.getInstance().getImage(ID_ICON_RATE_DOWN);
        this.graphicRateDown = new UISWTGraphicImpl(img);
        img = ImageLoader.getInstance().getImage(ID_ICON_RATE_UP);
        this.graphicRateUp = new UISWTGraphicImpl(img);
        this.boundsRate = img.getBounds();
        Image[] imgs = ImageLoader.getInstance().getImages("image.sidebar.vitality.dots");
        this.graphicsWait = new UISWTGraphicImpl[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            this.graphicsWait[i] = new UISWTGraphicImpl(imgs[i]);
        }
    }

    public void remove() {
        super.remove();
        ImageLoader imageLoader = ImageLoader.getInstance();
        if (this.graphicRate != null) {
            imageLoader.releaseImage(ID_ICON_RATE);
        }
        if (this.graphicRateDown != null) {
            imageLoader.releaseImage(ID_ICON_RATE_DOWN);
        }
        if (this.graphicRateUp != null) {
            imageLoader.releaseImage(ID_ICON_RATE_UP);
        }
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        UISWTGraphicImpl graphic;
        Object ds = cell.getDataSource();
        TOTorrent torrent = null;
        if (ds instanceof TOTorrent) {
            torrent = (TOTorrent)ds;
        } else if (ds instanceof DownloadManager && !PlatformTorrentUtils.isContentProgressive(torrent = ((DownloadManager)ds).getTorrent()) && !((DownloadManager)ds).isDownloadComplete(false)) {
            return;
        }
        if (torrent == null) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        int rating = PlatformTorrentUtils.getUserRating(torrent);
        if (!cell.setSortValue(rating) && cell.isValid() && rating != -2) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        switch (rating) {
            case -2: {
                int i = TableCellRefresher.getRefreshIndex(1, this.graphicsWait.length);
                graphic = this.graphicsWait[i];
                TableCellRefresher.addCell(this, cell);
                break;
            }
            case -1: {
                graphic = this.graphicRate;
                break;
            }
            case 0: {
                graphic = this.graphicRateDown;
                break;
            }
            case 1: {
                graphic = this.graphicRateUp;
                break;
            }
            default: {
                graphic = null;
            }
        }
        cell.setGraphic(graphic);
        if (!this.disabled && graphic != null && cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    public void cellMouseTrigger(final TableCellMouseEvent event2) {
        if (this.disabled) {
            return;
        }
        Object ds = event2.cell.getDataSource();
        TOTorrent torrent0 = null;
        if (ds instanceof TOTorrent) {
            torrent0 = (TOTorrent)ds;
        } else if (ds instanceof DownloadManager && !PlatformTorrentUtils.isContentProgressive(torrent0 = ((DownloadManager)ds).getTorrent()) && !((DownloadManager)ds).isDownloadComplete(false)) {
            return;
        }
        if (torrent0 == null) {
            return;
        }
        TOTorrent torrent = torrent0;
        if (event2.button != 1) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        if (event2.eventType == 1) {
            int alpha;
            boolean cancel = true;
            int cellWidth = event2.cell.getWidth();
            int cellHeight = event2.cell.getHeight();
            int x = event2.x - (cellWidth - this.boundsRate.width) / 2;
            int y = event2.y - (cellHeight - this.boundsRate.height) / 2;
            Graphic currentGraphic = event2.cell.getGraphic();
            if (x >= 0 && y >= 0 && x < this.boundsRate.width && y < this.boundsRate.height && (this.graphicRate.equals(currentGraphic) || this.graphicRateUp.equals(currentGraphic) || this.graphicRateDown.equals(currentGraphic)) && (alpha = this.graphicRate.getImage().getImageData().getAlpha(x, y)) > 0) {
                try {
                    cancel = false;
                    int value = x < this.boundsRate.width / 2 ? 0 : 1;
                    int previousValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (value != previousValue) {
                        PlatformRatingMessenger.setUserRating(torrent, value, true, 0L, new PlatformMessengerListener(){

                            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                                ColumnRateUpDown.this.refresh(event2.cell);
                            }

                            public void messageSent(PlatformMessage message) {
                            }
                        });
                        this.refresh(event2.cell);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if (cancel) {
                try {
                    int oldValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (oldValue == -2 || oldValue == -1) {
                        return;
                    }
                    PlatformRatingMessenger.setUserRating(torrent, -1, true, 0L, new PlatformMessengerListener(){

                        public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                            ColumnRateUpDown.this.refresh(event2.cell);
                        }

                        public void messageSent(PlatformMessage message) {
                        }
                    });
                    this.refresh(event2.cell);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public boolean useButton() {
        return this.useButton;
    }

    public void setUseButton(boolean useButton) {
        this.useButton = useButton;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

