/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnVideoLength
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "videoLength";
    private static final int WIDTH = 100;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public ColumnVideoLength(String tableID) {
        super(COLUMN_ID, 100, tableID);
        this.setAlignment(2);
    }

    public void refresh(TableCell cell) {
        TOTorrent torrent = DataSourceUtils.getTorrent(cell.getDataSource());
        long value = PlatformTorrentUtils.getContentVideoRunningTime(torrent);
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatTime(value * 1000L));
    }
}

