/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.utils;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnAzProduct;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnInfo;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnProgressETA;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnQuality;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRateUpDown;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRatingGlobal;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnThumbnail;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnUnopened;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnVideoLength;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityActions;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityAvatar;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityDate;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityNew;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityText;
import com.aelitis.azureus.ui.swt.columns.vuzeactivity.ColumnActivityType;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCoreCreationListener;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateCompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.StatusItem;

public class TableColumnCreatorV3 {
    public static TableColumnCore[] createAllDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        NameItem tcNameItem;
        StatusItem tcStatusItem;
        String[] defaultVisibleOrder = new String[]{"unopened", ColumnAzProduct.COLUMN_ID, "Thumbnail", "name", "azsubs.ui.column.subs", "size", "Quality", "Info", "RateIt", "status", "shareRatio", "DateCompleted"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(Download.class, tableID);
        if (!tcManager.loadTableColumnSettings(Download.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            NameItem tcName;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            DateCompletedItem tc = (DateCompletedItem)mapTCs.get("DateCompleted");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "DateCompleted");
                tc.setSortAscending(false);
            }
            if ((tcName = (NameItem)mapTCs.get("name")) != null) {
                tcName.setWidth(140);
            }
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
                tcStatusItem.setShowTrackerErrors(true);
            }
        }
        if ((tcNameItem = (NameItem)mapTCs.get("name")) != null) {
            tcNameItem.setShowIcon(false);
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
            tcShareRatioItem.setWidth(80);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createIncompleteDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        NameItem tcNameItem;
        StatusItem tcStatusItem;
        String[] defaultVisibleOrder = new String[]{ColumnAzProduct.COLUMN_ID, "Thumbnail", "name", "azsubs.ui.column.subs", "size", "Quality", "Info", "ProgressETA", "seeds", "peers"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeIncomplete.class, tableID);
        if (!tcManager.loadTableColumnSettings(DownloadTypeIncomplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            NameItem tcName;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            NameItem tc = (NameItem)mapTCs.get("name");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "name");
                tc.setSortAscending(true);
            }
            if ((tcName = (NameItem)mapTCs.get("name")) != null) {
                tcName.setWidth(220);
            }
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if ((tcNameItem = (NameItem)mapTCs.get("name")) != null) {
            tcNameItem.setShowIcon(false);
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
            tcShareRatioItem.setWidth(80);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static void setVisibility(Map mapTCs, String[] defaultVisibleOrder) {
        for (TableColumnCore tc : mapTCs.values()) {
            tc.setVisible(false);
        }
        for (int i = 0; i < defaultVisibleOrder.length; ++i) {
            String id = defaultVisibleOrder[i];
            TableColumnCore tc = (TableColumnCore)mapTCs.get(id);
            if (tc == null) continue;
            tc.setVisible(true);
            tc.setPositionNoShift(i);
        }
    }

    public static TableColumnCore[] createCompleteDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        NameItem tcNameItem;
        StatusItem tcStatusItem;
        String[] defaultVisibleOrder = new String[]{"unopened", ColumnAzProduct.COLUMN_ID, "Thumbnail", "name", "azsubs.ui.column.subs", "size", "Quality", "Info", "RateIt", "status", "shareRatio", "DateCompleted"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeComplete.class, tableID);
        if (!tcManager.loadTableColumnSettings(DownloadTypeComplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            NameItem tcName;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            DateCompletedItem tc = (DateCompletedItem)mapTCs.get("DateCompleted");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "DateCompleted");
                tc.setSortAscending(false);
            }
            if ((tcName = (NameItem)mapTCs.get("name")) != null) {
                tcName.setWidth(140);
            }
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if ((tcNameItem = (NameItem)mapTCs.get("name")) != null) {
            tcNameItem.setShowIcon(false);
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
            tcShareRatioItem.setWidth(80);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createUnopenedDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        NameItem tcNameItem;
        StatusItem tcStatusItem;
        String[] defaultVisibleOrder = new String[]{"unopened", "Thumbnail", "name", "azsubs.ui.column.subs", "size", "Quality", "Info", "status", "DateCompleted"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeIncomplete.class, tableID);
        if (!tcManager.loadTableColumnSettings(DownloadTypeIncomplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            NameItem tcName;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            DateCompletedItem tc = (DateCompletedItem)mapTCs.get("DateCompleted");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "DateCompleted");
                tc.setSortAscending(false);
            }
            if ((tcName = (NameItem)mapTCs.get("name")) != null) {
                tcName.setWidth(265);
            }
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if ((tcNameItem = (NameItem)mapTCs.get("name")) != null) {
            tcNameItem.setShowIcon(false);
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
            tcShareRatioItem.setWidth(80);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createActivitySmall(String tableID) {
        String[] defaultVisibleOrder = new String[]{"activityNew", "activityType", "activityText", "activityActions", "activityDate"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(VuzeActivitiesEntry.class, tableID);
        if (!tcManager.loadTableColumnSettings(VuzeActivitiesEntry.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            ColumnActivityText tcText;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            ColumnActivityDate tc = (ColumnActivityDate)mapTCs.get("activityDate");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "activityDate");
                tc.setSortAscending(false);
            }
            if ((tcText = (ColumnActivityText)mapTCs.get("activityText")) != null) {
                tcText.setWidth(445);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createActivityBig(String tableID) {
        String[] defaultVisibleOrder = new String[]{"activityNew", "activityType", "activityAvatar", "activityText", "Thumbnail", "activityActions", "activityDate"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(VuzeActivitiesEntry.class, tableID);
        if (!tcManager.loadTableColumnSettings(VuzeActivitiesEntry.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            ColumnActivityDate tc;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder);
            ColumnActivityText tcText = (ColumnActivityText)mapTCs.get("activityText");
            if (tcText != null) {
                tcText.setWidth(350);
            }
            if ((tc = (ColumnActivityDate)mapTCs.get("activityDate")) != null) {
                tcManager.setDefaultSortColumnName(tableID, "activityDate");
                tc.setSortAscending(false);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static boolean areNoneVisible(Map mapTCs) {
        boolean noneVisible = true;
        for (TableColumn tc : mapTCs.values()) {
            if (!tc.isVisible()) continue;
            noneVisible = false;
            break;
        }
        return noneVisible;
    }

    public static void initCoreColumns() {
        TableColumnCreator.initCoreColumns();
        final LightHashMap c = new LightHashMap(7);
        c.put("unopened", new cInfo(ColumnUnopened.class, ColumnUnopened.DATASOURCE_TYPE));
        c.put("Quality", new cInfo(ColumnQuality.class, ColumnQuality.DATASOURCE_TYPE));
        c.put("Info", new cInfo(ColumnInfo.class, ColumnInfo.DATASOURCE_TYPE));
        c.put("RateIt", new cInfo(ColumnRateUpDown.class, ColumnRateUpDown.DATASOURCE_TYPE));
        c.put("Rating_global", new cInfo(ColumnRatingGlobal.class, ColumnRatingGlobal.DATASOURCE_TYPE));
        c.put("videoLength", new cInfo(ColumnVideoLength.class, ColumnVideoLength.DATASOURCE_TYPE));
        c.put("date_added", new cInfo(DateAddedItem.class, DateAddedItem.DATASOURCE_TYPE));
        c.put("DateCompleted", new cInfo(DateCompletedItem.class, DateCompletedItem.DATASOURCE_TYPE));
        c.put("ProgressETA", new cInfo(ColumnProgressETA.class, ColumnProgressETA.DATASOURCE_TYPE));
        Class<VuzeActivitiesEntry> ac = VuzeActivitiesEntry.class;
        c.put("activityNew", new cInfo(ColumnActivityNew.class, ac));
        c.put("activityAvatar", new cInfo(ColumnActivityAvatar.class, ac));
        c.put("activityType", new cInfo(ColumnActivityType.class, ac));
        c.put("activityText", new cInfo(ColumnActivityText.class, ac));
        c.put("activityActions", new cInfo(ColumnActivityActions.class, ac));
        c.put("activityDate", new cInfo(ColumnActivityDate.class, ac));
        c.put("Thumbnail", new cInfo(ColumnThumbnail.class, new Class[]{ac, Download.class}));
        c.put(ColumnAzProduct.COLUMN_ID, new cInfo(ColumnAzProduct.class, new Class[]{ac, Download.class}));
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnCoreCreationListener tcCreator = new TableColumnCoreCreationListener(){

            public TableColumnCore createTableColumnCore(Class forDataSourceType, String tableID, String columnID) {
                cInfo info = (cInfo)c.get(columnID);
                try {
                    Constructor constructor = info.cla.getDeclaredConstructor(String.class);
                    TableColumnCore column = (TableColumnCore)constructor.newInstance(tableID);
                    return column;
                }
                catch (Exception e) {
                    Debug.out(e);
                    return null;
                }
            }

            public void tableColumnCreated(TableColumn column) {
            }
        };
        for (String id : c.keySet()) {
            cInfo info = (cInfo)c.get(id);
            for (int i = 0; i < info.forDataSourceTypes.length; ++i) {
                Class cla = info.forDataSourceTypes[i];
                tcManager.registerColumn(cla, id, tcCreator);
            }
        }
    }

    private static class cInfo {
        public Class cla;
        public Class[] forDataSourceTypes;

        public cInfo(Class cla, Class forDataSourceType) {
            this.cla = cla;
            this.forDataSourceTypes = new Class[]{forDataSourceType};
        }

        public cInfo(Class cla, Class[] forDataSourceTypes) {
            this.cla = cla;
            this.forDataSourceTypes = forDataSourceTypes;
        }
    }
}

