/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.swt.content.RelatedContentEnumerator;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarCloseListener;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class RelatedContentUI {
    private static final boolean DISABLE_ALL_UI = !Constants.isCVSVersion();
    private PluginInterface plugin_interface;
    private UIManager ui_manager;
    private RelatedContentManager manager;
    private boolean ui_setup;
    private SideBar side_bar;
    private boolean root_menus_added;
    private MainViewInfo main_view_info;
    private ByteArrayHashMap<RCMItem> rcm_item_map = new ByteArrayHashMap();
    private static final String SPINNER_IMAGE_ID = "image.sidebar.vitality.dl";

    public RelatedContentUI() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ui_manager = this.plugin_interface.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            RelatedContentUI.this.uiAttachedAndCoreRunning(core);
                        }
                    });
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void uiAttachedAndCoreRunning(AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                if (sideBar != null) {
                    RelatedContentUI.this.setupUI(sideBar);
                } else {
                    SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                        public void skinViewAdded(SkinView skinview) {
                            if (skinview instanceof SideBar) {
                                RelatedContentUI.this.setupUI((SideBar)skinview);
                                SkinViewManager.RemoveListener(this);
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupUI(SideBar _side_bar) {
        RelatedContentUI relatedContentUI = this;
        synchronized (relatedContentUI) {
            if (this.ui_setup) {
                return;
            }
            this.ui_setup = true;
        }
        this.side_bar = _side_bar;
        try {
            this.manager = RelatedContentManager.getSingleton();
            if (DISABLE_ALL_UI || !this.manager.isEnabled()) {
                return;
            }
            BasicPluginConfigModel config_model = this.ui_manager.createBasicPluginConfigModel("root", "Associations");
            final BooleanParameter enabled = config_model.addBooleanParameter2("rcm.config.enabled", "rcm.config.enabled", this.manager.isUIEnabled());
            enabled.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    RelatedContentUI.this.manager.setUIEnabled(enabled.getValue());
                    RelatedContentUI.this.buildSideBar();
                }
            });
            final IntParameter max_results = config_model.addIntParameter2("rcm.config.max_results", "rcm.config.max_results", this.manager.getMaxResults());
            max_results.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    RelatedContentUI.this.manager.setMaxResults(max_results.getValue());
                }
            });
            final IntParameter max_level = config_model.addIntParameter2("rcm.config.max_level", "rcm.config.max_level", this.manager.getMaxSearchLevel());
            max_level.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    RelatedContentUI.this.manager.setMaxSearchLevel(max_level.getValue());
                }
            });
            enabled.addEnabledOnSelection(max_results);
            enabled.addEnabledOnSelection(max_level);
            this.main_view_info = new MainViewInfo();
            this.hookMenus();
            this.buildSideBar();
            this.manager.addListener(new RelatedContentManagerListener(){
                private int last_unread;

                public void contentFound(RelatedContent[] content) {
                    this.check();
                }

                public void contentChanged(RelatedContent[] content) {
                    this.contentChanged();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contentChanged() {
                    ArrayList items;
                    this.check();
                    RelatedContentUI relatedContentUI = RelatedContentUI.this;
                    synchronized (relatedContentUI) {
                        items = new ArrayList(RelatedContentUI.this.rcm_item_map.values());
                    }
                    for (RCMItem item : items) {
                        item.updateNumUnread();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contentRemoved(RelatedContent[] content) {
                    ArrayList items;
                    this.check();
                    RelatedContentUI relatedContentUI = RelatedContentUI.this;
                    synchronized (relatedContentUI) {
                        items = new ArrayList(RelatedContentUI.this.rcm_item_map.values());
                    }
                    for (RCMItem item : items) {
                        item.contentRemoved(content);
                    }
                }

                public void contentReset() {
                    this.check();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void check() {
                    int unread = RelatedContentUI.this.manager.getNumUnread();
                    6 var2_2 = this;
                    synchronized (var2_2) {
                        if (unread == this.last_unread) {
                            return;
                        }
                        this.last_unread = unread;
                    }
                    ViewTitleInfoManager.refreshTitleInfo(RelatedContentUI.this.main_view_info);
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void hookMenus() {
        String[] table_ids;
        TableManager table_manager = this.plugin_interface.getUIManager().getTableManager();
        for (String table_id : table_ids = new String[]{"MyTorrents", "MySeeders", "MyLibrary.big", "MySeeders.big", "MyTorrents.big"}) {
            TableContextMenuItem menu_item = table_manager.addContextMenuItem(table_id, "rcm.contextmenu.lookupassoc");
            menu_item.setStyle(1);
            MenuItemListener listener = new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    TableRow[] rows = (TableRow[])target;
                    if (rows.length > 0) {
                        Download download = (Download)rows[0].getDataSource();
                        RelatedContentUI.this.explicitSearch(download);
                    }
                }
            };
            menu_item.addMultiListener(listener);
        }
    }

    protected void explicitSearch(Download download) {
        this.addSearch(download);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildSideBar() {
        String parent_id = "sidebar.RelatedContent";
        SideBarEntrySWT main_sb_entry = SideBar.getEntry("RelatedContent");
        if (main_sb_entry == null) return;
        SideBarEntrySWT subs_entry = SideBar.getEntry("Subscriptions");
        int index = this.side_bar.getIndexOfEntryRelativeToParent(subs_entry);
        if (index >= 0) {
            ++index;
        }
        if (main_sb_entry.getTreeItem() == null) {
            if (!this.manager.isUIEnabled()) return;
            this.side_bar.createEntryFromSkinRef(null, "RelatedContent", "rcmview", this.main_view_info.getTitle(), this.main_view_info, null, false, index);
            main_sb_entry.setDatasource(new RelatedContentEnumerator(){
                private RelatedContentManagerListener base_listener;
                private RelatedContentEnumerator.RelatedContentEnumeratorListener current_listener;

                public void enumerate(RelatedContentEnumerator.RelatedContentEnumeratorListener listener) {
                    this.current_listener = listener;
                    if (this.base_listener == null) {
                        this.base_listener = new RelatedContentManagerListener(){

                            public void contentFound(RelatedContent[] content) {
                                current_listener.contentFound(content);
                            }

                            public void contentChanged(RelatedContent[] content) {
                            }

                            public void contentRemoved(RelatedContent[] content) {
                            }

                            public void contentChanged() {
                            }

                            public void contentReset() {
                            }
                        };
                        RelatedContentUI.this.manager.addListener(this.base_listener);
                    }
                    RelatedContent[] current_content = RelatedContentUI.this.manager.getRelatedContent();
                    listener.contentFound(current_content);
                }
            });
        } else if (!this.manager.isUIEnabled()) {
            main_sb_entry.getTreeItem().dispose();
            return;
        }
        if (this.root_menus_added) return;
        this.root_menus_added = true;
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        MenuItem menu_item = menu_manager.addMenuItem("sidebar.RelatedContent", "v3.activity.button.readall");
        menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                RelatedContentUI.this.manager.setAllRead();
            }
        });
        menu_item = menu_manager.addMenuItem("sidebar.RelatedContent", "Subscription.menu.deleteall");
        menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                RelatedContentUI.this.manager.deleteAll();
            }
        });
        menu_item = menu_manager.addMenuItem("sidebar.RelatedContent", "Subscription.menu.reset");
        menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                for (RCMItem item : RelatedContentUI.this.rcm_item_map.values()) {
                    item.getTreeItem().dispose();
                }
                RelatedContentUI.this.manager.reset();
            }
        });
        menu_item = menu_manager.addMenuItem("sidebar.RelatedContent", "sep");
        menu_item.setStyle(4);
        menu_item = menu_manager.addMenuItem("sidebar.RelatedContent", "ConfigView.title.short");
        menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "Associations");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearch(final Download download) {
        RelatedContentUI relatedContentUI = this;
        synchronized (relatedContentUI) {
            Torrent torrent = download.getTorrent();
            if (torrent == null) {
                return;
            }
            final byte[] hash = torrent.getHash();
            final RCMItem existing_si = this.rcm_item_map.get(hash);
            if (existing_si == null) {
                final RCMItem new_si = new RCMItem(download, hash);
                this.rcm_item_map.put(hash, new_si);
                Utils.execSWTThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        RelatedContentUI relatedContentUI = RelatedContentUI.this;
                        synchronized (relatedContentUI) {
                            if (new_si.isDestroyed()) {
                                return;
                            }
                            RCMView view = new RCMView("RelatedContent", download);
                            new_si.setView(view);
                            String key = "RCM_" + ByteFormatter.encodeString(hash);
                            SideBarEntrySWT entry = RelatedContentUI.this.side_bar.createEntryFromSkinRef("RelatedContent", key, "rcmview", view.getTitle(), view, null, true, -1);
                            new_si.setTreeItem(entry.getTreeItem(), entry);
                            new_si.activate();
                        }
                    }
                });
            } else {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        ViewTitleInfoManager.refreshTitleInfo(existing_si.getView());
                        SideBarEntrySWT mainSBEntry = SideBar.getEntry("RelatedContent");
                        if (mainSBEntry != null) {
                            ViewTitleInfoManager.refreshTitleInfo(mainSBEntry.getTitleInfo());
                        }
                        existing_si.activate();
                    }
                });
            }
        }
    }

    protected static void hideIcon(SideBarVitalityImage x) {
        if (x == null) {
            return;
        }
        x.setVisible(false);
        x.setToolTip("");
    }

    protected static void showIcon(SideBarVitalityImage x, String t) {
        if (x == null) {
            return;
        }
        x.setToolTip(t);
        x.setVisible(true);
    }

    protected class MainViewInfo
    implements ViewTitleInfo {
        protected MainViewInfo() {
        }

        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                int unread = RelatedContentUI.this.manager.getNumUnread();
                if (unread > 0) {
                    return String.valueOf(unread);
                }
            } else if (propertyID == 8) {
                // empty if block
            }
            return null;
        }

        public String getTitle() {
            return MessageText.getString("rcm.view.title");
        }
    }

    public class RCMItem
    implements RelatedContentEnumerator,
    SideBarCloseListener {
        private Download download;
        private byte[] hash;
        private RCMView view;
        private SideBarEntrySWT sb_entry;
        private TreeItem tree_item;
        private boolean destroyed;
        private SideBarVitalityImage spinner;
        private List<RelatedContent> content_list = new ArrayList<RelatedContent>();
        private int num_unread;
        private CopyOnWriteList<RelatedContentEnumerator.RelatedContentEnumeratorListener> listeners = new CopyOnWriteList();
        private boolean lookup_complete;

        protected RCMItem(Download _download, byte[] _hash) {
            this.download = _download;
            this.hash = _hash;
        }

        protected void setTreeItem(TreeItem _tree_item, SideBarEntrySWT _sb_entry) {
            this.tree_item = _tree_item;
            this.sb_entry = _sb_entry;
            this.sb_entry.setDatasource(this);
            this.sb_entry.addListener(this);
            this.spinner = this.sb_entry.addVitalityImage(RelatedContentUI.SPINNER_IMAGE_ID);
            try {
                RelatedContentUI.showIcon(this.spinner, null);
                RelatedContentUI.this.manager.lookupContent(this.download, new RelatedContentLookupListener(){

                    public void lookupStart() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void contentFound(RelatedContent[] content) {
                        RCMItem rCMItem = RCMItem.this;
                        synchronized (rCMItem) {
                            if (!RCMItem.this.destroyed) {
                                for (RelatedContent c : content) {
                                    RCMItem.this.content_list.add(c);
                                }
                            }
                        }
                        RCMItem.this.updateNumUnread();
                        for (RelatedContentEnumerator.RelatedContentEnumeratorListener listener : RCMItem.this.listeners) {
                            try {
                                listener.contentFound(content);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void lookupComplete() {
                        RCMItem rCMItem = RCMItem.this;
                        synchronized (rCMItem) {
                            RCMItem.this.lookup_complete = true;
                        }
                        RelatedContentUI.hideIcon(RCMItem.this.spinner);
                    }

                    public void lookupFailed(ContentException e) {
                        this.lookupComplete();
                    }
                });
            }
            catch (Throwable e) {
                this.lookup_complete = true;
                Debug.out(e);
                RelatedContentUI.hideIcon(this.spinner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void contentRemoved(RelatedContent[] content) {
            boolean deleted = false;
            RCMItem rCMItem = this;
            synchronized (rCMItem) {
                Iterator<RelatedContent> it = this.content_list.iterator();
                block3: while (it.hasNext()) {
                    RelatedContent rc = it.next();
                    for (RelatedContent x : content) {
                        if (x != rc) continue;
                        it.remove();
                        deleted = true;
                        continue block3;
                    }
                }
            }
            if (deleted) {
                this.updateNumUnread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateNumUnread() {
            boolean changed = false;
            RCMItem rCMItem = this;
            synchronized (rCMItem) {
                int num = 0;
                for (RelatedContent c : this.content_list) {
                    if (!c.isUnread()) continue;
                    ++num;
                }
                if (num != this.num_unread) {
                    this.num_unread = num;
                    changed = true;
                }
            }
            if (changed) {
                this.view.setNumUnread(this.num_unread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enumerate(RelatedContentEnumerator.RelatedContentEnumeratorListener listener) {
            RelatedContent[] already_found;
            RCMItem rCMItem = this;
            synchronized (rCMItem) {
                if (!this.lookup_complete) {
                    this.listeners.add(listener);
                }
                already_found = this.content_list.toArray(new RelatedContent[this.content_list.size()]);
            }
            if (already_found.length > 0) {
                listener.contentFound(already_found);
            }
        }

        protected TreeItem getTreeItem() {
            return this.tree_item;
        }

        protected SideBarEntrySWT getSideBarEntry() {
            return this.sb_entry;
        }

        protected void setView(RCMView _view) {
            this.view = _view;
        }

        protected RCMView getView() {
            return this.view;
        }

        protected boolean isDestroyed() {
            return this.destroyed;
        }

        public void sidebarClosed(SideBarEntry entry) {
            this.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            Object object = this;
            synchronized (object) {
                this.content_list.clear();
                this.destroyed = true;
            }
            object = RelatedContentUI.this;
            synchronized (object) {
                RelatedContentUI.this.rcm_item_map.remove(this.hash);
            }
        }

        public void activate() {
            SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sideBar != null && this.sb_entry != null) {
                sideBar.showEntryByID(this.sb_entry.getId());
            }
        }
    }

    protected class RCMView
    implements ViewTitleInfo {
        private String parent_key;
        private Download download;
        private int num_unread;

        protected RCMView(String _parent_key, Download _download) {
            this.parent_key = _parent_key;
            this.download = _download;
        }

        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                if (this.num_unread > 0) {
                    return String.valueOf(this.num_unread);
                }
            } else if (propertyID == 8) {
                // empty if block
            }
            return null;
        }

        public String getTitle() {
            return this.download.getName();
        }

        protected void setNumUnread(int n) {
            this.num_unread = n;
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }
}

