/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.content.RelatedContentEnumerator;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Actions;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Hash;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_LastSeen;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Level;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_New;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Rank;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Size;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Title;
import com.aelitis.azureus.ui.swt.content.columns.ColumnRC_Tracker;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class SBC_RCMView
extends SkinView
implements UIUpdatable,
IconBarEnabler {
    public static final String TABLE_RCM = "RCM";
    private static boolean columnsAdded = false;
    private static RelatedContentManager manager;
    private TableViewSWTImpl<RelatedContent> tv_related_content;
    private SideBarEntrySWT sidebar_entry;
    private Composite table_parent;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SBC_RCMView.this.initColumns(core);
            }
        });
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null) {
            this.sidebar_entry = sidebar.getCurrentEntry();
            this.sidebar_entry.setIconBarEnabler(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(AzureusCore core) {
        Class<SBC_RCMView> clazz = SBC_RCMView.class;
        synchronized (SBC_RCMView.class) {
            if (columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
            TableManager tableManager = uiManager.getTableManager();
            tableManager.registerColumn(RelatedContent.class, "rc_new", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_New(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_rank", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Rank(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_level", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Level(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_title", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Title(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_actions", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Actions(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_hash", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Hash(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_tracker", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Tracker(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_size", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_Size(column);
                }
            });
            tableManager.registerColumn(RelatedContent.class, "rc_lastseen", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnRC_LastSeen(column);
                }
            });
            return;
        }
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("rcm-list");
        if (so_list != null) {
            this.initTable((Composite)so_list.getControl());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        SBC_RCMView sBC_RCMView = this;
        synchronized (sBC_RCMView) {
            if (this.tv_related_content != null) {
                this.tv_related_content.delete();
                this.tv_related_content = null;
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        return super.skinObjectHidden(skinObject, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        SBC_RCMView sBC_RCMView = this;
        synchronized (sBC_RCMView) {
            if (this.tv_related_content != null) {
                this.tv_related_content.delete();
                this.tv_related_content = null;
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        this.tv_related_content = new TableViewSWTImpl(RelatedContent.class, TABLE_RCM, TABLE_RCM, new TableColumnCore[0], "rc_new", 0x10010002);
        this.tv_related_content.setRowDefaultHeight(16);
        this.tv_related_content.setHeaderVisible(true);
        this.table_parent = new Composite(control, 0);
        this.table_parent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.table_parent.setLayout((Layout)layout);
        this.tv_related_content.addSelectionListener(new TableSelectionListener(){

            public void selected(TableRowCore[] row) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void mouseExit(TableRowCore row) {
            }

            public void mouseEnter(TableRowCore row) {
            }

            public void focusChanged(TableRowCore focus) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void deselected(TableRowCore[] rows) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }
        }, false);
        this.tv_related_content.addLifeCycleListener(new TableLifeCycleListener(){
            private Set<RelatedContent> content_set = new HashSet<RelatedContent>();
            private boolean destroyed;
            private RelatedContentManagerListener rcm_listener = new RelatedContentManagerListener(){

                public void contentFound(RelatedContent[] content) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contentChanged(RelatedContent[] content) {
                    boolean hit = false;
                    Set set = content_set;
                    synchronized (set) {
                        if (destroyed) {
                            return;
                        }
                        for (RelatedContent c : content) {
                            if (!content_set.contains(c)) continue;
                            hit = true;
                        }
                    }
                    if (hit) {
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                if (SBC_RCMView.this.tv_related_content != null && !SBC_RCMView.this.tv_related_content.isDisposed()) {
                                    SBC_RCMView.this.tv_related_content.refreshTable(false);
                                }
                            }
                        });
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contentRemoved(RelatedContent[] content) {
                    final ArrayList<RelatedContent> hits = new ArrayList<RelatedContent>(content.length);
                    Set set = content_set;
                    synchronized (set) {
                        if (destroyed) {
                            return;
                        }
                        for (RelatedContent c : content) {
                            if (!content_set.remove(c)) continue;
                            hits.add(c);
                        }
                    }
                    if (hits.size() > 0) {
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                if (SBC_RCMView.this.tv_related_content != null && !SBC_RCMView.this.tv_related_content.isDisposed()) {
                                    SBC_RCMView.this.tv_related_content.removeDataSources(hits.toArray(new RelatedContent[hits.size()]));
                                }
                            }
                        });
                    }
                }

                public void contentChanged() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (SBC_RCMView.this.tv_related_content != null && !SBC_RCMView.this.tv_related_content.isDisposed()) {
                                SBC_RCMView.this.tv_related_content.refreshTable(false);
                            }
                        }
                    });
                }

                public void contentReset() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (SBC_RCMView.this.tv_related_content != null && !SBC_RCMView.this.tv_related_content.isDisposed()) {
                                SBC_RCMView.this.tv_related_content.removeAllTableRows();
                            }
                        }
                    });
                }
            };

            public void tableViewInitialized() {
                manager.addListener(this.rcm_listener);
                Object data_source = SBC_RCMView.this.sidebar_entry.getDatasource();
                if (data_source instanceof RelatedContentEnumerator) {
                    final TableViewSWTImpl f_table = SBC_RCMView.this.tv_related_content;
                    ((RelatedContentEnumerator)data_source).enumerate(new RelatedContentEnumerator.RelatedContentEnumeratorListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void contentFound(RelatedContent[] content) {
                            ArrayList<RelatedContent> new_content = null;
                            Set set = content_set;
                            synchronized (set) {
                                if (destroyed) {
                                    return;
                                }
                                for (RelatedContent c : content) {
                                    if (content_set.contains(c)) {
                                        if (new_content != null) continue;
                                        new_content = new ArrayList<RelatedContent>(content.length);
                                        for (RelatedContent c2 : content) {
                                            if (c == c2) break;
                                            new_content.add(c2);
                                        }
                                        continue;
                                    }
                                    if (new_content == null) continue;
                                    new_content.add(c);
                                }
                                if (new_content != null) {
                                    content = new_content.toArray(new RelatedContent[new_content.size()]);
                                }
                                content_set.addAll(Arrays.asList(content));
                            }
                            if (content.length > 0) {
                                final RelatedContent[] f_content = content;
                                Utils.execSWTThread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        if (SBC_RCMView.this.tv_related_content == f_table && !SBC_RCMView.this.tv_related_content.isDisposed()) {
                                            Set set = content_set;
                                            synchronized (set) {
                                                if (destroyed) {
                                                    return;
                                                }
                                            }
                                            f_table.addDataSources(f_content);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableViewDestroyed() {
                manager.removeListener(this.rcm_listener);
                Set<RelatedContent> set = this.content_set;
                synchronized (set) {
                    this.destroyed = true;
                    this.content_set.clear();
                }
            }
        });
        this.tv_related_content.addMenuFillListener(new TableViewSWTMenuFillListener(){

            public void fillMenu(String sColumnName, Menu menu) {
                Object[] _related_content = SBC_RCMView.this.tv_related_content.getSelectedDataSources().toArray();
                final RelatedContent[] related_content = new RelatedContent[_related_content.length];
                System.arraycopy(_related_content, 0, related_content, 0, related_content.length);
                MenuItem remove_item = new MenuItem(menu, 8);
                remove_item.setText(MessageText.getString("azbuddy.ui.menu.remove"));
                Utils.setMenuItemImage(remove_item, "delete");
                remove_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        manager.delete(related_content);
                    }
                });
            }

            public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
            }
        });
        this.tv_related_content.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    Object[] selected;
                    14 var3_2 = this;
                    synchronized (var3_2) {
                        selected = SBC_RCMView.this.tv_related_content == null ? new Object[]{} : SBC_RCMView.this.tv_related_content.getSelectedDataSources().toArray();
                    }
                    RelatedContent[] content = new RelatedContent[selected.length];
                    for (int i = 0; i < content.length; ++i) {
                        content[i] = (RelatedContent)selected[i];
                    }
                    manager.delete(content);
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tv_related_content.initialize(this.table_parent);
        control.layout(true);
    }

    public boolean isEnabled(String key) {
        if (key.equals("remove")) {
            return this.tv_related_content.getSelectedDataSources().size() > 0;
        }
        return false;
    }

    public boolean isSelected(String key) {
        return false;
    }

    public void itemActivated(String key) {
        Object[] _related_content = this.tv_related_content.getSelectedDataSources().toArray();
        if (_related_content.length > 0) {
            RelatedContent[] related_content = new RelatedContent[_related_content.length];
            System.arraycopy(_related_content, 0, related_content, 0, related_content.length);
            manager.delete(related_content);
        }
    }

    public String getUpdateUIName() {
        return "RCMView";
    }

    public void updateUI() {
        if (this.tv_related_content != null) {
            this.tv_related_content.refreshTable(false);
        }
    }

    static {
        try {
            manager = RelatedContentManager.getSingleton();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }
}

