/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content.columns;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnRC_Actions
implements TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "rc_actions";
    private static Font font = null;
    private Color colorLinkNormal;
    private Color colorLinkHover;

    public ColumnRC_Actions(TableColumn column) {
        column.initialize(1, -2, 215);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(2);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
            ((TableColumnCore)column).addCellOtherListener("SWTPaint", this);
        }
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        String text = cell.getText();
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                for (int i = 0; i < hitUrlInfo.length; ++i) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow() == null || cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString(2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (rc == null) {
            return;
        }
        boolean downloadable = rc.getHash() != null;
        if (!cell.setSortValue(downloadable ? 1L : 0L) && cell.isValid()) {
            return;
        }
        String s = "<A HREF=\"search\">" + MessageText.getString("Button.search") + "</A>";
        if (downloadable) {
            s = s + " | <A HREF=\"dl\">" + MessageText.getString("v3.MainWindow.button.download") + "</A>";
        }
        cell.setText(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        RelatedContent rc = (RelatedContent)event2.cell.getDataSource();
        if (rc == null) {
            return;
        }
        boolean invalidateAndRefresh = event2.eventType == 5;
        Rectangle bounds = ((TableCellSWT)event2.cell).getBounds();
        String text = event2.cell.getText();
        GCStringPrinter sp = null;
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            if (font != null) {
                gc.setFont(font);
            }
            Rectangle drawBounds = this.getDrawBounds((TableCellSWT)event2.cell);
            sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
            sp.calculateMetrics();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 1 && event2.button == 1) {
                    if (hitUrl.url.equals("dl")) {
                        byte[] hash = rc.getHash();
                        if (hash != null) {
                            rc.setUnread(false);
                            TorrentOpener.openTorrent(ByteFormatter.encodeString(hash));
                        }
                    } else if (hitUrl.url.equals("search")) {
                        rc.setUnread(false);
                        String title = rc.getTitle();
                        MainWindow.doSearch(title);
                    }
                }
                newCursor = 21;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        return bounds;
    }
}

