/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content.columns;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ColumnRC_Hash
implements TableCellRefreshListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "rc_hash";

    public ColumnRC_Hash(TableColumn column) {
        column.initialize(1, -1, 215);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    public void cellAdded(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (cell instanceof TableCellSWT && rc != null && rc.getHash() != null) {
            ((TableCellSWT)cell).setCursorID(21);
            cell.setToolTip(MessageText.getString("rcm.rc_hash.tt"));
        }
    }

    public void refresh(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (rc == null) {
            return;
        }
        byte[] hash = rc.getHash();
        if (hash == null) {
            return;
        }
        cell.setText(ByteFormatter.encodeString(hash));
    }
}

