/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content.columns;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnRC_New
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "rc_new";
    private static int WIDTH = 38;
    private static Image imgNew;
    private static Image imgOld;

    public ColumnRC_New(TableColumn column) {
        column.initialize(3, -2, WIDTH);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(2);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).addCellOtherListener("SWTPaint", this);
        }
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        imgOld = ImageLoader.getInstance().getImage("image.activity.read");
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        RelatedContent entry = (RelatedContent)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image image = img = entry == null || entry.isUnread() ? imgNew : imgOld;
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    public void refresh(TableCell cell) {
        RelatedContent entry = (RelatedContent)cell.getDataSource();
        if (entry != null) {
            int sortVal;
            boolean unread = entry.isUnread();
            int n = sortVal = unread ? 1 : 0;
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            cell.invalidate();
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        RelatedContent entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (RelatedContent)event2.cell.getDataSource()) != null) {
            entry.setUnread(!entry.isUnread());
            event2.cell.invalidate();
        }
    }
}

