/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content.columns;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ColumnRC_Title
implements TableCellRefreshListener,
TableCellMouseListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "rc_title";

    public ColumnRC_Title(TableColumn column) {
        column.initialize(1, -2, 400);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    public void refresh(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (rc == null) {
            return;
        }
        String text = rc.getTitle();
        if (text == null || text.length() == 0) {
            return;
        }
        cell.setText(text);
    }

    public void cellAdded(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (cell instanceof TableCellSWT && rc != null) {
            ((TableCellSWT)cell).setCursorID(21);
            cell.setToolTip(MessageText.getString("rcm.rc_title.tt"));
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        RelatedContent rc;
        if (event2.eventType == 0 && event2.button == 1 && (rc = (RelatedContent)event2.cell.getDataSource()) != null) {
            rc.setUnread(false);
            String title = rc.getTitle();
            MainWindow.doSearch(title);
        }
    }
}

