/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.content.columns;

import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ColumnRC_Tracker
implements TableCellRefreshListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "rc_tracker";

    public ColumnRC_Tracker(TableColumn column) {
        column.initialize(1, -1, 215);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    public void refresh(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (rc == null) {
            return;
        }
        String tracker = rc.getTracker();
        if (!this.validTracker(tracker)) {
            return;
        }
        cell.setText(tracker);
    }

    public void cellAdded(TableCell cell) {
        RelatedContent rc = (RelatedContent)cell.getDataSource();
        if (cell instanceof TableCellSWT && rc != null && this.validTracker(rc.getTracker())) {
            ((TableCellSWT)cell).setCursorID(21);
            cell.setToolTip(MessageText.getString("rcm.rc_tracker.tt"));
        }
    }

    private boolean validTracker(String tracker) {
        if (tracker == null || tracker.length() == 0) {
            return false;
        }
        int pos = tracker.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        for (int i = pos + 1; i < tracker.length(); ++i) {
            if (Character.isDigit(tracker.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

