/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.swt.NetStatusPluginTester;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class DeviceInternetView
extends DeviceManagerUI.categoryView {
    private DeviceManagerUI device_manager_ui;
    private NetStatusPlugin plugin;
    private Composite main;
    private Button start_button;
    private Button cancel_button;
    private StyledText log;
    private static final int selected_tests = 14;
    private NetStatusPluginTester current_test;
    private static final int LOG_NORMAL = 1;
    private static final int LOG_SUCCESS = 2;
    private static final int LOG_ERROR = 3;
    private static final int LOG_INFO = 4;
    private int log_type = 1;

    protected DeviceInternetView(DeviceManagerUI dm_ui, String title) {
        super(dm_ui, 4, title);
        this.device_manager_ui = dm_ui;
    }

    public void initialize(Composite parent) {
        PluginInterface pi = this.device_manager_ui.getPluginInterface().getPluginManager().getPluginInterfaceByClass(NetStatusPlugin.class);
        this.plugin = (NetStatusPlugin)pi.getPlugin();
        this.main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        this.main.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        this.main.setLayoutData((Object)grid_data);
        Label info_lab = new Label(this.main, 0);
        info_lab.setText("Test your internet connection");
        Composite control = new Composite(this.main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        control.setLayout((Layout)layout);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        control.setLayoutData((Object)grid_data);
        this.start_button = new Button(control, 8);
        Messages.setLanguageText((Widget)this.start_button, "ConfigView.section.start");
        this.start_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceInternetView.this.start_button.setEnabled(false);
                DeviceInternetView.this.cancel_button.setEnabled(true);
                DeviceInternetView.this.startTest();
            }
        });
        this.cancel_button = new Button(control, 8);
        Messages.setLanguageText((Widget)this.cancel_button, "UpdateWindow.cancel");
        this.cancel_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceInternetView.this.cancel_button.setEnabled(false);
                DeviceInternetView.this.cancelTest();
            }
        });
        this.cancel_button.setEnabled(false);
        this.log = new StyledText(this.main, 2824);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        this.log.setLayoutData((Object)grid_data);
        this.log.setIndent(4);
    }

    protected void startTest() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                DeviceInternetView.this.startTestSupport(core);
            }
        });
    }

    protected void cancelTest() {
        new AEThread2("NetStatus:cancel", true){

            public void run() {
                DeviceInternetView.this.cancelTestSupport();
            }
        }.start();
    }

    /*
     * Exception decompiling
     */
    protected void startTestSupport(AzureusCore core) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void println(String str) {
        this.print(str + "\n", false);
    }

    protected void println(String str, boolean clear_first) {
        this.print(str + "\n", clear_first);
    }

    protected void print(final String str, final boolean clear_first) {
        if (!this.log.isDisposed() && !this.log.getDisplay().isDisposed()) {
            final int f_log_type = this.log_type;
            this.log.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int start;
                    if (DeviceInternetView.this.log.isDisposed()) {
                        return;
                    }
                    if (clear_first) {
                        start = 0;
                        DeviceInternetView.this.log.setText(str);
                    } else {
                        start = DeviceInternetView.this.log.getText().length();
                        DeviceInternetView.this.log.append(str);
                    }
                    Color color = f_log_type == 1 ? Colors.black : (f_log_type == 2 ? Colors.green : (f_log_type == 4 ? Colors.blue : Colors.red));
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = start;
                    styleRange.length = str.length();
                    styleRange.foreground = color;
                    DeviceInternetView.this.log.setStyleRange(styleRange);
                    DeviceInternetView.this.log.setSelection(DeviceInternetView.this.log.getText().length());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTestSupport() {
        DeviceInternetView deviceInternetView = this;
        synchronized (deviceInternetView) {
            if (this.current_test != null) {
                this.println("Cancelling test...");
                this.current_test.cancel();
            }
        }
    }

    public Composite getComposite() {
        return this.main;
    }

    public void delete() {
        super.delete();
    }
}

