/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceSearchListener;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.devices.TranscodeQueueListener;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.download.DiskManagerFileInfoFile;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.devices.DeviceInternetView;
import com.aelitis.azureus.ui.swt.devices.DevicesFTUX;
import com.aelitis.azureus.ui.swt.devices.TranscodeChooser;
import com.aelitis.azureus.ui.swt.devices.add.DeviceTemplateChooser;
import com.aelitis.azureus.ui.swt.devices.add.ManufacturerChooser;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnabler;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnablerSelectedContent;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarDropListener;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImageListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInputReceiver;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class DeviceManagerUI {
    public static boolean DISABLED;
    private static final int MIN_FILE_SIZE_FOR_XCODE = 131072;
    private static final int MAX_FILES_FOR_MULTI_XCODE = 64;
    private static final Object DEVICE_IVIEW_KEY;
    private static final String CONFIG_VIEW_TYPE = "device.sidebar.ui.viewtype";
    static final String CONFIG_VIEW_HIDE_REND_GENERIC = "device.sidebar.ui.rend.hidegeneric";
    private static final String SPINNER_IMAGE_ID = "image.sidebar.vitality.dl";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final boolean SHOW_VITALITY = false;
    private static final String[] to_copy_indicator_colors;
    private DeviceManager device_manager;
    private DeviceManagerListener device_manager_listener;
    private final PluginInterface plugin_interface;
    private final UIManager ui_manager;
    private UISWTInstance swt_ui;
    private boolean ui_setup;
    private SideBar side_bar;
    private boolean sidebar_built;
    private static final int SBV_SIMPLE = 0;
    private static final int SBV_FULL = Integer.MAX_VALUE;
    private int side_bar_view_type = COConfigurationManager.getIntParameter("device.sidebar.ui.viewtype", 0);
    private boolean side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true);
    private int next_sidebar_id;
    private List<categoryView> categories = new ArrayList<categoryView>();
    private MenuItemListener properties_listener;
    private MenuItemListener hide_listener;
    private MenuItemListener rename_listener;
    private MenuItemFillListener will_remove_listener;
    private MenuItemListener remove_listener;
    private MenuItemFillListener show_fill_listener;
    private MenuItemListener show_listener;
    private MenuItemFillListener will_browse_listener;

    public DeviceManagerUI(AzureusCore core) {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ui_manager = this.plugin_interface.getUIManager();
        if (DISABLED) {
            return;
        }
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    DeviceManagerUI.this.swt_ui = (UISWTInstance)instance;
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            DeviceManagerUI.this.uiAttachedAndCoreRunning(core);
                        }
                    });
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void uiAttachedAndCoreRunning(AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                if (sideBar != null) {
                    DeviceManagerUI.this.setupUI(sideBar);
                } else {
                    SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                        public void skinViewAdded(SkinView skinview) {
                            if (skinview instanceof SideBar) {
                                DeviceManagerUI.this.setupUI((SideBar)skinview);
                                SkinViewManager.RemoveListener(this);
                            }
                        }
                    });
                }
            }
        });
        UIExitUtilsSWT.addListener(new UIExitUtilsSWT.canCloseListener(){

            public boolean canClose() {
                try {
                    final TranscodeJob job = DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().getCurrentJob();
                    if (job == null || job.getState() != 1) {
                        return true;
                    }
                    boolean allowQuit = Utils.execSWTThreadWithBool("quitTranscoding", new AERunnableBoolean(){

                        public boolean runSupport() {
                            String title = MessageText.getString("device.quit.transcoding.title");
                            String text = MessageText.getString("device.quit.transcoding.text", new String[]{job.getName(), job.getTarget().getDevice().getName(), String.valueOf(job.getPercentComplete())});
                            MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1, null, null, false, 0);
                            return mb.open() == 0;
                        }
                    }, 0L);
                    return allowQuit;
                }
                catch (Exception e) {
                    Debug.out(e);
                    return true;
                }
            }
        });
    }

    protected DeviceManager getDeviceManager() {
        return this.device_manager;
    }

    protected PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupUI(SideBar _side_bar) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.ui_setup) {
                return;
            }
            this.ui_setup = true;
        }
        this.side_bar = _side_bar;
        this.device_manager = DeviceManagerFactory.getSingleton();
        this.device_manager.addListener(new DeviceManagerListener(){

            public void deviceRemoved(Device device) {
            }

            public void deviceManagerLoaded() {
                DeviceManagerUI.this.device_manager.removeListener(this);
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        DeviceManagerUI.this.setupUIwithDeviceManager();
                    }
                });
            }

            public void deviceChanged(Device device) {
            }

            public void deviceAttentionRequest(Device device) {
            }

            public void deviceAdded(Device device) {
            }
        });
    }

    private void setupUIwithDeviceManager() {
        this.device_manager_listener = new DeviceManagerListener(){

            public void deviceAdded(Device device) {
                DeviceManagerUI.this.addOrChangeDevice(device);
            }

            public void deviceChanged(Device device) {
                DeviceManagerUI.this.addOrChangeDevice(device);
            }

            public void deviceAttentionRequest(Device device) {
                DeviceManagerUI.this.showDevice(device);
            }

            public void deviceRemoved(Device device) {
                DeviceManagerUI.this.removeDevice(device);
            }

            public void deviceManagerLoaded() {
            }
        };
        TranscodeManager transMan = this.device_manager.getTranscodeManager();
        TranscodeQueue transQ = transMan.getQueue();
        transQ.addListener(new TranscodeQueueListener(){
            int last_job_count = 0;

            public void jobAdded(TranscodeJob job) {
                this.check();
            }

            public void jobChanged(TranscodeJob job) {
                this.check();
            }

            public void jobRemoved(TranscodeJob job) {
                this.check();
            }

            protected void check() {
                int job_count = DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().getJobCount();
                if (job_count != this.last_job_count) {
                    SideBarEntrySWT main_sb_entry;
                    if ((job_count == 0 || this.last_job_count == 0) && (main_sb_entry = SideBar.getEntry("Devices")) != null) {
                        ViewTitleInfoManager.refreshTitleInfo(main_sb_entry.getTitleInfo());
                    }
                    this.last_job_count = job_count;
                }
            }
        });
        this.setupListeners();
        this.buildSideBar(false);
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", "Devices");
        final BooleanParameter as = configModel.addBooleanParameter2("device.search.auto", "device.search.auto", this.device_manager.getAutoSearch());
        as.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setAutoSearch(as.getValue());
                if (DeviceManagerUI.this.device_manager.getAutoSearch()) {
                    DeviceManagerUI.this.search();
                }
            }
        });
        final BooleanParameter qosParam = configModel.addBooleanParameter2("devices.sendQOS", "devices.turnon.qos", false);
        qosParam.setValue(COConfigurationManager.getBooleanParameter("devices.sendQOS", false));
        qosParam.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                COConfigurationManager.setParameter("devices.sendQOS", qosParam.getValue());
            }
        });
        final IntParameter max_xcode = configModel.addIntParameter2("device.config.xcode.maxbps", "device.config.xcode.maxbps", (int)(this.device_manager.getTranscodeManager().getQueue().getMaxBytesPerSecond() / 1024L), 0, Integer.MAX_VALUE);
        max_xcode.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().setMaxBytesPerSecond(max_xcode.getValue() * 1024);
            }
        });
        final BooleanParameter config_simple_view = configModel.addBooleanParameter2(CONFIG_VIEW_TYPE, "devices.sidebar.simple", this.side_bar_view_type == 0);
        config_simple_view.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, config_simple_view.getValue() ? 0 : Integer.MAX_VALUE);
            }
        });
        COConfigurationManager.addParameterListener(CONFIG_VIEW_TYPE, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameterName) {
                config_simple_view.setValue(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
            }
        });
        configModel.addBooleanParameter2("!device.sidebar.ui.rend.hidegeneric!", "devices.sidebar.hide.rend.generic", this.side_bar_hide_rend_gen);
        String def = this.device_manager.getDefaultWorkingDirectory().getAbsolutePath();
        final DirectoryParameter def_work_dir = configModel.addDirectoryParameter2("device.config.xcode.workdir", "device.config.xcode.workdir", def);
        def_work_dir.setValue(def);
        def_work_dir.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setDefaultWorkingDirectory(new File(def_work_dir.getValue()));
            }
        });
        final BooleanParameter rss_enable = configModel.addBooleanParameter2("device.rss.enable", "device.rss.enable", this.device_manager.isRSSPublishEnabled());
        rss_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        final IntParameter rss_port = configModel.addIntParameter2("device.rss.port", "device.rss.port", this.device_manager.getRSSPort());
        final BooleanParameter rss_localonly = configModel.addBooleanParameter2("device.rss.localonly", "device.rss.localonly", this.device_manager.isRSSLocalOnly());
        rss_localonly.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setRSSLocalOnly(rss_localonly.getValue());
            }
        });
        final HyperlinkParameter rss_view = configModel.addHyperlinkParameter2("device.rss.view", this.getRSSLink(rss_port.getValue()));
        rss_port.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                int port = rss_port.getValue();
                DeviceManagerUI.this.device_manager.setRSSPort(port);
                rss_view.setHyperlink(DeviceManagerUI.this.getRSSLink(port));
            }
        });
        rss_enable.addEnabledOnSelection(rss_localonly);
        rss_enable.addEnabledOnSelection(rss_port);
        rss_enable.addEnabledOnSelection(rss_view);
        configModel.createGroup("device.rss.group", new Parameter[]{rss_enable, rss_port, rss_view, rss_localonly});
        final ActionParameter btnITunes = configModel.addActionParameter2(null, "devices.button.installitunes");
        btnITunes.setEnabled(false);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                boolean hasItunes = core.getPluginManager().getPluginInterfaceByID("azitunes") != null;
                btnITunes.setEnabled(!hasItunes);
            }
        });
        btnITunes.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        try {
                            PluginInstaller installer = core.getPluginManager().getPluginInstaller();
                            StandardPlugin itunes_plugin = installer.getStandardPlugin("azitunes");
                            itunes_plugin.install(false);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        });
        this.addAllDevices();
        this.setupMenus();
    }

    protected String getRSSLink(int port) {
        return "http://127.0.0.1:" + port + "/";
    }

    protected void setupListeners() {
        this.properties_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Device device = (Device)info.getDatasource();
                    DeviceManagerUI.this.showProperties(device);
                }
            }
        };
        this.hide_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Device device = (Device)info.getDatasource();
                    device.setHidden(true);
                }
            }
        };
        this.rename_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Device device = (Device)info.getDatasource();
                    UISWTInputReceiver entry = (UISWTInputReceiver)DeviceManagerUI.this.swt_ui.getInputReceiver();
                    entry.setPreenteredText(device.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setTitle("MyTorrentsView.menu.rename");
                    entry.prompt();
                    if (!entry.hasSubmittedInput()) {
                        return;
                    }
                    String input = entry.getSubmittedInput().trim();
                    if (input.length() > 0) {
                        device.setName(input);
                    }
                }
            }
        };
        this.will_remove_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)rows[0];
                    Device device = (Device)info.getDatasource();
                    menu.setEnabled(device.canRemove());
                } else {
                    menu.setEnabled(false);
                }
            }
        };
        this.remove_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Device device = (Device)info.getDatasource();
                    device.remove();
                }
            }
        };
        this.will_browse_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                menu.removeAllChildItems();
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)rows[0];
                    Device device = (Device)info.getDatasource();
                    Device.browseLocation[] locs = device.getBrowseLocations();
                    enabled = locs.length > 0;
                    MenuManager menuManager = DeviceManagerUI.this.ui_manager.getMenuManager();
                    for (final Device.browseLocation loc : locs) {
                        MenuItem loc_menu = menuManager.addMenuItem(menu, loc.getName());
                        loc_menu.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                Utils.launch(loc.getURL().toExternalForm());
                            }
                        });
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        this.show_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Object ds = info.getDatasource();
                    if (ds instanceof Device) {
                        Device device = (Device)ds;
                        device.setHidden(true);
                    } else {
                        Device[] devices;
                        int category_type = ds == null ? 0 : (Integer)ds;
                        for (Device device : devices = DeviceManagerUI.this.device_manager.getDevices()) {
                            if (category_type != 0 && (device.getType() != category_type || !device.isHidden())) continue;
                            device.setHidden(false);
                        }
                    }
                }
            }
        };
        this.show_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                for (Object row : rows) {
                    Device[] devices;
                    SideBarEntry info;
                    Object ds;
                    if (!(row instanceof SideBarEntry) || (ds = (info = (SideBarEntry)row).getDatasource()) instanceof Device) continue;
                    int category_type = ds == null ? 0 : (Integer)ds;
                    for (Device device : devices = DeviceManagerUI.this.device_manager.getDevices()) {
                        if (category_type != 0 && (device.getType() != category_type || !device.isHidden()) || !device.isHidden()) continue;
                        enabled = true;
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        this.side_bar.addListener(new SideBarListener(){

            public void sidebarItemSelected(SideBarEntrySWT new_entry, SideBarEntrySWT old_entry) {
                Object data_source = new_entry.getDatasource();
                if (data_source instanceof Device) {
                    final Device device = (Device)data_source;
                    ISelectedContent[] sels = new ISelectedContent[]{new ToolBarEnablerSelectedContent(new ToolBarEnabler(){

                        public boolean isEnabled(String itemKey) {
                            return "remove".equals(itemKey);
                        }

                        public boolean isSelected(String itemKey) {
                            return false;
                        }

                        public void itemActivated(String itemKey) {
                            MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{device.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                            int result = mb.open();
                            if (result == 0) {
                                device.remove();
                            }
                        }
                    })};
                    SelectedContentManager.changeCurrentlySelectedContent("IconBarEnabler", sels);
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{CONFIG_VIEW_TYPE, CONFIG_VIEW_HIDE_REND_GENERIC}, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameterName) {
                DeviceManagerUI.this.side_bar_view_type = COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0);
                DeviceManagerUI.this.side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true);
                if (DeviceManagerUI.this.sidebar_built) {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            DeviceManagerUI.this.removeAllDevices();
                            DeviceManagerUI.this.buildSideBar(true);
                            DeviceManagerUI.this.addAllDevices();
                        }
                    });
                }
            }
        });
    }

    protected static void hideIcon(SideBarVitalityImage x) {
        if (x == null) {
            return;
        }
        x.setVisible(false);
        x.setToolTip("");
    }

    protected static void showIcon(SideBarVitalityImage x, String t) {
        if (x == null) {
            return;
        }
        x.setToolTip(t);
        x.setVisible(true);
    }

    protected void buildSideBar(boolean rebuild) {
        final SideBarEntrySWT main_sb_entry = SideBar.getEntry("Devices");
        if (main_sb_entry != null) {
            MenuManager menu_manager = this.ui_manager.getMenuManager();
            if (!rebuild) {
                this.addDefaultDropListener(main_sb_entry);
                this.side_bar.createEntryFromSkinRef(null, "Devices", "devicesview", MessageText.getString("devices.view.title"), null, null, false, -1);
                if (this.device_manager.getTranscodeManager().getProviders().length == 0) {
                    SideBarVitalityImage turnon = main_sb_entry.addVitalityImage("image.sidebar.turnon");
                    turnon.addListener(new SideBarVitalityImageListener(){

                        public void sbVitalityImage_clicked(int x, int y) {
                            DevicesFTUX.ensureInstalled();
                        }
                    });
                }
                SideBarVitalityImage beta = main_sb_entry.addVitalityImage("image.sidebar.beta");
                beta.setAlignment(16384);
                main_sb_entry.setImageLeftID("image.sidebar.devices");
                main_sb_entry.setTitleInfo(new ViewTitleInfo(){
                    private int last_indicator = 0;
                    SideBarVitalityImage spinner = main_sb_entry.addVitalityImage("image.sidebar.vitality.dl");
                    SideBarVitalityImage warning = main_sb_entry.addVitalityImage("image.sidebar.vitality.alert");
                    SideBarVitalityImage info = main_sb_entry.addVitalityImage("image.sidebar.vitality.info");
                    {
                        DeviceManagerUI.hideIcon(this.spinner);
                        DeviceManagerUI.hideIcon(this.warning);
                        DeviceManagerUI.hideIcon(this.info);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object getTitleInfoProperty(int propertyID) {
                        boolean expanded = main_sb_entry.getTreeItem().getExpanded();
                        if (propertyID == 5) {
                            return MessageText.getString("devices.view.title");
                        }
                        if (propertyID == 0) {
                            this.spinner.setVisible(!expanded && DeviceManagerUI.this.device_manager.isBusy());
                            if (!expanded) {
                                Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                                this.last_indicator = 0;
                                String all_errors = "";
                                String all_infos = "";
                                for (Device device : devices) {
                                    String info;
                                    String error = device.getError();
                                    if (error != null) {
                                        all_errors = all_errors + (all_errors.length() == 0 ? "" : "; ") + error;
                                    }
                                    if ((info = device.getInfo()) != null) {
                                        all_infos = all_infos + (all_infos.length() == 0 ? "" : "; ") + info;
                                    }
                                    if (!(device instanceof DeviceMediaRenderer)) continue;
                                    DeviceMediaRenderer renderer = (DeviceMediaRenderer)device;
                                    this.last_indicator += renderer.getCopyToDevicePending() + renderer.getCopyToFolderPending();
                                }
                                if (all_errors.length() > 0) {
                                    DeviceManagerUI.hideIcon(this.info);
                                    DeviceManagerUI.showIcon(this.warning, all_errors);
                                } else {
                                    DeviceManagerUI.hideIcon(this.warning);
                                    if (all_infos.length() > 0) {
                                        DeviceManagerUI.showIcon(this.info, all_infos);
                                    } else {
                                        DeviceManagerUI.hideIcon(this.info);
                                    }
                                }
                                if (this.last_indicator <= 0) return null;
                            }
                            DeviceManagerUI.hideIcon(this.warning);
                            DeviceManagerUI.hideIcon(this.info);
                            return null;
                        } else if (propertyID == 8 && this.last_indicator <= 0) return null;
                        return null;
                    }
                });
                String parentID = "sidebar.Devices";
                MenuItem de_menu_item = menu_manager.addMenuItem(parentID, "device.search");
                de_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        DeviceManagerUI.this.search();
                    }
                });
                de_menu_item = menu_manager.addMenuItem(parentID, "device.show");
                de_menu_item.addListener(this.show_listener);
                de_menu_item.addFillListener(this.show_fill_listener);
                de_menu_item = menu_manager.addMenuItem(parentID, "devices.sidebar.simple");
                de_menu_item.setStyle(2);
                de_menu_item.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        menu.setData(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
                    }
                });
                de_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, (Boolean)menu.getData() != false ? 0 : Integer.MAX_VALUE);
                    }
                });
                de_menu_item = menu_manager.addMenuItem(parentID, "sep");
                de_menu_item.setStyle(4);
                de_menu_item = menu_manager.addMenuItem(parentID, "ConfigView.title.short");
                de_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            uif.openView(4, "Devices");
                        }
                    }
                });
                if (Constants.isCVSVersion()) {
                    de_menu_item = menu_manager.addMenuItem(parentID, "!(CVS Only)Show FTUX!");
                    de_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            DevicesFTUX.showForDebug();
                        }
                    });
                }
            }
            if (rebuild) {
                for (categoryView category : this.categories) {
                    category.destroy();
                }
            }
            this.categories.clear();
            if (this.side_bar_view_type == Integer.MAX_VALUE) {
                categoryView renderers_category = this.addDeviceCategory(3, "device.renderer.view.title", "image.sidebar.device.renderer");
                this.categories.add(renderers_category);
                MenuItem re_menu_item = menu_manager.addMenuItem("sidebar." + renderers_category.getKey(), "device.show");
                re_menu_item.addListener(this.show_listener);
                re_menu_item.addFillListener(this.show_fill_listener);
                categoryView media_servers_category = this.addDeviceCategory(2, "device.mediaserver.view.title", "image.sidebar.device.mediaserver");
                this.categories.add(media_servers_category);
                MenuItem ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.show");
                ms_menu_item.addListener(this.show_listener);
                ms_menu_item.addFillListener(this.show_fill_listener);
                ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.mediaserver.configure");
                ms_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            uif.openView(4, "upnpmediaserver.name");
                        }
                    }
                });
                categoryView routers_category = this.addDeviceCategory(1, "device.router.view.title", "image.sidebar.device.router");
                this.categories.add(routers_category);
                MenuItem rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.show");
                rt_menu_item.addListener(this.show_listener);
                rt_menu_item.addFillListener(this.show_fill_listener);
                rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.router.configure");
                rt_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            uif.openView(4, "UPnP");
                        }
                    }
                });
                categoryView internet_category = this.addDeviceCategory(4, "MainWindow.about.section.internet", "image.sidebar.device.internet");
                this.categories.add(internet_category);
            }
        }
        this.sidebar_built = true;
    }

    protected void addNewDevice() {
        ManufacturerChooser mfChooser = new ManufacturerChooser();
        mfChooser.open(new ManufacturerChooser.ClosedListener(){

            public void MfChooserClosed(DeviceManager.DeviceManufacturer mf) {
                if (mf == null) {
                    return;
                }
                DeviceTemplateChooser deviceTemplateChooser = new DeviceTemplateChooser(mf);
                deviceTemplateChooser.open(new DeviceTemplateChooser.DeviceTemplateClosedListener(){

                    public void deviceTemplateChooserClosed(DeviceTemplate deviceTemplate) {
                        if (deviceTemplate == null) {
                            return;
                        }
                        try {
                            Device device = deviceTemplate.createInstance(deviceTemplate.getName() + " test!");
                            device.requestAttention();
                        }
                        catch (DeviceManagerException e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
    }

    private void setupMenus() {
        String[] tables = new String[]{"MyTorrents", "MyTorrents.big", "MySeeders", "MySeeders.big", "Files", "Unopened", "Unopened.big", "MyLibrary.big"};
        TableManager table_manager = this.plugin_interface.getUIManager().getTableManager();
        MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object _target) {
                final TableRow[] target = _target instanceof TableRow ? new TableRow[]{(TableRow)_target} : (TableRow[])_target;
                boolean enabled = target.length > 0;
                for (TableRow row : target) {
                    Object obj = row.getDataSource();
                    if (obj instanceof Download) {
                        Download download = (Download)obj;
                        if (download.getState() != 8) continue;
                        enabled = false;
                        continue;
                    }
                    DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                    try {
                        if (file.getDownload().getState() != 8) continue;
                        enabled = false;
                    }
                    catch (Throwable e) {
                        enabled = false;
                    }
                }
                menu.setEnabled(enabled);
                menu.removeAllChildItems();
                if (enabled) {
                    Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                    int devices_added = 0;
                    for (Device device : devices) {
                        if (!(device instanceof TranscodeTarget)) continue;
                        ++devices_added;
                        final TranscodeTarget renderer = (TranscodeTarget)((Object)device);
                        TranscodeProfile[] profiles = renderer.getTranscodeProfiles();
                        TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!" + device.getName() + (profiles.length == 0 ? " (No Profiles)" : "") + "!");
                        device_item.setStyle(5);
                        if (profiles.length == 0) {
                            device_item.setEnabled(false);
                            continue;
                        }
                        for (final TranscodeProfile profile : profiles) {
                            TableContextMenuItem profile_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(device_item, "!" + profile.getName() + "!");
                            profile_item.addMultiListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object x) {
                                    for (TableRow row : target) {
                                        Object obj = row.getDataSource();
                                        try {
                                            if (obj instanceof Download) {
                                                Download download = (Download)obj;
                                                DeviceManagerUI.addDownload(renderer, profile, -1, download);
                                                continue;
                                            }
                                            DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                                            DeviceManagerUI.addFile(renderer, profile, -1, file);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    if (devices_added == 0) {
                        TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!(No Devices)!");
                        device_item.setEnabled(false);
                    }
                }
            }
        };
        for (String table : tables) {
            TableContextMenuItem menu = table_manager.addContextMenuItem(table, "devices.contextmenu.xcode");
            menu.setStyle(5);
            menu.addFillListener(menu_fill_listener);
        }
    }

    protected void search() {
        this.device_manager.search(10000, new DeviceSearchListener(){

            public void deviceFound(Device device) {
            }

            public void complete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrChangeDevice(final Device device) {
        DeviceMediaRenderer rend;
        int type = device.getType();
        String parent_key = null;
        if (this.side_bar_view_type == Integer.MAX_VALUE) {
            for (categoryView view : this.categories) {
                if (view.getDeviceType() != type) continue;
                parent_key = view.getKey();
                break;
            }
        } else {
            if (type != 3) {
                return;
            }
            parent_key = "Devices";
        }
        if (parent_key == null) {
            Debug.out("Unknown device type: " + device.getString());
            return;
        }
        boolean hide_device = device.isHidden();
        if (type == 3 && this.side_bar_hide_rend_gen && (rend = (DeviceMediaRenderer)device).isGeneric()) {
            hide_device = true;
        }
        if (hide_device) {
            this.removeDevice(device);
            return;
        }
        final String parent = parent_key;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            final deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di == null) {
                if (!device.isHidden()) {
                    final deviceItem new_di = new deviceItem();
                    device.setTransientProperty(DEVICE_IVIEW_KEY, new_di);
                    Utils.execSWTThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DeviceManagerUI deviceManagerUI = DeviceManagerUI.this;
                            synchronized (deviceManagerUI) {
                                DeviceMediaRenderer renderer;
                                SideBarEntrySWT entry;
                                if (new_di.isDestroyed()) {
                                    return;
                                }
                                deviceView view = new deviceView(parent, device);
                                new_di.setView(view);
                                String key = parent + "/" + device.getID() + ":" + DeviceManagerUI.this.nextSidebarID();
                                if (device.getType() == 3) {
                                    entry = DeviceManagerUI.this.side_bar.createEntryFromSkinRef(parent, key, "devicerendererview", device.getName(), view, null, false, -1);
                                    String id = null;
                                    int species = ((DeviceMediaRenderer)device).getRendererSpecies();
                                    if (species != 6) {
                                        id = "image.sidebar.device." + species + ".small";
                                    } else {
                                        String classification = device.getClassification();
                                        id = classification.equals("sony.PSP") ? "psp" : (classification.startsWith("tivo.") ? "tivo" : String.valueOf(species));
                                        id = "image.sidebar.device." + id + ".small";
                                    }
                                    if (id != null) {
                                        entry.setImageLeftID(id);
                                    }
                                    entry.setDatasource(device);
                                } else {
                                    DeviceManagerUI.this.side_bar.createTreeItemFromIView(parent, view, key, device, false, false, false);
                                    entry = SideBar.getEntry(key);
                                }
                                entry.setLogID(parent + "-" + device.getName());
                                new_di.setTreeItem(entry.getTreeItem(), entry);
                                DeviceManagerUI.this.setStatus(device, new_di);
                                if (device instanceof TranscodeTarget) {
                                    entry.addListener(new SideBarDropListener(){

                                        public void sideBarEntryDrop(SideBarEntry entry, Object payload) {
                                            DeviceManagerUI.handleDrop((TranscodeTarget)((Object)device), payload);
                                        }
                                    });
                                }
                                final MenuManager menu_manager = DeviceManagerUI.this.ui_manager.getMenuManager();
                                boolean need_sep = false;
                                if (device instanceof TranscodeTarget) {
                                    need_sep = true;
                                    MenuItem explore_menu_item = menu_manager.addMenuItem("sidebar." + key, "v3.menu.device.exploreTranscodes");
                                    explore_menu_item.addListener(new MenuItemListener(){

                                        public void selected(MenuItem menu, Object target) {
                                            ManagerUtils.open(((TranscodeTarget)((Object)device)).getWorkingDirectory());
                                        }
                                    });
                                }
                                if (device instanceof DeviceMediaRenderer) {
                                    need_sep = true;
                                    renderer = (DeviceMediaRenderer)device;
                                    if (renderer.canFilterFilesView()) {
                                        MenuItem filterfiles_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.only.show");
                                        filterfiles_menu_item.setStyle(2);
                                        filterfiles_menu_item.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                menu.setData(new Boolean(renderer.getFilterFilesView()));
                                            }
                                        });
                                        filterfiles_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.setFilterFilesView((Boolean)menu.getData());
                                            }
                                        });
                                    }
                                    if (renderer.canShowCategories()) {
                                        MenuItem showcat_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.show.cat");
                                        showcat_menu_item.setStyle(2);
                                        showcat_menu_item.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                menu.setData(new Boolean(renderer.getShowCategories()));
                                            }
                                        });
                                        showcat_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.setShowCategories((Boolean)menu.getData());
                                            }
                                        });
                                    }
                                    MenuItem alwayscache_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.always.cache");
                                    alwayscache_menu_item.setStyle(2);
                                    alwayscache_menu_item.addFillListener(new MenuItemFillListener(){

                                        public void menuWillBeShown(MenuItem menu, Object data) {
                                            menu.setData(new Boolean(renderer.getAlwaysCacheFiles()));
                                        }
                                    });
                                    alwayscache_menu_item.addListener(new MenuItemListener(){

                                        public void selected(MenuItem menu, Object target) {
                                            renderer.setAlwaysCacheFiles((Boolean)menu.getData());
                                        }
                                    });
                                }
                                if (need_sep) {
                                    menu_manager.addMenuItem("sidebar." + key, "1").setStyle(4);
                                }
                                need_sep = false;
                                if (device instanceof DeviceMediaRenderer) {
                                    TranscodeProfile[] transcodeProfiles;
                                    renderer = (DeviceMediaRenderer)device;
                                    if (renderer.canCopyToFolder()) {
                                        need_sep = true;
                                        MenuItem autocopy_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.autoCopy");
                                        autocopy_menu_item.setStyle(2);
                                        autocopy_menu_item.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                menu.setData(new Boolean(renderer.getAutoCopyToFolder()));
                                            }
                                        });
                                        autocopy_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.setAutoCopyToFolder((Boolean)menu.getData());
                                            }
                                        });
                                        final MenuItem mancopy_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.mancopy");
                                        mancopy_menu_item.setStyle(1);
                                        mancopy_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                try {
                                                    renderer.manualCopy();
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                        });
                                        mancopy_menu_item.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                File target;
                                                boolean enabled = false;
                                                if (!renderer.getAutoCopyToFolder() && (target = renderer.getCopyToFolder()) != null && target.exists()) {
                                                    enabled = renderer.getCopyToFolderPending() > 0;
                                                }
                                                mancopy_menu_item.setEnabled(enabled);
                                            }
                                        });
                                        MenuItem setcopyto_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.setcopyto");
                                        setcopyto_menu_item.setStyle(1);
                                        setcopyto_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                Shell shell = entry.getTreeItem().getDisplay().getActiveShell();
                                                DirectoryDialog dd = new DirectoryDialog(shell);
                                                File existing = renderer.getCopyToFolder();
                                                if (existing != null) {
                                                    dd.setFilterPath(existing.getAbsolutePath());
                                                }
                                                dd.setText(MessageText.getString("devices.xcode.setcopyto.title"));
                                                String path = dd.open();
                                                if (path != null) {
                                                    renderer.setCopyToFolder(new File(path));
                                                }
                                            }
                                        });
                                    }
                                    if (renderer.canAutoStartDevice()) {
                                        need_sep = true;
                                        MenuItem autostart_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.autoStart");
                                        autostart_menu_item.setStyle(2);
                                        autostart_menu_item.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                menu.setData(new Boolean(renderer.getAutoStartDevice()));
                                            }
                                        });
                                        autostart_menu_item.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.setAutoStartDevice((Boolean)menu.getData());
                                            }
                                        });
                                    }
                                    if (renderer.canAssociate()) {
                                        need_sep = true;
                                        final MenuItem menu_associate = menu_manager.addMenuItem("sidebar." + key, "devices.associate");
                                        menu_associate.setStyle(5);
                                        menu_associate.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                menu_associate.removeAllChildItems();
                                                if (renderer.isAlive()) {
                                                    InetAddress a = renderer.getAddress();
                                                    String address = a == null ? "" : a.getHostAddress();
                                                    MenuItem menu_none = menu_manager.addMenuItem(menu_associate, "!" + MessageText.getString("devices.associate.already") + ": " + address + "!");
                                                    menu_none.setEnabled(false);
                                                    menu_associate.setEnabled(true);
                                                } else {
                                                    DeviceManager.UnassociatedDevice[] unassoc = DeviceManagerUI.this.device_manager.getUnassociatedDevices();
                                                    if (unassoc.length == 0) {
                                                        menu_associate.setEnabled(false);
                                                    } else {
                                                        menu_associate.setEnabled(true);
                                                        for (final DeviceManager.UnassociatedDevice un : unassoc) {
                                                            MenuItem menu_un = menu_manager.addMenuItem(menu_associate, "!" + un.getAddress().getHostAddress() + ": " + un.getDescription() + "!");
                                                            menu_un.addListener(new MenuItemListener(){

                                                                public void selected(MenuItem menu, Object target) {
                                                                    renderer.associate(un);
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                    }
                                    if ((transcodeProfiles = renderer.getTranscodeProfiles()).length > 0) {
                                        need_sep = true;
                                        MenuItem menu_default_profile = menu_manager.addMenuItem("sidebar." + key, "v3.menu.device.defaultprofile");
                                        menu_default_profile.setStyle(5);
                                        MenuItem menu_profile_none = menu_manager.addMenuItem(menu_default_profile, "option.askeverytime");
                                        menu_profile_none.setStyle(3);
                                        menu_profile_none.setData(Boolean.FALSE);
                                        menu_profile_none.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.setDefaultTranscodeProfile(null);
                                            }
                                        });
                                        menu_profile_none.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(MenuItem menu, Object data) {
                                                TranscodeProfile profile = null;
                                                try {
                                                    profile = renderer.getDefaultTranscodeProfile();
                                                }
                                                catch (TranscodeException e) {
                                                    // empty catch block
                                                }
                                                menu.setData(profile == null ? Boolean.TRUE : Boolean.FALSE);
                                            }
                                        });
                                        for (final TranscodeProfile profile : transcodeProfiles) {
                                            MenuItem menuItem = menu_manager.addMenuItem(menu_default_profile, "!" + profile.getName() + "!");
                                            menuItem.setStyle(3);
                                            menuItem.setData(Boolean.FALSE);
                                            menuItem.addListener(new MenuItemListener(){

                                                public void selected(MenuItem menu, Object target) {
                                                    renderer.setDefaultTranscodeProfile(profile);
                                                }
                                            });
                                            menuItem.addFillListener(new MenuItemFillListener(){

                                                public void menuWillBeShown(MenuItem menu, Object data) {
                                                    TranscodeProfile dprofile = null;
                                                    try {
                                                        dprofile = renderer.getDefaultTranscodeProfile();
                                                    }
                                                    catch (TranscodeException e) {
                                                        // empty catch block
                                                    }
                                                    menu.setData(profile.equals(dprofile) ? Boolean.TRUE : Boolean.FALSE);
                                                }
                                            });
                                        }
                                    }
                                    need_sep = true;
                                    MenuItem rss_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.rsspub");
                                    rss_menu_item.setStyle(2);
                                    rss_menu_item.addFillListener(new MenuItemFillListener(){

                                        public void menuWillBeShown(MenuItem menu, Object data) {
                                            menu.setData(new Boolean(DeviceManagerUI.this.device_manager.isRSSPublishEnabled() && renderer.isRSSPublishEnabled()));
                                        }
                                    });
                                    rss_menu_item.addListener(new MenuItemListener(){

                                        public void selected(MenuItem menu, Object target) {
                                            renderer.setRSSPublishEnabled((Boolean)menu.getData());
                                        }
                                    });
                                    rss_menu_item.setEnabled(DeviceManagerUI.this.device_manager.isRSSPublishEnabled());
                                }
                                if (device.isBrowsable()) {
                                    need_sep = true;
                                    MenuItem browse_menu_item = menu_manager.addMenuItem("sidebar." + key, "device.browse");
                                    browse_menu_item.setStyle(5);
                                    browse_menu_item.addFillListener(DeviceManagerUI.this.will_browse_listener);
                                }
                                if (need_sep) {
                                    menu_manager.addMenuItem("sidebar." + key, "s2").setStyle(4);
                                }
                                MenuItem rename_menu_item = menu_manager.addMenuItem("sidebar." + key, "MyTorrentsView.menu.rename");
                                rename_menu_item.addListener(DeviceManagerUI.this.rename_listener);
                                MenuItem hide_menu_item = menu_manager.addMenuItem("sidebar." + key, "device.hide");
                                hide_menu_item.addListener(DeviceManagerUI.this.hide_listener);
                                MenuItem remove_menu_item = menu_manager.addMenuItem("sidebar." + key, "MySharesView.menu.remove");
                                remove_menu_item.addFillListener(DeviceManagerUI.this.will_remove_listener);
                                remove_menu_item.addListener(DeviceManagerUI.this.remove_listener);
                                menu_manager.addMenuItem("sidebar." + key, "s3").setStyle(4);
                                MenuItem menu_item = menu_manager.addMenuItem("sidebar." + key, "Subscription.menu.properties");
                                menu_item.addListener(DeviceManagerUI.this.properties_listener);
                            }
                        }
                    });
                }
            } else {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        ViewTitleInfoManager.refreshTitleInfo(existing_di.getView());
                        DeviceManagerUI.this.setStatus(device, existing_di);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            final deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null) {
                Utils.execSWTThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DeviceManagerUI deviceManagerUI = DeviceManagerUI.this;
                        synchronized (deviceManagerUI) {
                            TreeItem ti = existing_di.getTreeItem();
                            if (ti != null) {
                                for (TreeItem x = ti; x != null; x = x.getParentItem()) {
                                    x.setExpanded(true);
                                }
                                ti.getParent().setSelection(ti);
                            }
                        }
                    }
                });
            }
        }
    }

    public static void handleDrop(TranscodeTarget target, final Object payload) {
        TranscodeChooser deviceChooser = new TranscodeChooser(target){

            public void closed() {
                if (this.selectedTranscodeTarget != null && this.selectedProfile != null) {
                    DeviceManagerUI.handleDrop(this.selectedTranscodeTarget, this.selectedProfile, payload, this.getTranscodeRequirement());
                }
            }
        };
        deviceChooser.show();
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, byte[] hash) {
        try {
            DeviceManagerUI.addDownload(target, profile, transcode_requirement, AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, Download download) {
        DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
        int num_added = 0;
        for (DiskManagerFileInfo dm_file : dm_files) {
            if (num_added > 64) break;
            if (dm_files.length != 1 && dm_file.getLength() < 131072L) continue;
            DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
            ++num_added;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, DiskManagerFileInfo file) {
        try {
            DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, file, transcode_requirement);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDirectory(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        int num_added = 0;
        for (File f : files) {
            if (num_added > 64) break;
            if (f.isDirectory() || f.length() <= 131072L) continue;
            DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
            ++num_added;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (file.exists() && file.isFile()) {
            try {
                DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, new DiskManagerFileInfoFile(file), transcode_requirement);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            Debug.out("Drop to " + target.getDevice().getName() + " for " + file + " failed, file doesn't exist");
        }
    }

    protected static void handleDrop(TranscodeTarget target, TranscodeProfile profile, Object payload, int transcode_requirement) {
        block9: {
            String stuff;
            block10: {
                block8: {
                    String[] files;
                    if (!(payload instanceof String[])) break block8;
                    for (String file : files = (String[])payload) {
                        File f = new File(file);
                        if (f.isFile()) {
                            DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
                            continue;
                        }
                        DeviceManagerUI.addDirectory(target, profile, transcode_requirement, f);
                    }
                    break block9;
                }
                if (!(payload instanceof String)) break block9;
                stuff = (String)payload;
                if (!stuff.startsWith("DownloadManager\n") && !stuff.startsWith("DiskManagerFileInfo\n")) break block10;
                String[] bits = stuff.split("\n");
                for (int i = 1; i < bits.length; ++i) {
                    String hash_str = bits[i];
                    int pos = hash_str.indexOf(59);
                    try {
                        if (pos == -1) {
                            byte[] hash = Base32.decode(bits[i]);
                            DeviceManagerUI.addDownload(target, profile, transcode_requirement, hash);
                            continue;
                        }
                        String[] files = hash_str.split(";");
                        byte[] hash = Base32.decode(files[0].trim());
                        DiskManagerFileInfo[] dm_files = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash).getDiskManagerFileInfo();
                        for (int j = 1; j < files.length; ++j) {
                            DiskManagerFileInfo dm_file = dm_files[Integer.parseInt(files[j].trim())];
                            DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to get download for hash " + bits[1]);
                    }
                }
                break block9;
            }
            if (!stuff.startsWith("TranscodeFile\n")) break block9;
            String[] bits = stuff.split("\n");
            for (int i = 1; i < bits.length; ++i) {
                File f = new File(bits[i]);
                if (!f.isFile()) continue;
                DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
            }
        }
    }

    protected void setStatus(Device device, deviceItem sbi) {
        sbi.setStatus(device);
    }

    protected void addAllDevices() {
        this.device_manager.addListener(this.device_manager_listener);
        Utils.execSWTThread(new Runnable(){

            public void run() {
                Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                Arrays.sort(devices, new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                for (Device device : devices) {
                    DeviceManagerUI.this.addOrChangeDevice(device);
                }
            }
        });
    }

    protected void removeAllDevices() {
        this.device_manager.removeListener(this.device_manager_listener);
        Utils.execSWTThread(new Runnable(){

            public void run() {
                Device[] devices;
                for (Device device : devices = DeviceManagerUI.this.device_manager.getDevices()) {
                    DeviceManagerUI.this.removeDevice(device);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null) {
                device.setTransientProperty(DEVICE_IVIEW_KEY, null);
                existing_di.destroy();
            }
        }
    }

    protected categoryView addDeviceCategory(int device_type, String category_title, String category_image_id) {
        String key = "Device_" + category_title + ":" + this.nextSidebarID();
        categoryView view = device_type == 4 ? new DeviceInternetView(this, category_title) : new categoryViewGeneric(this, device_type, category_title);
        TreeItem item = this.side_bar.createTreeItemFromIView("Devices", view, key, new Integer(device_type), false, false, true);
        SideBarEntrySWT entry = SideBar.getEntry(key);
        this.addDefaultDropListener(entry);
        entry.setImageLeftID(category_image_id);
        view.setDetails(entry, item, key);
        return view;
    }

    protected void addDefaultDropListener(SideBarEntrySWT entry) {
        entry.addListener(new SideBarDropListener(){

            public void sideBarEntryDrop(SideBarEntry entry, Object payload) {
                DeviceManagerUI.handleDrop(null, payload);
            }
        });
    }

    protected void showProperties(Device device) {
        String[][] props = device.getDisplayProperties();
        new PropertiesWindow(device.getName(), props[0], props[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextSidebarID() {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            return this.next_sidebar_id++;
        }
    }

    static {
        DEVICE_IVIEW_KEY = new Object();
        to_copy_indicator_colors = new String[]{"#000000", "#000000", "#168866", "#1c5620"};
        try {
            String arch;
            DISABLED = Constants.isOSX ? (arch = System.getProperty("os.arch", "")).equalsIgnoreCase("powerpc") || arch.equalsIgnoreCase("ppc") : Constants.isUnix;
        }
        catch (Throwable t) {
            DISABLED = false;
        }
    }

    protected static abstract class categoryView
    extends AbstractIView
    implements ViewTitleInfo {
        private DeviceManagerUI ui;
        private int device_type;
        private String title;
        private TreeItem tree_item;
        private String key;
        private SideBarVitalityImage spinner;
        private SideBarVitalityImage warning;
        private SideBarVitalityImage info;
        private int last_indicator;

        protected categoryView(DeviceManagerUI _ui, int _device_type, String _title) {
            this.ui = _ui;
            this.device_type = _device_type;
            this.title = _title;
        }

        protected void setDetails(SideBarEntrySWT _entry, TreeItem _ti, String _key) {
            this.tree_item = _ti;
            this.key = _key;
            this.spinner = _entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.warning = _entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.info = _entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected int getDeviceType() {
            return this.device_type;
        }

        protected String getKey() {
            return this.key;
        }

        protected String getTitle() {
            return MessageText.getString(this.title);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getTitleInfoProperty(int propertyID) {
            boolean expanded;
            boolean bl = expanded = this.tree_item != null && this.tree_item.getExpanded();
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                if (this.device_type != 3) return null;
                if (this.spinner != null) {
                    this.spinner.setVisible(!expanded && this.ui.getDeviceManager().isBusy());
                }
                if (!expanded) {
                    Device[] devices = this.ui.getDeviceManager().getDevices();
                    this.last_indicator = 0;
                    String all_errors = "";
                    String all_infos = "";
                    for (Device device : devices) {
                        String info;
                        String error = device.getError();
                        if (error != null) {
                            all_errors = all_errors + (all_errors.length() == 0 ? "" : "; ") + error;
                        }
                        if ((info = device.getInfo()) != null) {
                            all_infos = all_infos + (all_infos.length() == 0 ? "" : "; ") + info;
                        }
                        if (!(device instanceof DeviceMediaRenderer)) continue;
                        DeviceMediaRenderer renderer = (DeviceMediaRenderer)device;
                        this.last_indicator += renderer.getCopyToDevicePending() + renderer.getCopyToFolderPending();
                    }
                    if (all_errors.length() > 0) {
                        DeviceManagerUI.showIcon(this.warning, all_errors);
                    } else {
                        DeviceManagerUI.hideIcon(this.warning);
                        if (all_infos.length() > 0) {
                            DeviceManagerUI.showIcon(this.info, all_infos);
                        } else {
                            DeviceManagerUI.hideIcon(this.info);
                        }
                    }
                    if (this.last_indicator <= 0) return null;
                }
                DeviceManagerUI.hideIcon(this.warning);
                DeviceManagerUI.hideIcon(this.info);
                return null;
            } else if (propertyID == 8 && this.last_indicator <= 0) return null;
            return null;
        }

        protected void destroy() {
            if (Utils.isThisThreadSWT()) {
                this.tree_item.dispose();
                this.delete();
            } else {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        categoryView.this.tree_item.dispose();
                        categoryView.this.delete();
                    }
                });
            }
        }
    }

    protected static class categoryViewGeneric
    extends categoryView {
        private Composite composite;

        protected categoryViewGeneric(DeviceManagerUI _ui, int _device_type, String _title) {
            super(_ui, _device_type, _title);
        }

        public void initialize(Composite parent_composite) {
            this.composite = new Composite(parent_composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 4;
            layout.marginLeft = 4;
            layout.marginRight = 4;
            layout.marginBottom = 4;
            this.composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            Label label = new Label(this.composite, 0);
            label.setText("Nothing to show for " + this.getTitle());
            label.setLayoutData((Object)data);
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void delete() {
            super.delete();
        }
    }

    public class deviceItem {
        private deviceView view;
        private SideBarEntrySWT sb_entry;
        private TreeItem tree_item;
        private boolean destroyed;
        private SideBarVitalityImage warning;
        private SideBarVitalityImage spinner;
        private SideBarVitalityImage info;

        protected deviceItem() {
        }

        protected void setTreeItem(TreeItem _tree_item, SideBarEntrySWT _sb_entry) {
            this.tree_item = _tree_item;
            this.sb_entry = _sb_entry;
            this.warning = this.sb_entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.spinner = this.sb_entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.info = this.sb_entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected TreeItem getTreeItem() {
            return this.tree_item;
        }

        protected SideBarEntrySWT getSideBarEntry() {
            return this.sb_entry;
        }

        protected void setView(deviceView _view) {
            this.view = _view;
        }

        protected deviceView getView() {
            return this.view;
        }

        protected void setStatus(Device device) {
            if (this.warning != null && this.info != null) {
                String error = device.getError();
                if (error != null) {
                    DeviceManagerUI.hideIcon(this.info);
                    this.warning.setToolTip(error);
                    this.warning.setImageID(DeviceManagerUI.ALERT_IMAGE_ID);
                    this.warning.setVisible(true);
                } else {
                    DeviceManagerUI.hideIcon(this.warning);
                    String info_str = device.getInfo();
                    if (info_str != null) {
                        DeviceManagerUI.showIcon(this.info, info_str);
                    } else {
                        DeviceManagerUI.hideIcon(this.info);
                    }
                }
            }
            if (this.spinner != null) {
                this.spinner.setVisible(device.isBusy());
            }
            if (this.view != null) {
                this.view.refreshTitles();
            }
        }

        protected boolean isDestroyed() {
            return this.destroyed;
        }

        protected void destroy() {
            this.destroyed = true;
            Utils.execSWTThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DeviceManagerUI deviceManagerUI = DeviceManagerUI.this;
                    synchronized (deviceManagerUI) {
                        if (deviceItem.this.tree_item != null && !deviceItem.this.tree_item.isDisposed()) {
                            deviceItem.this.tree_item.dispose();
                        }
                    }
                    deviceItem.this.view.delete();
                }
            });
        }

        public void activate() {
            SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sideBar != null && this.sb_entry != null) {
                sideBar.showEntryByID(this.sb_entry.getId());
            }
        }
    }

    protected static class deviceView
    extends AbstractIView
    implements ViewTitleInfo,
    TranscodeTargetListener {
        private String parent_key;
        private Device device;
        private Composite parent_composite;
        private Composite composite;
        private int last_indicator;

        protected deviceView(String _parent_key, Device _device) {
            this.parent_key = _parent_key;
            this.device = _device;
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.addListener(this);
            }
        }

        public void initialize(Composite _parent_composite) {
            this.parent_composite = _parent_composite;
            this.composite = new Composite(this.parent_composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 4;
            layout.marginLeft = 4;
            layout.marginRight = 4;
            layout.marginBottom = 4;
            this.composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            Label label = new Label(this.composite, 0);
            label.setText("Nothing to show for " + this.device.getName());
            label.setLayoutData((Object)data);
        }

        public Composite getComposite() {
            return this.composite;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                if (!(this.device instanceof DeviceMediaRenderer)) return null;
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                this.last_indicator = renderer.getCopyToDevicePending() + renderer.getCopyToFolderPending();
                if (this.last_indicator <= 0) return null;
            }
            if (propertyID == 8) {
                if (this.last_indicator <= 0) return null;
                return null;
            } else {
                if (propertyID != 9 || !this.device.isLivenessDetectable()) return null;
                return new Long(this.device.isAlive() ? 1L : 2L);
            }
            return null;
        }

        public String getTitle() {
            return this.device.getName();
        }

        public void fileAdded(TranscodeFile file) {
        }

        public void fileChanged(TranscodeFile file, int type, Object data) {
            if (type == 1 && data == "comp") {
                this.refreshTitles();
            }
        }

        protected void refreshTitles() {
            ViewTitleInfoManager.refreshTitleInfo(this);
            String key = this.parent_key;
            while (key != null) {
                SideBarEntrySWT parent = SideBar.getEntry(key);
                if (parent == null) continue;
                ViewTitleInfoManager.refreshTitleInfo(parent.getTitleInfo());
                key = parent.getParentID();
            }
        }

        public void fileRemoved(TranscodeFile file) {
        }

        public void delete() {
            super.delete();
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.removeListener(this);
            }
        }
    }
}

