/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class DevicesFTUX {
    private static final String URL_LEARN_MORE = "http://www.vuze.com/devices/qos.start";
    private static final String URL_DEVICES_INFO = "http://www.vuze.com/devices/turnon.start";
    public static DevicesFTUX instance;
    Shell shell;
    private Browser browser;
    private Button checkITunes;
    private Button btnInstall;
    private Button btnCancel;
    private Composite install_area;
    private Button checkQOS;
    private Composite install_area_parent;

    private boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private void setFocus() {
        this.shell.forceActive();
        this.shell.forceFocus();
    }

    private void open() {
        this.shell = ShellFactory.createShell(Utils.findAnyShell(), 2144);
        this.shell.setText(MessageText.getString("devices.turnon.title"));
        Utils.setShellIcon(this.shell);
        try {
            this.browser = new Browser((Composite)this.shell, Utils.getInitialBrowserStyle(0));
            new BrowserContext("DevicesFTUX", this.browser, null, true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Label lblInfo = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)lblInfo, "devices.turnon.prepageload");
        this.checkITunes = new Button((Composite)this.shell, 32);
        this.checkITunes.setSelection(true);
        Messages.setLanguageText((Widget)this.checkITunes, "devices.turnon.itunes");
        this.checkQOS = new Button((Composite)this.shell, 32);
        this.checkQOS.setSelection(true);
        Messages.setLanguageText((Widget)this.checkQOS, "devices.turnon.qos");
        Link lblLearnMore = new Link((Composite)this.shell, 0);
        lblLearnMore.setText("<A HREF=\"http://www.vuze.com/devices/qos.start\">" + MessageText.getString("label.learnmore") + "</A>");
        lblLearnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utils.launch(e.text);
            }
        });
        this.btnInstall = new Button((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)this.btnInstall, "Button.turnon");
        this.btnInstall.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                boolean sendQOS = DevicesFTUX.this.checkQOS.getSelection();
                DevicesFTUX.this.doInstall(DevicesFTUX.this.checkITunes.getSelection(), sendQOS);
            }
        });
        this.shell.setDefaultButton(this.btnInstall);
        this.btnCancel = new Button((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)this.btnCancel, "Button.cancel");
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DevicesFTUX.this.shell.dispose();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
        this.install_area_parent = new Composite((Composite)this.shell, 0);
        this.install_area_parent.setLayout((Layout)new FormLayout());
        this.install_area_parent.setVisible(false);
        this.install_area = new Composite(this.install_area_parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        this.shell.setLayout((Layout)formLayout);
        FormData fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment((Control)this.checkITunes, -5);
        fd.top = new FormAttachment(0, 8);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -8);
        lblInfo.setLayoutData((Object)fd);
        fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment((Control)this.checkITunes, -5);
        fd.width = 550;
        fd.height = 490;
        this.browser.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment(100, -10);
        this.btnCancel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment((Control)this.btnCancel, -12);
        this.btnInstall.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.checkQOS, -3);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment((Control)this.btnInstall, -12);
        this.checkITunes.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 10);
        this.checkQOS.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.checkQOS, 0, 0x1000000);
        fd.left = new FormAttachment((Control)this.checkQOS, 5);
        lblLearnMore.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.browser, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.install_area_parent.setLayoutData((Object)fd);
        fd = new FormData();
        fd.height = this.btnInstall.computeSize((int)-1, (int)-1).y;
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -12);
        this.install_area.setLayoutData((Object)fd);
        String url = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(URL_DEVICES_INFO, false, true);
        this.browser.setUrl(url);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.btnInstall.setFocus();
        this.shell.open();
    }

    protected void doInstall(final boolean itunes, final boolean sendQOS) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                DevicesFTUX.this._doInstall(core, itunes, sendQOS);
            }
        });
    }

    protected void _doInstall(AzureusCore core, boolean itunes, boolean sendQOS) {
        COConfigurationManager.setParameter("devices.sendQOS", sendQOS);
        if (sendQOS) {
            try {
                PlatformDevicesMessenger.qosTurnOn(itunes);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                Device[] devices;
                DeviceManager device_manager = DeviceManagerFactory.getSingleton();
                for (Device device : devices = device_manager.getDevices()) {
                    try {
                        PlatformDevicesMessenger.qosFoundDevice(device);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        ArrayList<StandardPlugin> plugins = new ArrayList<StandardPlugin>(2);
        PluginInstaller installer = core.getPluginManager().getPluginInstaller();
        StandardPlugin vuze_plugin = null;
        try {
            vuze_plugin = installer.getStandardPlugin("vuzexcode");
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (vuze_plugin != null && !vuze_plugin.isAlreadyInstalled()) {
            plugins.add(vuze_plugin);
        }
        if (itunes) {
            StandardPlugin itunes_plugin = null;
            try {
                itunes_plugin = installer.getStandardPlugin("azitunes");
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (itunes_plugin != null && !itunes_plugin.isAlreadyInstalled()) {
                plugins.add(itunes_plugin);
            }
        }
        if (plugins.size() == 0) {
            this.close();
            return;
        }
        InstallablePlugin[] installablePlugins = plugins.toArray(new InstallablePlugin[0]);
        try {
            this.install_area_parent.setVisible(true);
            this.install_area_parent.moveAbove(null);
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 2);
            properties.put(2, this.install_area);
            properties.put(3, true);
            installer.install(installablePlugins, false, properties, new PluginInstallationListener(){

                public void completed() {
                    SideBarVitalityImage[] vitalityImages;
                    DevicesFTUX.this.close();
                    SideBarEntrySWT sb = SideBar.getEntry("Devices");
                    for (SideBarVitalityImage vi : vitalityImages = sb.getVitalityImages()) {
                        if (!vi.getImageID().contains("turnon")) continue;
                        vi.setVisible(false);
                    }
                }

                public void cancelled() {
                    DevicesFTUX.this.close();
                }

                public void failed(PluginException e) {
                    Debug.out(e);
                    DevicesFTUX.this.close();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void close() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (DevicesFTUX.this.shell != null && !DevicesFTUX.this.shell.isDisposed()) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
    }

    public static boolean ensureInstalled() {
        DeviceManager device_manager = DeviceManagerFactory.getSingleton();
        if (device_manager.getTranscodeManager().getProviders().length == 0) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (instance == null || instance.isDisposed()) {
                        instance = new DevicesFTUX();
                        instance.open();
                    } else {
                        instance.setFocus();
                    }
                }
            });
            return false;
        }
        return true;
    }

    public static void showForDebug() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (instance == null || instance.isDisposed()) {
                    instance = new DevicesFTUX();
                    instance.open();
                } else {
                    instance.setFocus();
                }
            }
        });
    }
}

