/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.devices.TranscodeQueueListener;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnAzProduct;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnThumbnail;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Category;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Completion;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_CopiedToDevice;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Device;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Duration;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Name;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Profile;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Rank;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Resolution;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnTJ_Status;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_DevicesView
extends SkinView
implements TranscodeQueueListener,
IconBarEnabler,
UIUpdatable,
TranscodeTargetListener {
    public static final String TABLE_DEVICES = "Devices";
    public static final String TABLE_TRANSCODE_QUEUE = "TranscodeQueue";
    public static final String TABLE_DEVICE_LIBRARY = "DeviceLibrary";
    private static boolean columnsAdded = false;
    private DeviceManager device_manager;
    private TranscodeManager transcode_manager;
    private TranscodeQueue transcode_queue;
    private TableViewSWTImpl tvDevices;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private int drag_drop_line_start = -1;
    private TableRowCore[] drag_drop_rows;
    private TableViewSWTImpl<TranscodeFile> tvFiles;
    private SideBarEntrySWT sidebarEntry;
    private Composite tableJobsParent;
    private Device device;
    private TranscodeTarget transTarget;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soTitle;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SBC_DevicesView.this.initColumns(core);
            }
        });
        this.device_manager = DeviceManagerFactory.getSingleton();
        this.transcode_manager = this.device_manager.getTranscodeManager();
        this.transcode_queue = this.transcode_manager.getQueue();
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null) {
            this.sidebarEntry = sidebar.getCurrentEntry();
            this.sidebarEntry.setIconBarEnabler(this);
            this.device = (Device)this.sidebarEntry.getDatasource();
        }
        if (this.device instanceof TranscodeTarget) {
            this.transTarget = (TranscodeTarget)((Object)this.device);
        }
        if (this.device == null) {
            new InfoBarUtil(skinObject, "devicesview.infobar", false, "DeviceView.infobar", "v3.deviceview.infobar"){

                public boolean allowShow() {
                    return true;
                }
            };
        } else if (this.device instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
            int species = renderer.getRendererSpecies();
            String speciesID = null;
            switch (species) {
                case 3: {
                    speciesID = "itunes";
                    break;
                }
                case 1: {
                    speciesID = "ps3";
                    break;
                }
                case 2: {
                    speciesID = "xbox";
                    break;
                }
                case 6: {
                    String classification = renderer.getClassification();
                    if (classification.equals("sony.PSP")) {
                        speciesID = "psp";
                        break;
                    }
                    if (!classification.startsWith("tivo.")) break;
                    speciesID = "tivo";
                }
            }
            if (speciesID != null) {
                final String fSpeciesID = speciesID;
                new InfoBarUtil(skinObject, "devicesview.infobar", false, "DeviceView.infobar." + speciesID, "v3.deviceview.infobar"){

                    public boolean allowShow() {
                        return true;
                    }

                    protected void created(SWTSkinObject parent) {
                        SWTSkinObjectText soLine1 = (SWTSkinObjectText)SBC_DevicesView.this.skin.getSkinObject("line1", parent);
                        soLine1.setTextID("v3.deviceview.infobar.line1.generic", new String[]{SBC_DevicesView.this.device.getName()});
                        SWTSkinObjectText soLine2 = (SWTSkinObjectText)SBC_DevicesView.this.skin.getSkinObject("line2", parent);
                        soLine2.setTextID("v3.deviceview.infobar.line2." + fSpeciesID);
                    }
                };
            }
        }
        SWTSkinObject soAdvInfo = this.getSkinObject("advinfo");
        if (soAdvInfo != null) {
            this.initAdvInfo(soAdvInfo);
        }
        if (this.device != null && (soTitle = this.getSkinObject("title")) instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setTextID("device.view.heading", new String[]{this.device.getName()});
        }
        return null;
    }

    private void initColumns(AzureusCore core) {
        if (columnsAdded) {
            return;
        }
        columnsAdded = true;
        UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
        TableManager tableManager = uiManager.getTableManager();
        tableManager.registerColumn(TranscodeFile.class, "trancode_qpos", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Rank(column);
                if (!column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setVisible(false);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, ColumnAzProduct.COLUMN_ID, new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnAzProduct(column);
                column.setWidth(42);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "Thumbnail", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnThumbnail(column);
                column.setWidth(70);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "transcode_name", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Name(column);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(200);
                } else if (!column.getTableID().endsWith(":type=1")) {
                    column.setWidth(140);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "duration", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Duration(column);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "device", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Device(column);
                column.setVisible(false);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "profile", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Profile(column);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(70);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "resolution", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Resolution(column);
                column.setVisible(false);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(95);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "transcode_status", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Status(column);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "trancode_completion", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Completion(column);
                column.setWidth(145);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "copied", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_CopiedToDevice(column);
                if (column.getTableID().endsWith(":type=1") || column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setVisible(false);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "category", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Category(column);
            }
        });
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soTranscodeQueue;
        SWTSkinObject soDeviceList;
        super.skinObjectShown(skinObject, params);
        this.transcode_queue.addListener(this);
        if (this.transTarget != null) {
            this.transTarget.addListener(this);
        }
        if ((soDeviceList = this.getSkinObject("device-list")) != null) {
            this.initDeviceListTable((Composite)soDeviceList.getControl());
        }
        if ((soTranscodeQueue = this.getSkinObject("transcode-queue")) != null) {
            this.initTranscodeQueueTable((Composite)soTranscodeQueue.getControl());
        }
        if (this.device instanceof TranscodeTarget) {
            this.createDragDrop(this.tvFiles != null ? this.tvFiles : this.tvDevices);
        }
        this.setAdditionalInfoTitle(false);
        return null;
    }

    private void initAdvInfo(SWTSkinObject soAdvInfo) {
        SWTSkinButtonUtility btnAdvInfo = new SWTSkinButtonUtility(soAdvInfo);
        btnAdvInfo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                SWTSkinObject soArea = SBC_DevicesView.this.getSkinObject("advinfo-area");
                if (soArea != null) {
                    boolean newVisibility = !soArea.isVisible();
                    SBC_DevicesView.this.setAdditionalInfoTitle(newVisibility);
                }
            }
        });
        this.setAdditionalInfoTitle(false);
    }

    protected void setAdditionalInfoTitle(boolean newVisibility) {
        SWTSkinObject soText;
        SWTSkinObject soArea = this.getSkinObject("advinfo-area");
        if (soArea != null) {
            soArea.setVisible(newVisibility);
        }
        if ((soText = this.getSkinObject("advinfo-title")) instanceof SWTSkinObjectText) {
            String s = newVisibility ? "[-]" : "[+]";
            s = this.device != null ? s + "Additional Device Info and Settings" : s + "General Options";
            ((SWTSkinObjectText)soText).setText(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.transcode_queue.removeListener(this);
        if (this.transTarget != null) {
            this.transTarget.removeListener(this);
        }
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.delete();
                this.tvFiles = null;
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.tableJobsParent, this.dropTarget, this.dragSource});
        if (this.tvDevices != null) {
            this.tvDevices.delete();
            this.tvDevices = null;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    private void initTranscodeQueueTable(Composite control) {
        String tableID;
        if (this.device == null) {
            tableID = TABLE_TRANSCODE_QUEUE;
        } else {
            DeviceMediaRenderer dmr;
            tableID = TABLE_DEVICE_LIBRARY;
            if (this.device instanceof DeviceMediaRenderer && !(dmr = (DeviceMediaRenderer)this.device).canCopyToDevice() && !dmr.canCopyToFolder()) {
                tableID = tableID + ":type=1";
            }
        }
        this.tvFiles = new TableViewSWTImpl(TranscodeFile.class, tableID, tableID, new TableColumnCore[]{}, this.device == null ? "trancode_qpos" : "transcode_status", 0x10010002);
        this.tvFiles.setRowDefaultHeight(50);
        this.tvFiles.setHeaderVisible(true);
        this.tvFiles.setParentDataSource(this.device);
        this.tableJobsParent = new Composite(control, 0);
        this.tableJobsParent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.tableJobsParent.setLayout((Layout)layout);
        this.tvFiles.addSelectionListener(new TableSelectionListener(){

            public void selected(TableRowCore[] row) {
                SelectedContentManager.clearCurrentlySelectedContent();
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void mouseExit(TableRowCore row) {
            }

            public void mouseEnter(TableRowCore row) {
            }

            public void focusChanged(TableRowCore focus) {
                SelectedContentManager.clearCurrentlySelectedContent();
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void deselected(TableRowCore[] rows) {
                SelectedContentManager.clearCurrentlySelectedContent();
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }, false);
        this.tvFiles.addLifeCycleListener(new TableLifeCycleListener(){

            public void tableViewInitialized() {
                if (SBC_DevicesView.this.transTarget == null) {
                    TranscodeJob[] jobs;
                    for (TranscodeJob job : jobs = SBC_DevicesView.this.transcode_queue.getJobs()) {
                        TranscodeFile file = job.getTranscodeFile();
                        if (file == null) continue;
                        SBC_DevicesView.this.tvFiles.addDataSource(file);
                    }
                } else {
                    SBC_DevicesView.this.tvFiles.addDataSources(SBC_DevicesView.this.transTarget.getFiles());
                }
            }

            public void tableViewDestroyed() {
            }
        });
        this.tvFiles.addMenuFillListener(new TableViewSWTMenuFillListener(){

            public void fillMenu(String sColumnName, Menu menu) {
                SBC_DevicesView.this.fillMenu(menu);
            }

            public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
            }
        });
        this.tvFiles.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    Object[] selected;
                    20 var3_2 = this;
                    synchronized (var3_2) {
                        selected = SBC_DevicesView.this.tvFiles == null ? new Object[]{} : SBC_DevicesView.this.tvFiles.getSelectedDataSources().toArray();
                    }
                    for (Object ds : selected) {
                        SBC_DevicesView.this.deleteFile((TranscodeFile)ds);
                    }
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tvFiles.initialize(this.tableJobsParent);
        control.layout(true);
    }

    protected void fillMenu(Menu menu) {
        DeviceMediaRenderer dmr;
        Object[] _files = this.tvFiles.getSelectedDataSources().toArray();
        final TranscodeFile[] files = new TranscodeFile[_files.length];
        System.arraycopy(_files, 0, files, 0, files.length);
        MenuItem open_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)open_item, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(open_item, "run");
        File target_file = null;
        File source_file = null;
        try {
            if (files.length == 1 && !(target_file = files[0].getTargetFile().getFile()).exists()) {
                target_file = null;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        try {
            if (files.length == 1 && !(source_file = files[0].getSourceFile().getFile()).exists()) {
                source_file = null;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        final File f_target_file = target_file;
        final File f_source_file = source_file;
        open_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                Utils.launch(f_target_file.getAbsolutePath());
            }
        });
        open_item.setEnabled(target_file != null);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem show_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)show_item, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        show_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerUtils.open(f_target_file != null ? f_target_file : f_source_file, use_open_containing_folder);
            }
        });
        show_item.setEnabled(source_file != null && !files[0].isComplete() || target_file != null && files[0].isComplete());
        Menu menu_category = new Menu((Decorations)menu.getShell(), 4);
        MenuItem item_category = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)item_category, "MyTorrentsView.menu.setCategory");
        item_category.setMenu(menu_category);
        this.addCategorySubMenu(menu_category, files);
        new MenuItem(menu, 2);
        MenuItem pause_item = new MenuItem(menu, 8);
        pause_item.setText(MessageText.getString("v3.MainWindow.button.pause"));
        pause_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < files.length; ++i) {
                    TranscodeJob job = files[i].getJob();
                    if (job == null) continue;
                    job.pause();
                }
            }
        });
        MenuItem resume_item = new MenuItem(menu, 8);
        resume_item.setText(MessageText.getString("v3.MainWindow.button.resume"));
        resume_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < files.length; ++i) {
                    TranscodeJob job = files[i].getJob();
                    if (job == null) continue;
                    job.resume();
                }
            }
        });
        new MenuItem(menu, 2);
        if (this.device instanceof DeviceMediaRenderer && ((dmr = (DeviceMediaRenderer)this.device).canCopyToDevice() || dmr.canCopyToFolder())) {
            MenuItem retry_item = new MenuItem(menu, 8);
            retry_item.setText(MessageText.getString("device.retry.copy"));
            retry_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (int i = 0; i < files.length; ++i) {
                        TranscodeFile file = files[i];
                        if (file.getCopyToDeviceFails() <= 0L && !file.isCopiedToDevice()) continue;
                        file.retryCopyToDevice();
                    }
                }
            });
            retry_item.setEnabled(false);
            for (TranscodeFile file : files) {
                if (file.getCopyToDeviceFails() <= 0L && !file.isCopiedToDevice()) continue;
                retry_item.setEnabled(true);
            }
            new MenuItem(menu, 2);
        }
        MenuItem sc_item = new MenuItem(menu, 8);
        sc_item.setText(MessageText.getString("devices.copy_url"));
        if (files.length == 1) {
            final URL url = files[0].getStreamURL();
            if (url != null) {
                sc_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ClipboardCopy.copyToClipBoard(url.toExternalForm());
                    }
                });
            } else {
                sc_item.setEnabled(false);
            }
        } else {
            sc_item.setEnabled(false);
        }
        MenuItem remove_item = new MenuItem(menu, 8);
        remove_item.setText(MessageText.getString("azbuddy.ui.menu.remove"));
        Utils.setMenuItemImage(remove_item, "delete");
        remove_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TranscodeFile file : files) {
                    SBC_DevicesView.this.deleteFile(file);
                }
            }
        });
        new MenuItem(menu, 2);
        boolean has_selection = files.length > 0;
        remove_item.setEnabled(has_selection);
        boolean can_pause = has_selection;
        boolean can_resume = has_selection;
        int job_count = 0;
        for (int i = 0; i < files.length; ++i) {
            TranscodeJob job = files[i].getJob();
            if (job == null) continue;
            ++job_count;
            int state = job.getState();
            if (state != 1 || !job.canPause()) {
                can_pause = false;
            }
            if (state == 2) continue;
            can_resume = false;
        }
        pause_item.setEnabled(can_pause && job_count > 0);
        resume_item.setEnabled(can_resume && job_count > 0);
    }

    private void addCategorySubMenu(Menu menu_category, final TranscodeFile[] files) {
        int i;
        MenuItem[] items = menu_category.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(menu_category, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        SBC_DevicesView.this.assignSelectedToCategory((Category)item.getData("Category"), files);
                    }
                });
                new MenuItem(menu_category, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(menu_category, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        SBC_DevicesView.this.assignSelectedToCategory((Category)item.getData("Category"), files);
                    }
                });
            }
            new MenuItem(menu_category, 2);
        }
        MenuItem itemAddCategory = new MenuItem(menu_category, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SBC_DevicesView.this.addCategory(files);
            }
        });
    }

    private void addCategory(TranscodeFile[] files) {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory, files);
        }
    }

    private void assignSelectedToCategory(Category category, TranscodeFile[] files) {
        String[] cats = category.getType() == 2 ? new String[]{} : new String[]{category.getName()};
        for (TranscodeFile file : files) {
            file.setCategories(cats);
        }
    }

    private void initDeviceListTable(Composite control) {
        this.tvDevices = new TableViewSWTImpl(TranscodeProvider.class, TABLE_DEVICES, TABLE_DEVICES, new TableColumnCore[0], "trancode_qpos");
        this.tvDevices.setRowDefaultHeight(50);
        this.tvDevices.setHeaderVisible(true);
        Composite parent = new Composite(control, 0);
        parent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tvDevices.initialize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobAdded(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            TranscodeFile file;
            if (this.tvFiles == null) {
                return;
            }
            if (this.transTarget == null && (file = job.getTranscodeFile()) != null) {
                this.tvFiles.addDataSource(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobChanged(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            TableRowCore row = this.tvFiles.getRow(job.getTranscodeFile());
            if (row != null) {
                UIFunctions uiFunctions;
                row.invalidate();
                if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobRemoved(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            if (this.transTarget == null) {
                TranscodeFile file = job.getTranscodeFile();
                if (file != null) {
                    this.tvFiles.removeDataSource(file);
                }
            } else {
                TableRowCore row = this.tvFiles.getRow(job.getTranscodeFile());
                if (row != null) {
                    UIFunctions uiFunctions;
                    row.invalidate();
                    if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                        uiFunctions.refreshIconBar();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled(String itemKey) {
        int size;
        Object[] selectedDS;
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return false;
            }
            selectedDS = this.tvFiles.getSelectedDataSources().toArray();
            size = this.tvFiles.size(false);
        }
        if (selectedDS.length == 0) {
            return false;
        }
        if (itemKey.equals("remove")) {
            return true;
        }
        boolean can_stop = true;
        boolean can_queue = true;
        boolean can_move_up = true;
        boolean can_move_down = true;
        boolean hasJob = false;
        for (Object ds : selectedDS) {
            int state;
            TranscodeJob job = ((TranscodeFile)ds).getJob();
            if (job == null) continue;
            hasJob = true;
            int index = job.getIndex();
            if (index == 1) {
                can_move_up = false;
            }
            if (index == size) {
                can_move_down = false;
            }
            if ((state = job.getState()) != 2 && state != 1 && state != 5 && state != 0) {
                can_stop = false;
            }
            if (state == 2 || state == 6 || state == 5) continue;
            can_queue = false;
        }
        if (!hasJob) {
            can_move_up = false;
            can_move_down = false;
            can_queue = false;
            can_stop = false;
        }
        if (itemKey.equals("stop")) {
            return can_stop;
        }
        if (itemKey.equals("start")) {
            return can_queue;
        }
        if (itemKey.equals("up")) {
            return can_move_up;
        }
        if (itemKey.equals("down")) {
            return can_move_down;
        }
        return false;
    }

    @Override
    public boolean isSelected(String itemKey) {
        return false;
    }

    @Override
    public void itemActivated(final String itemKey) {
        if (this.tvFiles == null) {
            return;
        }
        Object[] selectedDS = this.tvFiles.getSelectedDataSources().toArray();
        int size = this.tvFiles.size(false);
        if (selectedDS.length == 0) {
            return;
        }
        if (itemKey.equals("remove")) {
            for (Object ds : selectedDS) {
                this.deleteFile((TranscodeFile)ds);
            }
        }
        ArrayList<TranscodeJob> jobs = new ArrayList<TranscodeJob>(selectedDS.length);
        for (int i = 0; i < selectedDS.length; ++i) {
            TranscodeFile file = (TranscodeFile)selectedDS[i];
            TranscodeJob job = file.getJob();
            if (job == null) continue;
            jobs.add(job);
        }
        if (jobs.size() == 0) {
            return;
        }
        if (itemKey.equals("up") || itemKey.equals("down")) {
            Collections.sort(jobs, new Comparator<TranscodeJob>(){

                @Override
                public int compare(TranscodeJob j1, TranscodeJob j2) {
                    return (itemKey.equals("up") ? 1 : -1) * (j1.getIndex() - j2.getIndex());
                }
            });
        }
        boolean forceSort = false;
        for (TranscodeJob job : jobs) {
            TableColumnCore sortColumn;
            if (itemKey.equals("stop")) {
                job.stop();
                continue;
            }
            if (itemKey.equals("start")) {
                job.queue();
                continue;
            }
            if (itemKey.equals("up")) {
                job.moveUp();
                sortColumn = this.tvFiles.getSortColumn();
                forceSort = sortColumn != null && sortColumn.getName().equals("trancode_qpos");
                continue;
            }
            if (!itemKey.equals("down")) continue;
            job.moveDown();
            sortColumn = this.tvFiles.getSortColumn();
            forceSort = sortColumn != null && sortColumn.getName().equals("trancode_qpos");
        }
        this.tvFiles.refreshTable(forceSort);
    }

    @Override
    public String getUpdateUIName() {
        return "DevicesView";
    }

    @Override
    public void updateUI() {
        if (this.tvFiles != null) {
            this.tvFiles.refreshTable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(TranscodeFile file) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.addDataSource(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(TranscodeFile file, int type, Object data) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            TableRowCore row = this.tvFiles.getRow(file);
            if (row != null) {
                UIFunctions uiFunctions;
                row.invalidate();
                if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(TranscodeFile file) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.removeDataSource(file);
            }
        }
    }

    protected void deleteFile(TranscodeFile file) {
        if (this.tvFiles == null || this.tvFiles.isDisposed()) {
            return;
        }
        try {
            boolean do_delete = false;
            File cache_file = file.getCacheFileIfExists();
            if (cache_file != null && cache_file.exists() && file.isComplete()) {
                String path = cache_file.toString();
                String title = MessageText.getString("xcode.deletedata.title");
                String copy_text = "";
                Device device = file.getDevice();
                if (device instanceof DeviceMediaRenderer) {
                    DeviceMediaRenderer dmr = (DeviceMediaRenderer)device;
                    File copy_to = dmr.getCopyToFolder();
                    if (dmr.canCopyToDevice() || dmr.canCopyToFolder() && copy_to != null && copy_to.exists()) {
                        copy_text = MessageText.getString("xcode.deletedata.message.2", new String[]{device.getName()});
                    }
                }
                String text = MessageText.getString("xcode.deletedata.message", new String[]{file.getName(), file.getProfileName(), copy_text});
                MessageBoxShell mb = new MessageBoxShell(this.tvFiles.getComposite().getShell(), title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1, "xcode.deletedata.noconfirm.key", MessageText.getString("deletedata.noprompt"), false, 0);
                mb.setRememberOnlyIfButton(0);
                Object dm = null;
                if (dm != null) {
                    mb.setRelatedObject(dm);
                }
                mb.setLeftImage(8);
                int result = mb.open();
                if (result == 0) {
                    do_delete = true;
                }
            } else {
                do_delete = true;
            }
            if (do_delete) {
                TranscodeJob job = file.getJob();
                if (job != null) {
                    job.remove();
                }
                file.delete(cache_file != null);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void createDragDrop(final TableViewSWTImpl<?> table) {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.dispose();
            }
            this.dragSource = table.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = table.getSelectedRows();
                        if (rows.length != 0) {
                            event2.doit = true;
                            SBC_DevicesView.this.drag_drop_line_start = rows[0].getIndex();
                            SBC_DevicesView.access$1002(SBC_DevicesView.this, rows);
                        } else {
                            event2.doit = false;
                            SBC_DevicesView.this.drag_drop_line_start = -1;
                            SBC_DevicesView.access$1002(SBC_DevicesView.this, null);
                        }
                        List selectedFiles = table.getSelectedDataSources();
                        this.eventData = "TranscodeFile\n";
                        for (Object o : selectedFiles) {
                            TranscodeFile file = (TranscodeFile)o;
                            if (!file.isComplete()) continue;
                            try {
                                this.eventData = this.eventData + file.getTargetFile().getFile().getAbsolutePath() + "\n";
                            }
                            catch (Throwable e) {}
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
            this.dropTarget = table.createDropTarget(31);
            if (this.dropTarget != null) {
                if (SWT.getVersion() >= 3107) {
                    this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                }
                this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                        if (SBC_DevicesView.this.drag_drop_line_start < 0) {
                            if (event2.detail != 1) {
                                if ((event2.operations & 4) > 0) {
                                    event2.detail = 4;
                                } else if ((event2.operations & 1) > 0) {
                                    event2.detail = 1;
                                }
                            }
                        } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if (SBC_DevicesView.this.drag_drop_line_start >= 0) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void drop(DropTargetEvent event2) {
                        try {
                            if (event2.data instanceof String && ((String)event2.data).startsWith("TranscodeFile\n")) {
                                return;
                            }
                            event2.detail = 0;
                            DeviceManagerUI.handleDrop((TranscodeTarget)((Object)SBC_DevicesView.this.device), event2.data);
                        }
                        finally {
                            SBC_DevicesView.this.drag_drop_line_start = -1;
                            SBC_DevicesView.access$1002(SBC_DevicesView.this, null);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Debug.out("failed to init drag-n-drop", t);
        }
    }

    static /* synthetic */ TableRowCore[] access$1002(SBC_DevicesView x0, TableRowCore[] x1) {
        x0.drag_drop_rows = x1;
        return x1;
    }
}

