/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.devices.DevicesFTUX;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public abstract class TranscodeChooser {
    private static final String skinFile = "skin3_transcodechooser";
    private static final String shellSkinObjectID = "shell";
    private Shell shell;
    private SWTSkin skin;
    private Font fontDevice;
    protected TranscodeTarget selectedTranscodeTarget;
    protected TranscodeProfile selectedProfile;
    protected DeviceTemplate selectedDeviceTemplate;
    private SWTSkinObjectContainer soList;
    private Shell mainShell;
    private SWTSkinObjectContainer soBottomContainer;
    private Button btnNoPrompt;
    private int transcodeRequirement;
    private List<String> listImageIDsToRelease = new ArrayList<String>();
    private SWTSkinObjectText soInfoTitle;
    private SWTSkinObjectText soInfoText;
    private Font fontDeviceDesc;
    private TranscodeProfile[] transcodeProfiles;

    public TranscodeChooser() {
        this((TranscodeTarget)null);
    }

    public TranscodeChooser(TranscodeTarget tt) {
        this.selectedTranscodeTarget = tt;
    }

    public TranscodeChooser(TranscodeProfile[] transcodeProfiles) {
        this.transcodeProfiles = transcodeProfiles;
    }

    public void show() {
        if (!DevicesFTUX.ensureInstalled()) {
            return;
        }
        this.mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        this.shell = ShellFactory.createShell(this.mainShell, 2160);
        Utils.setShellIcon(this.shell);
        this.skin = SWTSkinFactory.getNonPersistentInstance(SkinnedDialog.class.getClassLoader(), "com/aelitis/azureus/ui/skin/", "skin3_transcodechooser.properties");
        this.skin.initialize(this.shell, shellSkinObjectID);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TranscodeChooser.this.shell.close();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TranscodeChooser.this.closed();
            }
        });
        this.skin.layout();
        SWTSkinObject soBottom = this.skin.getSkinObject("bottom");
        if (soBottom instanceof SWTSkinObjectContainer) {
            this.soBottomContainer = (SWTSkinObjectContainer)soBottom;
            this.soBottomContainer.addListener(new SWTSkinObjectListener(){

                public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                    if (eventType == 0) {
                        skinObject.removeListener(this);
                        TranscodeChooser.this.initBottom();
                    }
                    return null;
                }
            });
            this.soBottomContainer.setVisible(this.selectedTranscodeTarget != null);
        }
        this.soList = (SWTSkinObjectContainer)this.skin.getSkinObject("list");
        if (this.soList != null) {
            if (this.transcodeProfiles != null) {
                this.createProfileList(this.soList, "drop");
            } else if (this.selectedTranscodeTarget == null) {
                this.createDeviceList(this.soList);
            } else {
                this.transcodeProfiles = this.selectedTranscodeTarget.getTranscodeProfiles();
                this.createProfileList(this.soList, "drop");
            }
        }
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(new Object[]{TranscodeChooser.this.fontDevice, TranscodeChooser.this.fontDeviceDesc});
                for (String id : TranscodeChooser.this.listImageIDsToRelease) {
                    ImageLoader.getInstance().releaseImage(id);
                }
            }
        });
        this.shell.open();
    }

    protected void initBottom() {
        Composite composite = this.soBottomContainer.getComposite();
        this.btnNoPrompt = new Button(composite, 32);
        Messages.setLanguageText((Widget)this.btnNoPrompt, "option.rememberthis");
        Label lblXCode = new Label(composite, 0);
        lblXCode.setText(MessageText.getString("device.xcode"));
        final Combo cmbXCode = new Combo(composite, 12);
        cmbXCode.add(MessageText.getString("device.xcode.whenreq"));
        cmbXCode.add(MessageText.getString("device.xcode.always"));
        cmbXCode.add(MessageText.getString("device.xcode.never"));
        this.transcodeRequirement = this.selectedTranscodeTarget.getTranscodeRequirement();
        switch (this.transcodeRequirement) {
            case 3: {
                cmbXCode.select(1);
                break;
            }
            case 1: {
                cmbXCode.select(2);
                break;
            }
            default: {
                cmbXCode.select(0);
            }
        }
        cmbXCode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = cmbXCode.getSelectionIndex();
                switch (i) {
                    case 0: {
                        TranscodeChooser.this.transcodeRequirement = 2;
                        break;
                    }
                    case 1: {
                        TranscodeChooser.this.transcodeRequirement = 3;
                        break;
                    }
                    case 2: {
                        TranscodeChooser.this.transcodeRequirement = 1;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 10);
        fd.top = new FormAttachment((Control)cmbXCode, 0, 0x1000000);
        this.btnNoPrompt.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -10);
        fd.top = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment(100, -5);
        cmbXCode.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)cmbXCode, -5);
        fd.top = new FormAttachment((Control)cmbXCode, 0, 0x1000000);
        lblXCode.setLayoutData((Object)fd);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode == 0) {
            lblXCode.setVisible(false);
            cmbXCode.setVisible(false);
        }
        Point computeSize = this.shell.computeSize(300, -1, true);
        this.shell.setSize(computeSize);
    }

    private void createProfileList(SWTSkinObjectContainer soList, String source) {
        SWTSkinObjectContainer soButtonBottomArea;
        SWTSkinObjectText soSubTitle;
        if (this.selectedTranscodeTarget == null && this.selectedDeviceTemplate == null) {
            Utils.openMessageBox(Utils.findAnyShell(), 32, "No Device", "No Device Selected!?");
            this.shell.dispose();
            return;
        }
        if (this.selectedTranscodeTarget != null) {
            try {
                PlatformDevicesMessenger.qosTranscodeRequest(this.selectedTranscodeTarget, source);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                TranscodeProfile defaultProfile = this.selectedTranscodeTarget.getDefaultTranscodeProfile();
                if (defaultProfile != null) {
                    this.selectedProfile = defaultProfile;
                    this.shell.dispose();
                    return;
                }
            }
            catch (TranscodeException e) {
                // empty catch block
            }
        }
        if (this.transcodeProfiles.length == 0) {
            Utils.openMessageBox(Utils.findAnyShell(), 32, "No Profiles", "No Profiles for " + this.selectedTranscodeTarget.getDevice().getName());
            this.shell.dispose();
            return;
        }
        if (this.transcodeProfiles.length == 1) {
            this.selectedProfile = this.transcodeProfiles[0];
            this.shell.dispose();
            return;
        }
        Arrays.sort(this.transcodeProfiles, new Comparator<TranscodeProfile>(){

            @Override
            public int compare(TranscodeProfile o1, TranscodeProfile o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        Composite parent = soList.getComposite();
        if (parent.getChildren().length > 0) {
            Utils.disposeComposite(parent, false);
        }
        this.soInfoTitle = (SWTSkinObjectText)this.skin.getSkinObject("info-title");
        this.soInfoText = (SWTSkinObjectText)this.skin.getSkinObject("info-text");
        this.resetProfileInfoBox(false);
        RowLayout layout = new RowLayout(256);
        layout.spacing = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.wrap = true;
        layout.justify = true;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Listener listenerMouseInout = new Listener(){

            public void handleEvent(Event event2) {
                Widget widget = event2.widget instanceof Canvas ? ((Canvas)event2.widget).getParent() : event2.widget;
                Composite c = TranscodeChooser.this.soList.getComposite();
                Rectangle bounds = c.getClientArea();
                c.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                TranscodeProfile profile = (TranscodeProfile)widget.getData("obj");
                if (profile == null) {
                    return;
                }
                if (event2.type == 6) {
                    String description = profile.getDescription();
                    if (description == null || description.length() == 0) {
                        TranscodeChooser.this.resetProfileInfoBox(true);
                    } else {
                        if (TranscodeChooser.this.soInfoTitle != null) {
                            TranscodeChooser.this.soInfoTitle.setTextID("devices.choose.profile.info.title.selected", new String[]{profile.getName()});
                        }
                        if (TranscodeChooser.this.soInfoText != null) {
                            TranscodeChooser.this.soInfoText.setText(description);
                            Point computeSize = TranscodeChooser.this.shell.computeSize(((TranscodeChooser)TranscodeChooser.this).shell.getClientArea().width, -1, true);
                            if (computeSize.y > ((TranscodeChooser)TranscodeChooser.this).shell.getSize().y) {
                                TranscodeChooser.this.shell.setSize(computeSize);
                            }
                        }
                    }
                }
            }
        };
        parent.addListener(6, new Listener(){

            public void handleEvent(Event event2) {
                TranscodeChooser.this.resetProfileInfoBox(true);
            }
        });
        Listener clickListener = new Listener(){
            boolean down = false;

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    this.down = true;
                } else if (event2.type == 4 && this.down) {
                    Widget widget = event2.widget instanceof Label ? ((Label)event2.widget).getParent() : event2.widget;
                    TranscodeChooser.this.selectedProfile = (TranscodeProfile)widget.getData("obj");
                    if (TranscodeChooser.this.selectedProfile == null) {
                        Debug.out("profile is null!");
                    } else if (TranscodeChooser.this.btnNoPrompt != null && TranscodeChooser.this.btnNoPrompt.getSelection()) {
                        TranscodeChooser.this.selectedTranscodeTarget.setDefaultTranscodeProfile(TranscodeChooser.this.selectedProfile);
                    }
                    TranscodeChooser.this.shell.dispose();
                    this.down = false;
                }
            }
        };
        for (TranscodeProfile profile : this.transcodeProfiles) {
            TranscodeChooser.addImageBox(parent, clickListener, listenerMouseInout, profile, profile.getIconURL(), profile.getName());
        }
        SWTSkinObjectText soTitle = (SWTSkinObjectText)this.skin.getSkinObject("title");
        if (soTitle != null) {
            soTitle.setTextID("devices.choose.profile.title");
        }
        if ((soSubTitle = (SWTSkinObjectText)this.skin.getSkinObject("subtitle")) != null) {
            soSubTitle.setTextID("label.clickone");
        }
        if (this.soBottomContainer != null) {
            this.soBottomContainer.setVisible(true);
        }
        if ((soButtonBottomArea = (SWTSkinObjectContainer)this.skin.getSkinObject("button-bottom")) != null) {
            soButtonBottomArea.setVisible(false);
        }
        Point computeSize = this.shell.computeSize(600, -1, true);
        this.shell.setSize(computeSize);
        Utils.centerWindowRelativeTo(this.shell, (Control)this.mainShell);
    }

    public static void addImageBox(Composite parent, Listener clickListener, Listener listenerMouseInout, Object obj, String iconURL, String name) {
        ImageLoader imageLoader;
        Image image;
        final Shell shell = parent.getShell();
        final Composite c = new Composite(parent, 0);
        GridLayout clayout = new GridLayout();
        clayout.horizontalSpacing = 0;
        clayout.marginWidth = 0;
        c.setLayout((Layout)clayout);
        c.setCursor(c.getDisplay().getSystemCursor(21));
        c.addListener(4, clickListener);
        c.addListener(3, clickListener);
        c.setData("obj", obj);
        if (listenerMouseInout != null) {
            c.addListener(6, listenerMouseInout);
            c.addListener(7, listenerMouseInout);
        }
        final Canvas lblImage = new Canvas(c, 0x20000000);
        if (listenerMouseInout != null) {
            lblImage.addListener(6, listenerMouseInout);
            lblImage.addListener(7, listenerMouseInout);
        }
        lblImage.addListener(4, clickListener);
        lblImage.addListener(3, clickListener);
        lblImage.setData("obj", obj);
        lblImage.addListener(9, new Listener(){

            public void handleEvent(Event event2) {
                Image image = (Image)lblImage.getData("Image");
                if (image != null) {
                    Rectangle bounds = image.getBounds();
                    Rectangle area = lblImage.getBounds();
                    Rectangle carea = c.getBounds();
                    Point ptInDisplay = c.toDisplay(0, 0);
                    event2.gc.setAdvanced(true);
                    event2.gc.setAntialias(1);
                    event2.gc.setLineWidth(2);
                    if (new Rectangle(ptInDisplay.x, ptInDisplay.y, carea.width, carea.height).contains(event2.display.getCursorLocation())) {
                        Color color1 = ColorCache.getColor(event2.gc.getDevice(), 252, 253, 255);
                        Color color2 = ColorCache.getColor(event2.gc.getDevice(), 169, 195, 252);
                        Pattern pattern = new Pattern(event2.gc.getDevice(), 0.0f, 0.0f, 0.0f, (float)area.height, color1, 0, color2, 200);
                        event2.gc.setBackgroundPattern(pattern);
                        event2.gc.fillRoundRectangle(0, 0, area.width - 1, area.height - 1, 20, 20);
                        event2.gc.setBackgroundPattern(null);
                        pattern.dispose();
                        pattern = new Pattern(event2.gc.getDevice(), 0.0f, 0.0f, 0.0f, (float)area.height, color2, 50, color2, 255);
                        event2.gc.setForegroundPattern(pattern);
                        event2.gc.drawRoundRectangle(0, 0, area.width - 1, area.height - 1, 20, 20);
                        event2.gc.setForegroundPattern(null);
                        pattern.dispose();
                    }
                    event2.gc.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, 8, 5, bounds.width, bounds.height);
                } else {
                    Rectangle ca = lblImage.getClientArea();
                    event2.gc.drawRectangle(ca.x, ca.y, ca.width - 1, ca.height - 1);
                }
            }
        });
        GridData gridData = new GridData(1040);
        gridData.heightHint = 100;
        gridData.widthHint = 120;
        if (iconURL != null && (image = (imageLoader = ImageLoader.getInstance()).getUrlImage(iconURL, new ImageLoader.ImageDownloaderListener(){

            public void imageDownloaded(Image image, boolean returnedImmediately) {
                if (!returnedImmediately) {
                    lblImage.setData("Image", (Object)image);
                    Rectangle bounds = image.getBounds();
                    GridData gridData = (GridData)lblImage.getLayoutData();
                    gridData.heightHint = bounds.height + 10;
                    gridData.widthHint = bounds.width + 16;
                    lblImage.setLayoutData((Object)gridData);
                    lblImage.getShell().layout(new Control[]{lblImage});
                    Point computeSize = shell.computeSize(600, -1, true);
                    shell.setSize(computeSize);
                }
            }
        })) != null) {
            lblImage.setData("Image", (Object)image);
            Rectangle bounds = image.getBounds();
            gridData.heightHint = bounds.height + 10;
            gridData.widthHint = bounds.width + 16;
        }
        lblImage.setLayoutData((Object)gridData);
        Label label = new Label(c, 0x1000040);
        if (listenerMouseInout != null) {
            label.addListener(6, listenerMouseInout);
        }
        label.addListener(4, clickListener);
        label.addListener(3, clickListener);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        String s = name;
        label.setText(s);
        label.setCursor(c.getDisplay().getSystemCursor(21));
    }

    protected void resetProfileInfoBox(boolean layout) {
        if (this.soInfoTitle != null) {
            this.soInfoTitle.setTextID("devices.choose.profile.info.title");
        }
        if (this.soInfoText != null) {
            this.soInfoText.setTextID("devices.choose.profile.info.text");
            if (layout) {
                Point computeSize = this.shell.computeSize(this.shell.getClientArea().width, -1, true);
                this.shell.setSize(computeSize);
            }
        }
    }

    private void createDeviceList(SWTSkinObjectContainer soDeviceList) {
        SWTSkinObjectContainer soButtonBottomArea;
        SWTSkinObjectText soSubTitle;
        Composite parent = soDeviceList.getComposite();
        parent.setBackgroundMode(2);
        FormLayout layout = new FormLayout();
        layout.marginLeft = 10;
        layout.marginHeight = 15;
        parent.setLayout((Layout)layout);
        DeviceManager device_manager = DeviceManagerFactory.getSingleton();
        Device[] devices = device_manager.getDevices();
        if (devices.length == 0) {
            this.noDevices();
            return;
        }
        Arrays.sort(devices, new Comparator<Device>(){

            @Override
            public int compare(Device o1, Device o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.fontDevice = Utils.getFontWithHeight(parent.getFont(), null, 16, 1);
        this.fontDeviceDesc = Utils.getFontWithHeight(parent.getFont(), null, 16, 0);
        boolean hide_generic = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true);
        int numDevices = 0;
        Button lastButton = null;
        for (Device device : devices) {
            TranscodeTarget transcodeTarget;
            if (device.getType() != 3 || device.isHidden() || !(device instanceof DeviceMediaRenderer)) continue;
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)device;
            if (hide_generic && renderer.isGeneric() || (transcodeTarget = (TranscodeTarget)((Object)device)).getTranscodeProfiles().length == 0) continue;
            String imageID = null;
            if (device instanceof DeviceMediaRenderer) {
                imageID = "image.sidebar.device." + ((DeviceMediaRenderer)device).getRendererSpecies() + ".big";
            }
            lastButton = this.createDeviceButton(parent, device, device.getName(), device.getShortDescription(), imageID, lastButton);
            ++numDevices;
        }
        if (numDevices == 0) {
            this.noDevices();
            return;
        }
        SWTSkinObjectText soTitle = (SWTSkinObjectText)this.skin.getSkinObject("title");
        if (soTitle != null) {
            soTitle.setTextID("devices.choose.device.title");
        }
        if ((soSubTitle = (SWTSkinObjectText)this.skin.getSkinObject("subtitle")) != null) {
            soSubTitle.setText("");
        }
        if ((soButtonBottomArea = (SWTSkinObjectContainer)this.skin.getSkinObject("button-bottom")) != null) {
            SWTSkinObjectButton soCancel;
            soButtonBottomArea.setVisible(true);
            SWTSkinObjectButton soOk = (SWTSkinObjectButton)this.skin.getSkinObject("ok");
            if (soOk != null) {
                this.shell.setDefaultButton((Button)soOk.getControl());
                soOk.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        TranscodeChooser.access$902(TranscodeChooser.this, TranscodeChooser.this.selectedTranscodeTarget.getTranscodeProfiles());
                        TranscodeChooser.this.createProfileList(TranscodeChooser.this.soList, "chooser");
                    }
                });
            }
            if ((soCancel = (SWTSkinObjectButton)this.skin.getSkinObject("cancel")) != null) {
                soCancel.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        TranscodeChooser.this.shell.close();
                    }
                });
            }
        }
        if (this.soBottomContainer != null) {
            this.soBottomContainer.setVisible(false);
        }
        Point computeSize = this.shell.computeSize(400, -1, true);
        this.shell.setSize(computeSize);
        this.shell.layout(true);
        Utils.centerWindowRelativeTo(this.shell, (Control)this.mainShell);
    }

    private Button createDeviceButton(Composite parent, Object deviceObj, String name, String shortDescription, String imageID, Button lastButton) {
        Button button = new Button(parent, 16400);
        StringBuffer sb = new StringBuffer(name);
        button.setFont(this.fontDevice);
        button.setData("Device", deviceObj);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object device = e.widget.getData("Device");
                if (device instanceof TranscodeTarget) {
                    TranscodeChooser.this.selectedTranscodeTarget = (TranscodeTarget)device;
                } else if (device instanceof DeviceTemplate) {
                    TranscodeChooser.this.selectedDeviceTemplate = (DeviceTemplate)device;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (lastButton == null) {
            button.setSelection(true);
            if (deviceObj instanceof TranscodeTarget) {
                this.selectedTranscodeTarget = (TranscodeTarget)deviceObj;
            }
        }
        Image imgRenderer = null;
        if (imageID != null) {
            this.listImageIDsToRelease.add(imageID);
            imgRenderer = ImageLoader.getInstance().getImage(imageID);
        }
        if (ImageLoader.isRealImage(imgRenderer)) {
            button.setImage(imgRenderer);
        } else {
            sb.insert(0, ' ');
        }
        button.setText(sb.toString());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = lastButton == null ? new FormAttachment(0, 0) : new FormAttachment((Control)lastButton, 15);
        button.setLayoutData((Object)fd);
        if (shortDescription != null && shortDescription.length() > 0) {
            Label label = new Label(parent, 0);
            label.setText("(" + shortDescription + ")");
            fd = new FormData();
            fd.top = new FormAttachment((Control)button, 0, 0x1000000);
            fd.left = new FormAttachment((Control)button, 5);
            label.setLayoutData((Object)fd);
        }
        return button;
    }

    private void noDevices() {
        Utils.openMessageBox(this.mainShell, 32, "No Devices Found", "We couldn't find any devices.  Maybe you didn't install the Vuze Transcoder Plugin?");
        this.shell.dispose();
    }

    public abstract void closed();

    public int getTranscodeRequirement() {
        return this.transcodeRequirement;
    }

    static /* synthetic */ TranscodeProfile[] access$902(TranscodeChooser x0, TranscodeProfile[] x1) {
        x0.transcodeProfiles = x1;
        return x1;
    }
}

