/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.add;

import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.devices.TranscodeChooser;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class DeviceTemplateChooser {
    private DeviceTemplateClosedListener listener;
    private SkinnedDialog skinnedDialog;
    private DeviceTemplate selectedDeviceTemplate;
    private DeviceManager.DeviceManufacturer mf;
    private SWTSkinObjectContainer soList;

    public DeviceTemplateChooser(DeviceManager.DeviceManufacturer mf) {
        this.mf = mf;
    }

    public void open(DeviceTemplateClosedListener l) {
        this.listener = l;
        this.skinnedDialog = new SkinnedDialog("skin3_dlg_deviceadd_mfchooser", "shell", 2080);
        this.skinnedDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            public void skinDialogClosed(SkinnedDialog dialog) {
                if (DeviceTemplateChooser.this.listener != null) {
                    DeviceTemplateChooser.this.listener.deviceTemplateChooserClosed(DeviceTemplateChooser.this.selectedDeviceTemplate);
                }
            }
        });
        SWTSkin skin = this.skinnedDialog.getSkin();
        SWTSkinObject so = skin.getSkinObject("list");
        if (so instanceof SWTSkinObjectContainer) {
            this.soList = (SWTSkinObjectContainer)so;
            this.createDeviceTemplateList2(this.soList);
        }
        this.skinnedDialog.open();
    }

    private void createDeviceTemplateList2(SWTSkinObjectContainer soList) {
        SWTSkinObjectText soSubTitle;
        DeviceTemplate[] devices = this.mf.getDeviceTemplates();
        if (devices.length == 0) {
            this.noDevices();
            return;
        }
        Arrays.sort(devices, new Comparator<DeviceTemplate>(){

            @Override
            public int compare(DeviceTemplate o1, DeviceTemplate o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        Composite parent = soList.getComposite();
        if (parent.getChildren().length > 0) {
            Utils.disposeComposite(parent, false);
        }
        SWTSkin skin = this.skinnedDialog.getSkin();
        SWTSkinObjectText soInfoTitle = (SWTSkinObjectText)skin.getSkinObject("info-title");
        SWTSkinObjectText soInfoText = (SWTSkinObjectText)skin.getSkinObject("info-text");
        RowLayout layout = new RowLayout(256);
        layout.spacing = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.wrap = true;
        layout.justify = true;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Listener clickListener = new Listener(){
            boolean down = false;

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    this.down = true;
                } else if (event2.type == 4 && this.down) {
                    Widget widget = event2.widget instanceof Label ? ((Label)event2.widget).getParent() : event2.widget;
                    DeviceTemplateChooser.this.selectedDeviceTemplate = (DeviceTemplate)widget.getData("obj");
                    if (DeviceTemplateChooser.this.selectedDeviceTemplate == null) {
                        Debug.out("selectedDeviceTemplate is null!");
                    }
                    DeviceTemplateChooser.this.skinnedDialog.close();
                    this.down = false;
                }
            }
        };
        for (DeviceTemplate deviceTemplate : devices) {
            if (deviceTemplate.isAuto()) continue;
            String iconURL = null;
            TranscodeChooser.addImageBox(parent, clickListener, null, deviceTemplate, iconURL, deviceTemplate.getName());
        }
        SWTSkinObjectText soTitle = (SWTSkinObjectText)skin.getSkinObject("title");
        if (soTitle != null) {
            soTitle.setTextID("devices.choose.device.title");
        }
        if ((soSubTitle = (SWTSkinObjectText)skin.getSkinObject("subtitle")) != null) {
            soSubTitle.setTextID("label.clickone");
        }
        Point computeSize = this.skinnedDialog.getShell().computeSize(600, -1, true);
        this.skinnedDialog.getShell().setSize(computeSize);
        Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        Utils.centerWindowRelativeTo(this.skinnedDialog.getShell(), (Control)mainShell);
    }

    private void noDevices() {
        Utils.openMessageBox(null, 32, "No Devices Found", "We couldn't find any devices.  Maybe you didn't install the Vuze Transcoder Plugin?");
        this.skinnedDialog.close();
    }

    public static interface DeviceTemplateClosedListener {
        public void deviceTemplateChooserClosed(DeviceTemplate var1);
    }
}

