/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;

public class ColumnTJ_Rank
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "trancode_qpos";

    public ColumnTJ_Rank(TableColumn column) {
        column.initialize(2, -2, 25);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
    }

    public void refresh(TableCell cell) {
        long value;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        TranscodeJob job = tf.getJob();
        if (job == null) {
            try {
                value = Integer.MAX_VALUE + tf.getCreationDateMillis() + 1L;
            }
            catch (Throwable t) {
                value = 0x80000000L;
            }
        } else {
            value = job.getIndex();
        }
        if (cell.setSortValue(value) || !cell.isValid()) {
            if (value > Integer.MAX_VALUE) {
                cell.setText("");
            } else {
                cell.setText("" + value);
            }
        }
    }
}

