/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.extlistener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;

public class StimulusRPC {
    public static void hookListeners(final AzureusCore core, final MainWindow mainWindow) {
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean receive(String name, Map values) {
                try {
                    BrowserMessage browserMsg;
                    ClientMessageContext context2;
                    block27: {
                        Map decodedMap;
                        String lId;
                        block32: {
                            String opId;
                            block31: {
                                block30: {
                                    block28: {
                                        String url;
                                        block29: {
                                            if (values == null) {
                                                return false;
                                            }
                                            if (!name.equals("AZMSG")) {
                                                return false;
                                            }
                                            Object valueObj = values.get("value");
                                            if (!(valueObj instanceof String)) {
                                                return false;
                                            }
                                            String value = (String)valueObj;
                                            context2 = PlatformMessenger.getClientMessageContext();
                                            if (context2 == null) {
                                                return false;
                                            }
                                            browserMsg = new BrowserMessage(value);
                                            context2.debug("Received External message: " + browserMsg);
                                            opId = browserMsg.getOperationId();
                                            lId = browserMsg.getListenerId();
                                            if (!opId.equals("open-url")) break block28;
                                            decodedMap = browserMsg.getDecodedMap();
                                            url = MapUtils.getMapString(decodedMap, "url", null);
                                            if (decodedMap.containsKey("target")) break block29;
                                            context2.debug("no target for url: " + url);
                                            break block27;
                                        }
                                        if (UrlFilter.getInstance().urlIsBlocked(url)) {
                                            context2.debug("url blocked: " + url);
                                            break block27;
                                        } else if (!UrlFilter.getInstance().urlCanRPC(url)) {
                                            context2.debug("url not in whitelistL " + url);
                                            break block27;
                                        } else {
                                            BrowserMessageDispatcher dispatcher;
                                            UIFunctions functions = UIFunctionsManager.getUIFunctions();
                                            if (functions != null) {
                                                functions.bringToFront();
                                            }
                                            if ((dispatcher = context2.getDispatcher()) != null) {
                                                dispatcher.dispatch(browserMsg);
                                                dispatcher.resetSequence();
                                                return true;
                                            }
                                            context2.debug("No dispatcher for StimulusRPC" + opId);
                                            return true;
                                        }
                                    }
                                    if (!opId.equals("load-torrent")) break block30;
                                    decodedMap = browserMsg.getDecodedMap();
                                    if (decodedMap.containsKey("b64")) {
                                        String b64 = MapUtils.getMapString(decodedMap, "b64", null);
                                        return TorrentListener.loadTorrentByB64(core, b64);
                                    }
                                    if (decodedMap.containsKey("url")) {
                                        String url = MapUtils.getMapString(decodedMap, "url", null);
                                        boolean blocked = UrlFilter.getInstance().urlIsBlocked(url);
                                        if (blocked) {
                                            Debug.out("stopped loading torrent URL because it's not in whitelist");
                                            return false;
                                        }
                                        boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
                                        boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
                                        boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
                                        long contentNetworkID = MapUtils.getMapLong(decodedMap, "content-network", ConstantsVuze.getDefaultContentNetwork().getID());
                                        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(contentNetworkID);
                                        if (cn == null) {
                                            cn = ConstantsVuze.getDefaultContentNetwork();
                                        }
                                        DownloadUrlInfoContentNetwork dlInfo = new DownloadUrlInfoContentNetwork(url, cn);
                                        dlInfo.setReferer(MapUtils.getMapString(decodedMap, "referer", null));
                                        TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, playPrepare, bringToFront, false);
                                        return true;
                                    }
                                    break block27;
                                }
                                if (opId.equals("is-ready")) {
                                    return mainWindow.isReady();
                                }
                                if (opId.equals("is-version-ge")) {
                                    Map decodedMap2 = browserMsg.getDecodedMap();
                                    if (!decodedMap2.containsKey("version")) return false;
                                    String id = MapUtils.getMapString(decodedMap2, "id", "client");
                                    String version = MapUtils.getMapString(decodedMap2, "version", "");
                                    if (!id.equals("client")) return false;
                                    if (Constants.compareVersions("4.2.0.8", version) < 0) return false;
                                    return true;
                                }
                                if (opId.equals("is-active-tab")) {
                                    Map decodedMap3 = browserMsg.getDecodedMap();
                                    if (!decodedMap3.containsKey("tab")) return false;
                                    String tabID = MapUtils.getMapString(decodedMap3, "tab", "");
                                    if (tabID.length() <= 0) return false;
                                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                                    SideBarEntrySWT entry = sidebar.getCurrentEntry();
                                    if (entry == null) return false;
                                    return entry.id.equals(tabID);
                                }
                                if (!"config".equals(lId)) break block31;
                                if ("is-new-install".equals(opId)) {
                                    return COConfigurationManager.isNewInstall();
                                }
                                if ("check-for-updates".equals(opId)) {
                                    ConfigListener.checkForUpdates();
                                    return true;
                                }
                                if ("log-diags".equals(opId)) {
                                    ConfigListener.logDiagnostics();
                                    return true;
                                }
                                break block27;
                            }
                            if (!"display".equals(lId)) break block32;
                            if ("refresh-browser".equals(opId)) {
                                decodedMap = browserMsg.getDecodedMap();
                                DisplayListener.refreshTab(MapUtils.getMapString(decodedMap, "browser-id", ""));
                                break block27;
                            } else if ("switch-to-tab".equals(opId)) {
                                decodedMap = browserMsg.getDecodedMap();
                                DisplayListener.switchToTab(MapUtils.getMapString(decodedMap, "target", ""), MapUtils.getMapString(decodedMap, "source-ref", null));
                            }
                            break block27;
                        }
                        if ("show-donation-window".equals(lId)) {
                            decodedMap = browserMsg.getDecodedMap();
                            DonationWindow.open(true, MapUtils.getMapString(decodedMap, "source-ref", "SRPC"));
                        }
                    }
                    if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                        BrowserMessageDispatcher dispatcher = context2.getDispatcher();
                        if (dispatcher == null) return false;
                        dispatcher.dispatch(browserMsg);
                        return false;
                    }
                    System.err.println("Unhandled external stimulus: " + browserMsg);
                    return false;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                return false;
            }

            public int query(String name, Map values) {
                return Integer.MIN_VALUE;
            }
        });
    }
}

