/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.imageloader;

import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.skin.SkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoaderRefInfo;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageLoader
implements AEDiagnosticsEvidenceGenerator {
    private static ImageLoader instance;
    private static final boolean DEBUG_UNLOAD = false;
    private static final boolean DEBUG_REFCOUNT = false;
    private static final int GC_INTERVAL = 60000;
    private final String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled", "-selected", "-gray"};
    private Display display;
    public static Image noImage;
    private final ConcurrentHashMap<String, ImageLoaderRefInfo> mapImages = new ConcurrentHashMap();
    private final ArrayList<String> notFound = new ArrayList();
    private CopyOnWriteArrayList<SkinProperties> skinProperties;
    private int disabledOpacity;

    public static ImageLoader getInstance() {
        if (instance == null) {
            instance = new ImageLoader(Display.getDefault(), null);
            SkinPropertiesImpl skinProperties = new SkinPropertiesImpl(ImageRepository.class.getClassLoader(), "org/gudy/azureus2/ui/icons/", "icons.properties");
            instance.addSkinProperties(skinProperties);
        }
        return instance;
    }

    public ImageLoader(Display display, SkinProperties skinProperties) {
        this.display = display;
        this.skinProperties = new CopyOnWriteArrayList();
        this.addSkinProperties(skinProperties);
        AEDiagnostics.addEvidenceGenerator(this);
        SimpleTimer.addPeriodicEvent("GC_ImageLoader", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                ImageLoader.this.collectGarbage();
            }
        });
    }

    private Image[] findResources(String sKey) {
        int i;
        if (Collections.binarySearch(this.notFound, sKey) >= 0) {
            return null;
        }
        for (i = 0; i < this.sSuffixChecks.length; ++i) {
            String sSuffix = this.sSuffixChecks[i];
            if (!sKey.endsWith(sSuffix)) continue;
            String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
            String[] sParentFiles = null;
            ClassLoader cl = null;
            for (SkinProperties sp : this.skinProperties) {
                sParentFiles = sp.getStringArray(sParentName);
                if (sParentFiles == null) continue;
                cl = sp.getClassLoader();
                break;
            }
            if (sParentFiles != null) {
                Image image;
                int j;
                boolean bFoundOne = false;
                Image[] images = this.parseValuesString(cl, sKey, sParentFiles, sSuffix);
                if (images == null) continue;
                for (j = 0; j < images.length; ++j) {
                    image = images[j];
                    if (!ImageLoader.isRealImage(image)) continue;
                    bFoundOne = true;
                }
                if (!bFoundOne) {
                    for (j = 0; j < images.length; ++j) {
                        image = images[j];
                        if (!ImageLoader.isRealImage(image)) continue;
                        image.dispose();
                    }
                    continue;
                }
                return images;
            }
            Image[] images = this.findResources(sParentName);
            if (images == null) continue;
            return images;
        }
        i = Collections.binarySearch(this.notFound, sKey) * -1 - 1;
        if (i >= 0) {
            this.notFound.add(i, sKey);
        }
        return null;
    }

    private Image[] parseValuesString(ClassLoader cl, String sKey, String[] values, String suffix) {
        Image[] images;
        block8: {
            String sTryFile;
            int locationStart;
            int splitX;
            block7: {
                images = null;
                splitX = 0;
                locationStart = 0;
                if (values[0].equals("multi") && values.length > 2) {
                    splitX = Integer.parseInt(values[1]);
                    locationStart = 2;
                }
                if (locationStart != 0 && splitX > 0) break block7;
                images = new Image[values.length];
                for (int i = 0; i < values.length; ++i) {
                    int index = values[i].lastIndexOf(46);
                    if (index > 0) {
                        String sTryFile2 = values[i].substring(0, index) + suffix + values[i].substring(index);
                        images[i] = this.loadImage(this.display, cl, sTryFile2, sKey);
                        if (images[i] == null) {
                            sTryFile2 = values[i].substring(0, index) + suffix.replace('-', '_') + values[i].substring(index);
                            images[i] = this.loadImage(this.display, cl, sTryFile2, sKey);
                        }
                    }
                    if (images[i] != null) continue;
                    images[i] = ImageLoader.getNoImage();
                }
                break block8;
            }
            Image image = null;
            String origFile = values[locationStart];
            int index = origFile.lastIndexOf(46);
            if (index > 0 && (image = this.loadImage(this.display, cl, sTryFile = origFile.substring(0, index) + suffix + origFile.substring(index), sKey)) == null) {
                sTryFile = origFile.substring(0, index) + suffix.replace('-', '_') + origFile.substring(index);
                image = this.loadImage(this.display, cl, sTryFile, sKey);
            }
            if (image == null) {
                image = this.loadImage(this.display, cl, values[locationStart], sKey);
            }
            if (image == null) break block8;
            Rectangle bounds = image.getBounds();
            images = new Image[(bounds.width + splitX - 1) / splitX];
            for (int i = 0; i < images.length; ++i) {
                Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                images[i] = Utils.blitImage((Device)this.display, image, new Rectangle(i * splitX, 0, splitX, bounds.height), imgBG, new Point(0, 0));
                imgBG.dispose();
            }
        }
        return images;
    }

    private Image loadImage(Display display, ClassLoader cl, String res, String sKey) {
        Image img;
        block17: {
            img = null;
            if (res == null) {
                for (int i = 0; i < this.sSuffixChecks.length; ++i) {
                    String sTryFile;
                    int index;
                    String sSuffix = this.sSuffixChecks[i];
                    if (!sKey.endsWith(sSuffix)) continue;
                    String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
                    String sParentFile = null;
                    for (SkinProperties sp : this.skinProperties) {
                        sParentFile = sp.getStringValue(sParentName);
                        if (sParentFile == null) continue;
                        if (cl != null) break;
                        cl = sp.getClassLoader();
                        break;
                    }
                    if (sParentFile != null && (index = sParentFile.lastIndexOf(46)) > 0 && ((img = this.loadImage(display, cl, sTryFile = sParentFile.substring(0, index) + sSuffix + sParentFile.substring(index), sKey)) != null || (img = this.loadImage(display, cl, sTryFile = sParentFile.substring(0, index) + sSuffix.replace('-', '_') + sParentFile.substring(index), sKey)) != null)) break;
                }
            }
            if (img == null) {
                try {
                    InputStream is;
                    if (cl != null && (is = cl.getResourceAsStream(res)) != null) {
                        img = new Image((Device)display, is);
                    }
                    if (img != null) break block17;
                    if (sKey.endsWith("-disabled") || sKey.endsWith("_disabled")) {
                        String id = sKey.substring(0, sKey.length() - 9);
                        Image imgToFade = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToFade)) {
                            ImageData imageData = imgToFade.getImageData();
                            img = new Image((Device)display, imageData);
                            if (imageData.alphaData != null) {
                                if (this.disabledOpacity == -1) {
                                    for (int i = 0; i < imageData.alphaData.length; ++i) {
                                        imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) >> 3);
                                    }
                                } else {
                                    for (int i = 0; i < imageData.alphaData.length; ++i) {
                                        imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) * this.disabledOpacity / 100);
                                    }
                                }
                                img = new Image((Device)display, imageData);
                            } else {
                                Rectangle bounds = imgToFade.getBounds();
                                Image bg = Utils.createAlphaImage((Device)display, bounds.width, bounds.height, (byte)0);
                                img = Utils.renderTransparency(display, bg, imgToFade, new Point(0, 0), this.disabledOpacity == -1 ? 64 : this.disabledOpacity * 255 / 100);
                                bg.dispose();
                            }
                        }
                        this.releaseImage(id);
                        break block17;
                    }
                    if (sKey.endsWith("-gray")) {
                        String id = sKey.substring(0, sKey.length() - 5);
                        Image imgToGray = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToGray)) {
                            img = new Image((Device)display, imgToGray, 2);
                        }
                        this.releaseImage(id);
                    }
                }
                catch (Throwable e) {
                    System.err.println("ImageRepository:loadImage:: Resource not found: " + res + "\n" + e);
                }
            }
        }
        return img;
    }

    public void unLoadImages() {
        for (ImageLoaderRefInfo imageInfo : this.mapImages.values()) {
            Image[] images = imageInfo.getImages();
            if (images == null) continue;
            for (int i = 0; i < images.length; ++i) {
                Image image = images[i];
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image[] getImages(String sKey) {
        Image[] images;
        if (!Utils.isThisThreadSWT()) {
            Debug.out("getImages called on non-SWT thread");
            return new Image[0];
        }
        if (sKey == null) {
            return new Image[0];
        }
        ImageLoaderRefInfo imageInfo = this.mapImages.get(sKey);
        if (imageInfo != null && imageInfo.getImages() != null) {
            imageInfo.addref();
            return imageInfo.getImages();
        }
        String[] locations = null;
        ClassLoader cl = null;
        for (SkinProperties sp : this.skinProperties) {
            locations = sp.getStringArray(sKey);
            if (locations == null || locations.length <= 0) continue;
            cl = sp.getClassLoader();
            break;
        }
        if (locations == null || locations.length == 0) {
            images = this.findResources(sKey);
            if (images == null) {
                File cache = new File(SystemProperties.getUserPath(), "cache" + File.separator + sKey.hashCode() + ".ico");
                if (cache.exists()) {
                    try {
                        FileInputStream fis = new FileInputStream(cache);
                        try {
                            byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                            ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                            org.eclipse.swt.graphics.ImageLoader swtImageLoader = new org.eclipse.swt.graphics.ImageLoader();
                            ImageData[] imageDatas = swtImageLoader.load((InputStream)is);
                            images = new Image[imageDatas.length];
                            for (int i = 0; i < imageDatas.length; ++i) {
                                images[i] = new Image((Device)Display.getCurrent(), imageDatas[i]);
                            }
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        finally {
                            fis.close();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (images == null) {
                    images = new Image[]{};
                }
            }
            for (int i = 0; i < images.length; ++i) {
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage();
            }
        } else {
            images = this.parseValuesString(cl, sKey, locations, "");
        }
        this.mapImages.put(sKey, new ImageLoaderRefInfo(images));
        return images;
    }

    public Image getImage(String sKey) {
        Image[] images = this.getImages(sKey);
        if (images == null || images.length == 0 || images[0].isDisposed()) {
            return ImageLoader.getNoImage();
        }
        return images[0];
    }

    public long releaseImage(String sKey) {
        if (sKey == null) {
            return 0L;
        }
        ImageLoaderRefInfo imageInfo = this.mapImages.get(sKey);
        if (imageInfo != null) {
            imageInfo.unref();
            return imageInfo.getRefCount();
        }
        return 0L;
    }

    public void addImage(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImage called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.mapImages.putIfAbsent(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    public void addImageNoDipose(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImageNoDispose called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.mapImages.putIfAbsent(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setNonDisposable();
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    private static Image getNoImage() {
        if (noImage == null) {
            Display display = Display.getDefault();
            int SIZE = 10;
            noImage = new Image((Device)display, 10, 10);
            GC gc = new GC((Drawable)noImage);
            gc.setBackground(display.getSystemColor(7));
            gc.fillRectangle(0, 0, 10, 10);
            gc.setBackground(display.getSystemColor(3));
            gc.drawRectangle(0, 0, 9, 9);
            gc.dispose();
        }
        return noImage;
    }

    public boolean imageExists(String name) {
        boolean exists = ImageLoader.isRealImage(this.getImage(name));
        this.releaseImage(name);
        return exists;
    }

    public boolean imageAdded(String name) {
        Image[] images = this.getImages(name);
        boolean added = images != null && images.length > 0;
        this.releaseImage(name);
        return added;
    }

    public static boolean isRealImage(Image image) {
        return image != null && image != ImageLoader.getNoImage() && !image.isDisposed();
    }

    public int getAnimationDelay(String sKey) {
        for (SkinProperties sp : this.skinProperties) {
            int delay = sp.getIntValue(sKey + ".delay", -1);
            if (delay < 0) continue;
            return delay;
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getUrlImage(final String url, final ImageDownloaderListener l) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("getUrlImage called on non-SWT thread");
            return null;
        }
        if (l == null || url == null) {
            return null;
        }
        if (this.imageExists(url)) {
            Image image = this.getImage(url);
            l.imageDownloaded(image, true);
            return image;
        }
        final File cache = new File(SystemProperties.getUserPath(), "cache" + File.separator + url.hashCode() + ".ico");
        if (cache.exists()) {
            Image image;
            FileInputStream fis = new FileInputStream(cache);
            try {
                byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                Image image2 = new Image((Device)Display.getCurrent(), (InputStream)is);
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.mapImages.put(url, new ImageLoaderRefInfo(image2));
                l.imageDownloaded(image2, true);
                image = image2;
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            fis.close();
            return image;
        }
        ImageBytesDownloader.loadImage(url, new ImageBytesDownloader.ImageDownloaderListener(){

            public void imageDownloaded(final byte[] imageBytes) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FileUtil.writeBytesAsFile(cache.getAbsolutePath(), imageBytes);
                        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                        Image image = new Image((Device)Display.getCurrent(), (InputStream)is);
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ImageLoader.this.mapImages.put(url, new ImageLoaderRefInfo(image));
                        l.imageDownloaded(image, false);
                    }
                });
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("ImageLoader for " + this.skinProperties);
        writer.indent();
        long[] sizeCouldBeFree = new long[]{0L};
        long[] totalSizeEstimate = new long[]{0L};
        try {
            writer.indent();
            try {
                ImageLoaderRefInfo info;
                writer.println("Non-Disposable:");
                writer.indent();
                for (String key : this.mapImages.keySet()) {
                    info = this.mapImages.get(key);
                    if (!info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
                writer.println("Disposable:");
                writer.indent();
                for (String key : this.mapImages.keySet()) {
                    info = this.mapImages.get(key);
                    if (info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
            }
            finally {
                writer.exdent();
            }
            if (totalSizeEstimate[0] > 0L) {
                writer.println(totalSizeEstimate[0] / 1024L + "k estimated used for images");
            }
            if (sizeCouldBeFree[0] > 0L) {
                writer.println(sizeCouldBeFree[0] / 1024L + "k could be freed");
            }
        }
        finally {
            writer.exdent();
        }
    }

    private void writeEvidenceLine(IndentWriter writer, String key, ImageLoaderRefInfo info, long[] totalSizeEstimate, long[] sizeCouldBeFree) {
        String line = info.getRefCount() + "] " + key;
        if (Utils.isThisThreadSWT()) {
            long sizeEstimate = 0L;
            Image[] images = info.getImages();
            for (int i = 0; i < images.length; ++i) {
                Image img = images[i];
                if (img == null) continue;
                if (img.isDisposed()) {
                    line = line + "; *DISPOSED*";
                    continue;
                }
                Rectangle bounds = img.getBounds();
                long est = (long)(bounds.width * bounds.height) * 4L;
                sizeEstimate += est;
                totalSizeEstimate[0] = totalSizeEstimate[0] + est;
                if (!info.canDispose()) continue;
                sizeCouldBeFree[0] = sizeCouldBeFree[0] + est;
            }
            line = line + "; est " + sizeEstimate + " bytes";
        }
        writer.println(line);
    }

    public void addSkinProperties(SkinProperties skinProperties) {
        if (skinProperties == null) {
            return;
        }
        this.skinProperties.add(skinProperties);
        this.disabledOpacity = skinProperties.getIntValue("imageloader.disabled-opacity", -1);
        this.notFound.clear();
    }

    public void collectGarbage() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int numRemoved = 0;
                Iterator iter = ImageLoader.this.mapImages.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    ImageLoaderRefInfo info = (ImageLoaderRefInfo)ImageLoader.this.mapImages.get(key);
                    if (info == null || !info.canDispose()) continue;
                    iter.remove();
                    ++numRemoved;
                    Image[] images = info.getImages();
                    for (int j = 0; j < images.length; ++j) {
                        Image image = images[j];
                        if (image == null || image.isDisposed()) continue;
                        image.dispose();
                    }
                }
            }
        });
    }

    public void setLabelImage(Label label, final String key) {
        Image bg = this.getImage(key);
        label.setImage(bg);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public void setButtonImage(Button btn, final String key) {
        Image bg = this.getImage(key);
        btn.setImage(bg);
        btn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public void setBackgroundImage(Control control, final String key) {
        Image bg = this.getImage(key);
        control.setBackgroundImage(bg);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public SkinProperties[] getSkinProperties() {
        return this.skinProperties.toArray(new SkinProperties[0]);
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(Image var1, boolean var2);
    }
}

