/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.friends;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeShareable;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.AbstractBuddyPageListener;
import com.aelitis.azureus.ui.swt.browser.listener.AbstractStatusListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.shells.MessageWindow;
import com.aelitis.azureus.ui.swt.shells.friends.SharePage;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.progress.ProgressReportMessage;
import org.gudy.azureus2.ui.swt.shells.AbstractWizardPage;
import org.gudy.azureus2.ui.swt.shells.MultipageWizard;

public class AddFriendsPage
extends AbstractWizardPage {
    public static final String ID = "add.friends.wizard.page";
    public static final String BUTTON_PREVIEW = "button.preview";
    public static final String BUTTON_CONTINUE = "button.continue";
    private Composite content;
    private Browser browser;
    private BrowserContext context;
    private AbstractBuddyPageListener buddyPageListener;
    private FriendsToolbar friendsToolbar;
    private boolean previewMode = false;
    private boolean isStandalone;
    private SharePage sharePage;
    private String message = null;

    public AddFriendsPage(MultipageWizard wizard) {
        this(wizard, null);
    }

    public AddFriendsPage(MultipageWizard wizard, SharePage sharePage) {
        super(wizard);
        this.sharePage = sharePage;
        this.isStandalone = sharePage == null;
    }

    public Composite createControls(Composite parent) {
        if (this.isStandalone) {
            this.getWizard().getShell().addListener(12, new Listener(){

                public void handleEvent(Event arg0) {
                    AddFriendsPage.this.friendsToolbar.reset();
                }
            });
        }
        this.content = super.createControls(parent);
        this.content.setLayout((Layout)new FillLayout());
        this.friendsToolbar = (FriendsToolbar)SkinViewManager.getByClass(FriendsToolbar.class);
        Color bg = parent.getDisplay().getSystemColor(22);
        byte[] color = new byte[]{(byte)bg.getRed(), (byte)bg.getGreen(), (byte)bg.getBlue()};
        this.browser = new Browser(this.content, Utils.getInitialBrowserStyle(0));
        String url = ConstantsVuze.getDefaultContentNetwork().getAddFriendURL(ByteFormatter.nicePrint(color));
        this.browser.setUrl(url);
        this.getMessageContext();
        return this.content;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPageID() {
        return ID;
    }

    public String getDesciption() {
        return MessageText.getString("v3.AddFriends.header.message");
    }

    public String getTitle() {
        return MessageText.getString("v3.AddFriends.header");
    }

    public String getWindowTitle() {
        return MessageText.getString("v3.AddFriends.wizard.title");
    }

    protected void createButtons(Composite buttonPanel) {
        this.createButton("button.cancel", this.isStandalone ? MessageText.getString("Button.cancel") : MessageText.getString("wizard.previous"), new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AddFriendsPage.this.previewMode && !AddFriendsPage.this.isStandalone) {
                    AddFriendsPage.this.previewMode = false;
                    AddFriendsPage.this.context.executeInBrowser("previewCancel()");
                    AddFriendsPage.this.showButton(AddFriendsPage.BUTTON_PREVIEW, true);
                } else if (AddFriendsPage.this.isStandalone) {
                    AddFriendsPage.this.getWizard().close();
                } else {
                    AddFriendsPage.this.getWizard().showPage("share.wizard.page");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(BUTTON_PREVIEW, MessageText.getString("Button.preview"), new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddFriendsPage.this.previewMode = true;
                AddFriendsPage.this.context.executeInBrowser("preview()");
                AddFriendsPage.this.showButton(AddFriendsPage.BUTTON_PREVIEW, false);
                if (AddFriendsPage.this.isStandalone) {
                    AddFriendsPage.this.showButton("button.back", true);
                    AddFriendsPage.this.enableButton("button.back", true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableButton(BUTTON_PREVIEW, false);
        if (this.isStandalone) {
            this.createButton("button.back", MessageText.getString("Button.back"), new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddFriendsPage.this.context.executeInBrowser("previewCancel()");
                    AddFriendsPage.this.showButton("button.back", false);
                    AddFriendsPage.this.showButton(AddFriendsPage.BUTTON_PREVIEW, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.showButton("button.back", false);
        }
        this.createButton("button.ok", this.isStandalone ? MessageText.getString("Button.send") : MessageText.getString("Button.continue"), new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddFriendsPage.this.context.executeInBrowser("inviteSubmit()");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableButton("button.ok", !this.isStandalone);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public boolean isInitOnStartup() {
        return true;
    }

    public synchronized ClientMessageContext getMessageContext() {
        if (null == this.context) {
            this.context = new BrowserContext("buddy-page-listener-invite" + Math.random(), this.getBrowser(), null, true);
            this.context.addMessageListener(new DisplayListener(this.getBrowser()));
            this.context.addMessageListener(new AbstractStatusListener("status"){

                public void handlePageLoadCompleted() {
                    this.context.executeInBrowser("inviteFromShare(" + !AddFriendsPage.this.isStandalone + ")");
                    this.context.removeMessageListener(this);
                    if (AddFriendsPage.this.message != null) {
                        AddFriendsPage.this.getMessageContext().executeInBrowser("preSelect(\"" + AddFriendsPage.this.message + "\")");
                    }
                }
            });
            this.buddyPageListener = new AbstractBuddyPageListener(this.getBrowser()){

                public void handleCancel() {
                    if (null != AddFriendsPage.this.friendsToolbar) {
                        AddFriendsPage.this.friendsToolbar.reset();
                    }
                    if (AddFriendsPage.this.isStandalone()) {
                        AddFriendsPage.this.getWizard().close();
                    } else {
                        AddFriendsPage.this.getWizard().performBack();
                    }
                }

                public void handleClose() {
                    if (null != AddFriendsPage.this.friendsToolbar) {
                        AddFriendsPage.this.friendsToolbar.reset();
                    }
                    AddFriendsPage.this.getWizard().close();
                }

                public void handleBuddyInvites() {
                    if (AddFriendsPage.this.sharePage != null) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                ((AddFriendsPage)AddFriendsPage.this).sharePage.inviteeList.clear();
                                for (VuzeBuddy buddy : this.getInvitedBuddies()) {
                                    ((AddFriendsPage)AddFriendsPage.this).sharePage.inviteeList.addFriend(buddy);
                                }
                            }
                        });
                    }
                }

                public void handleEmailInvites() {
                    if (AddFriendsPage.this.sharePage != null) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                Iterator iterator = this.getInvitedEmails().iterator();
                                while (iterator.hasNext()) {
                                    VuzeBuddy buddy = VuzeBuddyManager.createPotentialBuddy(null);
                                    buddy.setLoginID(iterator.next().toString());
                                    ((AddFriendsPage)AddFriendsPage.this).sharePage.inviteeList.addFriend(buddy);
                                }
                                AddFriendsPage.this.getWizard().performBack();
                            }
                        });
                    }
                }

                public void handleInviteConfirm() {
                    final Map confirmationResponse = this.getConfirmationResponse();
                    if (null != confirmationResponse) {
                        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

                            public void loginComplete() {
                                Utils.execSWTThread(new AERunnable(){

                                    public void runSupport() {
                                        try {
                                            VuzeShareable shareItem = null;
                                            String commentText = null;
                                            VuzeBuddy[] buddies = null;
                                            List buddiesToShareWith = null;
                                            if (AddFriendsPage.this.sharePage != null) {
                                                shareItem = AddFriendsPage.this.sharePage.getShareItem();
                                                commentText = AddFriendsPage.this.sharePage.getCommentText();
                                                buddiesToShareWith = AddFriendsPage.this.sharePage.getFriends();
                                                buddies = buddiesToShareWith.toArray(new VuzeBuddy[buddiesToShareWith.size()]);
                                            }
                                            VuzeBuddyManager.inviteWithShare(confirmationResponse, shareItem, commentText, buddies);
                                            this.handleClose();
                                            if (buddiesToShareWith != null) {
                                                AddFriendsPage.this.showConfirmationDialog(buddiesToShareWith);
                                            } else {
                                                AddFriendsPage.this.showConfirmationDialog();
                                            }
                                        }
                                        catch (NotLoggedInException notLoggedInException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        });
                    }
                }

                public void handleResize() {
                }

                public void handleNbBuddiesUpdated(int nbInvites) {
                    AddFriendsPage.this.enableButton("button.ok", nbInvites > 0 || !AddFriendsPage.this.isStandalone);
                    AddFriendsPage.this.enableButton(AddFriendsPage.BUTTON_PREVIEW, nbInvites > 0);
                }
            };
            this.context.addMessageListener(this.buddyPageListener);
        }
        return this.context;
    }

    public void refresh() {
        if (null == this.browser) {
            this.getBrowser();
        }
        this.browser.refresh();
    }

    private void showConfirmationDialog(List buddiesToShareWith) {
        if (null != this.buddyPageListener) {
            final String[] message = new String[1];
            final ArrayList messages = new ArrayList();
            if (null == buddiesToShareWith) {
                buddiesToShareWith = Collections.EMPTY_LIST;
            }
            if (this.buddyPageListener.getInvitationsSent() == 0) {
                message[0] = buddiesToShareWith.size() > 1 ? MessageText.getString("message.confirm.share.plural") : MessageText.getString("message.confirm.share.singular");
            } else {
                boolean hasError = false;
                List inviteMessages = this.buddyPageListener.getConfirmationMessages();
                for (ProgressReportMessage cMessage : inviteMessages) {
                    if (!cMessage.isError()) continue;
                    hasError = true;
                    break;
                }
                if (hasError) {
                    message[0] = MessageText.getString("message.confirm.invite.error");
                    messages.addAll(this.buddyPageListener.getConfirmationMessages());
                } else {
                    message[0] = buddiesToShareWith.size() + this.buddyPageListener.getInvitationsSent() == 1 ? MessageText.getString("message.confirm.share.invite.singular") : MessageText.getString("message.confirm.share.invite.plural");
                }
            }
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                    MessageWindow messageWindow = new MessageWindow(mainShell, 6);
                    messageWindow.setDetailMessages(messages);
                    messageWindow.setMessage(message[0]);
                    messageWindow.setTitle("Share confirmation");
                    messageWindow.setSize(400, 300);
                    Utils.centerWindowRelativeTo(messageWindow.getShell(), (Control)mainShell);
                    messageWindow.open();
                }
            });
        }
    }

    private void showConfirmationDialog() {
        if (null != this.buddyPageListener) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                    MessageWindow messageWindow = new MessageWindow(mainShell, 6);
                    messageWindow.setDetailMessages(AddFriendsPage.this.buddyPageListener.getConfirmationMessages());
                    messageWindow.setMessage(AddFriendsPage.this.buddyPageListener.getFormattedInviteMessage());
                    messageWindow.setTitle("Invite confirmation");
                    messageWindow.setSize(400, 300);
                    Utils.centerWindowRelativeTo(messageWindow.getShell(), (Control)mainShell);
                    messageWindow.open();
                }
            });
        }
    }

    public void inviteWithMessage(String message) {
        if (null != this.friendsToolbar) {
            this.friendsToolbar.setAddFriendsMode();
        }
    }

    public void setStandalone(boolean isStandalone) {
        this.isStandalone = isStandalone;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }
}

