/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.friends;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeShareable;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.AbstractBuddyPageListener;
import com.aelitis.azureus.ui.swt.buddy.VuzeBuddySWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.shells.friends.AddFriendsPage;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.BuddiesViewer;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.widgets.FriendsList;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import com.aelitis.azureus.util.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.AbstractWizardPage;
import org.gudy.azureus2.ui.swt.shells.MultipageWizard;

public class SharePage
extends AbstractWizardPage {
    public static final String ID = "share.wizard.page";
    private Composite content;
    private FriendsList buddyList;
    private Composite inviteePanel;
    FriendsList inviteeList;
    private Button addBuddyButton;
    private Text messageText;
    private BuddiesViewer buddiesViewer;
    private FriendsToolbar friendsToolbar;
    private BrowserContext context;
    private AbstractBuddyPageListener buddyPageListener;
    private VuzeShareable shareItem;
    private String referer;
    private Label contentThumbnail;
    private Browser browser;
    private Composite contentDetail;
    private StyledText contentStats;
    private Font contentTitleFont = null;
    private boolean alreadyShown = false;

    public SharePage(MultipageWizard wizard) {
        super(wizard);
    }

    public Composite createControls(Composite parent) {
        this.content = super.createControls(parent);
        this.buddiesViewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
        this.friendsToolbar = (FriendsToolbar)SkinViewManager.getByClass(FriendsToolbar.class);
        this.getWizard().getShell().addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
                SharePage.this.resetBuddyViewer();
            }
        });
        this.content.setBackground(parent.getDisplay().getSystemColor(22));
        this.content.setBackgroundMode(2);
        this.content.setLayout((Layout)new GridLayout(2, false));
        this.createContentDetail();
        this.createFriendsPanel();
        this.createOptionalMessage();
        return this.content;
    }

    private void createContentDetail() {
        this.contentDetail = new Composite(this.content, 0);
        this.contentDetail.setBackgroundMode(1);
        GridData gData = new GridData(4, 128, true, false);
        gData.horizontalSpan = 2;
        this.contentDetail.setLayoutData((Object)gData);
        this.contentDetail.setLayout((Layout)new GridLayout(2, false));
        this.contentThumbnail = new Label(this.contentDetail, 0);
        gData = new GridData(1, 4, false, false);
        gData.widthHint = 142;
        gData.heightHint = 82;
        this.contentThumbnail.setLayoutData((Object)gData);
        this.contentStats = new StyledText(this.contentDetail, 64);
        this.contentStats.setBackground(this.contentDetail.getDisplay().getSystemColor(22));
        this.contentStats.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contentStats.getCaret().setVisible(false);
        this.contentStats.setEnabled(false);
        this.contentStats.setEditable(false);
    }

    private void createFriendsPanel() {
        Composite friendsPanel = new Composite(this.content, 0);
        friendsPanel.setLayout((Layout)new FillLayout(256));
        friendsPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createExistingFriendsList(friendsPanel);
        this.createNewFriendsList(friendsPanel);
    }

    private void createExistingFriendsList(Composite parent) {
        this.buddyList = new FriendsList(parent);
        this.buddyList.setBuddiesViewer(this.buddiesViewer);
        this.buddyList.setDefault_prompt_text(MessageText.getString("message.prompt.add.friends"));
        Image imageBuddyPrompt = ImageLoader.getInstance().getImage("buddy_prompt_image");
        this.buddyList.setDefault_prompt_image(imageBuddyPrompt);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.getInstance().releaseImage("buddy_prompt_image");
            }
        });
    }

    private void createNewFriendsList(Composite parent) {
        this.inviteePanel = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        gLayout.marginBottom = 5;
        this.inviteePanel.setLayout((Layout)gLayout);
        this.inviteeList = new FriendsList(this.inviteePanel);
        this.inviteeList.setEmailDisplayOnly(true);
        GridData gData = new GridData(4, 4, true, true);
        gData.horizontalSpan = 2;
        this.inviteeList.getControl().setLayoutData((Object)gData);
        Label addBuddyPromptLabel = new Label(this.inviteePanel, 131136);
        addBuddyPromptLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        addBuddyPromptLabel.setText(MessageText.getString("v3.Share.invite.buddies.prompt"));
        this.addBuddyButton = new Button(this.inviteePanel, 8);
        gData = new GridData(0x1000008, 0x1000000, true, false);
        gData.widthHint = 130;
        this.addBuddyButton.setLayoutData((Object)gData);
        this.addBuddyButton.setText(MessageText.getString("v3.Share.add.buddy"));
        this.addBuddyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SharePage.this.getWizard().showPage("add.friends.wizard.page");
                SharePage.this.friendsToolbar.enableShareButton(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createOptionalMessage() {
        Composite messagePanel = new Composite(this.content, 0);
        GridData gData = new GridData(4, 1024, true, false);
        gData.horizontalSpan = 2;
        messagePanel.setLayoutData((Object)gData);
        messagePanel.setLayout((Layout)new GridLayout());
        Label messageLabel = new Label(messagePanel, 64);
        messageLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        messageLabel.setText(MessageText.getString("v3.Share.optional.message"));
        this.messageText = new Text(messagePanel, 2112);
        gData = new GridData(4, 4, true, true);
        gData.heightHint = this.messageText.computeSize((int)-1, (int)-1).y * 2;
        this.messageText.setLayoutData((Object)gData);
        this.messageText.setTextLimit(140);
        Label messageDisclaimerLabel = new Label(messagePanel, 64);
        messageDisclaimerLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        messageDisclaimerLabel.setText(MessageText.getString("v3.Share.disclaimer"));
    }

    protected void createButtons(Composite buttonPanel) {
        this.createButton("button.cancel", MessageText.getString("Button.cancel"), this.defaultButtonListener);
        this.createButton("button.ok", MessageText.getString("v3.Share.send.now"), new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.widget).setEnabled(false);
                SharePage.this.getMessageContext().executeInBrowser("sendSharingBuddies('" + SharePage.this.getCommitJSONMessage() + "')");
                SharePage.this.getMessageContext().executeInBrowser("setShareReferer('" + SharePage.this.referer + "')");
                SharePage.this.getMessageContext().executeInBrowser("shareSubmit()");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String getCommitJSONMessage() {
        if (null == this.shareItem || null == this.shareItem.getHash()) {
            return null;
        }
        ArrayList<Object> buddieloginIDsAndContentHash = new ArrayList<Object>();
        ArrayList<String> loginIDs = new ArrayList<String>();
        for (VuzeBuddySWT vuzeBuddy : this.buddyList.getFriends()) {
            loginIDs.add(vuzeBuddy.getLoginID());
        }
        buddieloginIDsAndContentHash.add(loginIDs);
        buddieloginIDsAndContentHash.add(this.shareItem.getHash());
        return JSONUtils.encodeToJSON(buddieloginIDsAndContentHash);
    }

    public void setShareItem(VuzeShareable content, String referer) {
        this.shareItem = content;
        this.referer = referer;
        if (SystemTime.getCurrentTime() - PlatformBuddyMessenger.getLastSyncCheck() > PlatformConfigMessenger.getBuddySyncOnShareMinTimeSecs() * 1000L) {
            try {
                PlatformBuddyMessenger.sync(null);
            }
            catch (NotLoggedInException notLoggedInException) {
                // empty catch block
            }
        }
        if (content != null && content.getThumbURL() != null) {
            ImageBytesDownloader.loadImage(content.getThumbURL(), new ImageBytesDownloader.ImageDownloaderListener(){

                public void imageDownloaded(final byte[] image) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (SharePage.this.contentThumbnail != null && !SharePage.this.contentThumbnail.isDisposed()) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(image);
                                final Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                                if (img != null) {
                                    SharePage.this.contentThumbnail.addDisposeListener(new DisposeListener(){

                                        public void widgetDisposed(DisposeEvent e) {
                                            if (img != null && !img.isDisposed()) {
                                                img.dispose();
                                            }
                                        }
                                    });
                                    SharePage.this.contentThumbnail.setImage(img);
                                }
                            }
                        }
                    });
                }
            });
        }
        if (null != this.shareItem && null != this.friendsToolbar) {
            this.friendsToolbar.setShareMode();
        }
    }

    public VuzeShareable getShareItem() {
        return this.shareItem;
    }

    public void performFinish() {
        System.out.println("TODO: send the share message now!!!!!");
    }

    public void performCancel() {
        super.performCancel();
        this.resetBuddyViewer();
    }

    private void resetBuddyViewer() {
        this.buddiesViewer.setShareMode(false, null);
        this.friendsToolbar.reset();
    }

    public void addBuddy(VuzeBuddySWT vuzeBuddy) {
        if (null == this.buddyList.findWidget(vuzeBuddy)) {
            this.buddyList.addFriend(vuzeBuddy);
            this.adjustLayout();
        }
    }

    public void removeBuddy(VuzeBuddySWT vuzeBuddy) {
        if (null != this.buddyList.findWidget(vuzeBuddy)) {
            this.buddyList.removeFriend(vuzeBuddy);
            this.adjustLayout();
        }
    }

    private void adjustLayout() {
        this.content.layout(true, true);
    }

    public String getPageID() {
        return ID;
    }

    public String getDesciption() {
        return MessageText.getString("v3.Share.header.message");
    }

    public List getFriends() {
        return this.buddyList.getFriends();
    }

    public String getTitle() {
        return MessageText.getString("v3.Share.header");
    }

    public String getWindowTitle() {
        return MessageText.getString("v3.Share.wizard.title");
    }

    public void performAboutToBeShown() {
        super.performAboutToBeShown();
        this.friendsToolbar.enableShareButton(true);
        if (this.alreadyShown) {
            return;
        }
        this.alreadyShown = true;
        if (null == this.browser) {
            this.getBrowser();
        }
        if (null != this.friendsToolbar) {
            this.friendsToolbar.setShareMode();
        }
        if (null != this.buddiesViewer) {
            this.setBuddies(this.buddiesViewer.getSelection());
            this.buddiesViewer.addSelectionToShare();
            this.buddiesViewer.setShareMode(true, this);
        }
        TorrentUIUtilsV3.getContentImage(this.shareItem, true, new TorrentUIUtilsV3.ContentImageLoadedListener(){

            public void contentImageLoaded(Image image, boolean wasReturned) {
                SharePage.this.contentThumbnail.setImage(image);
            }
        });
        this.contentDetail.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TorrentUIUtilsV3.releaseContentImage(SharePage.this.shareItem);
            }
        });
        this.updateContentStats();
    }

    public void setBuddies(List buddies) {
        this.buddyList.clear();
        for (Object vuzeBuddy : buddies) {
            if (!(vuzeBuddy instanceof VuzeBuddy)) continue;
            this.buddyList.addFriend((VuzeBuddy)vuzeBuddy);
        }
    }

    private void updateContentStats() {
        long size;
        this.contentStats.setText("");
        if (this.shareItem == null) {
            return;
        }
        if (null == this.contentTitleFont) {
            FontData[] fDatas = this.contentStats.getFont().getFontData();
            for (int i = 0; i < fDatas.length; ++i) {
                fDatas[i].height += 2.0f;
            }
            this.contentTitleFont = new Font((Device)this.contentStats.getDisplay(), fDatas);
            this.contentStats.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (null != SharePage.this.contentTitleFont && !SharePage.this.contentTitleFont.isDisposed()) {
                        SharePage.this.contentTitleFont.dispose();
                    }
                }
            });
        }
        int charCount = this.contentStats.getCharCount();
        this.contentStats.append(this.shareItem.getDisplayName() + "\n");
        StyleRange style2 = new StyleRange();
        style2.start = charCount;
        style2.length = this.shareItem.getDisplayName().length();
        style2.font = this.contentTitleFont;
        this.contentStats.setStyleRange(style2);
        String publisher = this.shareItem.getPublisher();
        if (null != publisher && publisher.length() > 0) {
            if (publisher.startsWith("az")) {
                publisher = publisher.substring(2);
            }
            this.contentStats.append("From: " + publisher + "\n");
        }
        if ((size = this.shareItem.getSize()) > 0L) {
            this.contentStats.append("File size: " + DisplayFormatters.formatByteCountToKiBEtc(size));
        }
    }

    public ClientMessageContext getMessageContext() {
        AddFriendsPage page = (AddFriendsPage)this.getWizard().getPage("add.friends.wizard.page");
        if (null != page) {
            this.browser = page.getBrowser();
            return page.getMessageContext();
        }
        return null;
    }

    private Browser getBrowser() {
        AddFriendsPage page;
        if (null == this.browser && null != (page = (AddFriendsPage)this.getWizard().getPage("add.friends.wizard.page"))) {
            this.browser = page.getBrowser();
            page.getMessageContext();
        }
        return this.browser;
    }

    public String getCommentText() {
        return this.messageText.getText();
    }
}

