/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyCreator;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRelayMessenger;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.launcher.Launcher;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.UISkinnableManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableSWTListener;
import com.aelitis.azureus.ui.swt.buddy.impl.VuzeBuddyFakeSWTImpl;
import com.aelitis.azureus.ui.swt.buddy.impl.VuzeBuddySWTImpl;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.extlistener.StimulusRPC;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.PlayNowList;
import com.aelitis.azureus.ui.swt.views.skin.BuddiesViewer;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SBC_AdvancedView;
import com.aelitis.azureus.ui.swt.views.skin.SearchResultsTabArea;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.ui.swt.views.skin.UserAreaUtils;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarLogIdListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.DCAdManager;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.NavigationHelper;
import com.aelitis.azureus.util.PublishUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelationUtils;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarOpenListener;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
implements IMainWindow,
ObfusticateShell,
SideBarListener,
AEDiagnosticsEvidenceGenerator,
SideBarLogIdListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    protected Shell shell;
    private Display display;
    private AzureusCore core;
    private IUIIntializer uiInitializer;
    private SWTSkin skin;
    private org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMW_tab;
    private org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMW_SB;
    private org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMainWindow;
    private MainMenu menu;
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private UIFunctionsImpl uiFunctions;
    private SystemTraySWT systemTraySWT;
    private static Map mapTrackUsage = null;
    private static final AEMonitor mapTrackUsage_mon = new AEMonitor("mapTrackUsage");
    private long lCurrentTrackTime = 0L;
    private long lCurrentTrackTimeIdle = 0L;
    private boolean disposedOrDisposing;
    private DownloadManager[] dms_Startup;
    protected boolean isReady = false;
    private MainStatusBar statusBar;
    private String lastShellStatus = null;
    private Color colorSearchTextBG;
    private Color colorSearchTextFGdef;
    private Color colorSearchTextFG;
    private boolean delayedCore;

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(MainWindow.class, args)) {
            return;
        }
        Initializer.main(new String[0]);
    }

    public MainWindow(AzureusCore core, Display display, final IUIIntializer uiInitializer) {
        GlobalManager gm;
        File fileFromInstall;
        this.delayedCore = false;
        this.core = core;
        this.display = display;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addEvidenceGenerator(this);
        this.disposedOrDisposing = false;
        VuzeBuddyManager.init(new VuzeBuddyCreator(){

            public VuzeBuddy createBuddy(String publicKey) {
                VuzeBuddyManager.log("created buddy: " + publicKey);
                return new VuzeBuddySWTImpl(publicKey);
            }

            public VuzeBuddy createBuddy() {
                VuzeBuddyManager.log("created buddy");
                return new VuzeBuddySWTImpl();
            }

            public VuzeBuddy createPotentialBuddy(Map map) {
                return new VuzeBuddyFakeSWTImpl(map);
            }
        });
        if (Constants.isWindows && System.getProperty("os.name").indexOf("Vista") > 0 && !COConfigurationManager.getBooleanParameter("vista.adminquit") && (fileFromInstall = FileUtil.getApplicationFile("license.txt")).exists() && fileFromInstall.lastModified() < new GregorianCalendar(2007, 6, 13).getTimeInMillis() && (gm = core.getGlobalManager()) != null && gm.getDownloadManagers().size() == 0 && gm.getStats().getTotalProtocolBytesReceived() < 0x6400000L) {
            File fileTestWrite = FileUtil.getApplicationFile("testwrite.dll");
            fileTestWrite.deleteOnExit();
            try {
                FileOutputStream fos = new FileOutputStream(fileTestWrite);
                fos.write(23);
                fos.close();
                COConfigurationManager.setParameter("vista.adminquit", true);
                MessageBoxShell.open(this.shell, MessageText.getString("mb.azmustclose.title"), MessageText.getString("mb.azmustclose.text"), new String[]{MessageText.getString("Button.ok")}, 0);
                if (uiInitializer != null) {
                    uiInitializer.abortProgress();
                }
                this.dispose(false, false);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindow.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                if (uiInitializer != null) {
                    uiInitializer.abortProgress();
                }
            }
        });
        GlobalManager gm2 = core.getGlobalManager();
        this.dms_Startup = gm2.getDownloadManagers().toArray(new DownloadManager[0]);
        gm2.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindow.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        gm2.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                TOTorrent torrent = dm.getTorrent();
                if (PublishUtils.isPublished(dm)) {
                    String title = MessageText.getString("v3.mb.delPublished.title");
                    ContentNetwork cn = DataSourceUtils.getContentNetwork(torrent);
                    if (cn == null) {
                        return;
                    }
                    String site = ContentNetworkUtils.getUrl(cn, 15);
                    String site_host = (String)cn.getProperty(1);
                    String text = MessageText.getString("v3.mb.delPublished.text", new String[]{dm.getDisplayName(), site, site_host, ContentNetworkUtils.getUrl(cn, 10)});
                    MessageBoxShell mb = new MessageBoxShell(MainWindow.this.shell, title, text, new String[]{MessageText.getString("v3.mb.delPublished.delete"), MessageText.getString("v3.mb.delPublished.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    int result = mb.open();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                } else if (PlatformTorrentUtils.isContentDRM(torrent) && remove_data) {
                    String prefix = "v3.mb.deletePurchased.";
                    String title = MessageText.getString(prefix + "title");
                    String text = MessageText.getString(prefix + "text", new String[]{dm.getDisplayName()});
                    MessageBoxShell mb = new MessageBoxShell(MainWindow.this.shell, title, text, new String[]{MessageText.getString(prefix + "button.delete"), MessageText.getString(prefix + "button.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    int result = mb.open();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                }
            }
        });
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                if (dm.getDownloadState().getFlag(16L)) {
                    return false;
                }
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (PlayNowList.contains(hw)) {
                        return false;
                    }
                }
                catch (TOTorrentException e) {
                    // empty catch block
                }
                return true;
            }
        });
    }

    public MainWindow(final Display display, final IUIIntializer uiInitializer) {
        this.delayedCore = true;
        this.display = display;
        this.uiInitializer = uiInitializer;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindow.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
            }
        });
    }

    public void init(final AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow.this._init(core);
                if (MainWindow.this.uiInitializer != null) {
                    MainWindow.this.uiInitializer.abortProgress();
                }
            }
        });
    }

    public void _init(AzureusCore core) {
        GlobalManager gm;
        File fileFromInstall;
        this.core = core;
        AEDiagnostics.addEvidenceGenerator(this);
        this.disposedOrDisposing = false;
        if (!Constants.isSafeMode && COConfigurationManager.getBooleanParameter("Open Transfer Bar On Start")) {
            this.uiFunctions.showGlobalTransferBar();
        }
        VuzeBuddyManager.init(new VuzeBuddyCreator(){

            public VuzeBuddy createBuddy(String publicKey) {
                VuzeBuddyManager.log("created buddy: " + publicKey);
                return new VuzeBuddySWTImpl(publicKey);
            }

            public VuzeBuddy createBuddy() {
                VuzeBuddyManager.log("created buddy");
                return new VuzeBuddySWTImpl();
            }

            public VuzeBuddy createPotentialBuddy(Map map) {
                return new VuzeBuddyFakeSWTImpl(map);
            }
        });
        if (Constants.isWindows && System.getProperty("os.name").indexOf("Vista") > 0 && !COConfigurationManager.getBooleanParameter("vista.adminquit") && (fileFromInstall = FileUtil.getApplicationFile("license.txt")).exists() && fileFromInstall.lastModified() < new GregorianCalendar(2007, 6, 13).getTimeInMillis() && (gm = core.getGlobalManager()) != null && gm.getDownloadManagers().size() == 0 && gm.getStats().getTotalProtocolBytesReceived() < 0x6400000L) {
            File fileTestWrite = FileUtil.getApplicationFile("testwrite.dll");
            fileTestWrite.deleteOnExit();
            try {
                FileOutputStream fos = new FileOutputStream(fileTestWrite);
                fos.write(23);
                fos.close();
                COConfigurationManager.setParameter("vista.adminquit", true);
                MessageBoxShell.open(this.shell, MessageText.getString("mb.azmustclose.title"), MessageText.getString("mb.azmustclose.text"), new String[]{MessageText.getString("Button.ok")}, 0);
                if (this.uiInitializer != null) {
                    this.uiInitializer.abortProgress();
                }
                this.dispose(false, false);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            DCAdManager.getInstance().initialize(core);
        }
        catch (Throwable e) {
            // empty catch block
        }
        StimulusRPC.hookListeners(core, this);
        this.uiSWTInstanceImpl = new UISWTInstanceImpl(core);
        this.uiSWTInstanceImpl.init(this.uiInitializer);
        PluginInterface pi = core.getPluginManager().getPluginInterfaceByID("azbpstartstoprules");
        if (pi != null) {
            StartStopRulesDefaultPlugin plugin = (StartStopRulesDefaultPlugin)pi.getPlugin();
            plugin.addListener(new StartStopRulesFPListener(){

                public boolean isFirstPriority(Download dl, int numSeeds, int numPeers, StringBuffer debug) {
                    boolean b = dl.getState() == 5 && numSeeds == 0 && dl.getStats().getAvailability() < 2.0f && PublishUtils.isPublished(dl);
                    return b;
                }
            });
        }
        VuzeActivitiesManager.initialize(core);
        gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindow.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        gm.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                TOTorrent torrent = dm.getTorrent();
                if (PublishUtils.isPublished(dm)) {
                    String title = MessageText.getString("v3.mb.delPublished.title");
                    ContentNetwork cn = DataSourceUtils.getContentNetwork(torrent);
                    if (cn == null) {
                        return;
                    }
                    String site = ContentNetworkUtils.getUrl(cn, 15);
                    String site_host = (String)cn.getProperty(1);
                    String text = MessageText.getString("v3.mb.delPublished.text", new String[]{dm.getDisplayName(), site, site_host, ContentNetworkUtils.getUrl(cn, 10)});
                    MessageBoxShell mb = new MessageBoxShell(MainWindow.this.shell, title, text, new String[]{MessageText.getString("v3.mb.delPublished.delete"), MessageText.getString("v3.mb.delPublished.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    int result = mb.open();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                } else if (PlatformTorrentUtils.isContentDRM(torrent) && remove_data) {
                    String prefix = "v3.mb.deletePurchased.";
                    String title = MessageText.getString(prefix + "title");
                    String text = MessageText.getString(prefix + "text", new String[]{dm.getDisplayName()});
                    MessageBoxShell mb = new MessageBoxShell(MainWindow.this.shell, title, text, new String[]{MessageText.getString(prefix + "button.delete"), MessageText.getString(prefix + "button.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    int result = mb.open();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                }
            }
        });
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                if (dm.getDownloadState().getFlag(16L)) {
                    return false;
                }
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (PlayNowList.contains(hw)) {
                        return false;
                    }
                }
                catch (TOTorrentException e) {
                    // empty catch block
                }
                return true;
            }
        });
        core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.processStartupDMS();
    }

    private void processStartupDMS() {
        AEThread2 thread = new AEThread2("v3.mw.dmAdded", true){

            public void run() {
                long startTime = SystemTime.getCurrentTime();
                if (MainWindow.this.dms_Startup == null || MainWindow.this.dms_Startup.length == 0) {
                    MainWindow.access$202(MainWindow.this, null);
                    return;
                }
                MainWindow.this.downloadAdded(MainWindow.this.dms_Startup);
                MainWindow.access$202(MainWindow.this, null);
                System.out.println("psDMS " + (SystemTime.getCurrentTime() - startTime) + "ms");
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private void downloadAdded(DownloadManager[] dms) {
        ArrayList<TOTorrent> toUpdateGlobalRating = new ArrayList<TOTorrent>();
        boolean oneIsNotPlatform = false;
        for (final DownloadManager dm : dms) {
            long completedTime;
            String lastVersion;
            if (dm == null) continue;
            DownloadManagerState dmState = dm.getDownloadState();
            final TOTorrent torrent = dm.getTorrent();
            if (torrent == null) continue;
            String hash = null;
            try {
                hash = torrent.getHashWrapper().toBase32String();
            }
            catch (TOTorrentException e) {
                Debug.out(e);
            }
            String title = PlatformTorrentUtils.getContentTitle(torrent);
            if (title != null && title.length() > 0 && dmState.getDisplayName() == null) {
                dmState.setDisplayName(title);
            }
            if (ConfigurationChecker.isNewVersion() && dm.getAssumedComplete() && Constants.compareVersions(lastVersion = COConfigurationManager.getStringParameter("Last Version"), "3.1.1.1") <= 0 && (completedTime = dmState.getLongParameter("stats.download.completed.time")) < SystemTime.getOffsetTime(-60000L)) {
                PlatformTorrentUtils.setHasBeenOpened(dm, true);
            }
            boolean isContent = PlatformTorrentUtils.isContent(torrent, true);
            if (!(oneIsNotPlatform || isContent || dmState.getFlag(16L))) {
                oneIsNotPlatform = true;
            }
            String fHash = hash;
            if (!isContent) continue;
            if (PlatformTorrentUtils.getUserRating(torrent) == -2) {
                PlatformTorrentUtils.setUserRating(torrent, -1);
                PlatformRatingMessenger.getUserRating(PlatformTorrentUtils.getContentNetworkID(torrent), new String[]{"content"}, new String[]{hash}, 5000L);
            }
            long now = SystemTime.getCurrentTime();
            long mdRefreshOn = PlatformTorrentUtils.getMetaDataRefreshOn(torrent);
            if (mdRefreshOn < now) {
                PlatformTorrentUtils.log(torrent, "addDM, update MD NOW");
                PlatformTorrentUtils.updateMetaData(torrent, 5000L);
            } else {
                PlatformTorrentUtils.log(torrent, "addDM, update MD on " + new Date(mdRefreshOn));
                SimpleTimer.addEvent("Update MD", mdRefreshOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        PlatformTorrentUtils.updateMetaData(torrent, 15000L);
                    }
                });
            }
            long grRefreshOn = GlobalRatingUtils.getRefreshOn(torrent);
            if (grRefreshOn <= now) {
                toUpdateGlobalRating.add(torrent);
            } else {
                SimpleTimer.addEvent("Update G.Rating", grRefreshOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        PlatformRatingMessenger.updateGlobalRating(torrent, 15000L);
                    }
                });
            }
            long expiresOn = PlatformTorrentUtils.getExpiresOn(torrent);
            if (expiresOn > now) {
                SimpleTimer.addEvent("dm Expirey", expiresOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        dm.getDownloadState().setFlag(16L, true);
                        ManagerUtils.remove(dm, null, true, true);
                    }
                });
            }
            if (!PublishUtils.isPublished(dm) || dm.getStats().getShareRatio() >= 1000 || dm.isForceStart()) continue;
            dm.setForceStart(true);
        }
        if (oneIsNotPlatform && this.dms_Startup == null) {
            DonationWindow.checkForDonationPopup();
        }
        if (toUpdateGlobalRating.size() > 0) {
            TOTorrent[] torrents = toUpdateGlobalRating.toArray(new TOTorrent[0]);
            PlatformRatingMessenger.updateGlobalRating(torrents, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createWindow(IUIIntializer uiInitializer) {
        String configID2222;
        long startTime;
        block28: {
            Method method;
            Class<?> ehancerClass;
            startTime = SystemTime.getCurrentTime();
            this.uiFunctions = new UIFunctionsImpl(this);
            UIFunctionsManager.setUIFunctions(this.uiFunctions);
            Utils.disposeComposite((Composite)this.shell);
            this.increaseProgress(uiInitializer, "splash.initializeGui");
            System.out.println("UIFunctions/ImageLoad took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            this.shell = new Shell(this.display, 1264);
            if (Constants.isWindows) {
                try {
                    ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                    method = ehancerClass.getMethod("initMainShell", Shell.class);
                    method.invoke(null, this.shell);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            try {
                try {
                    PluginInterface pi;
                    this.shell.setData("class", (Object)this);
                    this.shell.setText("Vuze");
                    Utils.setShellIcon(this.shell);
                    Utils.linkShellMetricsToConfig(this.shell, "window");
                    System.out.println("new shell took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    PlatformConfigMessenger.addPlatformLoginCompleteListener(new PlatformConfigMessenger.PlatformLoginCompleteListener(){

                        public void platformLoginComplete() {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    MainWindow.this.setupUsageTracker();
                                }
                            });
                        }
                    });
                    PlatformDevicesMessenger.setupDeviceSender();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin = SWTSkinFactory.getInstance();
                    this.uiFunctions.setSkin(this.skin);
                    System.out.println("new shell setup took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initSkinListeners();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skinlisteners init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.skin.initialize(this.shell, "main.shell", uiInitializer);
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.menu = new MainMenu(this.skin, this.shell);
                    this.shell.setData("MainMenu", (Object)this.menu);
                    System.out.println("MainMenu init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (Constants.isOSX && SWT.getPlatform().equals("carbon")) {
                        try {
                            ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                            method = ehancerClass.getMethod("registerToolbarToggle", Shell.class);
                            method.invoke(null, this.shell);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                        Listener toggleListener = new Listener(){

                            public void handleEvent(Event event2) {
                                ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                                if (tb != null) {
                                    tb.flipShowText();
                                }
                            }
                        };
                        this.shell.addListener(17, toggleListener);
                        this.shell.addListener(18, toggleListener);
                    }
                    System.out.println("createWindow init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin.layout();
                    System.out.println("skin layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    try {
                        Utils.createTorrentDropTarget((Composite)this.shell, false);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
                    }
                    this.shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            MainWindow.this.dispose(false, false);
                        }
                    });
                    this.shell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellClosed(ShellEvent event2) {
                            if (MainWindow.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                                MainWindow.this.minimizeToTray(event2);
                            } else {
                                event2.doit = MainWindow.this.dispose(false, false);
                            }
                        }

                        public void shellIconified(ShellEvent event2) {
                            if (MainWindow.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                                MainWindow.this.minimizeToTray(event2);
                            }
                        }

                        public void shellDeiconified(ShellEvent e) {
                            if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                                MainWindow.this.shell.setVisible(false);
                                if (PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                                    MainWindow.this.shell.setVisible(true);
                                }
                            }
                        }
                    });
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("pre skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        try {
                            DCAdManager.getInstance().initialize(this.core);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        StimulusRPC.hookListeners(this.core, this);
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("hooks init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initWidgets();
                    System.out.println("skin widgets (1/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initWidgets2();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sidebar != null) {
                        this.setupSideBar(sidebar);
                    } else {
                        SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                            public void skinViewAdded(SkinView skinview) {
                                if (skinview instanceof SideBar) {
                                    MainWindow.this.setupSideBar((SideBar)skinview);
                                }
                            }
                        });
                    }
                    System.out.println("pre SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    TableColumnCreatorV3.initCoreColumns();
                    System.out.println("Init Core Columns took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.core);
                        this.uiSWTInstanceImpl.init(uiInitializer);
                    }
                    System.out.println("SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null && (pi = this.core.getPluginManager().getPluginInterfaceByID("azbpstartstoprules")) != null) {
                        StartStopRulesDefaultPlugin plugin = (StartStopRulesDefaultPlugin)pi.getPlugin();
                        plugin.addListener(new StartStopRulesFPListener(){

                            public boolean isFirstPriority(Download dl, int numSeeds, int numPeers, StringBuffer debug) {
                                boolean b = dl.getState() == 5 && numSeeds == 0 && dl.getStats().getAvailability() < 2.0f && PublishUtils.isPublished(dl);
                                return b;
                            }
                        });
                    }
                    ManagerUtils.setRunRunnable(new ManagerUtils.RunDownloadManager(){

                        public void run(DownloadManager dm) {
                            TOTorrent torrent = dm.getTorrent();
                            if (PlatformTorrentUtils.isContent(torrent, true) && PlatformTorrentUtils.isContentAdEnabled(torrent)) {
                                TorrentListViewsUtils.playOrStream(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    Debug.out(t);
                    Object var8_12 = null;
                    String configID2222 = "pluginbar.visible";
                    if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                        COConfigurationManager.setBooleanDefault(configID2222, true);
                    }
                    this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                    configID2222 = "Friends.visible";
                    if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                        COConfigurationManager.setBooleanDefault(configID2222, true);
                    }
                    this.setVisible(5, true);
                    this.shell.layout(true, true);
                    System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.showMainWindow();
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.processStartupDMS();
                    System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        VuzeActivitiesManager.initialize(this.core);
                    }
                    System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    NavigationHelper.addListener(new NavigationHelper.navigationListener(){

                        public void processCommand(final int type, final String[] args) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (type == 1) {
                                        SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                                        if (sideBar == null) {
                                            return;
                                        }
                                        ContentNetworkUtils.setSourceRef(args[0], "menu", false);
                                        sideBar.showEntryByTabID(args[0]);
                                        if (uif != null) {
                                            uif.bringToFront();
                                        }
                                    } else if (type == 3) {
                                        try {
                                            PlatformRelayMessenger.fetch(0L);
                                            PlatformBuddyMessenger.sync(null);
                                            PlatformBuddyMessenger.getInvites();
                                        }
                                        catch (NotLoggedInException notLoggedInException) {}
                                    } else if (type == 2 && args[0].equals("buddy-manager") && args[1].equals("enabled") && !VuzeBuddyManager.isEnabled()) {
                                        VuzeBuddyManager.showDisabledDialog();
                                        if (uif != null) {
                                            uif.bringToFront();
                                        }
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                Object var8_11 = null;
                configID2222 = "pluginbar.visible";
                if (ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) break block28;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                String configID2222 = "pluginbar.visible";
                if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                    COConfigurationManager.setBooleanDefault(configID2222, true);
                }
                this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                configID2222 = "Friends.visible";
                if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                    COConfigurationManager.setBooleanDefault(configID2222, true);
                }
                this.setVisible(5, true);
                this.shell.layout(true, true);
                System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.showMainWindow();
                this.increaseProgress(uiInitializer, "splash.initializeGui");
                System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.processStartupDMS();
                System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                if (this.core != null) {
                    VuzeActivitiesManager.initialize(this.core);
                }
                System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            COConfigurationManager.setBooleanDefault(configID2222, true);
        }
        this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
        configID2222 = "Friends.visible";
        if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
            COConfigurationManager.setBooleanDefault(configID2222, true);
        }
        this.setVisible(5, true);
        this.shell.layout(true, true);
        System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.showMainWindow();
        this.increaseProgress(uiInitializer, "splash.initializeGui");
        System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.processStartupDMS();
        System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        if (this.core != null) {
            VuzeActivitiesManager.initialize(this.core);
        }
        System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
    }

    protected void setupSideBar(final SideBar sidebar) {
        sidebar.addListener(this);
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                String startTab;
                boolean showWelcome = COConfigurationManager.getBooleanParameter("v3.Show Welcome");
                boolean startAdv = COConfigurationManager.getBooleanParameter("v3.Start Advanced");
                ContentNetwork startupCN = ContentNetworkManagerFactory.getSingleton().getStartupContentNetwork();
                if (!startupCN.isServiceSupported(8)) {
                    showWelcome = false;
                }
                if (showWelcome && !startAdv) {
                    startTab = "Welcome";
                } else {
                    if (showWelcome && startAdv) {
                        sidebar.showEntryByID("Welcome");
                    }
                    if (COConfigurationManager.getBooleanParameter("v3.Start Advanced")) {
                        startTab = "Library";
                    } else {
                        startTab = "ContentNetwork." + startupCN.getID();
                        ContentNetworkUtils.setSourceRef(startTab, "startup", false);
                    }
                }
                sidebar.showEntryByTabID(startTab);
            }
        });
    }

    private void increaseProgress(IUIIntializer uiInitializer, String taskKey) {
        if (uiInitializer != null) {
            uiInitializer.increaseProgress();
            if (taskKey != null) {
                uiInitializer.reportCurrentTask(MessageText.getString(taskKey));
            }
        }
    }

    public boolean dispose(final boolean for_restart, final boolean close_already_in_progress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        return Utils.execSWTThreadWithBool("v3.MainWindow.dispose", new AERunnableBoolean(){

            public boolean runSupport() {
                return MainWindow.this._dispose(for_restart, close_already_in_progress);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _dispose(boolean bForRestart, boolean bCloseAlreadyInProgress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        this.isReady = false;
        this.disposedOrDisposing = true;
        if (this.oldMainWindow != null) {
            boolean res = this.oldMainWindow.dispose(bForRestart, bCloseAlreadyInProgress);
            this.oldMainWindow = null;
            if (!res) {
                this.disposedOrDisposing = false;
                return false;
            }
        } else {
            if (this.core != null && !UIExitUtilsSWT.canClose(this.core.getGlobalManager(), bForRestart)) {
                this.disposedOrDisposing = false;
                return false;
            }
            UIExitUtilsSWT.uiShutdown();
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        try {
            AllTransfersBar transfer_bar = AllTransfersBar.getBarIfOpen(this.core.getGlobalManager());
            if (transfer_bar != null) {
                transfer_bar.forceSaveLocation();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        mapTrackUsage_mon.enter();
        try {
            if (mapTrackUsage != null) {
                String id = this.getUsageActiveTabID();
                if (id != null) {
                    if (this.lastShellStatus == null) {
                        this.lastShellStatus = id;
                    }
                    this.updateMapTrackUsage(this.lastShellStatus);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version", "4.2.0.8");
                map.put("statsmap", mapTrackUsage);
                FileUtil.writeResilientFile(new File(SystemProperties.getUserPath(), "timingstats.dat"), map);
            }
        }
        finally {
            mapTrackUsage_mon.exit();
        }
        if (!SWTThread.getInstance().isTerminated()) {
            SWTThread.getInstance().getInitializer().stopIt(bForRestart, false);
        }
        return true;
    }

    private String getUsageActiveTabID() {
        try {
            SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sidebar != null) {
                SideBarEntrySWT curEntry = sidebar.getCurrentEntry();
                if (curEntry == null) {
                    return "none";
                }
                String id = curEntry.getLogID();
                return id == null ? "null" : id;
            }
        }
        catch (Exception e) {
            String name = e.getClass().getName();
            int i = name.indexOf(46);
            if (i > 0) {
                return name.substring(i);
            }
            return name;
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUsageTracker() {
        block11: {
            mapTrackUsage_mon.enter();
            try {
                File f = new File(SystemProperties.getUserPath(), "timingstats.dat");
                if (COConfigurationManager.getBooleanParameter("Send Version Info") && PlatformConfigMessenger.allowSendStats()) {
                    mapTrackUsage = new HashMap();
                    if (f.exists()) {
                        Map oldMapTrackUsage = FileUtil.readResilientFile(f);
                        String version = MapUtils.getMapString(oldMapTrackUsage, "version", null);
                        Map map = MapUtils.getMapMap(oldMapTrackUsage, "statsmap", null);
                        if (version != null && map != null) {
                            PlatformConfigMessenger.sendUsageStats(map, f.lastModified(), version, null);
                        }
                    }
                    SimpleTimer.addPeriodicEvent("UsageTracker", 1000L, new TimerEventPerformer(){
                        long lLastMouseMove = SystemTime.getCurrentTime();
                        Point ptLastMousePos = new Point(0, 0);

                        public void perform(TimerEvent event2) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    if (MainWindow.this.shell == null || MainWindow.this.shell.isDisposed() || MainWindow.this.shell.getDisplay().getActiveShell() == null) {
                                        if (ptLastMousePos.x > 0) {
                                            ptLastMousePos.x = 0;
                                            ptLastMousePos.y = 0;
                                            lLastMouseMove = 0L;
                                        }
                                        return;
                                    }
                                    Point pt = MainWindow.this.shell.getDisplay().getCursorLocation();
                                    if (pt.equals((Object)ptLastMousePos)) {
                                        return;
                                    }
                                    ptLastMousePos = pt;
                                    long now = SystemTime.getCurrentTime();
                                    if (lLastMouseMove > 0L) {
                                        long diff = now - lLastMouseMove;
                                        if (diff < 10000L) {
                                            MainWindow.this.lCurrentTrackTime += diff;
                                        } else {
                                            MainWindow.this.lCurrentTrackTimeIdle += diff;
                                        }
                                    }
                                    lLastMouseMove = now;
                                }
                            });
                        }
                    });
                    Listener lActivateDeactivate = new Listener(){
                        long start;

                        public void handleEvent(Event event2) {
                            if (event2.type == 26) {
                                MainWindow.this.lCurrentTrackTimeIdle = 0L;
                                if (this.start > 0L && MainWindow.this.lastShellStatus != null) {
                                    MainWindow.this.lCurrentTrackTime = SystemTime.getCurrentTime() - this.start;
                                    MainWindow.this.updateMapTrackUsage(MainWindow.this.lastShellStatus);
                                }
                                MainWindow.this.lastShellStatus = null;
                            } else {
                                MainWindow.this.updateMapTrackUsage(MainWindow.this.getUsageActiveTabID());
                                if (MainWindow.this.shell.getMinimized()) {
                                    MainWindow.this.lastShellStatus = "idle-minimized";
                                } else if (!MainWindow.this.shell.isVisible()) {
                                    MainWindow.this.lastShellStatus = "idle-invisible";
                                } else {
                                    MainWindow.this.lastShellStatus = "idle-nofocus";
                                }
                                this.start = SystemTime.getCurrentTime();
                            }
                        }
                    };
                    this.shell.addListener(26, lActivateDeactivate);
                    this.shell.addListener(27, lActivateDeactivate);
                    break block11;
                }
                mapTrackUsage = null;
                try {
                    if (f.exists()) {
                        f.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            finally {
                mapTrackUsage_mon.exit();
            }
        }
    }

    private void showMainWindow() {
        if (this.oldMainWindow != null) {
            // empty if block
        }
        boolean isOSX = Constants.isOSX;
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray") && (!isOSX || SWT.getVersion() > 3300);
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled");
        boolean bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized"));
        SWTSkinObject soMain = this.skin.getSkinObject("main");
        if (soMain != null) {
            soMain.getControl().setVisible(true);
        }
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                System.out.println("---------SHOWN AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            }
        });
        if (!bStartMinimize) {
            this.shell.open();
            if (!isOSX) {
                this.shell.forceActive();
            }
        } else if (isOSX) {
            this.shell.setMinimized(true);
            this.shell.setVisible(true);
        }
        if (this.delayedCore) {
            while (!this.display.isDisposed() && this.display.readAndDispatch()) {
            }
            System.out.println("---------DONE DISPATCH AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            if (this.display.isDisposed()) {
                return;
            }
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = new SystemTraySWT();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        if (this.uiInitializer != null) {
            this.uiInitializer.initializationComplete();
        }
        AssociationChecker.checkAssociations();
        Map map = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
        DonationWindow.setInitialAskHours(MapUtils.getMapInt(map, "donations.askhrs", DonationWindow.getInitialAskHours()));
        if (this.core != null) {
            this.core.triggerLifeCycleComponentCreated(this.uiFunctions);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                MainWindow.this.fixupActionBarSize();
            }
        });
        System.out.println("---------READY AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
        this.isReady = true;
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(final boolean visible, boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int i;
                Shell[] shells;
                boolean currentlyVisible;
                boolean bl = currentlyVisible = MainWindow.this.shell.getVisible() && !MainWindow.this.shell.getMinimized();
                if (visible && !currentlyVisible && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                    MainWindow.this.shell.setVisible(false);
                    return;
                }
                ArrayList<Shell> wasVisibleList = null;
                boolean bHideAndShow = false;
                if (bHideAndShow) {
                    wasVisibleList = new ArrayList<Shell>();
                    try {
                        MainWindow.this.shell.setMinimized(true);
                        shells = MainWindow.this.shell.getDisplay().getShells();
                        for (i = 0; i < shells.length; ++i) {
                            if (!shells[i].isVisible()) continue;
                            wasVisibleList.add(shells[i]);
                            shells[i].setVisible(false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (visible) {
                    MainWindow.this.shell.setMinimized(false);
                    if (!currentlyVisible && COConfigurationManager.getBooleanParameter("window.maximized")) {
                        MainWindow.this.shell.setMaximized(true);
                    }
                } else {
                    COConfigurationManager.setParameter("window.maximized", MainWindow.this.shell.getMaximized());
                }
                MainWindow.this.shell.setVisible(visible);
                if (visible) {
                    MainWindow.this.shell.forceActive();
                    if (bHideAndShow) {
                        try {
                            shells = MainWindow.this.shell.getDisplay().getShells();
                            for (i = 0; i < shells.length; ++i) {
                                if (shells[i] == MainWindow.this.shell) continue;
                                if (wasVisibleList.contains(shells[i])) {
                                    shells[i].setVisible(visible);
                                }
                                shells[i].setFocus();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        COConfigurationManager.setParameter("window.maximized", this.shell.getMaximized());
        this.shell.setVisible(false);
        MiniBarManager.getManager().setAllVisible(true);
    }

    private void initSkinListeners() {
        UISkinnableManagerSWT skinnableManagerSWT = UISkinnableManagerSWT.getInstance();
        skinnableManagerSWT.addSkinnableListener(MessageBoxShell.class.toString(), new UISkinnableSWTListener(){

            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                byte[] contentThumbnail;
                Color colorBG = MainWindow.this.skin.getSkinProperties().getColor("color.mainshell");
                Color colorLink = MainWindow.this.skin.getSkinProperties().getColor("color.links.normal");
                Color colorText = MainWindow.this.skin.getSkinProperties().getColor("color.text.fg");
                MessageBoxShell shell = (MessageBoxShell)skinnableObject;
                TOTorrent torrent = null;
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                if (torrent != null && shell.getLeftImage() == null && (contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent)) != null) {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                        final Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                        shell.setLeftImage(img);
                        composite.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (!img.isDisposed()) {
                                    img.dispose();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }

            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        });
        skinnableManagerSWT.addSkinnableListener(MessageSlideShell.class.toString(), new UISkinnableSWTListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                if (skinnableObject instanceof MessageSlideShell) {
                    MessageSlideShell shell;
                    Image image;
                    block8: {
                        image = new Image((Device)composite.getDisplay(), 250, 300);
                        TOTorrent torrent = null;
                        DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                        torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                        shell = (MessageSlideShell)skinnableObject;
                        byte[] contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent);
                        GC gc = new GC((Drawable)image);
                        try {
                            gc.setBackground(gc.getDevice().getSystemColor(22));
                            gc.fillRectangle(image.getBounds());
                            if (contentThumbnail == null) break block8;
                            try {
                                ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                                Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                                Rectangle imgBounds = img.getBounds();
                                double pct = 35.0 / (double)imgBounds.height;
                                int w = (int)((double)imgBounds.width * pct);
                                try {
                                    gc.setAdvanced(true);
                                    gc.setInterpolation(2);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                gc.drawImage(img, 0, 0, imgBounds.width, imgBounds.height, 0, 265, w, 35);
                                img.dispose();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        finally {
                            gc.dispose();
                        }
                    }
                    shell.setImgPopup(image);
                    composite.addListener(12, new Listener(){

                        public void handleEvent(Event event2) {
                            if (!image.isDisposed()) {
                                image.dispose();
                            }
                        }
                    });
                }
            }

            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        });
    }

    private void setChildrenFG(Control parent, Color color) {
        parent.setForeground(color);
        if (parent instanceof Composite) {
            Control[] children = ((Composite)parent).getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control control = children[i];
                if (control instanceof Button && (((Button)control).getStyle() & 0x20) <= 0) continue;
                this.setChildrenFG(control, color);
            }
        }
    }

    private void initWidgets() {
        Class[] forceInits = new Class[]{BuddiesViewer.class, SideBar.class, FriendsToolbar.class};
        String[] forceInitsIDs = new String[]{"buddies-viewer", "sidebar", "toolbar-friends"};
        for (int i = 0; i < forceInits.length; ++i) {
            Class cla = forceInits[i];
            String id = forceInitsIDs[i];
            try {
                SWTSkinObject skinObject = this.skin.getSkinObject(id);
                if (null == skinObject) continue;
                SkinView skinView = (SkinView)cla.newInstance();
                skinView.setMainSkinObject(skinObject);
                skinObject.addListener(skinView);
                continue;
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    private void initWidgets2() {
        SWTSkinObject skinObject = this.skin.getSkinObject("statusbar");
        if (skinObject != null) {
            Composite cArea = (Composite)skinObject.getControl();
            this.statusBar = new MainStatusBar();
            Composite composite = this.statusBar.initStatusBar(cArea);
            composite.setLayoutData((Object)Utils.getFilledFormData());
        }
        if ((skinObject = this.skin.getSkinObject("search-text")) != null) {
            this.attachSearchBox(skinObject);
        }
        if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
            Menu topbarMenu = new Menu((Decorations)this.shell, 8);
            if (COConfigurationManager.getIntParameter("User Mode") > 1) {
                MainMenu.createViewMenuItem(this.skin, topbarMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar", true, -1);
            }
            final MenuItem itemShowText = new MenuItem(topbarMenu, 32);
            Messages.setLanguageText((Widget)itemShowText, "v3.MainWindow.menu.showActionBarText");
            itemShowText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                    if (tb != null) {
                        tb.flipShowText();
                    }
                }
            });
            topbarMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                    if (tb != null) {
                        itemShowText.setSelection(tb.getShowText());
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            skinObject = this.skin.getSkinObject("tabbar");
            if (skinObject != null) {
                this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            }
        }
        new UserAreaUtils(this.skin, this.uiFunctions);
    }

    private void addMenuAndNonTextChildren(Composite parent, Menu menu) {
        parent.setMenu(menu);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                Composite c = (Composite)control;
                this.addMenuAndNonTextChildren(c, menu);
                continue;
            }
            if (control instanceof Text) continue;
            control.setMenu(menu);
        }
    }

    private void attachSearchBox(SWTSkinObject skinObject) {
        SWTSkinObject so;
        Composite cArea = (Composite)skinObject.getControl();
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                MainWindow.this.fixupActionBarSize();
            }
        });
        final Text text = new Text(cArea, 0);
        FormData filledFormData = Utils.getFilledFormData();
        text.setLayoutData((Object)filledFormData);
        text.addListener(11, new Listener(){
            Font lastFont = null;

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                int h = text.getClientArea().height - 2;
                Font font = Utils.getFontWithHeight(text.getFont(), null, h);
                if (font != null) {
                    text.setFont(font);
                    Utils.disposeSWTObjects(new Object[]{this.lastFont});
                    text.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            Text text = (Text)e.widget;
                            text.setFont(null);
                            Utils.disposeSWTObjects(new Object[]{lastFont});
                        }
                    });
                }
            }
        });
        text.setTextLimit(254);
        final String sDefault = MessageText.getString("v3.MainWindow.search.defaultText");
        SWTSkinProperties properties = skinObject.getProperties();
        this.colorSearchTextBG = properties.getColor("color.search.text.bg");
        this.colorSearchTextFG = properties.getColor("color.search.text.fg");
        this.colorSearchTextFGdef = properties.getColor("color.search.text.fg.default");
        if (this.colorSearchTextFGdef != null) {
            text.setForeground(this.colorSearchTextFGdef);
        }
        if (this.colorSearchTextBG != null) {
            text.setBackground(this.colorSearchTextBG);
        }
        text.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Text text = (Text)e.widget;
                if (text.getText().equals(sDefault)) {
                    if (MainWindow.this.colorSearchTextFG != null) {
                        text.setForeground(MainWindow.this.colorSearchTextFG);
                    }
                    text.setText("");
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97) {
                        text.selectAll();
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
                if (text.getText().equals(sDefault)) {
                    if (MainWindow.this.colorSearchTextFG != null) {
                        text.setForeground(MainWindow.this.colorSearchTextFG);
                    }
                    if (event2.character != '\u0000') {
                        text.setText("");
                    }
                    return;
                }
                Text text2 = (Text)event2.widget;
                if (event2.keyCode == 27) {
                    text2.setText("");
                    return;
                }
                if (event2.character == '\r') {
                    MainWindow.doSearch(text2.getText());
                }
            }
        });
        text.setText(sDefault);
        SWTSkinObject searchGo = this.skin.getSkinObject("search-go");
        if (searchGo != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(searchGo);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindow.doSearch(sSearchText);
                }
            });
        }
        if ((so = this.skin.getSkinObject("sidebar-list")) != null && so.getProperties().getBooleanValue(so.getConfigID() + ".resizeSearch", false)) {
            Listener l = new Listener(){

                public void handleEvent(Event event2) {
                    SWTSkinObject soSearchArea = MainWindow.this.skin.getSkinObject("topbar-area-search");
                    if (soSearchArea != null) {
                        Control c = soSearchArea.getControl();
                        Rectangle bounds = ((Control)event2.widget).getBounds();
                        FormData fd = (FormData)c.getLayoutData();
                        int newWidth = bounds.width - 1 - c.getBounds().x;
                        if (bounds.width < 125) {
                            return;
                        }
                        fd.width = newWidth;
                        Utils.relayout(c);
                    }
                }
            };
            so.getControl().addListener(11, l);
        }
        if ((so = this.skin.getSkinObject("search-dropdown")) != null) {
            SWTSkinButtonUtility btnSearchDD = new SWTSkinButtonUtility(so);
            btnSearchDD.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindow.doSearch(sSearchText);
                }
            });
        }
    }

    protected void fixupActionBarSize() {
        Rectangle clientArea = this.shell.getClientArea();
        SWTSkinObject soSearch = this.skin.getSkinObject("topbar-area-search");
        if (soSearch == null) {
            return;
        }
        FormData fd = (FormData)soSearch.getControl().getLayoutData();
        if (fd == null || fd.width <= 0) {
            return;
        }
        if (clientArea.width > 1024 && fd.width == 260) {
            return;
        }
        SWTSkinObject soTabBar = this.skin.getSkinObject("tabbar");
        if (soTabBar == null) {
            return;
        }
        Point size = soTabBar.getControl().computeSize(-1, -1);
        int oldWidth = fd.width;
        fd.width = clientArea.width - (size.x - oldWidth) - 5;
        if (fd.width < 100) {
            fd.width = 100;
        } else if (fd.width > 260) {
            fd.width = 260;
        }
        if (oldWidth != fd.width) {
            ((Composite)soTabBar.getControl()).layout(true, true);
        }
    }

    public static void doSearch(final String sSearchText) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow.doSearch(sSearchText, false);
            }
        });
    }

    public static void doSearch(String sSearchText, boolean toSubscribe) {
        String sDefault = MessageText.getString("v3.MainWindow.search.defaultText");
        if (sSearchText.equals(sDefault) || sSearchText.length() == 0) {
            return;
        }
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        String id = "Search";
        SearchResultsTabArea searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class);
        if (searchClass != null) {
            searchClass.anotherSearch(sSearchText, toSubscribe);
        } else {
            SearchResultsTabArea.SearchQuery sq = new SearchResultsTabArea.SearchQuery();
            sq.term = sSearchText;
            sq.toSubscribe = toSubscribe;
            SideBarEntrySWT entry = sidebar.createEntryFromSkinRef(null, id, "main.area.searchresultstab", sSearchText, null, sq, true, -1);
            if (entry != null) {
                entry.setImageLeftID("image.sidebar.search");
            }
        }
        sidebar.showEntryByID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapTrackUsage(String sTabID) {
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                Long currentLength;
                long newLength;
                if (this.lCurrentTrackTime > 0L && (newLength = (currentLength = (Long)mapTrackUsage.get(sTabID)) == null ? this.lCurrentTrackTime : currentLength + this.lCurrentTrackTime) > 1000L) {
                    mapTrackUsage.put(sTabID, new Long(newLength / 1000L));
                }
                if (this.lCurrentTrackTimeIdle > 0L) {
                    long newLengthIdle;
                    String id = "idle-" + sTabID;
                    Long currentLengthIdle = (Long)mapTrackUsage.get(id);
                    long l = newLengthIdle = currentLengthIdle == null ? this.lCurrentTrackTimeIdle : currentLengthIdle + this.lCurrentTrackTimeIdle;
                    if (newLengthIdle > 1000L) {
                        mapTrackUsage.put(id, new Long(newLengthIdle / 1000L));
                    }
                }
            }
            finally {
                mapTrackUsage_mon.exit();
            }
        }
        this.lCurrentTrackTime = 0L;
        this.lCurrentTrackTimeIdle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUsageStat(String id, long value) {
        if (id == null) {
            return;
        }
        if (id.length() > 150) {
            id = id.substring(0, 150);
        }
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                Long currentLength = (Long)mapTrackUsage.get(id);
                long newLength = currentLength == null ? value : currentLength + value;
                if (newLength > 1000L) {
                    mapTrackUsage.put(id, new Long(newLength / 1000L));
                }
            }
            finally {
                mapTrackUsage_mon.exit();
            }
        }
    }

    private org.gudy.azureus2.ui.swt.mainwindow.MainWindow createOldMainWindow() {
        SkinView skinView;
        if (this.oldMainWindow != null || this.disposedOrDisposing) {
            return this.oldMainWindow;
        }
        SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sideBar != null) {
            sideBar.showEntryByID("Advanced");
        }
        if ((skinView = SkinViewManager.getByClass(SBC_AdvancedView.class)) instanceof SBC_AdvancedView) {
            this.oldMainWindow = ((SBC_AdvancedView)skinView).getOldMainWindow();
        }
        return this.oldMainWindow;
    }

    public org.gudy.azureus2.ui.swt.mainwindow.MainWindow getOldMainWindow(boolean bForceCreate) {
        if (this.oldMW_SB == null && bForceCreate) {
            this.oldMainWindow = this.createOldMainWindow();
        }
        this.oldMainWindow = this.oldMW_SB;
        return this.oldMainWindow;
    }

    public UIFunctionsSWT getOldUIFunctions(boolean bCreateOld) {
        if (this.oldMainWindow == null && bCreateOld) {
            this.createOldMainWindow();
        }
        if (this.oldMainWindow != null) {
            return this.oldMainWindow.getUIFunctions();
        }
        return null;
    }

    public UISWTInstance getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    public void showURL(final String url, String target) {
        SideBar sideBar;
        String id;
        if (url.startsWith("AZMSG%3B")) {
            // empty if block
        }
        if ("_blank".equalsIgnoreCase(target)) {
            Utils.launch(url);
            return;
        }
        if (target.startsWith("tab-")) {
            target = target.substring(4);
        }
        if ((id = (sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class)).showEntryByTabID(target)) == null) {
            Utils.launch(url);
            return;
        }
        SideBarEntrySWT entry = SideBar.getEntry(id);
        entry.addListener(new SideBarOpenListener(){

            public void sideBarEntryOpen(SideBarEntry entry) {
                entry.removeListener(this);
                MainWindow.this.setVisible(true);
                if (!(entry instanceof SideBarEntrySWT)) {
                    return;
                }
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                SWTSkinObjectBrowser soBrowser = SWTSkinUtils.findBrowserSO(entrySWT.getSkinObject());
                if (soBrowser != null) {
                    if (url == null || url.length() == 0) {
                        soBrowser.restart();
                    } else {
                        String fullURL = url;
                        if (UrlFilter.getInstance().urlCanRPC(url)) {
                            fullURL = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                        }
                        soBrowser.setURL(fullURL);
                    }
                }
            }
        });
    }

    protected MainStatusBar getMainStatusBar() {
        return this.statusBar;
    }

    public boolean isVisible(int windowElement) {
        if (windowElement == 2) {
            if (null != this.oldMainWindow) {
                return this.oldMainWindow.isVisible(windowElement);
            }
        } else if (windowElement == 4) {
            SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 5) {
            SWTSkinObject skinObject = this.skin.getSkinObject("tabbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
        return false;
    }

    public void setVisible(int windowElement, boolean value) {
        if (windowElement == 2) {
            if (null != this.oldMainWindow) {
                this.oldMainWindow.setVisible(windowElement, value);
            }
        } else if (windowElement == 4) {
            SWTSkinUtils.setVisibility(this.skin, "pluginbar.visible", "pluginbar", value, true, true);
        } else if (windowElement != 3 && windowElement != 1 && windowElement == 5) {
            SWTSkinUtils.setVisibility(this.skin, "TabBar.visible", "tabbar", value, true, true);
        }
    }

    public Rectangle getMetrics(int windowElement) {
        if (windowElement == 2) {
            if (null != this.oldMainWindow) {
                return this.oldMainWindow.getMetrics(windowElement);
            }
        } else if (windowElement == 4) {
            SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
            if (skinObject != null) {
                return skinObject.getControl().getBounds();
            }
        } else if (windowElement == 5) {
            SWTSkinObject skinObject = this.skin.getSkinObject("tabbar");
            if (skinObject != null) {
                return skinObject.getControl().getBounds();
            }
        } else {
            if (windowElement == 3) {
                return this.statusBar.getBounds();
            }
            if (windowElement == 6) {
                return this.shell.getClientArea();
            }
            if (windowElement == 7) {
                Rectangle r = this.getMetrics(6);
                r.height -= this.getMetrics((int)4).height;
                r.height -= this.getMetrics((int)5).height;
                r.height -= this.getMetrics((int)3).height;
                return r;
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public boolean isReady() {
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateObfusticatedImage() {
        Rectangle clientArea = this.shell.getClientArea();
        Image image = new Image((Device)this.display, clientArea.width, clientArea.height);
        GC gc = new GC((Drawable)this.shell);
        try {
            gc.copyArea(image, clientArea.x, clientArea.y);
            Control[] children = this.shell.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Image obfusticatedImage;
                Control control = children[i];
                SWTSkinObject so = (SWTSkinObject)control.getData("SkinObject");
                if (so == null || (obfusticatedImage = so.generateObfusticatedImage()) == null) continue;
                Rectangle bounds = so.getControl().getBounds();
                gc.drawImage(obfusticatedImage, bounds.x, bounds.y);
            }
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    public void openView(final String parentID, final Class cla, String id, final Object data, final boolean closeable) {
        IView viewFromID;
        int i;
        final SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (id == null && (i = (id = cla.getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        if ((viewFromID = sideBar.getIViewFromID(id)) != null) {
            sideBar.showEntryByID(id);
        }
        final String _id = id;
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (sideBar != null) {
                    if (MainWindow.this.isOnAdvancedView()) {
                        try {
                            IView view = (IView)cla.newInstance();
                            Tab mainTabSet = MainWindow.this.oldMainWindow.getMainTabSet();
                            mainTabSet.createTabItem(view, true);
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    } else {
                        if (sideBar.showEntryByID(_id)) {
                            return;
                        }
                        if (UISWTViewEventListener.class.isAssignableFrom(cla)) {
                            try {
                                UISWTViewEventListener l = (UISWTViewEventListener)cla.newInstance();
                                sideBar.createTreeItemFromEventListener(parentID, null, l, _id, closeable, data);
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        } else {
                            sideBar.createTreeItemFromIViewClass(parentID, _id, null, cla, null, null, data, null, true);
                        }
                        sideBar.showEntryByID(_id);
                    }
                }
            }
        });
    }

    public boolean isOnAdvancedView() {
        SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sideBar == null) {
            return false;
        }
        SideBarEntrySWT currentSB = sideBar.getCurrentEntry();
        if (currentSB == null) {
            return false;
        }
        return this.oldMainWindow != null && currentSB.id != null && currentSB.id.equals("Advanced");
    }

    public void sidebarItemSelected(SideBarEntrySWT newSideBarEntry, SideBarEntrySWT oldSideBarEntry) {
        if (newSideBarEntry == null) {
            return;
        }
        if (mapTrackUsage != null && oldSideBarEntry != null) {
            oldSideBarEntry.removeListener(this);
            String id2 = null;
            SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sidebar != null) {
                id2 = oldSideBarEntry.getLogID();
            }
            if (id2 == null) {
                id2 = oldSideBarEntry.id;
            }
            this.updateMapTrackUsage(id2);
        }
        if (newSideBarEntry.id.equals("Advanced") && this.oldMW_SB == null) {
            SkinView[] advViews = SkinViewManager.getMultiByClass(SBC_AdvancedView.class);
            if (advViews != null) {
                for (int i = 0; i < advViews.length; ++i) {
                    SBC_AdvancedView advView = (SBC_AdvancedView)advViews[i];
                    if (this.oldMW_tab != null && advView.getOldMainWindow() == this.oldMW_tab) continue;
                    this.oldMW_SB = advView.getOldMainWindow();
                }
            }
            this.oldMainWindow = this.oldMW_SB;
        }
        if (mapTrackUsage != null) {
            newSideBarEntry.addListener(this);
        }
    }

    public void sidebarLogIdChanged(SideBarEntrySWT sideBarEntrySWT, String oldID, String newID) {
        if (oldID == null) {
            oldID = "null";
        }
        this.updateMapTrackUsage(oldID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            TableColumnManager.getInstance().generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
        }
    }

    protected void setSelectedLanguageItem() {
        Messages.updateLanguageForControl((Widget)this.shell);
        if (this.systemTraySWT != null) {
            this.systemTraySWT.updateLanguage();
        }
        if (this.statusBar != null) {
            this.statusBar.refreshStatusText();
        }
        this.skin.triggerLanguageChange();
        if (this.statusBar != null) {
            this.statusBar.updateStatusText();
        }
        if (this.menu != null) {
            MenuFactory.updateMenuText(this.menu.getMenu("menu.bar"));
        }
    }

    protected MainMenu getMainMenu() {
        return this.menu;
    }

    static /* synthetic */ DownloadManager[] access$202(MainWindow x0, DownloadManager[] x1) {
        x0.dms_Startup = x1;
        return x1;
    }

    static /* synthetic */ void access$1400(MainWindow x0, Control x1, Color x2) {
        x0.setChildrenFG(x1, x2);
    }
}

