/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.update.FullUpdateWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigShell;
import org.gudy.azureus2.ui.swt.views.DetailedListView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.PeerSuperView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private final Map mapPluginViews = new HashMap();
    private final AEMonitor pluginViews_mon = new AEMonitor("v3.uif.pluginViews");
    private SWTSkin skin = null;

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(PluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void addPluginView(final String viewID, final UISWTViewEventListener l) {
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    PluginsMenuHelper.getInstance().addPluginView(viewID, l);
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void bringToFront() {
        this.bringToFront(true);
    }

    public void bringToFront(final boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    UIFunctionsImpl.this.mainWindow.setVisible(true, tryTricks);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    public void closeDownloadBars() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.closeDownloadBars();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    public void closePluginView(IView view) {
        try {
            SkinView sideBarView;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.closePluginView(view);
            }
            if ((sideBarView = SkinViewManager.getByClass(SideBar.class)) instanceof SideBar) {
                String id;
                SideBar sideBar = (SideBar)sideBarView;
                if (view instanceof UISWTViewImpl) {
                    id = ((UISWTViewImpl)view).getViewID();
                } else {
                    id = view.getClass().getName();
                    int i = id.lastIndexOf(46);
                    if (i > 0) {
                        id = id.substring(i + 1);
                    }
                }
                sideBar.closeEntry(id);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginView", e));
        }
    }

    public void closePluginViews(String sViewID) {
        try {
            SkinView sideBarView;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.closePluginViews(sViewID);
            }
            if ((sideBarView = SkinViewManager.getByClass(SideBar.class)) instanceof SideBar) {
                SideBar sideBar = (SideBar)sideBarView;
                sideBar.closeEntry(sViewID);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginViews", e));
        }
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        try {
            return this.mainWindow.dispose(for_restart, close_already_in_progress);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    public Shell getMainShell() {
        return this.mainWindow.shell;
    }

    public Menu getMenu(int id) {
        return null;
    }

    public UISWTView[] getPluginViews() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return new UISWTView[0];
            }
            return uiFunctions.getPluginViews();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        try {
            return (UISWTInstanceImpl)this.mainWindow.getUISWTInstanceImpl();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getSWTPluginInstanceImpl", e));
            return null;
        }
    }

    public void openPluginView(AbstractIView view, String name) {
        try {
            SideBar sideBar;
            SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
            if (sideBarView instanceof SideBar && (sideBar = (SideBar)sideBarView).createTreeItemFromIView(null, view, name, null, true, true, true) != null) {
                return;
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(PluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        try {
            SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sideBar != null) {
                String sidebarParentID = null;
                if ("MyTorrents".equals(sParentID)) {
                    sidebarParentID = "Library";
                } else if (!"Main".equals(sParentID)) {
                    System.err.println("Can't find parent " + sParentID + " for " + sViewID);
                }
                sideBar.createTreeItemFromEventListener(sidebarParentID, null, l, sViewID, true, dataSource);
                if (bSetFocus) {
                    sideBar.showEntryByID(sViewID);
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(UISWTPluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void refreshIconBar() {
        try {
            ToolBarView tb;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.refreshIconBar();
            }
            if ((tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class)) != null) {
                tb.refreshCoreToolBarItems();
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    public void refreshLanguage() {
        try {
            this.mainWindow.setSelectedLanguageItem();
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.refreshLanguage();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    public void removeManagerView(DownloadManager dm) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.removeManagerView(dm);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removeManagerView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(String viewID) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(viewID);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                PluginsMenuHelper.getInstance().removePluginViews(viewID);
                return;
            }
            uiFunctions.removePluginView(viewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(view);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                PluginsMenuHelper.getInstance().removePluginView(view, view.getPluginViewName());
                return;
            }
            uiFunctions.removePluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    public void setStatusText(String string) {
    }

    public void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
    }

    public MainStatusBar getMainStatusBar() {
        return this.mainWindow.getMainStatusBar();
    }

    public boolean showConfig(String section) {
        try {
            ConfigShell.getInstance().open(section);
            return true;
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showConfig", e));
            return false;
        }
    }

    public void openView(int viewID, Object data) {
        UIFunctionsSWT uiFunctions;
        if (this.mainWindow.isOnAdvancedView() && (uiFunctions = this.mainWindow.getOldUIFunctions(false)) != null) {
            uiFunctions.openView(viewID, data);
            return;
        }
        switch (viewID) {
            case 0: {
                this.mainWindow.openView("Tools", LoggerView.class, null, data, true);
                break;
            }
            case 10: {
                this.mainWindow.openView("Tools", PeerSuperView.class, null, data, true);
                break;
            }
            case 4: {
                this.showConfig(data instanceof String ? (String)data : null);
                break;
            }
            case 5: {
                DownloadManager dm;
                TOTorrent torrent;
                String id = "DMDetails_";
                if (data instanceof DownloadManager && (torrent = (dm = (DownloadManager)data).getTorrent()) != null) {
                    try {
                        id = id + torrent.getHashWrapper().toBase32String();
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                }
                this.mainWindow.openView("Library", ManagerView.class, id, data, true);
                break;
            }
            case 6: {
                this.mainWindow.openView("Library", TorrentOptionsView.class, null, data, true);
                break;
            }
            case 7: {
                this.mainWindow.openView("Library", MySharesView.class, null, data, true);
                break;
            }
            case 8: {
                SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                if (sideBar == null) break;
                sideBar.showEntryByID("Library");
                break;
            }
            case 9: {
                this.mainWindow.openView("Tools", MyTrackerView.class, null, data, true);
                break;
            }
            case 1: {
                this.mainWindow.openView("Tools", StatsView.class, null, data, true);
                break;
            }
            case 11: {
                this.mainWindow.openView("Tools", DetailedListView.class, null, data, true);
                break;
            }
        }
    }

    public UISWTInstance getUISWTInstance() {
        return this.mainWindow.getUISWTInstanceImpl();
    }

    public void viewURL(String url, String target, String sourceRef) {
        ContentNetworkUtils.setSourceRef(target, sourceRef, false);
        this.viewURL(url, target, 0, 0, true, false);
    }

    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http")) {
                    realURL = cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    public boolean viewURL(final String url, final String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http")) {
                    realURL = cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldMainWindowInitialized(org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMainWindow) {
        UIFunctionsSWT uiFunctions = oldMainWindow.getUIFunctions();
        if (uiFunctions == null) {
            return;
        }
        this.pluginViews_mon.enter();
        try {
            for (Object key : this.mapPluginViews.keySet()) {
                if (key instanceof PluginView) {
                    uiFunctions.addPluginView((PluginView)key);
                    continue;
                }
                if (key instanceof UISWTPluginView) {
                    uiFunctions.addPluginView((UISWTPluginView)key);
                    continue;
                }
                if (!(key instanceof String)) continue;
                UISWTViewEventListener value = (UISWTViewEventListener)this.mapPluginViews.get(key);
                uiFunctions.addPluginView((String)key, value);
            }
            this.mapPluginViews.clear();
        }
        finally {
            this.pluginViews_mon.exit();
        }
    }

    public int promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS) {
        return MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS);
    }

    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(this.getMainShell(), title, text, buttons, defaultOption);
        return mb;
    }

    public boolean isGlobalTransferBarShown() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        return AllTransfersBar.getManager().isOpen(AzureusCoreFactory.getSingleton().getGlobalManager());
    }

    public void showGlobalTransferBar() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                AllTransfersBar.open(core.getGlobalManager(), UIFunctionsImpl.this.getMainShell());
            }
        });
    }

    public void closeGlobalTransferBar() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                AllTransfersBar.close(core.getGlobalManager());
            }
        });
    }

    public void refreshTorrentMenu() {
        try {
            if (this.mainWindow.isOnAdvancedView()) {
                UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
                if (uiFunctions != null) {
                    uiFunctions.refreshTorrentMenu();
                }
                return;
            }
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    MenuItem torrentItem = MenuFactory.findMenuItem(UIFunctionsImpl.this.mainWindow.getMainMenu().getMenu("menu.bar"), "MainWindow.menu.torrent");
                    if (null != torrentItem) {
                        DownloadManager[] dms;
                        DownloadManager[] dm_final = dms = SelectedContentManager.getDMSFromSelectedContent();
                        Object tv_final = null;
                        boolean detailed_view_final = false;
                        if (null == dm_final) {
                            torrentItem.setEnabled(false);
                        } else {
                            torrentItem.setData("downloads", (Object)dm_final);
                            torrentItem.setData("TableView", tv_final);
                            torrentItem.setData("is_detailed_view", (Object)false);
                            torrentItem.setEnabled(true);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshTorrentMenu", e));
        }
    }

    public IMainMenu createMainMenu(Shell shell) {
        return new MainMenu(this.getSkin(), shell);
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void setSkin(SWTSkin skin) {
        this.skin = skin;
    }

    public IMainWindow getMainWindow() {
        return this.mainWindow;
    }

    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    public void closeAllDetails() {
        UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
        if (uiFunctions != null) {
            uiFunctions.closeAllDetails();
            return;
        }
        SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
        if (sideBarView instanceof SideBar) {
            SideBar sideBar = (SideBar)sideBarView;
            SideBarEntry[] sideBarEntries = sideBar.getEntries();
            for (int i = 0; i < sideBarEntries.length; ++i) {
                SideBarEntry entry = sideBarEntries[i];
                String id = entry.getId();
                if (id == null || !id.startsWith("DMDetails_")) continue;
                sideBar.closeEntry(id);
            }
        }
    }

    public boolean hasDetailViews() {
        UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
        if (uiFunctions != null) {
            return uiFunctions.hasDetailViews();
        }
        SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
        if (sideBarView instanceof SideBar) {
            SideBar sideBar = (SideBar)sideBarView;
            SideBarEntry[] sideBarEntries = sideBar.getEntries();
            for (int i = 0; i < sideBarEntries.length; ++i) {
                SideBarEntry entry = sideBarEntries[i];
                String id = entry.getId();
                if (id == null || !id.startsWith("DMDetails_")) continue;
                return true;
            }
        }
        return false;
    }

    public void performAction(int action_id, Object args, UIFunctions.actionListener listener) {
        if (action_id == 1) {
            FullUpdateWindow.handleUpdate((String)args, listener);
        } else {
            Debug.out("Unknown action " + action_id);
        }
    }

    public Shell showCoreWaitDlg() {
        Initializer initializer;
        final SkinnedDialog closeDialog = new SkinnedDialog("skin3_dlg_coreloading", "coreloading.body", 67616);
        closeDialog.setTitle(MessageText.getString("dlg.corewait.title"));
        SWTSkin skin = closeDialog.getSkin();
        SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
        final SWTSkinObjectText soWaitTask = (SWTSkinObjectText)skin.getSkinObject("task");
        final SWTSkinObject soWaitProgress = skin.getSkinObject("progress");
        if (soWaitProgress != null) {
            soWaitProgress.getControl().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Control c = (Control)e.widget;
                    Point size = c.getSize();
                    e.gc.setBackground(ColorCache.getColor((Device)e.display, "#0000ff"));
                    Object data = soWaitProgress.getData("progress");
                    if (data instanceof Long) {
                        int waitProgress = ((Long)data).intValue();
                        int breakX = size.x * waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#808080"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                }
            });
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (!AzureusCoreFactory.isCoreRunning() && (initializer = Initializer.getLastInitializer()) != null) {
            initializer.addListener(new InitializerListener(){

                public void reportPercent(final int percent) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (soWaitProgress != null && !soWaitProgress.isDisposed()) {
                                soWaitProgress.setData("progress", new Long(percent));
                                soWaitProgress.getControl().redraw();
                                soWaitProgress.getControl().update();
                            }
                        }
                    });
                    if (percent > 100) {
                        initializer.removeListener(this);
                    }
                }

                public void reportCurrentTask(String currentTask) {
                    if (soWaitTask != null && !soWaitTask.isDisposed()) {
                        soWaitTask.setText(currentTask);
                    }
                }
            });
        }
        if (soButton != null) {
            soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    closeDialog.close();
                }
            });
        }
        closeDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            public void skinDialogClosed(SkinnedDialog dialog) {
            }
        });
        closeDialog.open();
        return closeDialog.getShell();
    }

    public void doSearch(String searchText) {
        MainWindow.doSearch(searchText);
    }
}

