/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.BrowserRpcBuddyListener;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.LightBoxBrowserRequestListener;
import com.aelitis.azureus.ui.swt.browser.listener.StatusListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.browser.listener.publish.PublishListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.util.LocalResourceHTTPServer;
import com.aelitis.azureus.util.UrlFilter;
import java.io.File;
import java.net.URL;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectBrowser
extends SWTSkinObjectBasic
implements LocalHoster {
    private Browser browser;
    private Composite cParent;
    private Composite cArea;
    private String sStartURL;
    private LocalResourceHTTPServer local_publisher;
    private BrowserContext context;
    private String urlToUse;
    private boolean forceVisibleAfterLoad;
    private static boolean doneTheUglySWTFocusHack = false;

    public SWTSkinObjectBrowser(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "browser", parent);
        this.cArea = this.cParent = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.cArea = new Canvas(this.cParent, 262144);
        this.cArea.setLayout((Layout)new FormLayout());
        this.setControl((Control)this.cArea);
        if (this.cParent.isVisible()) {
            this.init();
        } else {
            this.addListener(new SWTSkinObjectListener(){

                public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                    if (eventType == 0) {
                        SWTSkinObjectBrowser.this.removeListener(this);
                        SWTSkinObjectBrowser.this.init();
                    }
                    return null;
                }
            });
        }
    }

    public void init() {
        String url;
        String browserID;
        SWTSkinObject skinObjectIndicator;
        if (this.browser != null && !this.browser.isDisposed()) {
            return;
        }
        try {
            this.browser = new Browser(this.cArea, Utils.getInitialBrowserStyle(0));
            this.browser.setLayoutData((Object)Utils.getFilledFormData());
            this.browser.getParent().layout(true);
        }
        catch (SWTError e) {
            System.err.println("Browser: " + e.toString());
            return;
        }
        if (Constants.isOSX && !doneTheUglySWTFocusHack) {
            doneTheUglySWTFocusHack = true;
            Shell shell = new Shell(this.browser.getDisplay(), 0);
            shell.setSize(1, 1);
            shell.setLocation(-2, -2);
            shell.open();
            shell.close();
            this.browser.setFocus();
        }
        Control widgetIndicator = null;
        String sIndicatorWidgetID = this.properties.getStringValue(this.sConfigID + ".indicator");
        if (sIndicatorWidgetID != null && (skinObjectIndicator = this.skin.getSkinObjectByID(sIndicatorWidgetID)) != null) {
            widgetIndicator = skinObjectIndicator.getControl();
        }
        if ((browserID = this.properties.getStringValue(this.sConfigID + ".view")) == null) {
            browserID = this.sID;
        }
        this.forceVisibleAfterLoad = this.properties.getBooleanValue(this.sConfigID + ".forceVisibleAfterLoad", true);
        this.context = new BrowserContext(browserID, this.browser, widgetIndicator, this.forceVisibleAfterLoad);
        this.context.addMessageListener(new TorrentListener());
        this.context.addMessageListener(new VuzeListener());
        this.context.addMessageListener(new DisplayListener(this.browser));
        this.context.addMessageListener(new ConfigListener(this.browser));
        this.context.addMessageListener(new PublishListener(this.skin.getShell(), this));
        this.context.addMessageListener(new LightBoxBrowserRequestListener());
        this.context.addMessageListener(new StatusListener());
        this.context.addMessageListener(new BrowserRpcBuddyListener());
        this.context.addListener(new BrowserContext.loadingListener(){

            public void browserLoadingChanged(boolean loading, String url) {
                if (loading && SWTSkinObjectBrowser.this.browser.isVisible() && UrlFilter.getInstance().urlCanRPC(url)) {
                    SelectedContentManager.clearCurrentlySelectedContent();
                }
            }
        });
        PublishUtils.setupContext(this.context);
        String string = this.urlToUse != null ? this.urlToUse : (url = this.sStartURL != null ? this.sStartURL : this.properties.getStringValue(this.sConfigID + ".url", (String)null));
        if (url != null) {
            this.setURL(url);
        }
    }

    public Browser getBrowser() {
        if (this.browser == null) {
            this.init();
        }
        return this.browser;
    }

    public void setURL(final String url) {
        this.urlToUse = url;
        if (this.browser == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (url == null) {
                    SWTSkinObjectBrowser.this.browser.setText("");
                } else {
                    ContentNetwork contentNetwork;
                    String urlToUse = url;
                    if (UrlFilter.getInstance().urlCanRPC(url) && (contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(SWTSkinObjectBrowser.this.context.getContentNetworkID())) != null) {
                        urlToUse = contentNetwork.appendURLSuffix(urlToUse, false, true);
                    }
                    if (SWTSkinObjectBrowser.this.browser != null) {
                        SWTSkinObjectBrowser.this.browser.setUrl(urlToUse);
                        if (SWTSkinObjectBrowser.this.browser.isVisible()) {
                            SWTSkinObjectBrowser.this.browser.setFocus();
                        }
                    }
                }
                if (SWTSkinObjectBrowser.this.sStartURL == null) {
                    SWTSkinObjectBrowser.this.sStartURL = url;
                    if (SWTSkinObjectBrowser.this.browser != null) {
                        SWTSkinObjectBrowser.this.browser.setData("StartURL", (Object)url);
                    }
                }
            }
        });
    }

    public void restart() {
        if (null != this.sStartURL) {
            String sRand = "rand=" + SystemTime.getCurrentTime();
            String startURLUnique = this.sStartURL.indexOf("rand=") > 0 ? this.sStartURL.replaceAll("rand=[0-9.]+", sRand) : (this.sStartURL.indexOf(63) > 0 ? this.sStartURL + "&" + sRand : this.sStartURL + "?" + sRand);
            System.out.println(startURLUnique);
            this.setURL(startURLUnique);
        }
    }

    public void layout() {
        this.cParent.layout();
    }

    public void dispose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setVisible(false);
            this.browser.setUrl("about:blank");
        }
        super.dispose();
    }

    public URL hostFile(File f) {
        if (this.local_publisher == null) {
            try {
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                this.local_publisher = new LocalResourceHTTPServer(pi, null);
            }
            catch (Throwable e) {
                Debug.out("Failed to create local resource publisher", e);
                return null;
            }
        }
        try {
            return this.local_publisher.publishResource(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BrowserContext getContext() {
        return this.context;
    }

    public String getStartURL() {
        return this.sStartURL;
    }

    public void setStartURL(String url) {
        this.sStartURL = url;
        if (null != this.browser) {
            if (this.urlToUse == null) {
                this.browser.setUrl(url);
            }
            this.browser.setData("StartURL", (Object)url);
        }
    }

    public boolean isPageLoading() {
        return this.context == null ? false : this.context.isPageLoading();
    }

    public boolean setIsVisible(final boolean visible, boolean walkup) {
        boolean changed = super.setIsVisible(visible, walkup);
        if (changed) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    if (!SWTSkinObjectBrowser.this.isDisposed() && SWTSkinObjectBrowser.this.context != null) {
                        SWTSkinObjectBrowser.this.context.sendBrowserMessage("browser", visible ? "shown" : "hidden");
                    }
                }
            });
        }
        return changed;
    }

    public void addListener(BrowserContext.loadingListener l) {
        if (this.context != null) {
            this.context.addListener(l);
        }
    }

    public void refresh() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectBrowser.this.browser != null && !SWTSkinObjectBrowser.this.browser.isDisposed()) {
                    SWTSkinObjectBrowser.this.browser.refresh();
                }
            }
        });
    }
}

