/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectContainer
extends SWTSkinObjectBasic {
    boolean bPropogate = false;
    boolean bPropogateDown = false;

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "container", parent);
        this.createComposite();
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, type, parent);
        this.triggerListeners(4);
        if (control != null) {
            this.setControl(control);
        }
    }

    private void createComposite() {
        Composite parentComposite;
        int style = 0;
        if (this.properties.getIntValue(this.sConfigID + ".border", 0) == 1) {
            style = 2048;
        }
        if (this.properties.getBooleanValue(this.sConfigID + ".doublebuffer", false)) {
            style |= 0x20000000;
        }
        Object createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        final int minWidth = this.properties.getIntValue(this.sConfigID + ".minwidth", -1);
        if (SWTSkin.DEBUGLAYOUT) {
            System.out.println("linkIDtoParent: Create Composite " + this.sID + " on " + createOn);
            parentComposite = new Group((Composite)createOn, style);
            ((Group)parentComposite).setText(this.sConfigID == null ? this.sID : this.sConfigID);
            parentComposite.setData("DEBUG", (Object)"1");
        } else {
            parentComposite = new Composite((Composite)createOn, style){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    Point size = super.computeSize(wHint, hHint, changed);
                    if (this.getChildren().length == 0 && (size.x == 64 || size.y == 64)) {
                        Object ld = this.getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            if (fd.width != 0 && fd.height != 0) {
                                Rectangle trim = this.computeTrim(0, 0, fd.width, fd.height);
                                return new Point(trim.width, trim.height);
                            }
                        }
                        return new Point(1, 1);
                    }
                    if (minWidth > 0 && size.x < minWidth) {
                        size.x = minWidth;
                    }
                    return size;
                }

                public Point computeSize(int wHint, int hHint) {
                    Point size = super.computeSize(wHint, hHint);
                    if (this.getChildren().length == 0 && (size.x == 64 || size.y == 64)) {
                        Object ld = this.getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            if (fd.width != 0 && fd.height != 0) {
                                Rectangle trim = this.computeTrim(0, 0, fd.width, fd.height);
                                return new Point(trim.width, trim.height);
                            }
                        }
                        return new Point(1, 1);
                    }
                    if (minWidth > 0 && size.x < minWidth) {
                        size.x = minWidth;
                    }
                    return size;
                }
            };
        }
        parentComposite.setLayout((Layout)new FormLayout());
        this.control = parentComposite;
        this.setControl(this.control);
    }

    public void setControl(Control control) {
        this.bPropogateDown = this.properties.getIntValue(this.sConfigID + ".propogateDown", 1) == 1;
        super.setControl(control);
    }

    protected void setViewID(String viewID) {
        super.setViewID(viewID);
        if (SWTSkin.DEBUGLAYOUT && this.control != null) {
            ((Group)this.control).setText("[" + viewID + "]");
        }
    }

    public SWTSkinObject[] getChildren() {
        if (this.isDisposed()) {
            return new SWTSkinObject[0];
        }
        SWTSkinObject[] so = (SWTSkinObject[])Utils.execSWTThreadWithObject("getChildren", new AERunnableObject(){

            public Object runSupport() {
                if (SWTSkinObjectContainer.this.control.isDisposed()) {
                    return new SWTSkinObject[0];
                }
                Control[] swtChildren = ((Composite)SWTSkinObjectContainer.this.control).getChildren();
                ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>(swtChildren.length);
                for (int i = 0; i < swtChildren.length; ++i) {
                    Control childControl = swtChildren[i];
                    SWTSkinObject so = (SWTSkinObject)childControl.getData("SkinObject");
                    if (so == null) continue;
                    list.add(so);
                }
                return list.toArray(new SWTSkinObject[list.size()]);
            }
        }, 2000L);
        if (so == null) {
            System.err.println("Tell Tux to fix this " + Debug.getCompressedStackTrace());
            return this.oldgetChildren();
        }
        return so;
    }

    public SWTSkinObject[] oldgetChildren() {
        String[] widgets = this.properties.getStringArray(this.sConfigID + ".widgets");
        if (widgets == null) {
            return new SWTSkinObject[0];
        }
        ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>();
        for (int i = 0; i < widgets.length; ++i) {
            String id = widgets[i];
            SWTSkinObject skinObject = this.skin.getSkinObjectByID(id, this);
            if (skinObject == null) continue;
            list.add(skinObject);
        }
        SWTSkinObject[] objects = new SWTSkinObject[list.size()];
        objects = list.toArray(objects);
        return objects;
    }

    public Composite getComposite() {
        return (Composite)this.control;
    }

    public String switchSuffix(final String suffix, final int level, boolean walkUp, boolean walkDown) {
        String sFullsuffix = super.switchSuffix(suffix, level, walkUp, walkDown);
        if (this.bPropogateDown && walkDown && suffix != null && this.control != null && !this.control.isDisposed()) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTSkinObject[] children = SWTSkinObjectContainer.this.getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        children[i].switchSuffix(suffix, level, false);
                    }
                }
            });
        }
        return sFullsuffix;
    }

    public void setPropogation(boolean propogate) {
        this.bPropogate = propogate;
        if (SWTSkin.DEBUGLAYOUT) {
            ((Group)this.control).setText(((Group)this.control).getText() + (this.bPropogate ? ";P" : ""));
        }
    }

    public boolean getPropogation() {
        return this.bPropogate;
    }

    public void setDebugAndChildren(boolean b) {
        this.setDebug(true);
        SWTSkinObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof SWTSkinObjectContainer) {
                ((SWTSkinObjectContainer)children[i]).setDebugAndChildren(b);
                continue;
            }
            children[i].setDebug(b);
        }
    }

    protected boolean setIsVisible(boolean visible, boolean walkup) {
        boolean changed = super.setIsVisible(visible, walkup);
        if (changed) {
            // empty if block
        }
        SWTSkinObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            SWTSkinObjectBasic child;
            Control childControl;
            if (!(children[i] instanceof SWTSkinObjectBasic) || (childControl = (child = (SWTSkinObjectBasic)children[i]).getControl()) == null || childControl.isDisposed()) continue;
            child.setIsVisible(childControl.isVisible(), false);
        }
        return changed;
    }
}

