/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.text.NumberFormat;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectSash
extends SWTSkinObjectBasic {
    private static final boolean FASTDRAG = true;
    protected String sControlBefore;
    protected String sControlAfter;
    private int resizeContainerAboveMin = -1;
    boolean ignoreContainerAboveMin = false;
    private Composite createOn;
    private final boolean isVertical;
    private Sash sash;
    Point lastSize = new Point(0, 0);
    private Composite parentComposite;
    private Composite above = null;
    private int aboveMin = 0;
    private Composite below = null;
    private int belowMin = 0;
    private double sashPct;
    private boolean noresize = false;
    private String sBorder;

    public SWTSkinObjectSash(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent, final boolean bVertical) {
        super(skin, properties, sID, sConfigID, "sash", parent);
        int style;
        this.isVertical = bVertical;
        int n = style = bVertical ? 512 : 256;
        if (typeParams.length > 2) {
            this.sControlBefore = typeParams[1];
            this.sControlAfter = typeParams[2];
        }
        this.createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        if (this.createOn == null || this.createOn.isDisposed()) {
            Debug.out("Can not create " + sID + " because parent is null or disposed");
            return;
        }
        this.sash = new Sash(this.createOn, style);
        this.noresize = properties.getBooleanValue(sConfigID + ".noresize", false);
        String sMinContainerPos = properties.getStringValue(sConfigID + ".resize.container.min");
        if (sMinContainerPos != null) {
            try {
                this.resizeContainerAboveMin = NumberFormat.getInstance().parse(sMinContainerPos).intValue();
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        int splitAt = COConfigurationManager.getIntParameter("v3." + sID + ".splitAt", -1);
        int splitAtPX = COConfigurationManager.getIntParameter("v3." + sID + ".splitAtPX", -1);
        if (this.noresize && splitAtPX >= 0) {
            if (splitAtPX < this.resizeContainerAboveMin) {
                splitAtPX = this.resizeContainerAboveMin;
            }
            this.sash.setData("PX", (Object)new Long(splitAtPX));
        } else if (!this.noresize && splitAt >= 0) {
            this.sashPct = (double)splitAt / 10000.0;
            if (this.sashPct > 1.0) {
                this.sashPct = 1.0;
            } else if (this.sashPct < 0.0) {
                this.sashPct = 0.0;
            }
            this.sash.setData("PCT", (Object)new Double(this.sashPct));
        } else {
            String sPos = properties.getStringValue(sConfigID + ".startpos");
            if (sPos != null) {
                try {
                    long l = NumberFormat.getInstance().parse(sPos).longValue();
                    if (sPos.endsWith("%")) {
                        this.sashPct = (double)l / 100.0;
                        this.sash.setData("PCT", (Object)new Double(this.sashPct));
                    } else {
                        this.sash.setData("PX", (Object)new Long(l));
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        this.parentComposite = this.createOn;
        SWTSkinObject soInitializeSashAfterCreated = parent == null ? this : parent;
        soInitializeSashAfterCreated.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 4) {
                    SWTSkinObjectSash.this.initialize();
                }
                return null;
            }
        });
        String sDblClick = properties.getStringValue(sConfigID + ".dblclick");
        if (sDblClick != null) {
            final int dir = (sDblClick = sDblClick.toLowerCase()).equals("left") ? 16384 : 131072;
            this.sash.addListener(8, new Listener(){

                public void handleEvent(Event e) {
                    if (SWTSkinObjectSash.this.below == null || SWTSkinObjectSash.this.above == null) {
                        return;
                    }
                    Double oldPCT = (Double)SWTSkinObjectSash.this.sash.getData("PCT");
                    if (oldPCT == null) {
                        oldPCT = new Double(-1.0);
                    }
                    double pct = dir == 16384 ? (oldPCT == 1.0 ? 0.0 : 1.0) : (oldPCT == 0.0 ? 1.0 : 0.0);
                    SWTSkinObjectSash.this.setPercent(pct, (Control)SWTSkinObjectSash.this.sash, SWTSkinObjectSash.this.above, SWTSkinObjectSash.this.below, bVertical, (Control)SWTSkinObjectSash.this.parentComposite, SWTSkinObjectSash.this.aboveMin, SWTSkinObjectSash.this.belowMin);
                    SWTSkinObjectSash.this.above.getParent().layout();
                }
            });
        }
        this.sBorder = properties.getStringValue(sConfigID + ".border", (String)null);
        if (this.sBorder != null) {
            this.sash.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(e.gc.getDevice().getSystemColor(18));
                    Point size = SWTSkinObjectSash.this.sash.getSize();
                    if (bVertical) {
                        e.gc.drawLine(0, 0, 0, size.y);
                        if (!SWTSkinObjectSash.this.sBorder.startsWith("thin-top")) {
                            int x = size.x - 1;
                            e.gc.drawLine(x, 0, x, 0 + size.y);
                        }
                    } else {
                        e.gc.drawLine(0, 0, 0 + size.x, 0);
                        if (!SWTSkinObjectSash.this.sBorder.startsWith("thin-top")) {
                            int y = size.y - 1;
                            e.gc.drawLine(0, y, 0 + size.x, y);
                        }
                    }
                }
            });
        }
        this.setControl((Control)this.sash);
    }

    protected void initialize() {
        SWTSkinObject skinObject = this.skin.getSkinObjectByID(this.sControlBefore);
        if (skinObject != null) {
            this.above = (Composite)skinObject.getControl();
            this.aboveMin = skinObject.getProperties().getIntValue(this.getConfigID() + ".above" + (this.isVertical ? ".minwidth" : ".minheight"), 0);
        }
        if ((skinObject = this.skin.getSkinObjectByID(this.sControlAfter)) != null) {
            this.below = (Composite)skinObject.getControl();
        }
        if (this.below == null) {
            return;
        }
        this.belowMin = skinObject.getProperties().getIntValue(this.getConfigID() + ".below" + (this.isVertical ? ".minwidth" : ".minheight"), 0);
        Listener l = new Listener(){
            private boolean skipResize = false;

            public void handleEvent(Event e) {
                if (e.type == 4) {
                    if (e.button == 2 || e.button == 3 && (e.stateMask & SWT.MOD1) > 0) {
                        String sPos = SWTSkinObjectSash.this.properties.getStringValue(SWTSkinObjectSash.this.sConfigID + ".startpos");
                        if (sPos == null) {
                            return;
                        }
                        try {
                            long l = NumberFormat.getInstance().parse(sPos).longValue();
                            if (sPos.endsWith("%")) {
                                SWTSkinObjectSash.this.sashPct = (double)l / 100.0;
                                SWTSkinObjectSash.this.sash.setData("PCT", (Object)new Double(SWTSkinObjectSash.this.sashPct));
                            } else {
                                SWTSkinObjectSash.this.sash.setData("PX", (Object)new Long(l));
                                SWTSkinObjectSash.this.sash.setData("PCT", null);
                            }
                            e.type = 22;
                        }
                        catch (Exception ex) {
                            Debug.out(ex);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (e.type == 11 && this.skipResize) {
                    return;
                }
                if (e.type == 11 || e.type == 22) {
                    SWTSkinObjectSash.this.handleShowResize(e);
                } else if (e.type == 13) {
                    double d;
                    double aboveNewSize;
                    int excess;
                    this.skipResize = true;
                    if (e.detail == 1) {
                        return;
                    }
                    Rectangle area = SWTSkinObjectSash.this.parentComposite.getBounds();
                    FormData aboveData = (FormData)SWTSkinObjectSash.this.above.getLayoutData();
                    FormData belowData = (FormData)SWTSkinObjectSash.this.below.getLayoutData();
                    if (SWTSkinObjectSash.this.isVertical) {
                        aboveData.width = e.x - SWTSkinObjectSash.this.above.getBorderWidth();
                        if (aboveData.width < SWTSkinObjectSash.this.aboveMin) {
                            aboveData.width = SWTSkinObjectSash.this.aboveMin;
                            e.x = SWTSkinObjectSash.this.aboveMin;
                        } else {
                            excess = area.width - SWTSkinObjectSash.this.above.getBorderWidth() * 2 - ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().x;
                            if (excess - aboveData.width < SWTSkinObjectSash.this.belowMin) {
                                aboveData.width = excess - SWTSkinObjectSash.this.belowMin;
                                e.doit = false;
                            }
                        }
                        SWTSkinObjectSash.this.ignoreContainerAboveMin = aboveData.width < SWTSkinObjectSash.this.resizeContainerAboveMin;
                    } else {
                        aboveData.height = e.y - SWTSkinObjectSash.this.above.getBorderWidth();
                        if (aboveData.height < SWTSkinObjectSash.this.aboveMin) {
                            aboveData.height = SWTSkinObjectSash.this.aboveMin;
                            e.y = SWTSkinObjectSash.this.aboveMin;
                        } else {
                            excess = area.height - SWTSkinObjectSash.this.above.getBorderWidth() * 2 - ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().y;
                            if (excess - aboveData.height < SWTSkinObjectSash.this.belowMin) {
                                aboveData.height = excess - SWTSkinObjectSash.this.belowMin;
                                e.doit = false;
                            }
                        }
                    }
                    SWTSkinObjectSash.this.parentComposite.layout(true);
                    if (SWTSkinObjectSash.this.isVertical) {
                        aboveNewSize = (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).above.getBounds().width + (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().x / 2.0;
                        d = aboveNewSize / (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).parentComposite.getBounds().width;
                    } else {
                        aboveNewSize = (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).above.getBounds().height + (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().y / 2.0;
                        d = aboveNewSize / (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).parentComposite.getBounds().height;
                    }
                    SWTSkinObjectSash.this.sashPct = SWTSkinObjectSash.this.ensureVisibilityStates(d, SWTSkinObjectSash.this.above, SWTSkinObjectSash.this.below, SWTSkinObjectSash.this.isVertical);
                    SWTSkinObjectSash.this.sash.setData("PCT", (Object)new Double(SWTSkinObjectSash.this.sashPct));
                    if (SWTSkinObjectSash.this.noresize) {
                        SWTSkinObjectSash.this.sash.setData("PX", (Object)new Long((long)aboveNewSize));
                    }
                    if (e.detail != 1) {
                        COConfigurationManager.setParameter("v3." + SWTSkinObjectSash.this.sID + ".splitAt", (int)(SWTSkinObjectSash.this.sashPct * 10000.0));
                    }
                    this.skipResize = false;
                }
            }
        };
        if (!this.noresize) {
            this.createOn.addListener(11, l);
        }
        this.sash.addListener(13, l);
        this.sash.addListener(4, l);
        this.sash.getShell().addListener(22, l);
        Event event2 = new Event();
        event2.type = 22;
        this.handleShowResize(event2);
    }

    public void dispose() {
        Long px;
        if (this.noresize && (px = (Long)this.sash.getData("PX")) != null && px != 0L) {
            COConfigurationManager.setParameter("v3." + this.sID + ".splitAtPX", px);
        }
        super.dispose();
    }

    protected void handleShowResize(Event e) {
        Point size;
        if (!this.createOn.isVisible() && e.type != 22) {
            return;
        }
        Double l = (Double)this.sash.getData("PCT");
        Long px = (Long)this.sash.getData("PX");
        if (this.noresize && px == null && e.type != 22) {
            size = this.createOn.getSize();
            size.x -= this.createOn.getBorderWidth() * 2;
            size.x -= this.sash.getSize().x;
            px = new Long((long)((double)size.x * l));
            this.sash.setData("PX", (Object)px);
        }
        if (!(l == null || this.noresize && e.type != 22)) {
            size = this.createOn.getSize();
            if (this.isVertical && size.x == this.lastSize.x) {
                return;
            }
            if (!this.isVertical && size.y == this.lastSize.y) {
                return;
            }
            this.lastSize = size;
            this.setPercent(l, (Control)this.sash, this.above, this.below, this.isVertical, (Control)this.parentComposite, this.aboveMin, this.belowMin);
        } else if (px != null) {
            int i;
            int n = i = this.isVertical ? this.parentComposite.getSize().x : this.parentComposite.getSize().y;
            if (i == 0) {
                return;
            }
            double pctAbove = px.doubleValue() / (double)i;
            FormData aboveData = (FormData)this.above.getLayoutData();
            if (aboveData == null) {
                aboveData = Utils.getFilledFormData();
                this.above.setLayoutData((Object)aboveData);
            }
            if (this.isVertical) {
                int parentWidth = this.parentComposite.getBounds().width;
                aboveData.width = (int)((double)parentWidth * pctAbove);
                if (parentWidth - aboveData.width < this.aboveMin) {
                    aboveData.width = parentWidth - this.aboveMin;
                }
                if (this.noresize) {
                    this.sash.setData("PX", (Object)new Long(aboveData.width));
                }
            } else {
                int parentHeight = this.parentComposite.getBounds().height;
                aboveData.height = (int)((double)parentHeight * pctAbove);
                if (parentHeight - aboveData.width < this.aboveMin) {
                    aboveData.height = parentHeight - this.aboveMin;
                }
                if (this.noresize) {
                    this.sash.setData("PX", (Object)new Long(aboveData.height));
                }
            }
            if (pctAbove >= 0.0 && pctAbove <= 1.0) {
                this.sashPct = pctAbove;
                this.sash.setData("PCT", (Object)new Double(pctAbove));
            }
            boolean bl = this.ignoreContainerAboveMin = px < (long)this.resizeContainerAboveMin;
        }
        if (e.type == 22) {
            this.parentComposite.layout(true);
        }
    }

    public void setPercent(double pct) {
        this.setPercent(pct, (Control)this.sash, this.above, this.below, this.isVertical, (Control)this.parentComposite, this.aboveMin, this.belowMin);
    }

    public double getPercent() {
        if (this.noresize) {
            Long px = (Long)this.sash.getData("PX");
            int i = this.isVertical ? this.parentComposite.getSize().x : this.parentComposite.getSize().y;
            return px.doubleValue() / (double)i;
        }
        return this.sashPct;
    }

    protected void setPercent(double pctAbove, Control sash, Composite above, Composite below, boolean bVertical, Control parentComposite, int minAbove, int belowMin) {
        FormData aboveData = (FormData)above.getLayoutData();
        if (aboveData == null) {
            return;
        }
        boolean layoutNeeded = false;
        if (bVertical) {
            int parentWidth = parentComposite.getBounds().width - parentComposite.getBorderWidth() * 2 - sash.getSize().x;
            int newWidth = (int)((double)parentWidth * pctAbove);
            if (newWidth != aboveData.width) {
                aboveData.width = newWidth;
                layoutNeeded = true;
            }
            if (!this.ignoreContainerAboveMin && this.resizeContainerAboveMin > 0 && pctAbove != 0.0 && pctAbove != 1.0) {
                minAbove = Math.max(this.resizeContainerAboveMin, minAbove);
            }
            if (pctAbove != 0.0 && parentWidth - aboveData.width - sash.getSize().x < minAbove) {
                aboveData.width = parentWidth - minAbove - sash.getSize().x;
                layoutNeeded = true;
            } else if (aboveData.width < belowMin) {
                layoutNeeded = true;
                aboveData.width = belowMin;
            } else {
                boolean bl = this.ignoreContainerAboveMin = aboveData.width <= this.resizeContainerAboveMin;
            }
            if (this.noresize) {
                sash.setData("PX", (Object)new Long(aboveData.width));
            }
        } else {
            int parentHeight = parentComposite.getBounds().height - parentComposite.getBorderWidth() * 2 - sash.getSize().y;
            int newHeight = (int)((double)parentHeight * pctAbove);
            if (aboveData.height != newHeight) {
                aboveData.height = newHeight;
                layoutNeeded = true;
            }
            if (pctAbove != 0.0 && parentHeight - aboveData.height < minAbove && parentHeight >= minAbove) {
                aboveData.height = parentHeight - minAbove;
                layoutNeeded = true;
            } else if (aboveData.height < belowMin) {
                layoutNeeded = true;
                aboveData.height = belowMin;
            }
            if (this.noresize) {
                sash.setData("PX", (Object)new Long(aboveData.height));
            }
        }
        if (layoutNeeded) {
            above.getParent().layout();
        }
        pctAbove = this.ensureVisibilityStates(pctAbove, above, below, bVertical);
        sash.setData("PCT", (Object)new Double(pctAbove));
        this.sashPct = pctAbove;
        if (this.sashPct != 0.0 && this.sashPct != 100.0) {
            COConfigurationManager.setParameter("v3." + this.sID + ".splitAt", (int)(pctAbove * 10000.0));
        }
    }

    private double ensureVisibilityStates(double pct, Composite above, Composite below, boolean bVertical) {
        int sizeAbove;
        if (pct > 1.0) {
            pct = 1.0;
        } else if (pct < 0.0) {
            pct = 0.0;
        }
        int sizeBelow = bVertical ? below.getSize().x : below.getSize().y;
        int n = sizeAbove = bVertical ? above.getSize().x : above.getSize().y;
        if ((pct == 1.0 || sizeBelow <= 1) && below != null && below.getVisible()) {
            below.setVisible(false);
            below.setData("SashSetVisibility", (Object)new Boolean(true));
        } else if (below != null && !below.isVisible() && below.getData("SashSetVisibility") != null) {
            below.setVisible(true);
            below.setData("SashSetVisibility", null);
        }
        if ((pct == 0.0 || sizeAbove <= 1) && above != null && above.getVisible()) {
            above.setVisible(false);
            above.setData("SashSetVisibility", (Object)new Boolean(true));
        } else if (above != null && !above.isVisible() && above.getData("SashSetVisibility") != null) {
            above.setVisible(true);
            above.setData("SashSetVisibility", null);
        }
        return pct;
    }

    public void setBelowPX(int px) {
        double sashHeight = this.sash.getSize().y;
        double parentHeight = this.parentComposite.getBounds().height - this.parentComposite.getBorderWidth() * 2;
        double want = parentHeight - sashHeight - (double)px;
        double pct = want / parentHeight;
        this.setPercent(pct);
    }
}

