/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.skin.SkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.LightHashMap;

public class SWTSkinPropertiesImpl
extends SkinPropertiesImpl
implements SWTSkinProperties {
    private static Map colorMap = new LightHashMap();

    public SWTSkinPropertiesImpl(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        super(classLoader, skinPath, mainSkinFile);
    }

    public SWTSkinPropertiesImpl() {
    }

    public Color getColor(String sID) {
        Color color;
        if (colorMap.containsKey(sID)) {
            return (Color)colorMap.get(sID);
        }
        try {
            int[] rgb = this.getColorValue(sID);
            color = rgb[0] > -1 ? ColorCache.getColor((Device)Display.getCurrent(), rgb[0], rgb[1], rgb[2]) : ColorCache.getColor((Device)Display.getCurrent(), this.getStringValue(sID));
        }
        catch (Exception e) {
            color = null;
        }
        colorMap.put(sID, color);
        return color;
    }

    public Color getColor(String name, Color def) {
        Color color = this.getColor(name);
        if (color == null) {
            return def;
        }
        return color;
    }
}

