/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinLayoutCompleteListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinTabSet {
    private Listener tabMouseListener;
    private final SWTSkin skin;
    private final String sID;
    private SWTSkinObjectTab activeTab;
    private List tabs;
    private ArrayList listeners = new ArrayList();

    public SWTSkinTabSet(SWTSkin skin, String sID) {
        this.sID = sID;
        this.skin = skin;
        this.tabs = new ArrayList();
    }

    public void addTab(final SWTSkinObjectTab tab) {
        this.tabs.add(tab);
        tab.setTabset(this);
        this.addMouseListener(tab, tab.getControl());
        this.skin.addListener(new SWTSkinLayoutCompleteListener(){

            public void skinLayoutCompleted() {
                SWTSkinTabSet.this.setTabVisible(tab, SWTSkinTabSet.this.activeTab == tab, null);
            }
        });
    }

    public SWTSkinObjectTab getActiveTab() {
        return this.activeTab;
    }

    public SWTSkinObjectTab[] getTabs() {
        return this.tabs.toArray(new SWTSkinObjectTab[0]);
    }

    public SWTSkinObjectTab getTabByID(String sID) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
            String sTabID = tab.getSkinObjectID();
            if (!sTabID.equals(sID)) continue;
            return tab;
        }
        return null;
    }

    public SWTSkinObjectTab getTab(String sViewID) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
            String sTabViewID = tab.getViewID();
            if (!sTabViewID.equals(sViewID)) continue;
            return tab;
        }
        return null;
    }

    public boolean setActiveTabByID(String sID) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            String sTabID;
            SWTSkinObject tab = (SWTSkinObject)this.tabs.get(i);
            if (!(tab instanceof SWTSkinObjectTab) || !(sTabID = tab.getSkinObjectID()).equals(sID)) continue;
            this.setActiveTab((SWTSkinObjectTab)tab);
            return true;
        }
        return false;
    }

    public boolean setActiveTab(String viewID) {
        SWTSkinObject skinObject = this.skin.getSkinObject(viewID);
        if (skinObject == null) {
            return false;
        }
        return this.skin.activateTab(skinObject) != null;
    }

    public void setActiveTab(SWTSkinObjectTab newTab) {
        this.setActiveTab(newTab, false);
    }

    private void setActiveTab(final SWTSkinObjectTab newTab, final boolean evenIfSame) {
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                Shell shell = SWTSkinTabSet.this.skin.getShell();
                Cursor cursor = shell.getCursor();
                try {
                    shell.setCursor(shell.getDisplay().getSystemCursor(1));
                    SWTSkinTabSet.this.swtSetActiveTab(newTab, evenIfSame);
                }
                finally {
                    shell.setCursor(cursor);
                }
            }
        });
    }

    protected void swtSetActiveTab(SWTSkinObjectTab newTab, boolean evenIfSame) {
        String sOldID;
        if (!this.tabs.contains(newTab)) {
            System.err.println("Not contain in " + this.sID + ": " + newTab);
            return;
        }
        String string = sOldID = this.activeTab == null ? "" : this.activeTab.getSkinObjectID();
        if (newTab != this.activeTab) {
            SWTSkinObject[] objects = this.setTabVisible(newTab, true, null);
            if (this.activeTab != null) {
                this.setTabVisible(this.activeTab, false, objects);
            }
            this.activeTab = newTab;
        } else if (!evenIfSame) {
            return;
        }
        String sConfigID = this.activeTab.getConfigID();
        String sNewID = this.activeTab.getSkinObjectID();
        SWTSkinObject parent = this.skin.getSkinObject(this.activeTab.getProperties().getStringValue(sConfigID + ".activate"));
        if (parent != null) {
            parent.getControl().setFocus();
        }
        if (Constants.isOSX) {
            boolean bHasSkinBrowser = false;
            SWTSkinObject[] activeWidgets = this.activeTab.getActiveWidgets(true);
            for (int i = 0; i < activeWidgets.length; ++i) {
                SWTSkinObject skinObject = activeWidgets[i];
                if (!this.hasSkinBrowser(skinObject)) continue;
                bHasSkinBrowser = true;
                break;
            }
            if (bHasSkinBrowser) {
                Shell shell = this.activeTab.getControl().getShell();
                Point size = shell.getSize();
                --size.x;
                shell.setSize(size);
                ++size.x;
                shell.setSize(size);
            }
        }
        this.triggerChangeListener(sOldID, sNewID);
    }

    private boolean hasSkinBrowser(SWTSkinObject skinObject) {
        if (skinObject instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children = ((SWTSkinObjectContainer)skinObject).getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTSkinObject object = children[i];
                if (!this.hasSkinBrowser(object)) continue;
                return true;
            }
        }
        return skinObject instanceof SWTSkinObjectBrowser;
    }

    private void triggerChangeListener(String oldID, String newID) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            try {
                SWTSkinTabSetListener l = (SWTSkinTabSetListener)iter.next();
                l.tabChanged(this, oldID, newID);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void addMouseListener(SWTSkinObject tab, Control control) {
        if (this.tabMouseListener == null) {
            this.tabMouseListener = new Listener(){
                boolean bDownPressed = false;

                public void handleEvent(Event event2) {
                    if (event2.type == 3) {
                        this.bDownPressed = true;
                        return;
                    }
                    if (!this.bDownPressed) {
                        return;
                    }
                    this.bDownPressed = false;
                    Control control = (Control)event2.widget;
                    SWTSkinTabSet.this.setActiveTab((SWTSkinObjectTab)control.getData("Tab"), true);
                }
            };
        }
        control.setData("Tab", (Object)tab);
        control.addListener(4, this.tabMouseListener);
        control.addListener(3, this.tabMouseListener);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.addMouseListener(tab, children[i]);
            }
        }
    }

    private SWTSkinObject[] setTabVisible(SWTSkinObjectTab tab, boolean visible, SWTSkinObject[] skipObjects) {
        String sSkinID = tab.getSkinObjectID();
        SWTSkinObject soTabContent = this.skin.getSkinObjectByID(sSkinID);
        if (soTabContent == null) {
            return null;
        }
        String suffix = visible ? "-selected" : "";
        soTabContent.switchSuffix(suffix, 1, true);
        SWTSkinObject[] activeWidgets = tab.getActiveWidgets(visible);
        for (int i = 0; i < activeWidgets.length; ++i) {
            SWTSkinObject skinObject = activeWidgets[i];
            boolean ok = true;
            if (skipObjects != null) {
                for (int j = 0; j < skipObjects.length; ++j) {
                    if (!skinObject.equals(skipObjects[j])) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            if (visible) {
                skinObject.setDefaultVisibility();
                continue;
            }
            skinObject.setVisible(visible);
        }
        tab.triggerListeners(2);
        return activeWidgets;
    }

    public void addListener(SWTSkinTabSetListener listener) {
        this.listeners.add(listener);
    }

    public String getID() {
        return this.sID;
    }

    protected static String[] getTemplateInfo(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        SWTSkinProperties skinProperties = skin.getSkinProperties();
        String sID = skinObject.getConfigID() + ".view.template." + sTemplateKey;
        return skinProperties.getStringArray(sID);
    }

    protected static String getTemplateID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo2 = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo2 != null) {
            return templateInfo2[0];
        }
        return null;
    }

    public static String getTabSetID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo2 = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo2 != null && templateInfo2.length > 1) {
            return templateInfo2[1];
        }
        return null;
    }
}

