/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnablerSelectedContent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.IconBarEnabler;

public class SubscriptionSelectedContent
extends ToolBarEnablerSelectedContent
implements ISelectedVuzeFileContent {
    private Subscription subs;
    private TOTorrent torrent;

    protected SubscriptionSelectedContent(IconBarEnabler _enabler, Subscription _subs) {
        super(_enabler);
        this.subs = _subs;
    }

    public String getDisplayName() {
        return MessageText.getString("subscriptions.column.name") + ": " + this.subs.getName();
    }

    public String getHash() {
        return this.subs.getID();
    }

    public VuzeFile getVuzeFile() {
        try {
            return this.subs.getVuzeFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TOTorrent getTorrent() {
        SubscriptionSelectedContent subscriptionSelectedContent = this;
        synchronized (subscriptionSelectedContent) {
            if (this.torrent == null) {
                try {
                    VuzeFile vf = this.subs.getVuzeFile();
                    File f1 = AETemporaryFileHandler.createTempFile();
                    File f = new File(f1.getParent(), "Update Vuze to access this share_" + f1.getName());
                    f1.delete();
                    try {
                        vf.write(f);
                        TOTorrentCreator cr = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(f, new URL("dht://"));
                        TOTorrent temp = cr.create();
                        Map vuze_map = vf.exportToMap();
                        Map torrent_map = temp.serialiseToMap();
                        torrent_map.putAll(vuze_map);
                        this.torrent = TOTorrentFactory.deserialiseFromMap(torrent_map);
                    }
                    finally {
                        f.delete();
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return this.torrent;
    }
}

