/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import com.aelitis.azureus.util.ContentNetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.Utils;

public class ContentNetworkUI {
    public static Map<Long, Image> mapImages = new HashMap<Long, Image>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(final long contentNetworkID, final ContentNetworkImageLoadedListener cnImageLoadedListener) {
        Image image = mapImages.get(new Long(contentNetworkID));
        if (image != null && cnImageLoadedListener != null) {
            cnImageLoadedListener.contentNetworkImageLoaded(contentNetworkID, image, true);
            return image;
        }
        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(contentNetworkID);
        if (cn == null) {
            return image;
        }
        String imgURL = ContentNetworkUtils.getUrl(cn, 30);
        if (imgURL != null) {
            final File cache = new File(SystemProperties.getUserPath(), "cache" + File.separator + imgURL.hashCode() + ".ico");
            boolean loadImage = true;
            if (cache.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(cache);
                    try {
                        byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                        image = new Image((Device)Display.getCurrent(), (InputStream)is);
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        mapImages.put(new Long(contentNetworkID), image);
                        if (cnImageLoadedListener != null) {
                            cnImageLoadedListener.contentNetworkImageLoaded(contentNetworkID, image, true);
                        }
                    }
                    finally {
                        fis.close();
                    }
                    loadImage = false;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (loadImage) {
                ImageBytesDownloader.loadImage(imgURL, new ImageBytesDownloader.ImageDownloaderListener(){

                    public void imageDownloaded(final byte[] imageBytes) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                FileUtil.writeBytesAsFile(cache.getAbsolutePath(), imageBytes);
                                ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                                Image image = new Image((Device)Display.getCurrent(), (InputStream)is);
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                mapImages.put(new Long(contentNetworkID), image);
                                if (cnImageLoadedListener != null) {
                                    cnImageLoadedListener.contentNetworkImageLoaded(contentNetworkID, image, false);
                                }
                            }
                        });
                    }
                });
            }
        } else if (contentNetworkID == 1L && cnImageLoadedListener != null) {
            image = ImageLoader.getInstance().getImage("image.sidebar.vuze");
            mapImages.put(new Long(contentNetworkID), image);
            cnImageLoadedListener.contentNetworkImageLoaded(contentNetworkID, image, true);
        }
        return image;
    }

    public static interface ContentNetworkImageLoadedListener {
        public void contentNetworkImageLoaded(Long var1, Image var2, boolean var3);
    }
}

