/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.utils.ContentNetworkUI;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ContentNetworkUtils;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;

public class ContentNetworkUIManagerWindow {
    public ContentNetworkUIManagerWindow() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                ContentNetworkUIManagerWindow.this.open();
            }
        });
    }

    protected void open() {
        SWTSkinObjectContainer soListArea;
        final SkinnedDialog dlg = new SkinnedDialog("skin3_manageCN", "manageCN.body");
        SWTSkin skin = dlg.getSkin();
        SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
        if (soButton != null) {
            soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    dlg.close();
                }
            });
        }
        if ((soListArea = (SWTSkinObjectContainer)skin.getSkinObject("list-area")) != null) {
            Composite parent = (Composite)soListArea.getControl();
            ContentNetwork[] networks = ContentNetworkManagerFactory.getSingleton().getContentNetworks();
            Arrays.sort(networks, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String p1 = "" + ((ContentNetwork)o1).getProperty(3);
                    String p2 = "" + ((ContentNetwork)o2).getProperty(3);
                    return p1.compareTo(p2);
                }
            });
            Button lastButton = null;
            for (int i = 0; i < networks.length; ++i) {
                final ContentNetwork cn = networks[i];
                Object prop = cn.getProperty(2);
                boolean removable = prop instanceof Boolean ? (Boolean)prop : false;
                final Button button = new Button(parent, 32);
                button.setText(cn.getName());
                prop = cn.getPersistentProperty("in_menu");
                boolean show = prop instanceof Boolean ? (Boolean)prop : true;
                button.setSelection(show || !removable);
                button.setEnabled(removable);
                FormData fd = new FormData();
                fd.top = lastButton != null ? new FormAttachment(lastButton, 3) : new FormAttachment(0, 5);
                fd.left = new FormAttachment(0, 5);
                button.setLayoutData((Object)fd);
                ContentNetworkUI.loadImage(cn.getID(), new ContentNetworkUI.ContentNetworkImageLoadedListener(){

                    public void contentNetworkImageLoaded(Long contentNetworkID, Image image, boolean wasReturned) {
                        if (image != null && image.getBounds().height < 50) {
                            button.setImage(image);
                            if (!wasReturned) {
                                button.getShell().layout(new Control[]{button});
                            }
                        }
                    }
                });
                lastButton = button;
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.widget;
                        boolean show = button.getSelection();
                        cn.setPersistentProperty("in_menu", new Boolean(show));
                        if (!show) {
                            cn.setPersistentProperty("auth_shown", Boolean.FALSE);
                            cn.setPersistentProperty("active", Boolean.FALSE);
                            SideBarEntrySWT entry = SideBar.getEntry(ContentNetworkUtils.getTarget(cn));
                            if (entry.isInTree()) {
                                entry.getSidebar().closeEntry(entry.getId());
                            }
                            cn.setStartupNetwork(false);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                String url = ContentNetworkUtils.getUrl(cn, 35);
                if (url == null) continue;
                Link lblLearnMore = new Link(parent, 0);
                lblLearnMore.setText("<A HREF=\"" + url + "\">" + MessageText.getString("label.learnmore") + "</A>");
                fd = new FormData();
                fd.left = new FormAttachment((Control)button, 10);
                fd.top = new FormAttachment((Control)button, 0, 0x1000000);
                lblLearnMore.setLayoutData((Object)fd);
                lblLearnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Utils.launch(e.text);
                    }
                });
            }
        }
        dlg.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            public void skinDialogClosed(SkinnedDialog dialog) {
            }
        });
        dlg.open();
        soButton.getControl().setFocus();
    }
}

