/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.ui.swt.utils.ImageResizeException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageResizer {
    private static final int RESIZE_STEPS = 100000;
    private static final int MARGIN = 20;
    private int minWidth;
    private int minHeight;
    private int displayWidth;
    private int displayHeight;
    private Display display;
    private Shell parent;
    private Shell shell;
    private Cursor cursor;
    private Canvas canvas;
    private Scale scale;
    private long lastUpdate = 0L;
    private Image original;
    private int originalWidth;
    private int originalHeight;
    private Image currentImage;
    private Image overlay;
    private Image overlayDragging;
    private Image overlayNotDragging;
    private boolean done;
    private Image result;
    private float zoomRatio;
    private float minZoomRatio;
    private float maxZoomRatio;
    private Point offset;
    private Listener moveImageListener = new Listener(){
        private boolean mouseDown = false;
        private Point pointDown;

        public void handleEvent(Event event2) {
            switch (event2.type) {
                case 3: {
                    this.mouseDown = true;
                    this.pointDown = new Point(event2.x, event2.y);
                    ImageResizer.this.overlay = ImageResizer.this.overlayDragging;
                    ImageResizer.this.drawCurrentImage();
                    break;
                }
                case 4: {
                    this.mouseDown = false;
                    ImageResizer.this.overlay = ImageResizer.this.overlayNotDragging;
                    ImageResizer.this.drawCurrentImage();
                    break;
                }
                case 5: {
                    if (!this.mouseDown) break;
                    ((ImageResizer)ImageResizer.this).offset.x = ((ImageResizer)ImageResizer.this).offset.x + event2.x - this.pointDown.x;
                    ((ImageResizer)ImageResizer.this).offset.y = ((ImageResizer)ImageResizer.this).offset.y + event2.y - this.pointDown.y;
                    ImageResizer.this.insureOffsetIsCorrect();
                    this.pointDown.x = event2.x;
                    this.pointDown.y = event2.y;
                    ImageResizer.this.drawCurrentImage();
                    break;
                }
                case 6: {
                    break;
                }
            }
        }
    };

    public ImageResizer(Display display, int width, int height, Shell parent) {
        this.parent = parent;
        this.display = display;
        this.minWidth = width;
        this.minHeight = height;
    }

    public Image resize(Image original) throws ImageResizeException {
        this.original = original;
        if (!this.checkSize(original)) {
            this.dispose();
            throw new ImageResizeException(MessageText.getString("ImageResizer.image.too.small", new String[]{this.minWidth + "", this.minHeight + ""}));
        }
        this.originalWidth = original.getBounds().width;
        this.originalHeight = original.getBounds().height;
        this.currentImage = new Image((Device)this.display, this.internalResize(original, (int)((float)this.originalWidth * this.zoomRatio), (int)((float)this.originalHeight * this.zoomRatio)));
        this.offset = new Point(0, 0);
        if (this.minWidth != original.getBounds().width || this.minHeight != original.getBounds().height) {
            this.displayWidth = this.minWidth + 42;
            this.displayHeight = this.minHeight + 42;
            this.overlay = this.overlayNotDragging = this.createOverlayImage((byte)-1, 0xFFFFFF, (byte)-1, 0);
            this.overlayDragging = this.createOverlayImage((byte)80, 0xFFFFFF, (byte)-1, 0xFFFFFF);
            this.initUI();
            this.done = false;
            while (!this.done) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        } else {
            this.result = this.computeResultImage();
        }
        this.dispose();
        return this.result;
    }

    private void initUI() {
        Label label;
        this.cursor = new Cursor((Device)this.display, 21);
        this.shell = this.parent != null ? new Shell(this.parent, 67680) : new Shell(this.display, 2112);
        this.shell.setText("Thumbnail Assistant");
        Utils.setShellIcon(this.shell);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = false;
                ImageResizer.this.result = null;
                ImageResizer.this.done = true;
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        this.shell.setLayout((Layout)layout);
        Label title = new Label((Composite)this.shell, 64);
        title.setText(MessageText.getString("ImageResizer.title"));
        FormData data = new FormData();
        data.width = this.displayWidth;
        title.setLayoutData((Object)data);
        this.canvas = new Canvas((Composite)this.shell, 2048);
        this.canvas.setCursor(this.cursor);
        data = new FormData();
        data.width = this.displayWidth;
        data.height = this.displayHeight;
        data.top = new FormAttachment((Control)title, 5);
        this.canvas.setLayoutData((Object)data);
        this.canvas.addListener(3, this.moveImageListener);
        this.canvas.addListener(4, this.moveImageListener);
        this.canvas.addListener(5, this.moveImageListener);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                ImageResizer.this.drawCurrentImage();
            }
        });
        this.offset.x = (this.minWidth - this.currentImage.getBounds().width) / 2;
        this.offset.y = (this.minHeight - this.currentImage.getBounds().height) / 2;
        Label attach = label = new Label((Composite)this.shell, 64);
        if (this.minZoomRatio < 1.0f) {
            this.scale = new Scale((Composite)this.shell, 256);
            data = new FormData();
            data.width = this.displayWidth;
            data.top = new FormAttachment((Control)label, 5);
            this.scale.setLayoutData((Object)data);
            this.scale.setMaximum((int)(100000.0f * this.maxZoomRatio));
            this.scale.setMinimum((int)(100000.0f * this.minZoomRatio));
            this.scale.setIncrement((int)((this.maxZoomRatio - this.minZoomRatio) * 100000.0f / 10.0f));
            this.scale.setPageIncrement((int)((this.maxZoomRatio - this.minZoomRatio) * 100000.0f / 10.0f));
            this.scale.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    final long timestamp = SystemTime.getCurrentTime();
                    ImageResizer.this.lastUpdate = timestamp;
                    final int position = ImageResizer.this.scale.getSelection();
                    AEThread t = new AEThread(""){

                        public void runSupport() {
                            try {
                                Thread.sleep(150L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (timestamp == ImageResizer.this.lastUpdate && ImageResizer.this.display != null && !ImageResizer.this.display.isDisposed()) {
                                ImageResizer.this.display.asyncExec(new Runnable(){

                                    public void run() {
                                        ImageResizer.this.refreshCurrentImage(position);
                                    }
                                });
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            });
            attach = this.scale;
            label.setText(MessageText.getString("ImageResizer.move.image.with.slider"));
        } else {
            label.setText(MessageText.getString("ImageResizer.move.image"));
        }
        int width = label.computeSize((int)-1, (int)-1).x;
        if (width > this.displayWidth) {
            width = this.displayWidth;
        }
        data = new FormData();
        data.width = width;
        data.top = new FormAttachment((Control)this.canvas, 5);
        data.left = new FormAttachment((Control)this.canvas, 0, 0x1000000);
        label.setLayoutData((Object)data);
        Button btnCancel = new Button((Composite)this.shell, 8);
        btnCancel.setText("Cancel");
        data = new FormData();
        data.width = 70;
        data.top = new FormAttachment((Control)attach, 10);
        data.right = new FormAttachment(100, -10);
        btnCancel.setLayoutData((Object)data);
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ImageResizer.this.result = null;
                ImageResizer.this.done = true;
            }
        });
        Button btnOk = new Button((Composite)this.shell, 8);
        btnOk.setText("OK");
        data = new FormData();
        data.width = 70;
        data.top = new FormAttachment((Control)attach, 10);
        data.right = new FormAttachment((Control)btnCancel, -10);
        btnOk.setLayoutData((Object)data);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ImageResizer.this.result = ImageResizer.this.computeResultImage();
                ImageResizer.this.done = true;
            }
        });
        this.shell.setDefaultButton(btnOk);
        btnOk.setFocus();
        this.shell.setSize(this.shell.computeSize(-1, -1));
        if (this.parent != null) {
            Utils.centerWindowRelativeTo(this.shell, (Control)this.parent);
        }
        this.shell.open();
        this.drawCurrentImage();
    }

    private boolean checkSize(Image image) {
        Rectangle size = image.getBounds();
        if (size.width < this.minWidth || size.height < this.minHeight) {
            return false;
        }
        float minHRatio = (float)this.minHeight / (float)size.height;
        float minWRatio = (float)this.minWidth / (float)size.width;
        float maxHRatio = (float)(this.minHeight * 4) / (float)size.height;
        float maxWRatio = (float)(this.minWidth * 4) / (float)size.width;
        this.minZoomRatio = minHRatio > minWRatio ? minHRatio : minWRatio;
        float f = this.maxZoomRatio = maxHRatio > maxWRatio ? maxHRatio : maxWRatio;
        if (this.maxZoomRatio > 1.0f) {
            this.maxZoomRatio = 1.0f;
        }
        this.zoomRatio = this.minZoomRatio;
        return true;
    }

    private ImageData internalResize(Image image, int newWidth, int newHeight) {
        ImageData srcData;
        ImageData data = srcData = image.getImageData();
        ImageData copy = new ImageData(newWidth, newHeight, 24, new PaletteData(0xFF0000, 65280, 255));
        Image src = new Image((Device)this.display, srcData);
        Image dst = new Image((Device)this.display, copy);
        GC gc = new GC((Drawable)dst);
        gc.setAdvanced(true);
        try {
            gc.setInterpolation(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        gc.drawImage(src, 0, 0, srcData.width, srcData.height, 0, 0, copy.width, copy.height);
        gc.dispose();
        data = dst.getImageData();
        src.dispose();
        dst.dispose();
        return data;
    }

    private void drawCurrentImage() {
        GC gcCanvas = new GC((Drawable)this.canvas);
        Image temp = new Image((Device)this.display, this.displayWidth, this.displayHeight);
        GC gc = new GC((Drawable)temp);
        gc.drawImage(this.currentImage, this.offset.x + 20 + 1, this.offset.y + 20 + 1);
        gc.drawImage(this.overlay, 0, 0);
        gc.dispose();
        gcCanvas.drawImage(temp, 0, 0);
        temp.dispose();
        gcCanvas.dispose();
    }

    private void insureOffsetIsCorrect() {
        int minY;
        int minX = this.minWidth - this.currentImage.getBounds().width;
        if (this.offset.x < minX) {
            this.offset.x = minX;
        }
        if (this.offset.y < (minY = this.minHeight - this.currentImage.getBounds().height)) {
            this.offset.y = minY;
        }
        if (this.offset.x > 0) {
            this.offset.x = 0;
        }
        if (this.offset.y > 0) {
            this.offset.y = 0;
        }
    }

    private void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            this.currentImage.dispose();
        }
        if (this.overlayDragging != null && !this.overlayDragging.isDisposed()) {
            this.overlayDragging.dispose();
        }
        if (this.overlayNotDragging != null && !this.overlayNotDragging.isDisposed()) {
            this.overlayNotDragging.dispose();
        }
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
    }

    private Image computeResultImage() {
        Image img = new Image((Device)this.display, this.minWidth, this.minHeight);
        GC gc = new GC((Drawable)img);
        gc.drawImage(this.currentImage, this.offset.x, this.offset.y);
        gc.dispose();
        return img;
    }

    private Image createOverlayImage(byte marginAlpha, int marginColor, byte borderAlpha, int borderColor) {
        int i;
        int width = this.displayWidth;
        int height = this.displayHeight;
        ImageData data = new ImageData(width, height, 32, new PaletteData(255, 65280, 0xFF0000));
        byte[] transparency = new byte[width * height];
        int[] pixels = new int[width * height];
        byte[] rowAlpha = new byte[width];
        int[] rowPixels = new int[width];
        for (i = 0; i < width; ++i) {
            rowAlpha[i] = marginAlpha;
            rowPixels[i] = marginColor;
        }
        for (i = 0; i < 20; ++i) {
            System.arraycopy(rowAlpha, 0, transparency, i * width, width);
            System.arraycopy(rowPixels, 0, pixels, i * width, width);
        }
        for (i = 0; i < 20; ++i) {
            rowAlpha[i] = marginAlpha;
            rowAlpha[width - i - 1] = marginAlpha;
        }
        for (i = 20; i < width - 20; ++i) {
            rowAlpha[i] = 0;
        }
        for (i = 20; i < height - 20; ++i) {
            System.arraycopy(rowAlpha, 0, transparency, i * width, width);
            System.arraycopy(rowPixels, 0, pixels, i * width, width);
        }
        for (i = 0; i < width; ++i) {
            rowAlpha[i] = marginAlpha;
        }
        for (i = height - 20 - 1; i < height; ++i) {
            System.arraycopy(rowAlpha, 0, transparency, i * width, width);
            System.arraycopy(rowPixels, 0, pixels, i * width, width);
        }
        for (i = 20; i < width - 20; ++i) {
            transparency[width * 20 + i] = borderAlpha;
            pixels[width * 20 + i] = borderColor;
        }
        for (int j = 20; j < height - 20; ++j) {
            transparency[j * width + 20] = borderAlpha;
            pixels[j * width + 20] = borderColor;
            transparency[j * width + width - 20 - 1] = borderAlpha;
            pixels[j * width + width - 20 - 1] = borderColor;
        }
        for (i = 20; i < width - 20; ++i) {
            transparency[width * (height - 20 - 1) + i] = borderAlpha;
            pixels[width * (height - 20 - 1) + i] = borderColor;
        }
        data.alphaData = transparency;
        data.setPixels(0, 0, width * height, pixels, 0);
        Image overlay = new Image((Device)this.display, data);
        return overlay;
    }

    private void refreshCurrentImage(int position) {
        float previousZoom = this.zoomRatio;
        this.zoomRatio = (float)position / 100000.0f;
        if (this.zoomRatio > 1.0f) {
            this.zoomRatio = 1.0f;
        }
        if (this.zoomRatio < this.minZoomRatio) {
            this.zoomRatio = this.minZoomRatio;
        }
        if (previousZoom != this.zoomRatio) {
            Image previous = this.currentImage;
            this.currentImage = new Image((Device)this.display, this.internalResize(this.original, (int)((float)this.originalWidth * this.zoomRatio), (int)((float)this.originalHeight * this.zoomRatio)));
            this.offset.x += (previous.getBounds().width - this.currentImage.getBounds().width) / 2;
            this.offset.y += (previous.getBounds().height - this.currentImage.getBounds().height) / 2;
            if (previous != null && !previous.isDisposed()) {
                previous.dispose();
            }
            this.insureOffsetIsCorrect();
            this.drawCurrentImage();
        }
    }

    public static void main(String[] args) throws Exception {
        Display display = Display.getDefault();
        Shell test = new Shell(display);
        ImageResizer resizer = new ImageResizer(display, 228, 128, null);
        String file = new FileDialog(test).open();
        Image img = new Image((Device)display, file);
        Image thumbnail = resizer.resize(img);
        System.out.println(thumbnail);
        thumbnail.dispose();
        test.dispose();
        if (args.length == 0) {
            display.dispose();
        }
    }
}

