/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.ui.swt.shells.LightBoxBrowserWindow;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.LoginInfoManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTLoginUtils {
    public static void waitForLogin(final loginWaitListener l) {
        VuzeBuddyManager.log("Wait for login " + l);
        if (l == null) {
            return;
        }
        final AERunnable loginCompleteRunnable = new AERunnable(){

            public void runSupport() {
                VuzeBuddyManager.log("Fire Login Complete");
                l.loginComplete();
            }
        };
        final AERunnable loginCancelRunnable = new AERunnable(){

            public void runSupport() {
                VuzeBuddyManager.log("Fire Login Cancel");
                l.loginCanceled();
            }
        };
        final LoginInfoManager loginManager = LoginInfoManager.getInstance();
        if (loginManager.isLoggedIn()) {
            Utils.execSWTThread(loginCompleteRunnable);
            return;
        }
        final ILoginInfoListener loginInfoListener = new ILoginInfoListener(){

            public void loginUpdate(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
                if (loginManager.isLoggedIn()) {
                    loginManager.removeListener(this);
                    Utils.execSWTThread(loginCompleteRunnable);
                }
            }

            public void avatarURLUpdated(String newAvatarURL) {
            }
        };
        loginManager.addListener(loginInfoListener);
        LightBoxBrowserWindow loginWindow = SWTLoginUtils.openLoginWindow(l.getOptionalMessage());
        loginWindow.setCloseListener(new LightBoxBrowserWindow.closeListener(){

            public void close() {
                SimpleTimer.addEvent("cancel login wait", SystemTime.getOffsetTime(l.getCancelDelay()), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        loginManager.removeListener(loginInfoListener);
                        if (!loginManager.isLoggedIn()) {
                            Utils.execSWTThread(loginCancelRunnable);
                        }
                    }
                });
            }
        });
    }

    public static LightBoxBrowserWindow openLoginWindow() {
        return SWTLoginUtils.openLoginWindow(null);
    }

    public static LightBoxBrowserWindow openLoginWindow(String optionalMessage) {
        VuzeBuddyManager.log("Open Login Window: msg=" + optionalMessage);
        String url = ConstantsVuze.getDefaultContentNetwork().getLoginService(optionalMessage);
        return new LightBoxBrowserWindow(url, "vuzePage", 380, 280);
    }

    public static abstract class loginWaitListener {
        private String message = null;
        private long cancelDelay;

        public abstract void loginComplete();

        public loginWaitListener() {
            this.init();
        }

        public void init() {
            this.cancelDelay = 10000L;
        }

        public String getOptionalMessage() {
            if (null == this.message) {
                this.message = MessageText.getString("login.optional.message");
            }
            return this.message;
        }

        public void loginCanceled() {
        }

        public long getCancelDelay() {
            return this.cancelDelay;
        }

        public void setCancelDelay(long cancelDelay) {
            this.cancelDelay = cancelDelay;
        }
    }
}

