/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.PlayNowList;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class TorrentUIUtilsV3 {
    private static final String MSG_ALREADY_EXISTS = "OpenTorrentWindow.mb.alreadyExists";
    private static final String MSG_ALREADY_EXISTS_NAME = "OpenTorrentWindow.mb.alreadyExists.default.name";
    private static final Pattern hashPattern = Pattern.compile("download/([A-Z0-9]{32})\\.torrent");

    public static void loadTorrent(final DownloadUrlInfo dlInfo, final boolean playNow, final boolean playPrepare, final boolean bringToFront, final boolean forceDRMtoCDP) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                TorrentUIUtilsV3._loadTorrent(core, dlInfo, playNow, playPrepare, bringToFront, forceDRMtoCDP);
            }
        });
    }

    private static void _loadTorrent(final AzureusCore core, final DownloadUrlInfo dlInfo, final boolean playNow, final boolean playPrepare, boolean bringToFront, final boolean forceDRMtoCDP) {
        if (dlInfo instanceof DownloadUrlInfoSWT) {
            DownloadUrlInfoSWT dlInfoSWT = (DownloadUrlInfoSWT)dlInfo;
            dlInfoSWT.invoke(playNow ? "play" : "download");
            return;
        }
        String url = dlInfo.getDownloadURL();
        try {
            UIFunctionsSWT uiFunctions;
            Matcher m = hashPattern.matcher(url);
            if (m.find()) {
                String hash = m.group(1);
                GlobalManager gm = core.getGlobalManager();
                final DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm != null) {
                    if (playNow || playPrepare) {
                        new AEThread2("playExisting", true){

                            public void run() {
                                if (playNow) {
                                    Debug.outNoStack("loadTorrent already exists.. playing", false);
                                    TorrentListViewsUtils.playOrStream(dm);
                                } else {
                                    Debug.outNoStack("loadTorrent already exists.. preparing", false);
                                    PlayUtils.prepareForPlay(dm);
                                }
                            }
                        }.start();
                    } else {
                        Utils.openMessageBox(Utils.findAnyShell(), 32, MSG_ALREADY_EXISTS, new String[]{" ", dm.getDisplayName(), MessageText.getString(MSG_ALREADY_EXISTS_NAME)});
                    }
                    return;
                }
            }
            if (UrlFilter.getInstance().urlCanRPC(url)) {
                ContentNetwork cn = null;
                if (dlInfo instanceof DownloadUrlInfoContentNetwork) {
                    cn = ((DownloadUrlInfoContentNetwork)dlInfo).getContentNetwork();
                }
                if (cn == null) {
                    cn = ConstantsVuze.getDefaultContentNetwork();
                }
                url = cn.appendURLSuffix(url, false, true);
            }
            if ((uiFunctions = (UIFunctionsSWT)UIFunctionsManager.getUIFunctions()) != null) {
                Shell shell;
                if (!COConfigurationManager.getBooleanParameter("add_torrents_silently") && bringToFront) {
                    uiFunctions.bringToFront();
                }
                if ((shell = uiFunctions.getMainShell()) != null) {
                    new FileDownloadWindow(shell, url, dlInfo.getReferer(), dlInfo.getRequestProperties(), new TorrentDownloaderCallBackInterface(){

                        public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
                            if (state == 3) {
                                DownloadManager existingDM;
                                HashWrapper hw;
                                TOTorrent torrent;
                                File file = inf.getFile();
                                file.deleteOnExit();
                                if (!TorrentUtil.isFileTorrent(file, null, file.getName())) {
                                    Matcher m = hashPattern.matcher(inf.getURL());
                                    if (m.find()) {
                                        String hash = m.group(1);
                                        ContentNetwork cn = null;
                                        if (dlInfo instanceof DownloadUrlInfoContentNetwork) {
                                            cn = ((DownloadUrlInfoContentNetwork)dlInfo).getContentNetwork();
                                        }
                                        if (cn == null) {
                                            cn = ConstantsVuze.getDefaultContentNetwork();
                                        }
                                        TorrentListViewsUtils.viewDetails(cn, hash, "loadtorrent");
                                    } else {
                                        TorrentUtil.isFileTorrent(file, Utils.findAnyShell(), file.getName());
                                    }
                                    return;
                                }
                                try {
                                    torrent = TorrentUtils.readFromFile(file, false);
                                }
                                catch (TOTorrentException e) {
                                    Debug.out(e);
                                    return;
                                }
                                if (playNow && !PlatformTorrentUtils.isPlatformTracker(torrent)) {
                                    Debug.out("stopped loading torrent because it's not in whitelist");
                                    return;
                                }
                                try {
                                    hw = torrent.getHashWrapper();
                                }
                                catch (TOTorrentException e1) {
                                    Debug.out(e1);
                                    return;
                                }
                                if (forceDRMtoCDP && (PlatformTorrentUtils.isContentDRM(torrent) || PlatformTorrentUtils.isContentPurchased(torrent))) {
                                    TorrentListViewsUtils.viewDetailsFromDS(torrent, "loadtorrent");
                                    return;
                                }
                                GlobalManager gm = core.getGlobalManager();
                                if ((playNow || playPrepare) && (existingDM = gm.getDownloadManager(hw)) != null) {
                                    if (playNow) {
                                        TorrentListViewsUtils.playOrStream(existingDM);
                                    } else {
                                        PlayUtils.prepareForPlay(existingDM);
                                    }
                                    return;
                                }
                                final HashWrapper fhw = hw;
                                GlobalManagerAdapter l = new GlobalManagerAdapter(){

                                    public void downloadManagerAdded(DownloadManager dm) {
                                        try {
                                            core.getGlobalManager().removeListener(this);
                                            TorrentUIUtilsV3.handleDMAdded(dm, playNow, playPrepare, fhw);
                                        }
                                        catch (Exception e) {
                                            Debug.out(e);
                                        }
                                    }
                                };
                                gm.addListener(l, false);
                                if (playNow || playPrepare) {
                                    PlayNowList.add(hw);
                                }
                                TorrentOpener.openTorrent(file.getAbsolutePath());
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void handleDMAdded(final DownloadManager dm, final boolean playNow, final boolean playPrepare, final HashWrapper fhw) {
        new AEThread2("playDM", true){

            public void run() {
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (!hw.equals(fhw)) {
                        return;
                    }
                    boolean showHomeHint = true;
                    if (playNow || playPrepare) {
                        if (playNow) {
                            showHomeHint = !TorrentListViewsUtils.playOrStream(dm);
                        } else {
                            PlayUtils.prepareForPlay(dm);
                            showHomeHint = false;
                        }
                    }
                    if (showHomeHint) {
                        TorrentListViewsUtils.showHomeHint(dm);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }.start();
    }

    public static void addTorrentToGM(final TOTorrent torrent) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                try {
                    File tempTorrentFile = File.createTempFile("AZU", ".torrent");
                    tempTorrentFile.deleteOnExit();
                    String filename = tempTorrentFile.getAbsolutePath();
                    torrent.serialiseToBEncodedFile(tempTorrentFile);
                    String savePath = COConfigurationManager.getStringParameter("Default save path");
                    if (savePath == null || savePath.length() == 0) {
                        savePath = ".";
                    }
                    core.getGlobalManager().addDownloadManager(filename, savePath);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        });
    }

    public static Image getContentImage(Object datasource, boolean big, final ContentImageLoadedListener l) {
        Image image;
        if (l == null) {
            return null;
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(datasource);
        if (torrent == null) {
            l.contentImageLoaded(null, true);
            return null;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        String thumbnailUrl = PlatformTorrentUtils.getContentThumbnailUrl(torrent);
        if (thumbnailUrl != null && imageLoader.imageExists(thumbnailUrl)) {
            l.contentImageLoaded(imageLoader.getImage(thumbnailUrl), true);
            return null;
        }
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (hash == null) {
            l.contentImageLoaded(null, true);
            return null;
        }
        String id = "Thumbnail." + hash;
        Image image2 = image = imageLoader.imageAdded(id) ? imageLoader.getImage(id) : null;
        if (image != null && !image.isDisposed()) {
            l.contentImageLoaded(image, true);
            return image;
        }
        final byte[] imageBytes = PlatformTorrentUtils.getContentThumbnail(torrent);
        if (imageBytes != null) {
            image = (Image)Utils.execSWTThreadWithObject("thumbcreator", new AERunnableObject(){

                public Object runSupport() {
                    ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
                    Image image = new Image((Device)Display.getDefault(), (InputStream)bis);
                    return image;
                }
            }, 500L);
        }
        if ((image == null || image.isDisposed()) && thumbnailUrl != null) {
            image = imageLoader.getUrlImage(thumbnailUrl, new ImageLoader.ImageDownloaderListener(){

                public void imageDownloaded(Image image, boolean returnedImmediately) {
                    l.contentImageLoaded(image, returnedImmediately);
                }
            });
            return image;
        }
        if (image == null || image.isDisposed()) {
            Image icon;
            DownloadManager dm = DataSourceUtils.getDM(datasource);
            String path = null;
            if (dm == null) {
                TOTorrentFile[] files;
                if (torrent != null && (files = torrent.getFiles()).length > 0) {
                    path = files[0].getRelativePath();
                }
            } else {
                path = dm.getDownloadState().getPrimaryFile();
            }
            if (path != null && (icon = ImageRepository.getPathIcon(path, big, torrent != null && !torrent.isSimpleTorrent())) != null) {
                image = new Image((Device)Display.getDefault(), icon, 0);
            }
            if (image == null) {
                imageLoader.addImage(id, ImageLoader.noImage);
            } else {
                imageLoader.addImage(id, image);
            }
        } else {
            imageLoader.addImage(id, image);
        }
        l.contentImageLoaded(image, true);
        return image;
    }

    public static void releaseContentImage(Object datasource) {
        TOTorrent torrent = DataSourceUtils.getTorrent(datasource);
        if (torrent == null) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        String thumbnailUrl = PlatformTorrentUtils.getContentThumbnailUrl(torrent);
        if (thumbnailUrl != null) {
            imageLoader.releaseImage(thumbnailUrl);
        } else {
            String hash = null;
            try {
                hash = torrent.getHashWrapper().toBase32String();
            }
            catch (TOTorrentException e) {
                // empty catch block
            }
            if (hash == null) {
                return;
            }
            String id = "Thumbnail." + hash;
            imageLoader.releaseImage(id);
        }
    }

    public static interface ContentImageLoadedListener {
        public void contentImageLoaded(Image var1, boolean var2);
    }
}

